/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.socket.func.db2.DBI;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.db2.Db2ImportModel;
import com.ibm.etools.fm.ui.wizards.db2.Db2ImportRunnable;
import com.ibm.etools.fm.ui.wizards.db2.Db2ImportWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Db2ImportActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_SUBSYSTEM = "ssid";
    private Db2ImportModel model;

    public Db2ImportActionItem(Db2ImportModel model) {
        super(ActionType.DBI, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.Db2ImportActionItem_IMPORT_FROM_X_TO_Y_OWNER_Z, this.model.getResource(), this.model.getObject().getFormattedName(), this.model.getObjectOwner());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        memento.putString(KEY_SUBSYSTEM, this.model.getSubsystem().getName());
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        DBI function = new DBI();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        Db2ImportModel model = new Db2ImportModel(system);
        model.setSubsystem(memento.getString(KEY_SUBSYSTEM));
        model.fromUtilityFunction(function);
        return new Db2ImportActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        Db2ImportRunnable runnable = new Db2ImportRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final Db2ImportModel clone = this.model.clone();
        Db2ImportWizard wizard = new Db2ImportWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                Db2ImportActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public Db2ImportActionItem clone() {
        Db2ImportActionItem clone = new Db2ImportActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Db2ImportActionItem) {
            return this.model.equals(((Db2ImportActionItem)obj).model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.model.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        return new Db2ImportActionItemPropertySource(this.model);
    }

    private static class Db2ImportActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private static final Object KEY_DATA_SET = new Object();
        private static final Object KEY_VOLUME = new Object();
        private static final Object KEY_TEMPLATE_IN = new Object();
        private static final Object KEY_OBJECT_OWNER = new Object();
        private static final Object KEY_OBJECT_NAME = new Object();
        private static final Object KEY_TEMPLATE_OUT = new Object();
        private static final Object KEY_UPDATE = new Object();
        private static final Object KEY_AUTO_COMMIT = new Object();
        private static final Object KEY_START_POSITION = new Object();
        private static final Object KEY_DUPLICATE_MAX = new Object();
        private static final Object KEY_DELETE_ROWS = new Object();
        private static final Object KEY_ROWS = new Object();
        private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_DATA_SET, Messages.Db2ImportActionItem_DATA_SET), new PropertyDescriptor(KEY_VOLUME, Messages.Db2ImportActionItem_VOLUME), new PropertyDescriptor(KEY_TEMPLATE_IN, Messages.Db2ImportActionItem_TEMPLATE_IN), new PropertyDescriptor(KEY_OBJECT_OWNER, Messages.Db2ImportActionItem_OBJECT_OWNER), new PropertyDescriptor(KEY_OBJECT_NAME, Messages.Db2ImportActionItem_OBJECT_NAME), new PropertyDescriptor(KEY_TEMPLATE_OUT, Messages.Db2ImportActionItem_TEMPLATE_OUT), new PropertyDescriptor(KEY_UPDATE, Messages.Db2ImportActionItem_UPDATE), new PropertyDescriptor(KEY_AUTO_COMMIT, Messages.Db2ImportActionItem_AUTO_COMMIT), new PropertyDescriptor(KEY_START_POSITION, Messages.Db2ImportActionItem_START_POSITION), new PropertyDescriptor(KEY_DUPLICATE_MAX, Messages.Db2ImportActionItem_DUPLICATE_MAX), new PropertyDescriptor(KEY_DELETE_ROWS, Messages.Db2ImportActionItem_DELETE_ROWS), new PropertyDescriptor(KEY_ROWS, Messages.Db2ImportActionItem_ROWS)};
        private Db2ImportModel model;

        public Db2ImportActionItemPropertySource(Db2ImportModel model) {
            this.model = model;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return DESCRIPTORS;
        }

        public Object getEditableValue() {
            return null;
        }

        public Object getPropertyValue(Object id) {
            if (KEY_DATA_SET.equals(id)) {
                return this.model.getResource();
            }
            if (KEY_VOLUME.equals(id)) {
                return this.model.getVolume();
            }
            if (KEY_TEMPLATE_IN.equals(id)) {
                return this.model.getTemplateInSet();
            }
            if (KEY_OBJECT_OWNER.equals(id)) {
                return this.model.getObjectOwner();
            }
            if (KEY_OBJECT_NAME.equals(id)) {
                return this.model.getObjectName();
            }
            if (KEY_TEMPLATE_OUT.equals(id)) {
                return this.model.getTemplateOutSet();
            }
            if (KEY_UPDATE.equals(id)) {
                return this.model.isUpdate() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_AUTO_COMMIT.equals(id)) {
                return this.model.getAutoCommit();
            }
            if (KEY_START_POSITION.equals(id)) {
                return this.model.getStartPosition();
            }
            if (KEY_DUPLICATE_MAX.equals(id)) {
                return this.model.getDuplicateMax();
            }
            if (KEY_DELETE_ROWS.equals(id)) {
                return this.model.isDeleteRows() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_ROWS.equals(id)) {
                return this.model.getRows();
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

