/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.Db2TableContentProposals;
import com.ibm.etools.fm.ui.wizards.db2.Db2GenerateModel;
import com.ibm.etools.fm.ui.wizards.db2.IFmDb2WizardPage;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.text.MessageFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Db2GenerateWizardPageFirst
extends WizardPage
implements IFmDb2WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.Db2GenerateWizardPageFirst_TITLE;
    private final Db2GenerateModel model;
    private Db2GenerateWizardPageFirstConnector connector = new Db2GenerateWizardPageFirstConnector();
    private Combo wSubsystem;
    private Button wSubsystemLookup;
    private Combo wObjectOutOwner;
    private Button wObjectOutOwnerLookup;
    private Combo wObjectOutName;
    private Button wObjectOutNameLookup;
    private Combo wTemplateOut;
    private Button wTemplateOutEdit;
    private Combo wRows;

    protected Db2GenerateWizardPageFirst(Db2GenerateModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.Db2GenerateWizardPageFirst_DEFAULT_MSG);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group systemGroup = GUI.group((Composite)parent, (String)Messages.__SYSTEM, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)systemGroup, (String)Messages.LABEL__DB2_SUBSYSTEM, (Object)GUI.grid.d.left1());
        this.wSubsystem = GUI.combo.editable((Composite)systemGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wSubsystem.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new ComboValueSaver(this.wSubsystem, this.getClass().getCanonicalName() + "Subsystem");
        this.wSubsystemLookup = LookupButton.createLookupButtonLeft1((Composite)systemGroup);
        this.wSubsystemLookup.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(Db2GenerateWizardPageFirst.this.model.getHostProvider().getSystem());
                if (lookup.open() == 0) {
                    Db2GenerateWizardPageFirst.this.wSubsystemLookup.setFocus();
                    Db2GenerateWizardPageFirst.this.model.setSubsystem((Db2Subsystem)lookup.getFirstSelectedObject());
                    Db2GenerateWizardPageFirst.this.model.fireModelChangeEvent();
                    Db2GenerateWizardPageFirst.this.wSubsystem.setText(Db2GenerateWizardPageFirst.this.model.getSubsystemSet());
                }
            }
        });
        Group destGroup = GUI.group((Composite)parent, (String)Messages.Db2GenerateWizardPageFirst_OBJECT_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Listener objectLookup = new Listener(){

            public void handleEvent(Event event) {
                Db2TableLookupDialog lookup = new Db2TableLookupDialog(Db2GenerateWizardPageFirst.this.model.getSubsystem());
                lookup.setInitialOwnerPattern(Db2GenerateWizardPageFirst.this.wObjectOutOwner.getText());
                lookup.setInitialNamePattern(Db2GenerateWizardPageFirst.this.wObjectOutName.getText());
                if (lookup.open() == 0) {
                    if (event.widget instanceof Button) {
                        ((Button)event.widget).setFocus();
                    }
                    Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                    Db2GenerateWizardPageFirst.this.model.setObjectOut(selected);
                    Db2GenerateWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        };
        GUI.label.left((Composite)destGroup, (String)Messages.Db2GenerateWizardPageFirst_OWNER, (Object)GUI.grid.d.left1());
        this.wObjectOutOwner = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wObjectOutOwnerLookup = LookupButton.createLookupButtonLeft1((Composite)destGroup);
        this.wObjectOutOwnerLookup.addListener(13, objectLookup);
        GUI.label.left((Composite)destGroup, (String)Messages.Db2GenerateWizardPageFirst_NAME, (Object)GUI.grid.d.left1());
        this.wObjectOutName = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)2));
        Db2TableContentProposals.addTo(this.wObjectOutOwner, this.wObjectOutName, this.model, this.getClass().getCanonicalName() + "Object");
        this.wObjectOutNameLookup = LookupButton.createLookupButtonLeft1((Composite)destGroup);
        this.wObjectOutNameLookup.addListener(13, objectLookup);
        GUI.label.left((Composite)destGroup, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateOut = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateOutEdit = GUI.button.push((Composite)destGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateOutEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities2.openTemplateEditSession(new Db2TemplateOptions((Db2SubsystemProvider)Db2GenerateWizardPageFirst.this.model.getObjectOut(), (DataSetOrMember)Db2GenerateWizardPageFirst.this.model.getTemplateOut()));
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)destGroup), this.wTemplateOut, (IHostProvider)this.model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof Member) {
                    Db2GenerateWizardPageFirst.this.model.setTemplateOut(zrl.getFormattedName());
                    Db2GenerateWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "TemplateOut").create();
        GUI.label.left((Composite)destGroup, (String)Messages.Db2GenerateWizardPageFirst_CREATE_ROWS_COUNT, (Object)GUI.grid.d.left1());
        this.wRows = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wRows, this.getClass().getCanonicalName() + "Rows");
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wSubsystem);
        this.connector.listenTo((Control)this.wObjectOutOwner);
        this.connector.listenTo((Control)this.wObjectOutName);
        this.connector.listenTo((Control)this.wTemplateOut);
        this.connector.listenTo((Control)this.wRows);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
            ModelViewConnector.guessFocus((Control)this.getControl());
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        if (this.model.getSubsystem() == null) {
            return Messages.Db2GenerateWizardPageFirst_INVALID_SUBSYSTEM;
        }
        if (!Db2Table.isValidName((IPDHost)this.model.getSystem(), (String)this.model.getObjectName())) {
            return Messages.Db2GenerateWizardPageFirst_INVALID_OBJECT_NAME;
        }
        if (this.model.getTemplateOutSet().length() > 0 && !Member.isParseable((String)this.model.getTemplateOutSet(), (boolean)true, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2GenerateWizardPageFirst_INVALID_TEMPLATE;
        }
        if (!UIValidator.isInRange(this.model.getRows(), 1, 99999999)) {
            return Messages.Db2GenerateWizardPageFirst_INVALID_CREATE_ROWS_COUNT;
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    @Override
    public boolean validateDb2Object() {
        Result result;
        Db2Table aTable = this.model.getObjectOut();
        if (!ZrlLoaderDialogUtils.tableExists(aTable, result = new Result(), true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, aTable.getOwner(), aTable.getName()));
            return false;
        }
        return true;
    }

    private class Db2GenerateWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private Db2GenerateWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (Db2GenerateWizardPageFirstConnector.focussed((Control)Db2GenerateWizardPageFirst.this.wSubsystem)) {
                Db2GenerateWizardPageFirst.this.model.setSubsystem(Db2GenerateWizardPageFirst.this.wSubsystem.getText());
            }
            if (Db2GenerateWizardPageFirstConnector.focussed((Control)Db2GenerateWizardPageFirst.this.wObjectOutOwner)) {
                Db2GenerateWizardPageFirst.this.model.setObjectOwner(Db2GenerateWizardPageFirst.this.wObjectOutOwner.getText());
            }
            if (Db2GenerateWizardPageFirstConnector.focussed((Control)Db2GenerateWizardPageFirst.this.wObjectOutName)) {
                Db2GenerateWizardPageFirst.this.model.setObjectName(Db2GenerateWizardPageFirst.this.wObjectOutName.getText());
            }
            if (Db2GenerateWizardPageFirstConnector.focussed((Control)Db2GenerateWizardPageFirst.this.wTemplateOut)) {
                Db2GenerateWizardPageFirst.this.model.setTemplateOut(Db2GenerateWizardPageFirst.this.wTemplateOut.getText());
            }
            if (Db2GenerateWizardPageFirstConnector.focussed((Control)Db2GenerateWizardPageFirst.this.wRows)) {
                Db2GenerateWizardPageFirst.this.model.setRows(Db2GenerateWizardPageFirst.this.wRows.getText());
            }
            Db2GenerateWizardPageFirst.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateComboFromModelIfNeeded(Db2GenerateWizardPageFirst.this.wSubsystem, Db2GenerateWizardPageFirst.this.model.getSubsystemSet());
            this.updateComboFromModelIfNeeded(Db2GenerateWizardPageFirst.this.wObjectOutOwner, Db2GenerateWizardPageFirst.this.model.getObjectOwner());
            this.updateComboFromModelIfNeeded(Db2GenerateWizardPageFirst.this.wObjectOutName, Db2GenerateWizardPageFirst.this.model.getObjectName());
            Db2GenerateWizardPageFirst.this.wObjectOutOwnerLookup.setEnabled(Db2GenerateWizardPageFirst.this.model.getSubsystem() != null);
            Db2GenerateWizardPageFirst.this.wObjectOutNameLookup.setEnabled(Db2GenerateWizardPageFirst.this.model.getSubsystem() != null);
            this.updateComboFromModelIfNeeded(Db2GenerateWizardPageFirst.this.wTemplateOut, Db2GenerateWizardPageFirst.this.model.getTemplateOutSet());
            Db2GenerateWizardPageFirst.this.wTemplateOutEdit.setEnabled(Db2GenerateWizardPageFirst.this.model.getObjectOut() != null && Db2GenerateWizardPageFirst.this.model.getTemplateOut() != null);
            this.updateComboFromModelIfNeeded(Db2GenerateWizardPageFirst.this.wRows, Db2GenerateWizardPageFirst.this.model.getRows());
            String validationErrorMessage = Db2GenerateWizardPageFirst.this.getValidationErrorMessage();
            Db2GenerateWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            Db2GenerateWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }
    }
}

