/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.db2.D2G;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.wizards.db2.Db2ObjectModelUtil;
import com.ibm.etools.fm.ui.wizards.db2.Db2UtilFuncWizardModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Objects;

public class Db2GenerateModel
extends Db2UtilFuncWizardModel<D2G> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Db2GenerateModel.class);
    private String objectOutOwner = "";
    private String objectOutName = "";
    private String templateOut = "";
    private String rows = "10";

    public Db2GenerateModel(IPDHost host) {
        super(host);
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        D2G d2g = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSubsystem().getSystem(), (IPDConnectEndpoint)this.getSubsystem(), (UtilityFunction)d2g, (IHowIsGoing)monitor);
    }

    @Override
    public D2G toUtilityFunction() {
        this.guessDefaultDb2ObjectOwner();
        D2G d2g = new D2G();
        d2g.setValue((NewUtilityFunction.IUtilFuncParam)D2G.OBJOOWNR, (Object)Db2ObjectModelUtil.getObjectName(this.objectOutOwner), this.getSystem());
        d2g.setValue((NewUtilityFunction.IUtilFuncParam)D2G.OBJONAME, (Object)Db2ObjectModelUtil.getObjectName(this.objectOutName), this.getSystem());
        d2g.setValue((NewUtilityFunction.IUtilFuncParam)D2G.TMOUT, (Object)this.templateOut, this.getSystem());
        d2g.setValue((NewUtilityFunction.IUtilFuncParam)D2G.ROWS, (Object)this.rows, this.getSystem());
        return d2g;
    }

    @Override
    public void fromUtilityFunction(D2G d2g) {
        this.setObjectOwner((String)d2g.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)D2G.OBJOOWNR, this.getSystem()));
        this.setObjectName((String)d2g.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)D2G.OBJONAME, this.getSystem()));
        this.setTemplateOut((String)d2g.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)D2G.TMOUT, this.getSystem()));
        this.setRows((String)d2g.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)D2G.ROWS, this.getSystem()));
    }

    private void guessDefaultDb2ObjectOwner() {
        if (this.objectOutOwner.isEmpty()) {
            try {
                AuthDetails auth = this.getSystem().getLogin(false);
                this.objectOutOwner = auth == null ? "" : auth.getUsername();
            }
            catch (InterruptedException e) {
                logger.trace((Object)"user cancelled providing backup owner for db2 object");
            }
        }
    }

    public Db2GenerateModel clone() {
        Db2GenerateModel clone = new Db2GenerateModel(this.getSystem());
        clone.setSubsystem(this.getSubsystemSet());
        clone.objectOutOwner = Db2ObjectModelUtil.getObjectName(this.objectOutOwner);
        clone.objectOutName = Db2ObjectModelUtil.getObjectName(this.objectOutName);
        clone.templateOut = this.templateOut;
        clone.rows = this.rows;
        return clone;
    }

    public String getObjectOwner() {
        return this.objectOutOwner;
    }

    public void setObjectOwner(String objectOutOwner) {
        this.objectOutOwner = Db2ObjectModelUtil.getObjectName(objectOutOwner);
    }

    public String getObjectName() {
        return this.objectOutName;
    }

    public void setObjectName(String objectOutName) {
        this.objectOutName = Db2ObjectModelUtil.getObjectName(objectOutName);
    }

    public void setObjectOut(Db2Table objectOut) {
        Objects.requireNonNull(objectOut, "Must provide a non-null objectOut");
        if (!objectOut.getSubsystem().equals((Object)this.getSubsystem())) {
            throw new IllegalArgumentException(objectOut.getSubsystem().toString());
        }
        this.objectOutOwner = Db2ObjectModelUtil.getObjectName(objectOut.getOwner());
        this.objectOutName = Db2ObjectModelUtil.getObjectName(objectOut.getName());
    }

    public Db2Table getObjectOut() {
        Db2Subsystem subSys = this.getSubsystem();
        if (subSys != null && Db2Table.isValidName((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectOutName)) && Db2Table.isValidOwner((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectOutOwner))) {
            return new Db2Table(subSys, Db2ObjectModelUtil.getObjectName(this.objectOutName), Db2ObjectModelUtil.getObjectName(this.objectOutOwner));
        }
        return null;
    }

    public String getTemplateOutSet() {
        return this.templateOut;
    }

    public Member getTemplateOut() {
        if (Member.isParseable((String)this.templateOut, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.templateOut).asMember();
        }
        return null;
    }

    public void setTemplateOut(String templateOut) {
        this.templateOut = templateOut;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }
}

