/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.socket.func.db2.D2G;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.db2.Db2GenerateModel;
import com.ibm.etools.fm.ui.wizards.db2.Db2GenerateRunnable;
import com.ibm.etools.fm.ui.wizards.db2.Db2GenerateWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Db2GenerateActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_SUBSYSTEM = "ssid";
    private Db2GenerateModel model;

    public Db2GenerateActionItem(Db2GenerateModel model) {
        super(ActionType.D2G, Objects.requireNonNull(model, "Must specify a non-null model.").getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.DSGActionItem_LABEL, this.model.getObjectOut().getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        memento.putString(KEY_SUBSYSTEM, this.model.getSubsystem().getName());
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        D2G function = new D2G();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        Db2GenerateModel model = new Db2GenerateModel(system);
        model.setSubsystem(memento.getString(KEY_SUBSYSTEM));
        model.fromUtilityFunction(function);
        return new Db2GenerateActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        Db2GenerateRunnable runnable = new Db2GenerateRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final Db2GenerateModel clone = this.model.clone();
        Db2GenerateWizard wizard = new Db2GenerateWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                Db2GenerateActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public Db2GenerateActionItem clone() {
        Db2GenerateActionItem clone = new Db2GenerateActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Db2GenerateActionItem) {
            return this.model.equals(((Db2GenerateActionItem)obj).model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.model.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        return new Db2GenerateActionItemPropertySource(this.model);
    }

    private static class Db2GenerateActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private static final Object KEY_OBJECT_OUT_OWNER = new Object();
        private static final Object KEY_OBJECT_OUT_NAME = new Object();
        private static final Object KEY_TEMPLATE_OUT = new Object();
        private static final Object KEY_ROWS = new Object();
        private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_OBJECT_OUT_OWNER, Messages.Db2GenerateActionItem_OBJECT_OUT_OWNER), new PropertyDescriptor(KEY_OBJECT_OUT_NAME, Messages.Db2GenerateActionItem_OBJECT_OUT_NAME), new PropertyDescriptor(KEY_TEMPLATE_OUT, Messages.Db2GenerateActionItem_TEMPLATE_OUT), new PropertyDescriptor(KEY_ROWS, Messages.Db2GenerateActionItem_ROWS)};
        private Db2GenerateModel model;

        public Db2GenerateActionItemPropertySource(Db2GenerateModel model) {
            this.model = model;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return DESCRIPTORS;
        }

        public Object getEditableValue() {
            return null;
        }

        public Object getPropertyValue(Object id) {
            if (KEY_OBJECT_OUT_OWNER.equals(id)) {
                return this.model.getObjectOwner();
            }
            if (KEY_OBJECT_OUT_NAME.equals(id)) {
                return this.model.getObjectName();
            }
            if (KEY_TEMPLATE_OUT.equals(id)) {
                return this.model.getTemplateOutSet();
            }
            if (KEY_ROWS.equals(id)) {
                return this.model.getRows();
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

