/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.core.socket.func.db2.DBX;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.Db2TableContentProposals;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportModel;
import com.ibm.etools.fm.ui.wizards.db2.IFmDb2WizardPage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Db2ExportWizardPageFirst
extends WizardPage
implements IFmDb2WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.Db2ExportWizardPageFirst_TITLE;
    private static final PDLogger logger = PDLogger.get(Db2ExportWizardPageFirst.class);
    private final Db2ExportModel model;
    private Db2ExportWizardPageFirstConnector connector = new Db2ExportWizardPageFirstConnector();
    private Combo wSubsystem;
    private Button wSubsystemLookup;
    private Combo wObjectOwner;
    private Combo wObjectName;
    private Button wObjectOwnerLookup;
    private Button wObjectNameLookup;
    private Combo wTemplateIn;
    private Button wTemplateInEdit;
    private Combo wResource;
    private Button wAllocateResource;
    private Combo wTemplateOut;
    private Button wTemplateOutEdit;
    private Button wDataFormatSqlda;
    private Button wDataFormatUnload;
    private Button wDataFormatDsntiaul;
    private Button wDataFormatUser;
    private Button wDataFormatCsv;
    private Combo wRows;
    private Button wNative;
    private Boolean finishFlag = false;

    protected Db2ExportWizardPageFirst(Db2ExportModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.Db2ExportWizardPageFirst_DEFAULT_MSG);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group systemGroup = GUI.group((Composite)parent, (String)Messages.__SYSTEM, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)systemGroup, (String)Messages.LABEL__DB2_SUBSYSTEM, (Object)GUI.grid.d.left1());
        this.wSubsystem = GUI.combo.editable((Composite)systemGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wSubsystem.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new ComboValueSaver(this.wSubsystem, this.getClass().getCanonicalName() + "Subsystem");
        this.wSubsystemLookup = LookupButton.createLookupButtonLeft1((Composite)systemGroup);
        this.wSubsystemLookup.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(Db2ExportWizardPageFirst.this.model.getHostProvider().getSystem());
                if (lookup.open() == 0) {
                    Db2ExportWizardPageFirst.this.model.setSubsystem((Db2Subsystem)lookup.getFirstSelectedObject());
                    Db2ExportWizardPageFirst.this.model.fireModelChangeEvent();
                    Db2ExportWizardPageFirst.this.wSubsystem.setText(Db2ExportWizardPageFirst.this.model.getSubsystemSet());
                }
            }
        });
        Group sourceGroup = GUI.group((Composite)parent, (String)Messages.Db2ExportWizardPageFirst_SOURCE_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Listener objectLookup = new Listener(){

            public void handleEvent(Event event) {
                Db2TableLookupDialog lookup = new Db2TableLookupDialog(Db2ExportWizardPageFirst.this.model.getSubsystem());
                lookup.setInitialOwnerPattern(Db2ExportWizardPageFirst.this.wObjectOwner.getText());
                lookup.setInitialNamePattern(Db2ExportWizardPageFirst.this.wObjectName.getText());
                if (lookup.open() == 0) {
                    Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                    Db2ExportWizardPageFirst.this.model.setObject(selected);
                    Db2ExportWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        };
        GUI.label.left((Composite)sourceGroup, (String)Messages.Db2ExportWizardPageFirst_OWNER, (Object)GUI.grid.d.left1());
        this.wObjectOwner = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wObjectOwnerLookup = LookupButton.createLookupButtonLeft1((Composite)sourceGroup);
        this.wObjectOwnerLookup.addListener(13, objectLookup);
        GUI.label.left((Composite)sourceGroup, (String)Messages.Db2ExportWizardPageFirst_NAME, (Object)GUI.grid.d.left1());
        this.wObjectName = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)2));
        Db2TableContentProposals.addTo(this.wObjectOwner, this.wObjectName, this.model, this.getClass().getCanonicalName() + "Obj");
        this.wObjectNameLookup = LookupButton.createLookupButtonLeft1((Composite)sourceGroup);
        this.wObjectNameLookup.addListener(13, objectLookup);
        GUI.label.left((Composite)sourceGroup, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateIn = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateInEdit = GUI.button.push((Composite)sourceGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateInEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities2.openTemplateEditSession(new Db2TemplateOptions((Db2SubsystemProvider)Db2ExportWizardPageFirst.this.model.getObject(), (DataSetOrMember)Db2ExportWizardPageFirst.this.model.getTemplateIn()));
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)sourceGroup), this.wTemplateIn, (IHostProvider)this.model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof Member) {
                    Db2ExportWizardPageFirst.this.model.setTemplateIn(zrl.getFormattedName());
                    Db2ExportWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "TemplateIn").create();
        Group destGroup = GUI.group((Composite)parent, (String)Messages.Db2ExportWizardPageFirst_DEST_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)destGroup, (String)Messages.Label__DATA_SET, (Object)GUI.grid.d.left1());
        this.wResource = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wAllocateResource = GUI.button.push((Composite)destGroup, (String)"Allocate", (Object)GUI.grid.d.left1());
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)destGroup), this.wResource, (IHostProvider)this.model).types(DataSet.class, Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof DataSetOrMember) {
                    Db2ExportWizardPageFirst.this.model.setResource((DataSetOrMember)zrl);
                    Db2ExportWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "Resource").create();
        this.wAllocateResource.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2ExportWizardPageFirst.this.allocateResourceListener();
            }
        });
        GUI.label.left((Composite)destGroup, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateOut = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateOutEdit = GUI.button.push((Composite)destGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateOutEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities.openTemplateEditSession((IZRL)Db2ExportWizardPageFirst.this.model.getTemplateOut());
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)destGroup), this.wTemplateOut, (IHostProvider)this.model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof Member) {
                    Db2ExportWizardPageFirst.this.model.setTemplateOut(zrl.getFormattedName());
                    Db2ExportWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "TemplateOut").create();
        Group dfGroup = GUI.group((Composite)parent, (String)Messages.Db2ExportWizardPageFirst_DATA_FORMAT_GROUP, (Layout)GUI.grid.l.margins((int)5, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.wDataFormatSqlda = GUI.button.radio((Composite)dfGroup, (String)DBX.DbxDataFormat.SQLDA.getName(), (Object)GUI.grid.d.fillH((int)1));
        this.wDataFormatUnload = GUI.button.radio((Composite)dfGroup, (String)DBX.DbxDataFormat.UNLOAD.getName(), (Object)GUI.grid.d.fillH((int)1));
        this.wDataFormatDsntiaul = GUI.button.radio((Composite)dfGroup, (String)DBX.DbxDataFormat.DSNTIAUL.getName(), (Object)GUI.grid.d.fillH((int)1));
        this.wDataFormatUser = GUI.button.radio((Composite)dfGroup, (String)DBX.DbxDataFormat.USER.getName(), (Object)GUI.grid.d.fillH((int)1));
        this.wDataFormatCsv = GUI.button.radio((Composite)dfGroup, (String)DBX.DbxDataFormat.CSV.getName(), (Object)GUI.grid.d.fillH((int)1));
        Group optionsGroup = GUI.group((Composite)parent, (String)Messages.Db2ExportWizardPageFirst_BASIC_OPTS_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2ExportWizardPageFirst_NUM_ROWS, (Object)GUI.grid.d.left1());
        this.wRows = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wRows, this.getClass().getCanonicalName() + "Rows");
        GUI.grid.padding((Composite)optionsGroup, (int)1);
        this.wNative = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2ExportWizardPageFirst_NATIVE, (Object)GUI.grid.d.fillH((int)2));
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wSubsystem);
        this.connector.listenTo((Control)this.wResource);
        this.connector.listenTo((Control)this.wTemplateIn);
        this.connector.listenTo((Control)this.wObjectOwner);
        this.connector.listenTo((Control)this.wObjectName);
        this.connector.listenTo((Control)this.wTemplateOut);
        this.connector.listenTo((Control)this.wDataFormatSqlda);
        this.connector.listenTo((Control)this.wDataFormatUnload);
        this.connector.listenTo((Control)this.wDataFormatDsntiaul);
        this.connector.listenTo((Control)this.wDataFormatUser);
        this.connector.listenTo((Control)this.wDataFormatCsv);
        this.connector.listenTo((Control)this.wRows);
        this.connector.listenTo((Control)this.wNative);
        this.setControl((Control)parent);
    }

    public String getValidationErrorMessage() {
        if (this.model.getSubsystem() == null) {
            return Messages.Db2ExportWizardPageFirst_INVALID_SUBSYSTEM;
        }
        if (!Db2Table.isValidName((IPDHost)this.model.getSystem(), (String)this.model.getObjectName())) {
            return Messages.Db2ExportWizardPageFirst_INVALID_NAME;
        }
        if (!Member.isParseable((String)this.model.getResource(), (boolean)false, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2ExportWizardPageFirst_INVALID_DEST_DATA_SET;
        }
        if (this.model.getTemplateInSet().length() > 0 && !Member.isParseable((String)this.model.getTemplateInSet(), (boolean)true, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2ExportWizardPageFirst_INVALID_SOURCE_TEMPLATE;
        }
        if (this.model.getTemplateOutSet().length() > 0 && !Member.isParseable((String)this.model.getTemplateOutSet(), (boolean)true, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2ExportWizardPageFirst_INVALID_DEST_TEMPLATE;
        }
        if (this.model.getRows().length() > 0 && !"ALL".equals(this.model.getRows()) && !UIValidator.isInRange(this.model.getRows(), 1, 99999999)) {
            return Messages.Db2ExportWizardPageFirst_INVALID_ROW_COUNT;
        }
        return null;
    }

    public IWizardPage getNextPage() {
        if (this.model.getDataFormat() == DBX.DbxDataFormat.SQLDA || this.model.getDataFormat() == DBX.DbxDataFormat.UNLOAD || this.model.getDataFormat() == DBX.DbxDataFormat.DSNTIAUL) {
            return null;
        }
        return super.getNextPage();
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    @Override
    public boolean validateDb2Object() {
        Result result;
        Db2Table aTable = this.model.getObject();
        if (!ZrlLoaderDialogUtils.tableExists(aTable, result = new Result(), true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, aTable.getOwner(), aTable.getName()));
            return false;
        }
        return true;
    }

    public void disableFinish() {
        this.setPageComplete(false);
    }

    public void enableFinish() {
        this.setPageComplete(true);
    }

    private void allocateResourceListener() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    String validationResult = Db2ExportWizardPageFirst.this.model.validateResourceTypes(howIsGoing, Db2ExportWizardPageFirst.this);
                    if (validationResult != null) {
                        Db2ExportWizardPageFirst.this.model.promptToAllocate(howIsGoing, Db2ExportWizardPageFirst.this);
                    } else {
                        PDDialogs.openInfoThreadSafe((String)Messages.ActionHistoryFactory_ALLOCATE_DATA_SET, (String)"Dataset already exists.");
                    }
                }
            });
            this.getContainer().getCurrentPage().setVisible(true);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if (t instanceof IllegalArgumentException) {
                PDDialogs.openErrorThreadSafe((String)Messages.Cannot_PROGRESS_SEE_ERROR_BELOW, (String)t.getMessage(), (Throwable)t);
            } else {
                logger.error(t);
            }
            IWizardPage newPage = this.getWizard().getStartingPage();
            this.getContainer().showPage(newPage);
            newPage.setPreviousPage(null);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
            ModelViewConnector.guessFocus((Control)this.getControl());
        }
        super.setVisible(visible);
    }

    public Boolean getFinishFlag() {
        return this.finishFlag;
    }

    public void setFinishFlag(Boolean flag) {
        this.finishFlag = flag;
    }

    private class Db2ExportWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private Db2ExportWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (Db2ExportWizardPageFirstConnector.focussed((Control)Db2ExportWizardPageFirst.this.wSubsystem)) {
                Db2ExportWizardPageFirst.this.model.setSubsystem(Db2ExportWizardPageFirst.this.wSubsystem.getText());
            }
            if (Db2ExportWizardPageFirstConnector.focussed((Control)Db2ExportWizardPageFirst.this.wObjectOwner)) {
                Db2ExportWizardPageFirst.this.model.setObjectOwner(Db2ExportWizardPageFirst.this.wObjectOwner.getText());
            }
            if (Db2ExportWizardPageFirstConnector.focussed((Control)Db2ExportWizardPageFirst.this.wObjectName)) {
                Db2ExportWizardPageFirst.this.model.setObjectName(Db2ExportWizardPageFirst.this.wObjectName.getText());
            }
            if (Db2ExportWizardPageFirstConnector.focussed((Control)Db2ExportWizardPageFirst.this.wTemplateIn)) {
                Db2ExportWizardPageFirst.this.model.setTemplateIn(Db2ExportWizardPageFirst.this.wTemplateIn.getText());
            }
            if (Db2ExportWizardPageFirstConnector.focussed((Control)Db2ExportWizardPageFirst.this.wResource)) {
                Db2ExportWizardPageFirst.this.model.setResource(Db2ExportWizardPageFirst.this.wResource.getText());
            }
            if (Db2ExportWizardPageFirstConnector.focussed((Control)Db2ExportWizardPageFirst.this.wTemplateOut)) {
                Db2ExportWizardPageFirst.this.model.setTemplateOut(Db2ExportWizardPageFirst.this.wTemplateOut.getText());
            }
            if (Db2ExportWizardPageFirst.this.wDataFormatSqlda.getSelection()) {
                Db2ExportWizardPageFirst.this.model.setDataFormat(DBX.DbxDataFormat.SQLDA);
            } else if (Db2ExportWizardPageFirst.this.wDataFormatUnload.getSelection()) {
                Db2ExportWizardPageFirst.this.model.setDataFormat(DBX.DbxDataFormat.UNLOAD);
            } else if (Db2ExportWizardPageFirst.this.wDataFormatDsntiaul.getSelection()) {
                Db2ExportWizardPageFirst.this.model.setDataFormat(DBX.DbxDataFormat.DSNTIAUL);
            } else if (Db2ExportWizardPageFirst.this.wDataFormatUser.getSelection()) {
                Db2ExportWizardPageFirst.this.model.setDataFormat(DBX.DbxDataFormat.USER);
            } else if (Db2ExportWizardPageFirst.this.wDataFormatCsv.getSelection()) {
                Db2ExportWizardPageFirst.this.model.setDataFormat(DBX.DbxDataFormat.CSV);
            }
            if (Db2ExportWizardPageFirstConnector.focussed((Control)Db2ExportWizardPageFirst.this.wRows)) {
                Db2ExportWizardPageFirst.this.model.setRows(Db2ExportWizardPageFirst.this.wRows.getText());
            }
            Db2ExportWizardPageFirst.this.model.setNative(Db2ExportWizardPageFirst.this.wNative.getSelection());
            Db2ExportWizardPageFirst.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateComboFromModelIfNeeded(Db2ExportWizardPageFirst.this.wSubsystem, Db2ExportWizardPageFirst.this.model.getSubsystemSet());
            this.updateComboFromModelIfNeeded(Db2ExportWizardPageFirst.this.wObjectOwner, Db2ExportWizardPageFirst.this.model.getObjectOwner());
            this.updateComboFromModelIfNeeded(Db2ExportWizardPageFirst.this.wObjectName, Db2ExportWizardPageFirst.this.model.getObjectName());
            Db2ExportWizardPageFirst.this.wObjectNameLookup.setEnabled(Db2ExportWizardPageFirst.this.model.getSubsystem() != null);
            Db2ExportWizardPageFirst.this.wObjectOwnerLookup.setEnabled(Db2ExportWizardPageFirst.this.model.getSubsystem() != null);
            this.updateComboFromModelIfNeeded(Db2ExportWizardPageFirst.this.wTemplateIn, Db2ExportWizardPageFirst.this.model.getTemplateInSet());
            Db2ExportWizardPageFirst.this.wTemplateInEdit.setEnabled(Db2ExportWizardPageFirst.this.model.getObject() != null && Db2ExportWizardPageFirst.this.model.getTemplateIn() != null);
            this.updateComboFromModelIfNeeded(Db2ExportWizardPageFirst.this.wResource, Db2ExportWizardPageFirst.this.model.getResource());
            this.updateComboFromModelIfNeeded(Db2ExportWizardPageFirst.this.wTemplateOut, Db2ExportWizardPageFirst.this.model.getTemplateOutSet());
            Db2ExportWizardPageFirst.this.wTemplateOutEdit.setEnabled(Db2ExportWizardPageFirst.this.model.getTemplateOut() != null);
            Db2ExportWizardPageFirst.this.wDataFormatSqlda.setSelection(Db2ExportWizardPageFirst.this.model.getDataFormat() == DBX.DbxDataFormat.SQLDA);
            Db2ExportWizardPageFirst.this.wDataFormatUnload.setSelection(Db2ExportWizardPageFirst.this.model.getDataFormat() == DBX.DbxDataFormat.UNLOAD);
            Db2ExportWizardPageFirst.this.wDataFormatDsntiaul.setSelection(Db2ExportWizardPageFirst.this.model.getDataFormat() == DBX.DbxDataFormat.DSNTIAUL);
            Db2ExportWizardPageFirst.this.wDataFormatUser.setSelection(Db2ExportWizardPageFirst.this.model.getDataFormat() == DBX.DbxDataFormat.USER);
            Db2ExportWizardPageFirst.this.wDataFormatCsv.setSelection(Db2ExportWizardPageFirst.this.model.getDataFormat() == DBX.DbxDataFormat.CSV);
            this.updateComboFromModelIfNeeded(Db2ExportWizardPageFirst.this.wRows, Db2ExportWizardPageFirst.this.model.getRows());
            Db2ExportWizardPageFirst.this.wNative.setSelection(Db2ExportWizardPageFirst.this.model.isNative());
            String validationErrorMessage = Db2ExportWizardPageFirst.this.getValidationErrorMessage();
            Db2ExportWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            Db2ExportWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }
    }
}

