/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.db2.DBX;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.util.ConversionUtil;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetActionItem;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizard;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportWizardPageFirst;
import com.ibm.etools.fm.ui.wizards.db2.Db2ObjectModelUtil;
import com.ibm.etools.fm.ui.wizards.db2.Db2UtilFuncWizardModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IRefreshable;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.PlatformUI;

public class Db2ExportModel
extends Db2UtilFuncWizardModel<DBX> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Db2ExportModel.class);
    private String objectOwner = "";
    private String objectName = "";
    private String templateOut = "";
    private String dsom = "";
    private IRefreshable dsomLoaded = null;
    private String templateIn = "";
    private String nullIndicator = "_";
    private String rows = "ALL";
    private boolean _native = false;
    private DBX.DbxDataFormat dataFormat = DBX.DbxDataFormat.SQLDA;
    private boolean csvHdr = false;
    private boolean csvLdg = true;
    private boolean csvTlg = false;
    private boolean csvQuo = false;
    private boolean csvSnq = false;
    private boolean csvLze = false;
    private String separator = ",";
    private DBX.DbxPlace place = DBX.DbxPlace.BEFORE;
    private boolean printingNullIndicators = false;
    private DBX.DbxDecimal decimal = DBX.DbxDecimal.INTERNAL;
    private DBX.DbxInteger integer = DBX.DbxInteger.NO;
    private DBX.DbxFloat _float = DBX.DbxFloat.NO;
    private boolean sosi = false;
    private boolean v15plus = false;
    private boolean v15_1_2plus = false;

    public Db2ExportModel(IPDHost host) {
        super(host);
        int hostVersion = HostVersion.getInstance().setHost(host).getVersion();
        this.v15plus = hostVersion / 10000 > 14;
        this.v15_1_2plus = hostVersion >= 150201;
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        DBX dbx = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSubsystem().getSystem(), (IPDConnectEndpoint)this.getSubsystem(), (UtilityFunction)dbx, (IHowIsGoing)monitor);
    }

    public boolean isV15plus() {
        return this.v15plus;
    }

    public boolean isV15_1_2plus() {
        return this.v15_1_2plus;
    }

    @Override
    public DBX toUtilityFunction() {
        this.guessDefaultDb2ObjectOwner();
        DBX dbx = new DBX();
        dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.OBJIOWNR, (Object)Db2ObjectModelUtil.getObjectName(this.objectOwner), this.getSystem());
        dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.OBJINAME, (Object)Db2ObjectModelUtil.getObjectName(this.objectName), this.getSystem());
        dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.TMIN, (Object)this.templateIn, this.getSystem());
        dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.DSNOUT, (Object)this.dsom, this.getSystem());
        dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.TCOUT, (Object)this.templateOut, this.getSystem());
        dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.NULLIND, (Object)this.nullIndicator, this.getSystem());
        dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.ROWS, (Object)this.rows, this.getSystem());
        dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.DATAFORMAT, (Object)this.dataFormat, this.getSystem());
        if (this.dataFormat == DBX.DbxDataFormat.SQLDA) {
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSV, (Object)false, this.getSystem());
        } else if (this.dataFormat == DBX.DbxDataFormat.DSNTIAUL) {
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSV, (Object)false, this.getSystem());
        } else if (this.dataFormat == DBX.DbxDataFormat.USER) {
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSV, (Object)false, this.getSystem());
            if (this.printingNullIndicators) {
                dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.NIUSAGE, (Object)DBX.DbxNiUsage.SEPARATE, this.getSystem());
                dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.PLACE, (Object)this.place, this.getSystem());
                if (ConversionUtil.isInt((String)this.nullIndicator)) {
                    dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.TYPE, (Object)DBX.DbxType.INTEGER, this.getSystem());
                    dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.NIINTEGER, (Object)this.nullIndicator, this.getSystem());
                } else {
                    dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.TYPE, (Object)DBX.DbxType.CHAR, this.getSystem());
                    dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.NICHAR, (Object)this.nullIndicator, this.getSystem());
                }
            } else {
                dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.NIUSAGE, (Object)DBX.DbxNiUsage.NONE, this.getSystem());
            }
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.DECIMAL, (Object)this.decimal, this.getSystem());
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.INTEGER, (Object)this.integer, this.getSystem());
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.FLOAT, (Object)this._float, this.getSystem());
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.SOSI, (Object)this.sosi, this.getSystem());
        } else if (this.dataFormat == DBX.DbxDataFormat.UNLOAD) {
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSV, (Object)false, this.getSystem());
        } else if (this.dataFormat == DBX.DbxDataFormat.CSV) {
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSV, (Object)true, this.getSystem());
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSVHDR, (Object)this.csvHdr, this.getSystem());
            if (this.isV15plus()) {
                dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSVLDG, (Object)this.csvLdg, this.getSystem());
                dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSVTLG, (Object)this.csvTlg, this.getSystem());
            }
            if (this.isV15_1_2plus()) {
                dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSVQUO, (Object)this.csvQuo, this.getSystem());
                dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSVSNQ, (Object)this.csvSnq, this.getSystem());
                dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.CSVLZE, (Object)this.csvLze, this.getSystem());
            }
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.SEPARATOR, (Object)this.separator, this.getSystem());
        }
        if (this.dataFormat != DBX.DbxDataFormat.CSV) {
            dbx.setValue((NewUtilityFunction.IUtilFuncParam)DBX.NATIVE, (Object)this._native, this.getSystem());
        }
        return dbx;
    }

    @Override
    public void fromUtilityFunction(DBX dbx) {
        this.setObjectOwner((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.OBJIOWNR, this.getSystem()));
        this.setObjectName((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.OBJINAME, this.getSystem()));
        this.setTemplateIn((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.TMIN, this.getSystem()));
        this.setResource((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.DSNOUT, this.getSystem()));
        this.setTemplateOut((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.TCOUT, this.getSystem()));
        String nullInd = (String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.NULLIND, this.getSystem());
        this.setNullIndicator(nullInd);
        this.setRows((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.ROWS, this.getSystem()));
        this.setNative((Boolean)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.NATIVE, this.getSystem()));
        this.setDataFormat((DBX.DbxDataFormat)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.DATAFORMAT, this.getSystem()));
        this.setPrintingNullIndicators(dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.NIUSAGE, this.getSystem()) == DBX.DbxNiUsage.SEPARATE);
        this.setPlace((DBX.DbxPlace)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.PLACE, this.getSystem()));
        if (ConversionUtil.isInt((String)nullInd)) {
            this.setNullIndicator((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.NIINTEGER, this.getSystem()));
        } else {
            this.setNullIndicator((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.NICHAR, this.getSystem()));
        }
        this.setDecimal((DBX.DbxDecimal)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.DECIMAL, this.getSystem()));
        this.setInteger((DBX.DbxInteger)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.INTEGER, this.getSystem()));
        this.setFloat((DBX.DbxFloat)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.FLOAT, this.getSystem()));
        this.setSosi((Boolean)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.SOSI, this.getSystem()));
        this.setCsvHdr((Boolean)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.CSVHDR, this.getSystem()));
        this.setCsvLdg((Boolean)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.CSVLDG, this.getSystem()));
        this.setCsvTlg((Boolean)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.CSVTLG, this.getSystem()));
        this.setCsvQuo((Boolean)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.CSVQUO, this.getSystem()));
        this.setCsvSnq((Boolean)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.CSVSNQ, this.getSystem()));
        this.setCsvLze((Boolean)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.CSVLZE, this.getSystem()));
        this.setSeparator((String)dbx.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBX.SEPARATOR, this.getSystem()));
    }

    private void guessDefaultDb2ObjectOwner() {
        if (this.objectOwner.isEmpty()) {
            try {
                AuthDetails auth = this.getSystem().getLogin(false);
                this.objectOwner = auth == null ? "" : auth.getUsername();
            }
            catch (InterruptedException e) {
                logger.trace((Object)"user cancelled providing backup owner for db2 object");
            }
        }
    }

    public Db2ExportModel clone() {
        Db2ExportModel clone = new Db2ExportModel(this.getSystem());
        clone.setSubsystem(this.getSubsystemSet());
        clone.dsom = this.dsom;
        clone.templateOut = this.templateOut;
        clone.objectOwner = Db2ObjectModelUtil.getObjectName(this.objectOwner);
        clone.objectName = Db2ObjectModelUtil.getObjectName(this.objectName);
        clone.templateIn = this.templateIn;
        clone.nullIndicator = this.nullIndicator;
        clone.rows = this.rows;
        clone._native = this._native;
        clone.dataFormat = this.dataFormat;
        clone.csvHdr = this.csvHdr;
        clone.csvLdg = this.csvLdg;
        clone.csvTlg = this.csvTlg;
        clone.csvQuo = this.csvQuo;
        clone.csvSnq = this.csvSnq;
        clone.csvLze = this.csvLze;
        clone.separator = this.separator;
        clone.place = this.place;
        clone.printingNullIndicators = this.printingNullIndicators;
        clone.decimal = this.decimal;
        clone.integer = this.integer;
        clone._float = this._float;
        clone.sosi = this.sosi;
        return clone;
    }

    public void setResource(DataSetOrMember dsom) {
        this.dsom = Objects.requireNonNull(dsom, "Must provide a non-null dsom").getFormattedName();
    }

    public void setResource(String dsom) {
        this.dsom = Objects.requireNonNull(dsom, "Must provide a non-null dsom");
    }

    public String getResource() {
        return this.dsom;
    }

    public String getTemplateInSet() {
        return this.templateIn;
    }

    public Member getTemplateIn() {
        if (Member.isParseable((String)this.templateIn, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.templateIn).asMember();
        }
        return null;
    }

    public void setTemplateIn(String templateIn) {
        this.templateIn = templateIn;
    }

    public void setObject(Db2Table object) {
        Objects.requireNonNull(object, "Must provide a non-null object");
        if (!object.getSubsystem().equals((Object)this.getSubsystem())) {
            throw new IllegalArgumentException(object.getSubsystem().toString());
        }
        this.objectOwner = Db2ObjectModelUtil.getObjectName(object.getOwner());
        this.objectName = Db2ObjectModelUtil.getObjectName(object.getName());
    }

    public Db2Table getObject() {
        Db2Subsystem subSys = this.getSubsystem();
        if (subSys != null && Db2Table.isValidName((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectName)) && Db2Table.isValidOwner((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectOwner))) {
            return new Db2Table(subSys, Db2ObjectModelUtil.getObjectName(this.objectName), Db2ObjectModelUtil.getObjectName(this.objectOwner));
        }
        return null;
    }

    public String getObjectOwner() {
        return this.objectOwner;
    }

    public void setObjectOwner(String objectOwner) {
        this.objectOwner = Db2ObjectModelUtil.getObjectName(objectOwner);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = Db2ObjectModelUtil.getObjectName(objectName);
    }

    public String getTemplateOutSet() {
        return this.templateOut;
    }

    public Member getTemplateOut() {
        if (Member.isParseable((String)this.templateOut, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.templateOut).asMember();
        }
        return null;
    }

    public void setTemplateOut(String templateOut) {
        this.templateOut = templateOut;
    }

    public String getNullIndicator() {
        if (this.dataFormat == DBX.DbxDataFormat.SQLDA || this.dataFormat == DBX.DbxDataFormat.UNLOAD || this.dataFormat == DBX.DbxDataFormat.DSNTIAUL) {
            return "";
        }
        return this.nullIndicator;
    }

    public void setNullIndicator(String nullIndicator) {
        this.nullIndicator = nullIndicator;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public boolean isNative() {
        return this._native;
    }

    public void setNative(boolean _native) {
        this._native = _native;
    }

    public DBX.DbxDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DBX.DbxDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public boolean isCsvHdr() {
        return this.csvHdr;
    }

    public void setCsvHdr(boolean csvHdr) {
        this.csvHdr = csvHdr;
    }

    public boolean isCsvLdg() {
        return this.csvLdg;
    }

    public void setCsvLdg(boolean csvLdg) {
        this.csvLdg = csvLdg;
    }

    public boolean isCsvTlg() {
        return this.csvTlg;
    }

    public void setCsvTlg(boolean csvTlg) {
        this.csvTlg = csvTlg;
    }

    public boolean isCsvQuo() {
        return this.csvQuo;
    }

    public void setCsvQuo(boolean csvQuo) {
        this.csvQuo = csvQuo;
    }

    public boolean isCsvSnq() {
        return this.csvSnq;
    }

    public void setCsvSnq(boolean csvSnq) {
        this.csvSnq = csvSnq;
    }

    public boolean isCsvLze() {
        return this.csvLze;
    }

    public void setCsvLze(boolean csvLze) {
        this.csvLze = csvLze;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public DBX.DbxPlace getPlace() {
        return this.place;
    }

    public void setPlace(DBX.DbxPlace place) {
        this.place = place;
    }

    public boolean isPrintingNullIndicators() {
        if (this.dataFormat == DBX.DbxDataFormat.SQLDA || this.dataFormat == DBX.DbxDataFormat.UNLOAD || this.dataFormat == DBX.DbxDataFormat.DSNTIAUL || this.dataFormat == DBX.DbxDataFormat.CSV) {
            return true;
        }
        return this.printingNullIndicators;
    }

    public void setPrintingNullIndicators(boolean niUsage) {
        this.printingNullIndicators = niUsage;
    }

    public DBX.DbxDecimal getDecimal() {
        return this.decimal;
    }

    public void setDecimal(DBX.DbxDecimal decimal) {
        this.decimal = decimal;
    }

    public DBX.DbxInteger getInteger() {
        return this.integer;
    }

    public void setInteger(DBX.DbxInteger integer) {
        this.integer = integer;
    }

    public DBX.DbxFloat getFloat() {
        return this._float;
    }

    public void setFloat(DBX.DbxFloat _float) {
        this._float = _float;
    }

    public boolean isSosi() {
        return this.sosi;
    }

    public void setSosi(boolean sosi) {
        this.sosi = sosi;
    }

    private IZRL getResourceParsed() {
        IZRL parsedResource = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.dsom);
        return parsedResource;
    }

    public IZRL getResourceZRL() {
        if (this.getSystem() != null && ZRLs.isParseable((IPDHost)this.getSystem(), (String)this.dsom)) {
            return this.getResourceParsed();
        }
        return null;
    }

    public String validateResourceTypes(IHowIsGoing monitor, final Db2ExportWizardPageFirst page) throws InterruptedException {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                page.disableFinish();
            }
        });
        IZRL resource = this.getResourceZRL();
        if (resource instanceof DataSetOrMember) {
            DataSet exportDataSet = ((DataSetOrMember)resource).asDataSet();
            if (!(this.dsomLoaded instanceof DataSet && resource.equals(this.dsomLoaded) && exportDataSet.getAllVolumes().equals(((DataSet)this.dsomLoaded).getAllVolumes()) && exportDataSet.getConfirmedExists())) {
                Result refreshExistence = exportDataSet.refreshExistence(monitor);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        page.disableFinish();
                    }
                });
                refreshExistence.isSuccessfulWithoutWarnings();
                this.dsomLoaded = exportDataSet;
            }
            if (!exportDataSet.getConfirmedExists()) {
                return Messages.DSPCommand_RESOURCE_NO_EXIST;
            }
        } else if (resource instanceof CicsFile) {
            CicsFile oldCicsFile = (CicsFile)resource;
            if (!(this.dsomLoaded instanceof CicsFile) || !resource.equals(this.dsomLoaded)) {
                oldCicsFile.refreshSelf(monitor);
                this.dsomLoaded = oldCicsFile;
            }
            if (!oldCicsFile.getConfirmedExists()) {
                return Messages.DSPCommand_RESOURCE_NO_EXIST;
            }
            if (!oldCicsFile.isOpen()) {
                return Messages.DSPCommand_CICS_FILE_CLOSED;
            }
        }
        return null;
    }

    void promptToAllocate(IHowIsGoing howIsGoing, final Db2ExportWizardPageFirst page) throws InterruptedException {
        DataSetOrMember dsom;
        Result r;
        if (this.getResourceZRL() != null && this.getResourceZRL() instanceof DataSetOrMember && (r = (dsom = (DataSetOrMember)this.getResourceZRL()).refreshSelf(howIsGoing)).isSuccessfulWithoutWarnings() && !dsom.getConfirmedExists()) {
            final AtomicInteger result = new AtomicInteger();
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AllocateDataSetModel allocateParams = new AllocateDataSetModel();
                    if (Db2ExportModel.this.getResourceZRL() instanceof DataSetOrMember) {
                        DataSet dataSet = ((DataSetOrMember)Db2ExportModel.this.getResourceZRL()).asDataSet();
                        if (dataSet.getProperties() == null || dataSet.getProperties().getPropertyCount() == 0) {
                            try {
                                ZrlLoaderDialogUtils.refreshDataSetProperties((DataSetOrMember)dataSet);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        allocateParams.setDataSetName(Db2ExportModel.this.getResource());
                    }
                    allocateParams.setHost(Db2ExportModel.this.getSystem());
                    allocateParams.setDataSetType(DataSetType.PS);
                    allocateParams.setAllocationUnits(DSAQ.SpaceUnit.TRK);
                    allocateParams.setAllocationPrimary("1");
                    allocateParams.setAllocationSecondary("5");
                    allocateParams.setQSAMrecordFormat(DSAQ.QsamRecordFormat.VB);
                    allocateParams.setQSAMrecordLength("32760");
                    AllocateDataSetWizard wizard = AllocateDataSetWizard.create(allocateParams);
                    page.disableFinish();
                    final AllocateDataSetActionItem action = new AllocateDataSetActionItem(allocateParams, Db2ExportModel.this.getSystem());
                    try {
                        wizard.getRunnable().addCallback(new Runnable(){

                            @Override
                            public void run() {
                                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
                                page.enableFinish();
                            }
                        });
                        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
                        result.set(PDScrollableWizardDialog.openWizard((IWizard)wizard));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            if (result.get() == 1) {
                throw new InterruptedException();
            }
        }
    }
}

