/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportActionItem;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportModel;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class Db2ExportHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (host == null) {
            return;
        }
        Db2ExportHandler.showDb2ExportWizard(selected, host);
    }

    public static void showDb2ExportWizard(Object selected, IPDHost host) {
        Db2ExportModel model = new Db2ExportModel(host);
        if (selected instanceof Db2Subsystem) {
            model.setSubsystem((Db2Subsystem)selected);
        } else if (selected instanceof Db2ObjectQuery) {
            Db2ObjectQuery query = (Db2ObjectQuery)selected;
            model.setSubsystem(query.getSubsystem());
            model.setObjectOwner(Db2ObjectQuery.stripWildcards((String)query.getOwnerPattern()));
            model.setObjectName(Db2ObjectQuery.stripWildcards((String)query.getNamePattern()));
        } else if (selected instanceof Db2Table) {
            Db2Table table = (Db2Table)selected;
            model.setSubsystem(table.getSubsystem());
            model.setObject(table);
        }
        Db2ExportHandler.showDb2ExportWizard(model);
    }

    public static void showDb2ExportWizard(Db2ExportModel model) {
        Objects.requireNonNull(model, "Must provide a non-null model.");
        Db2ExportWizard wizard = new Db2ExportWizard(model);
        final Db2ExportActionItem action = new Db2ExportActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

