/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.socket.func.db2.DBX;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportModel;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportRunnable;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Db2ExportActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_SUBSYSTEM = "ssid";
    private Db2ExportModel model;

    public Db2ExportActionItem(Db2ExportModel model) {
        super(ActionType.DBX, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        Db2Table object = this.model.getObject();
        return MessageFormat.format(Messages.Db2ExportActionItem_EXPORT_FROM_X_TO_Y, object == null ? Messages.Db2ExportActionItem_ObjectNotSpecified : object.getFormattedName(), this.model.getObjectOwner(), this.model.getResource());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        memento.putString(KEY_SUBSYSTEM, this.model.getSubsystem().getName());
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        DBX function = new DBX();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        Db2ExportModel model = new Db2ExportModel(system);
        model.setSubsystem(memento.getString(KEY_SUBSYSTEM));
        model.fromUtilityFunction(function);
        return new Db2ExportActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        Db2ExportRunnable runnable = new Db2ExportRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final Db2ExportModel clone = this.model.clone();
        Db2ExportWizard wizard = new Db2ExportWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                Db2ExportActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public Db2ExportActionItem clone() {
        Db2ExportActionItem clone = new Db2ExportActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Db2ExportActionItem) {
            return this.model.equals(((Db2ExportActionItem)obj).model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.model.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        return new Db2ExportActionItemPropertySource(this.model);
    }

    private static class Db2ExportActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private static final Object KEY_RESOURCE = new Object();
        private static final Object KEY_TEMPLATE_OUT = new Object();
        private static final Object KEY_OBJECT_OWNER = new Object();
        private static final Object KEY_OBJECT_NAME = new Object();
        private static final Object KEY_TEMPLATE_IN = new Object();
        private static final Object KEY_NULL_INDICATOR = new Object();
        private static final Object KEY_ROWS = new Object();
        private static final Object KEY_NATIVE = new Object();
        private static final Object KEY_DATA_FORMAT = new Object();
        private static final Object KEY_CSV_HDR = new Object();
        private static final Object KEY_CSV_LDG = new Object();
        private static final Object KEY_CSV_TLG = new Object();
        private static final Object KEY_CSV_QUO = new Object();
        private static final Object KEY_CSV_SNQ = new Object();
        private static final Object KEY_CSV_LZE = new Object();
        private static final Object KEY_SEPARATOR = new Object();
        private static final Object KEY_PLACE = new Object();
        private static final Object KEY_NI_USAGE = new Object();
        private static final Object KEY_DECIMAL = new Object();
        private static final Object KEY_INTEGER = new Object();
        private static final Object KEY_FLOAT = new Object();
        private static final Object KEY_SOSI = new Object();
        private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_RESOURCE, Messages.Db2ExportActionItem_RESOURCE), new PropertyDescriptor(KEY_TEMPLATE_OUT, Messages.Db2ExportActionItem_TEMPLATE_OUT), new PropertyDescriptor(KEY_OBJECT_OWNER, Messages.Db2ExportActionItem_OBJECT_OWNER), new PropertyDescriptor(KEY_OBJECT_NAME, Messages.Db2ExportActionItem_OBJECT_NAME), new PropertyDescriptor(KEY_TEMPLATE_IN, Messages.Db2ExportActionItem_TEMPLATE_IN), new PropertyDescriptor(KEY_NULL_INDICATOR, Messages.Db2ExportActionItem_NULL_INDICATOR), new PropertyDescriptor(KEY_ROWS, Messages.Db2ExportActionItem_ROWS), new PropertyDescriptor(KEY_NATIVE, Messages.Db2ExportActionItem_NATIVE), new PropertyDescriptor(KEY_DATA_FORMAT, Messages.Db2ExportActionItem_DATA_FORMAT), new PropertyDescriptor(KEY_CSV_HDR, Messages.Db2ExportActionItem_CSV_HDR), new PropertyDescriptor(KEY_CSV_LDG, Messages.Db2ExportActionItem_CSV_LDG), new PropertyDescriptor(KEY_CSV_TLG, Messages.Db2ExportActionItem_CSV_TLG), new PropertyDescriptor(KEY_CSV_QUO, Messages.Db2ExportActionItem_CSV_QUO), new PropertyDescriptor(KEY_CSV_SNQ, Messages.Db2ExportActionItem_CSV_SNQ), new PropertyDescriptor(KEY_CSV_LZE, Messages.Db2ExportActionItem_CSV_LZE), new PropertyDescriptor(KEY_SEPARATOR, Messages.Db2ExportActionItem_SEPARATOR), new PropertyDescriptor(KEY_PLACE, Messages.Db2ExportActionItem_PLACE), new PropertyDescriptor(KEY_NI_USAGE, Messages.Db2ExportActionItem_NI_USAGE), new PropertyDescriptor(KEY_DECIMAL, Messages.Db2ExportActionItem_DECIMAL), new PropertyDescriptor(KEY_INTEGER, Messages.Db2ExportActionItem_INTEGER), new PropertyDescriptor(KEY_FLOAT, Messages.Db2ExportActionItem_FLOAT), new PropertyDescriptor(KEY_SOSI, Messages.Db2ExportActionItem_SOSI)};
        private Db2ExportModel model;

        public Db2ExportActionItemPropertySource(Db2ExportModel model) {
            this.model = model;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return DESCRIPTORS;
        }

        public Object getEditableValue() {
            return null;
        }

        public Object getPropertyValue(Object id) {
            if (KEY_RESOURCE.equals(id)) {
                return this.model.getResource();
            }
            if (KEY_TEMPLATE_OUT.equals(id)) {
                return this.model.getTemplateOutSet();
            }
            if (KEY_OBJECT_OWNER.equals(id)) {
                return this.model.getObjectOwner();
            }
            if (KEY_OBJECT_NAME.equals(id)) {
                return this.model.getObjectName();
            }
            if (KEY_TEMPLATE_IN.equals(id)) {
                return this.model.getTemplateInSet();
            }
            if (KEY_NULL_INDICATOR.equals(id)) {
                return this.model.getNullIndicator();
            }
            if (KEY_ROWS.equals(id)) {
                return this.model.getRows();
            }
            if (KEY_NATIVE.equals(id)) {
                return this.model.isNative() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_DATA_FORMAT.equals(id)) {
                return this.model.getDataFormat().getName();
            }
            if (KEY_CSV_HDR.equals(id)) {
                return this.model.isCsvHdr() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_CSV_LDG.equals(id)) {
                return this.model.isCsvLdg() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_CSV_TLG.equals(id)) {
                return this.model.isCsvTlg() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_CSV_QUO.equals(id)) {
                return this.model.isCsvQuo() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_CSV_SNQ.equals(id)) {
                return this.model.isCsvSnq() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_CSV_LZE.equals(id)) {
                return this.model.isCsvLze() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_SEPARATOR.equals(id)) {
                return this.model.getSeparator();
            }
            if (KEY_PLACE.equals(id)) {
                return this.model.getPlace().getName();
            }
            if (KEY_NI_USAGE.equals(id)) {
                return this.model.isPrintingNullIndicators() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_DECIMAL.equals(id)) {
                return this.model.getDecimal().getName();
            }
            if (KEY_INTEGER.equals(id)) {
                return this.model.getInteger().getName();
            }
            if (KEY_FLOAT.equals(id)) {
                return this.model.getFloat().getName();
            }
            if (KEY_SOSI.equals(id)) {
                return this.model.isSosi() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

