/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.core.socket.func.db2.DBC;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.Db2TableContentProposals;
import com.ibm.etools.fm.ui.wizards.db2.Db2CopyModel;
import com.ibm.etools.fm.ui.wizards.db2.IFmDb2WizardPage;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.text.MessageFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Db2CopyWizardPageFirst
extends WizardPage
implements IFmDb2WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.Db2CopyWizardPageFirst_TITLE;
    private final Db2CopyModel model;
    private Db2CopyWizardPageFirstConnector connector = new Db2CopyWizardPageFirstConnector();
    private Combo wSubsystem;
    private Button wSubsystemLookup;
    private Combo wObjectInOwner;
    private Button wObjectInOwnerLookup;
    private Combo wObjectInName;
    private Button wObjectInNameLookup;
    private Combo wTemplateIn;
    private Button wTemplateInEdit;
    private Combo wObjectOutOwner;
    private Button wObjectOutOwnerLookup;
    private Combo wObjectOutName;
    private Button wObjectOutNameLookup;
    private Combo wTemplateOut;
    private Button wTemplateOutEdit;
    private Button wNative;
    private Button wUncommittedRead;
    private Button wLockNone;
    private Button wLockShare;
    private Button wLockExclusive;
    private Button wDuplicateKey;
    private Combo wDuplicateMax;
    private Button wRefi;
    private Button wDeleteRows;
    private Combo wRows;

    protected Db2CopyWizardPageFirst(Db2CopyModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.Db2CopyWizardPageFirst_DEFAULT_MSG);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group systemGroup = GUI.group((Composite)parent, (String)Messages.__SYSTEM, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)systemGroup, (String)Messages.LABEL__DB2_SUBSYSTEM, (Object)GUI.grid.d.left1());
        this.wSubsystem = GUI.combo.editable((Composite)systemGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wSubsystem.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new ComboValueSaver(this.wSubsystem, this.getClass().getCanonicalName() + "Subsystem");
        this.wSubsystemLookup = LookupButton.createLookupButtonLeft1((Composite)systemGroup);
        this.wSubsystemLookup.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(Db2CopyWizardPageFirst.this.model.getHostProvider().getSystem());
                if (lookup.open() == 0) {
                    Db2CopyWizardPageFirst.this.wSubsystemLookup.setFocus();
                    Db2CopyWizardPageFirst.this.model.setSubsystem((Db2Subsystem)lookup.getFirstSelectedObject());
                    Db2CopyWizardPageFirst.this.model.fireModelChangeEvent();
                    Db2CopyWizardPageFirst.this.wSubsystem.setText(Db2CopyWizardPageFirst.this.model.getSubsystemSet());
                }
            }
        });
        Group sourceGroup = GUI.group((Composite)parent, (String)Messages.Db2CopyWizardPageFirst_SOURCE_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Listener objectInLookup = new Listener(){

            public void handleEvent(Event event) {
                Db2TableLookupDialog lookup = new Db2TableLookupDialog(Db2CopyWizardPageFirst.this.model.getSubsystem());
                lookup.setInitialOwnerPattern(Db2CopyWizardPageFirst.this.wObjectInOwner.getText());
                lookup.setInitialNamePattern(Db2CopyWizardPageFirst.this.wObjectInName.getText());
                if (lookup.open() == 0) {
                    Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                    Db2CopyWizardPageFirst.this.model.setObjectIn(selected);
                    Db2CopyWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        };
        GUI.label.left((Composite)sourceGroup, (String)Messages.Db2CopyWizardPageFirst_OWNER, (Object)GUI.grid.d.left1());
        this.wObjectInOwner = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wObjectInOwnerLookup = LookupButton.createLookupButtonLeft1((Composite)sourceGroup);
        this.wObjectInOwnerLookup.addListener(13, objectInLookup);
        GUI.label.left((Composite)sourceGroup, (String)Messages.Db2CopyWizardPageFirst_NAME, (Object)GUI.grid.d.left1());
        this.wObjectInName = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)2));
        Db2TableContentProposals.addTo(this.wObjectInOwner, this.wObjectInName, this.model, this.getClass().getCanonicalName() + "ObjIn");
        this.wObjectInNameLookup = LookupButton.createLookupButtonLeft1((Composite)sourceGroup);
        this.wObjectInNameLookup.addListener(13, objectInLookup);
        GUI.label.left((Composite)sourceGroup, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateIn = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateInEdit = GUI.button.push((Composite)sourceGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateInEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities2.openTemplateEditSession(new Db2TemplateOptions((Db2SubsystemProvider)Db2CopyWizardPageFirst.this.model.getObjectIn(), (DataSetOrMember)Db2CopyWizardPageFirst.this.model.getTemplateIn()));
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)sourceGroup), this.wTemplateIn, (IHostProvider)this.model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof Member) {
                    Db2CopyWizardPageFirst.this.model.setTemplateIn(zrl.getFormattedName());
                    Db2CopyWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "TemplateIn").create();
        Group destGroup = GUI.group((Composite)parent, (String)Messages.Db2CopyWizardPageFirst_DEST_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Listener objectOutLookup = new Listener(){

            public void handleEvent(Event event) {
                Db2TableLookupDialog lookup = new Db2TableLookupDialog(Db2CopyWizardPageFirst.this.model.getSubsystem());
                lookup.setInitialOwnerPattern(Db2CopyWizardPageFirst.this.wObjectOutOwner.getText());
                lookup.setInitialNamePattern(Db2CopyWizardPageFirst.this.wObjectOutName.getText());
                if (lookup.open() == 0) {
                    Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                    Db2CopyWizardPageFirst.this.model.setObjectOut(selected);
                    Db2CopyWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        };
        GUI.label.left((Composite)destGroup, (String)Messages.Db2CopyWizardPageFirst_OWNER, (Object)GUI.grid.d.left1());
        this.wObjectOutOwner = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wObjectOutOwnerLookup = LookupButton.createLookupButtonLeft1((Composite)destGroup);
        this.wObjectOutOwnerLookup.addListener(13, objectOutLookup);
        GUI.label.left((Composite)destGroup, (String)Messages.Db2CopyWizardPageFirst_NAME, (Object)GUI.grid.d.left1());
        this.wObjectOutName = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)2));
        Db2TableContentProposals.addTo(this.wObjectOutOwner, this.wObjectOutName, this.model, this.getClass().getCanonicalName() + "Obj");
        this.wObjectOutNameLookup = LookupButton.createLookupButtonLeft1((Composite)destGroup);
        this.wObjectOutNameLookup.addListener(13, objectOutLookup);
        GUI.label.left((Composite)destGroup, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateOut = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateOutEdit = GUI.button.push((Composite)destGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateOutEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities2.openTemplateEditSession(new Db2TemplateOptions((Db2SubsystemProvider)Db2CopyWizardPageFirst.this.model.getObjectOut(), (DataSetOrMember)Db2CopyWizardPageFirst.this.model.getTemplateOut()));
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)destGroup), this.wTemplateOut, (IHostProvider)this.model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof Member) {
                    Db2CopyWizardPageFirst.this.model.setTemplateOut(zrl.getFormattedName());
                    Db2CopyWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "TemplateOut").create();
        Group optionsGroup = GUI.group((Composite)parent, (String)Messages.Db2CopyWizardPageFirst_OPTS_GROUP, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2CopyWizardPageFirst_NUM_ROWS, (Object)GUI.grid.d.left1());
        this.wRows = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wRows, this.getClass().getCanonicalName() + "Rows");
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2CopyWizardPageFirst_DUPLICATE_MAX, (Object)GUI.grid.d.left1());
        this.wDuplicateMax = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wRows, this.getClass().getCanonicalName() + "DupMax");
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2CopyWizardPageFirst_LOCKING, (Object)GUI.grid.d.left1());
        Composite lockComp = GUI.composite((Composite)optionsGroup, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.wLockNone = GUI.button.radio((Composite)lockComp, (String)DBC.DbcLock.NONE.getName(), (Object)GUI.grid.d.fillH((int)1));
        this.wLockShare = GUI.button.radio((Composite)lockComp, (String)DBC.DbcLock.SHARE.getName(), (Object)GUI.grid.d.fillH((int)1));
        this.wLockExclusive = GUI.button.radio((Composite)lockComp, (String)DBC.DbcLock.EXCL.getName(), (Object)GUI.grid.d.fillH((int)1));
        this.wNative = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2CopyWizardPageFirst_NATIVE, (Object)GUI.grid.d.fillH((int)2));
        this.wUncommittedRead = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2CopyWizardPageFirst_UNCOMMITTED_READ, (Object)GUI.grid.d.fillH((int)2));
        this.wDuplicateKey = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2CopyWizardPageFirst_UPDATE_DUPLICATES, (Object)GUI.grid.d.fillH((int)2));
        this.wRefi = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2CopyWizardPageFirst_REFI, (Object)GUI.grid.d.fillH((int)2));
        this.wDeleteRows = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2CopyWizardPageFirst_DELETE_DEST_ROWS, (Object)GUI.grid.d.fillH((int)2));
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wSubsystem);
        this.connector.listenTo((Control)this.wObjectInOwner);
        this.connector.listenTo((Control)this.wObjectInName);
        this.connector.listenTo((Control)this.wTemplateIn);
        this.connector.listenTo((Control)this.wObjectOutOwner);
        this.connector.listenTo((Control)this.wObjectOutName);
        this.connector.listenTo((Control)this.wTemplateOut);
        this.connector.listenTo((Control)this.wNative);
        this.connector.listenTo((Control)this.wUncommittedRead);
        this.connector.listenTo((Control)this.wLockNone);
        this.connector.listenTo((Control)this.wLockShare);
        this.connector.listenTo((Control)this.wLockExclusive);
        this.connector.listenTo((Control)this.wDuplicateKey);
        this.connector.listenTo((Control)this.wDuplicateMax);
        this.connector.listenTo((Control)this.wRefi);
        this.connector.listenTo((Control)this.wDeleteRows);
        this.connector.listenTo((Control)this.wRows);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
            ModelViewConnector.guessFocus((Control)this.getControl());
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        if (this.model.getSubsystem() == null) {
            return Messages.Db2CopyWizardPageFirst_INVALID_SUBSYSTEM;
        }
        if (!Db2Table.isValidName((IPDHost)this.model.getSystem(), (String)this.model.getObjectInName())) {
            return Messages.Db2CopyWizardPageFirst_INVALID_SOURCE_OBJECT_NAME;
        }
        if (!Db2Table.isValidName((IPDHost)this.model.getSystem(), (String)this.model.getObjectOutName())) {
            return Messages.Db2CopyWizardPageFirst_INVALID_DEST_OBJECT_NAME;
        }
        if (this.model.getObjectIn() != null && this.model.getObjectIn().equals((Object)this.model.getObjectOut())) {
            return Messages.Db2CopyWizardPageFirst_SOURCE_DEST_MUST_BE_DIFF;
        }
        if (this.model.getTemplateInSet().length() > 0 && !Member.isParseable((String)this.model.getTemplateInSet(), (boolean)true, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2CopyWizardPageFirst_INVALID_SOURCE_TEMPLATE;
        }
        if (this.model.getTemplateOutSet().length() > 0 && !Member.isParseable((String)this.model.getTemplateOutSet(), (boolean)true, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2CopyWizardPageFirst_INVALID_DEST_TEMPLATE;
        }
        if (this.model.getDuplicateMax().length() > 0 && !"ALL".equals(this.model.getDuplicateMax()) && !UIValidator.isInRange(this.model.getDuplicateMax(), 0, Integer.MAX_VALUE)) {
            return Messages.Db2CopyWizardPageFirst_INVALID_DUPLICATE_MAX;
        }
        if (this.model.getRows().length() > 0 && !"ALL".equals(this.model.getRows()) && !UIValidator.isInRange(this.model.getRows(), 1, 99999999)) {
            return Messages.Db2CopyWizardPageFirst_INVALID_ROW_COUNT;
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    @Override
    public boolean validateDb2Object() {
        Result result;
        Db2Table inTable = this.model.getObjectIn();
        if (!ZrlLoaderDialogUtils.tableExists(inTable, result = new Result(), true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, inTable.getOwner(), inTable.getName()));
            return false;
        }
        Db2Table outTable = this.model.getObjectOut();
        if (!ZrlLoaderDialogUtils.tableExists(outTable, result = new Result(), true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, outTable.getOwner(), outTable.getName()));
            return false;
        }
        return true;
    }

    private class Db2CopyWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private Db2CopyWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wSubsystem)) {
                Db2CopyWizardPageFirst.this.model.setSubsystem(Db2CopyWizardPageFirst.this.wSubsystem.getText());
            }
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wObjectInOwner)) {
                Db2CopyWizardPageFirst.this.model.setObjectInOwner(Db2CopyWizardPageFirst.this.wObjectInOwner.getText());
            }
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wObjectInName)) {
                Db2CopyWizardPageFirst.this.model.setObjectInName(Db2CopyWizardPageFirst.this.wObjectInName.getText());
            }
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wTemplateIn)) {
                Db2CopyWizardPageFirst.this.model.setTemplateIn(Db2CopyWizardPageFirst.this.wTemplateIn.getText());
            }
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wObjectOutOwner)) {
                Db2CopyWizardPageFirst.this.model.setObjectOutOwner(Db2CopyWizardPageFirst.this.wObjectOutOwner.getText());
            }
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wObjectOutName)) {
                Db2CopyWizardPageFirst.this.model.setObjectOutName(Db2CopyWizardPageFirst.this.wObjectOutName.getText());
            }
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wTemplateOut)) {
                Db2CopyWizardPageFirst.this.model.setTemplateOut(Db2CopyWizardPageFirst.this.wTemplateOut.getText());
            }
            Db2CopyWizardPageFirst.this.model.setNative(Db2CopyWizardPageFirst.this.wNative.getSelection());
            Db2CopyWizardPageFirst.this.model.setUncommittedRead(Db2CopyWizardPageFirst.this.wUncommittedRead.getSelection());
            if (Db2CopyWizardPageFirst.this.wLockNone.getSelection()) {
                Db2CopyWizardPageFirst.this.model.setLock(DBC.DbcLock.NONE);
            } else if (Db2CopyWizardPageFirst.this.wLockShare.getSelection()) {
                Db2CopyWizardPageFirst.this.model.setLock(DBC.DbcLock.SHARE);
            } else if (Db2CopyWizardPageFirst.this.wLockExclusive.getSelection()) {
                Db2CopyWizardPageFirst.this.model.setLock(DBC.DbcLock.EXCL);
            }
            Db2CopyWizardPageFirst.this.model.setDuplicateKeyUpdate(Db2CopyWizardPageFirst.this.wDuplicateKey.getSelection());
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wDuplicateMax)) {
                Db2CopyWizardPageFirst.this.model.setDuplicateMax(Db2CopyWizardPageFirst.this.wDuplicateMax.getText());
            }
            Db2CopyWizardPageFirst.this.model.setRefiIgnore(Db2CopyWizardPageFirst.this.wRefi.getSelection());
            Db2CopyWizardPageFirst.this.model.setDeleteRows(Db2CopyWizardPageFirst.this.wDeleteRows.getSelection());
            if (Db2CopyWizardPageFirstConnector.focussed((Control)Db2CopyWizardPageFirst.this.wRows)) {
                Db2CopyWizardPageFirst.this.model.setRows(Db2CopyWizardPageFirst.this.wRows.getText());
            }
            Db2CopyWizardPageFirst.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wSubsystem, Db2CopyWizardPageFirst.this.model.getSubsystemSet());
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wObjectInOwner, Db2CopyWizardPageFirst.this.model.getObjectInOwner());
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wObjectInName, Db2CopyWizardPageFirst.this.model.getObjectInName());
            Db2CopyWizardPageFirst.this.wObjectInOwnerLookup.setEnabled(Db2CopyWizardPageFirst.this.model.getSubsystem() != null);
            Db2CopyWizardPageFirst.this.wObjectInNameLookup.setEnabled(Db2CopyWizardPageFirst.this.model.getSubsystem() != null);
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wTemplateIn, Db2CopyWizardPageFirst.this.model.getTemplateInSet());
            Db2CopyWizardPageFirst.this.wTemplateInEdit.setEnabled(Db2CopyWizardPageFirst.this.model.getObjectIn() != null && Db2CopyWizardPageFirst.this.model.getTemplateIn() != null);
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wObjectOutOwner, Db2CopyWizardPageFirst.this.model.getObjectOutOwner());
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wObjectOutName, Db2CopyWizardPageFirst.this.model.getObjectOutName());
            Db2CopyWizardPageFirst.this.wObjectOutOwnerLookup.setEnabled(Db2CopyWizardPageFirst.this.model.getSubsystem() != null);
            Db2CopyWizardPageFirst.this.wObjectOutNameLookup.setEnabled(Db2CopyWizardPageFirst.this.model.getSubsystem() != null);
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wTemplateOut, Db2CopyWizardPageFirst.this.model.getTemplateOutSet());
            Db2CopyWizardPageFirst.this.wTemplateOutEdit.setEnabled(Db2CopyWizardPageFirst.this.model.getObjectOut() != null && Db2CopyWizardPageFirst.this.model.getTemplateOut() != null);
            Db2CopyWizardPageFirst.this.wNative.setSelection(Db2CopyWizardPageFirst.this.model.isNative());
            Db2CopyWizardPageFirst.this.wUncommittedRead.setSelection(Db2CopyWizardPageFirst.this.model.isUncommittedRead());
            Db2CopyWizardPageFirst.this.wLockNone.setSelection(Db2CopyWizardPageFirst.this.model.getLock() == DBC.DbcLock.NONE);
            Db2CopyWizardPageFirst.this.wLockShare.setSelection(Db2CopyWizardPageFirst.this.model.getLock() == DBC.DbcLock.SHARE);
            Db2CopyWizardPageFirst.this.wLockExclusive.setSelection(Db2CopyWizardPageFirst.this.model.getLock() == DBC.DbcLock.EXCL);
            Db2CopyWizardPageFirst.this.wDuplicateKey.setSelection(Db2CopyWizardPageFirst.this.model.isDuplicateKeyUpdate());
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wDuplicateMax, Db2CopyWizardPageFirst.this.model.getDuplicateMax());
            Db2CopyWizardPageFirst.this.wRefi.setSelection(Db2CopyWizardPageFirst.this.model.isRefiIgnore());
            Db2CopyWizardPageFirst.this.wDeleteRows.setSelection(Db2CopyWizardPageFirst.this.model.isDeleteRows());
            this.updateComboFromModelIfNeeded(Db2CopyWizardPageFirst.this.wRows, Db2CopyWizardPageFirst.this.model.getRows());
            String validationErrorMessage = Db2CopyWizardPageFirst.this.getValidationErrorMessage();
            Db2CopyWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            Db2CopyWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }
    }
}

