/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.db2.DBC;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.wizards.db2.Db2ObjectModelUtil;
import com.ibm.etools.fm.ui.wizards.db2.Db2UtilFuncWizardModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Objects;

public class Db2CopyModel
extends Db2UtilFuncWizardModel<DBC> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Db2CopyModel.class);
    private String objectInOwner = "";
    private String objectInName = "";
    private String templateIn = "";
    private String objectOutOwner = "";
    private String objectOutName = "";
    private String templateOut = "";
    private boolean _native = false;
    private boolean uncommittedRead = false;
    private DBC.DbcLock lock = DBC.DbcLock.NONE;
    private boolean duplicateKeyUpdate = false;
    private String duplicateMax = "ALL";
    private boolean refiIgnore = false;
    private boolean deleteRows = false;
    private String rows = "ALL";

    public Db2CopyModel(IPDHost host) {
        super(host);
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        DBC dbc = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSubsystem().getSystem(), (IPDConnectEndpoint)this.getSubsystem(), (UtilityFunction)dbc, (IHowIsGoing)monitor);
    }

    @Override
    public DBC toUtilityFunction() {
        this.guessDefaultDb2ObjectOwner();
        DBC dbc = new DBC();
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.OBJIOWNR, (Object)Db2ObjectModelUtil.getObjectName(this.objectInOwner), this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.OBJINAME, (Object)Db2ObjectModelUtil.getObjectName(this.objectInName), this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.TMIN, (Object)this.templateIn, this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.OBJOOWNR, (Object)Db2ObjectModelUtil.getObjectName(this.objectOutOwner), this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.OBJONAME, (Object)Db2ObjectModelUtil.getObjectName(this.objectOutName), this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.TMOUT, (Object)this.templateOut, this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.NATIVE, (Object)this._native, this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.UCREAD, (Object)this.uncommittedRead, this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.LOCK, (Object)this.lock, this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.DUPKEY, (Object)(this.duplicateKeyUpdate ? DBC.DbcDupKey.UPDATE : DBC.DbcDupKey.IGNORE), this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.DUPMAX, (Object)this.duplicateMax, this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.REFI, (Object)(this.refiIgnore ? DBC.DbcRefi.IGNORE : DBC.DbcRefi.FAIL), this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.DELROWS, (Object)this.deleteRows, this.getSystem());
        dbc.setValue((NewUtilityFunction.IUtilFuncParam)DBC.ROWS, (Object)this.rows, this.getSystem());
        return dbc;
    }

    @Override
    public void fromUtilityFunction(DBC dbc) {
        this.setObjectInOwner((String)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.OBJIOWNR, this.getSystem()));
        this.setObjectInName((String)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.OBJINAME, this.getSystem()));
        this.setTemplateIn((String)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.TMIN, this.getSystem()));
        this.setObjectOutOwner((String)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.OBJOOWNR, this.getSystem()));
        this.setObjectOutName((String)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.OBJONAME, this.getSystem()));
        this.setTemplateOut((String)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.TMOUT, this.getSystem()));
        this.setNative((Boolean)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.NATIVE, this.getSystem()));
        this.setUncommittedRead((Boolean)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.UCREAD, this.getSystem()));
        this.setLock((DBC.DbcLock)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.LOCK, this.getSystem()));
        this.setDuplicateKeyUpdate(dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.DUPKEY, this.getSystem()) == DBC.DbcDupKey.UPDATE);
        this.setDuplicateMax((String)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.DUPMAX, this.getSystem()));
        this.setRefiIgnore(dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.REFI, this.getSystem()) == DBC.DbcRefi.IGNORE);
        this.setDeleteRows((Boolean)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.DELROWS, this.getSystem()));
        this.setRows((String)dbc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBC.ROWS, this.getSystem()));
    }

    private void guessDefaultDb2ObjectOwner() {
        if (this.objectInOwner.isEmpty() || this.objectOutOwner.isEmpty()) {
            String backupOwner = "";
            try {
                AuthDetails auth = this.getSystem().getLogin(false);
                backupOwner = auth == null ? "" : auth.getUsername();
            }
            catch (InterruptedException e) {
                logger.trace((Object)"user cancelled providing backup owner for db2 objects");
            }
            if (this.objectInOwner.isEmpty()) {
                this.objectInOwner = backupOwner;
            }
            if (this.objectOutOwner.isEmpty()) {
                this.objectOutOwner = backupOwner;
            }
        }
    }

    public Db2CopyModel clone() {
        Db2CopyModel clone = new Db2CopyModel(this.getSystem());
        clone.setSubsystem(this.getSubsystemSet());
        clone.objectInOwner = Db2ObjectModelUtil.getObjectName(this.objectInOwner);
        clone.objectInName = Db2ObjectModelUtil.getObjectName(this.objectInName);
        clone.templateIn = this.templateIn;
        clone.objectOutOwner = Db2ObjectModelUtil.getObjectName(this.objectOutOwner);
        clone.objectOutName = Db2ObjectModelUtil.getObjectName(this.objectOutName);
        clone.templateOut = this.templateOut;
        clone._native = this._native;
        clone.uncommittedRead = this.uncommittedRead;
        clone.lock = this.lock;
        clone.duplicateKeyUpdate = this.duplicateKeyUpdate;
        clone.duplicateMax = this.duplicateMax;
        clone.refiIgnore = this.refiIgnore;
        clone.deleteRows = this.deleteRows;
        clone.rows = this.rows;
        return clone;
    }

    public String getTemplateInSet() {
        return this.templateIn;
    }

    public Member getTemplateIn() {
        if (Member.isParseable((String)this.templateIn, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.templateIn).asMember();
        }
        return null;
    }

    public void setTemplateIn(String templateIn) {
        this.templateIn = templateIn;
    }

    public void setObjectIn(Db2Table object) {
        Objects.requireNonNull(object, "Must provide a non-null object");
        if (!object.getSubsystem().equals((Object)this.getSubsystem())) {
            throw new IllegalArgumentException(object.getSubsystem().toString());
        }
        this.objectInOwner = Db2ObjectModelUtil.getObjectName(object.getOwner());
        this.objectInName = Db2ObjectModelUtil.getObjectName(object.getName());
    }

    public Db2Table getObjectIn() {
        Db2Subsystem subSys = this.getSubsystem();
        if (subSys != null && Db2Table.isValidName((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectInName)) && Db2Table.isValidOwner((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectInOwner))) {
            return new Db2Table(subSys, Db2ObjectModelUtil.getObjectName(this.objectInName), Db2ObjectModelUtil.getObjectName(this.objectInOwner));
        }
        return null;
    }

    public String getObjectInOwner() {
        return this.objectInOwner;
    }

    public void setObjectInOwner(String objectOwner) {
        this.objectInOwner = Db2ObjectModelUtil.getObjectName(objectOwner);
    }

    public String getObjectInName() {
        return this.objectInName;
    }

    public void setObjectInName(String objectName) {
        this.objectInName = Db2ObjectModelUtil.getObjectName(objectName);
    }

    public String getObjectOutOwner() {
        return this.objectOutOwner;
    }

    public void setObjectOutOwner(String objectOutOwner) {
        this.objectOutOwner = Db2ObjectModelUtil.getObjectName(objectOutOwner);
    }

    public String getObjectOutName() {
        return this.objectOutName;
    }

    public void setObjectOutName(String objectOutName) {
        this.objectOutName = Db2ObjectModelUtil.getObjectName(objectOutName);
    }

    public void setObjectOut(Db2Table object) {
        Objects.requireNonNull(object, "Must provide a non-null object");
        if (!object.getSubsystem().equals((Object)this.getSubsystem())) {
            throw new IllegalArgumentException(object.getSubsystem().toString());
        }
        this.objectOutOwner = object.getOwner();
        this.objectOutName = object.getName();
    }

    public Db2Table getObjectOut() {
        Db2Subsystem subSys = this.getSubsystem();
        if (subSys != null && Db2Table.isValidName((IPDHost)subSys.getSystem(), (String)this.objectOutName) && Db2Table.isValidOwner((IPDHost)subSys.getSystem(), (String)this.objectOutOwner)) {
            return new Db2Table(subSys, this.objectOutName, this.objectOutOwner);
        }
        return null;
    }

    public String getTemplateOutSet() {
        return this.templateOut;
    }

    public Member getTemplateOut() {
        if (Member.isParseable((String)this.templateOut, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.templateOut).asMember();
        }
        return null;
    }

    public void setTemplateOut(String templateOut) {
        this.templateOut = templateOut;
    }

    public boolean isNative() {
        return this._native;
    }

    public void setNative(boolean _native) {
        this._native = _native;
    }

    public boolean isUncommittedRead() {
        return this.uncommittedRead;
    }

    public void setUncommittedRead(boolean ucRead) {
        this.uncommittedRead = ucRead;
    }

    public DBC.DbcLock getLock() {
        return this.lock;
    }

    public void setLock(DBC.DbcLock lock) {
        this.lock = lock;
    }

    public boolean isDuplicateKeyUpdate() {
        return this.duplicateKeyUpdate;
    }

    public void setDuplicateKeyUpdate(boolean dupKey) {
        this.duplicateKeyUpdate = dupKey;
    }

    public String getDuplicateMax() {
        return this.duplicateMax;
    }

    public void setDuplicateMax(String dupMax) {
        this.duplicateMax = dupMax;
    }

    public boolean isRefiIgnore() {
        return this.refiIgnore;
    }

    public void setRefiIgnore(boolean refi) {
        this.refiIgnore = refi;
    }

    public boolean isDeleteRows() {
        return this.deleteRows;
    }

    public void setDeleteRows(boolean delRows) {
        this.deleteRows = delRows;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }
}

