/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.db2.Db2CopyActionItem;
import com.ibm.etools.fm.ui.wizards.db2.Db2CopyModel;
import com.ibm.etools.fm.ui.wizards.db2.Db2CopyWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class Db2CopyHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IPDHost host;
        List selectedItems = PDTreeHandlerUtil.getSelectedDataObjects((ExecutionEvent)event);
        if (!selectedItems.isEmpty() && (host = PDTreeHandlerUtil.getSystemFrom(selectedItems.get(0))) != null) {
            Db2CopyHandler.doOpen(selectedItems, host);
        }
    }

    public static void doOpen(List<Object> selectedItems, IPDHost host) {
        Objects.requireNonNull(selectedItems, "Please provide non-null  list of selected items.");
        Db2CopyModel model = new Db2CopyModel(host);
        boolean objectInGuessed = false;
        for (Object selected : selectedItems) {
            Db2Table table;
            Db2ObjectQuery query;
            if (!objectInGuessed) {
                if (selected instanceof Db2Subsystem) {
                    Db2Subsystem subsys = (Db2Subsystem)selected;
                    model.setSubsystem(subsys);
                } else if (selected instanceof Db2ObjectQuery) {
                    query = (Db2ObjectQuery)selected;
                    model.setSubsystem(query.getSubsystem());
                    model.setObjectInOwner(Db2ObjectQuery.stripWildcards((String)query.getOwnerPattern()));
                    model.setObjectInName(Db2ObjectQuery.stripWildcards((String)query.getNamePattern()));
                } else if (selected instanceof Db2Table) {
                    table = (Db2Table)selected;
                    model.setSubsystem(table.getSubsystem());
                    model.setObjectIn(table);
                }
                objectInGuessed = true;
                continue;
            }
            if (selected instanceof Db2ObjectQuery) {
                query = (Db2ObjectQuery)selected;
                model.setObjectOutOwner(Db2ObjectQuery.stripWildcards((String)query.getOwnerPattern()));
                model.setObjectOutName(Db2ObjectQuery.stripWildcards((String)query.getNamePattern()));
                continue;
            }
            if (!(selected instanceof Db2Table)) continue;
            table = (Db2Table)selected;
            model.setObjectOut(table);
        }
        Db2CopyHandler.showDb2CopyWizard(model);
    }

    public static void showDb2CopyWizard(Db2CopyModel model) {
        Objects.requireNonNull(model, "Must specify a non-null model.");
        Db2CopyWizard wizard = new Db2CopyWizard(model);
        final Db2CopyActionItem action = new Db2CopyActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

