/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.socket.func.db2.DBC;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.db2.Db2CopyModel;
import com.ibm.etools.fm.ui.wizards.db2.Db2CopyRunnable;
import com.ibm.etools.fm.ui.wizards.db2.Db2CopyWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Db2CopyActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_SUBSYSTEM = "ssid";
    private Db2CopyModel model;

    public Db2CopyActionItem(Db2CopyModel model) {
        super(ActionType.DBC, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.DSCActionItem_COPY_LABEL, this.model.getObjectIn().getFormattedName(), this.model.getObjectOut().getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        memento.putString(KEY_SUBSYSTEM, this.model.getSubsystem().getName());
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        DBC function = new DBC();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        Db2CopyModel model = new Db2CopyModel(system);
        model.setSubsystem(memento.getString(KEY_SUBSYSTEM));
        model.fromUtilityFunction(function);
        return new Db2CopyActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        Db2CopyRunnable runnable = new Db2CopyRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final Db2CopyModel clone = this.model.clone();
        Db2CopyWizard wizard = new Db2CopyWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                Db2CopyActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public Db2CopyActionItem clone() {
        Db2CopyActionItem clone = new Db2CopyActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Db2CopyActionItem) {
            Db2CopyActionItem other = (Db2CopyActionItem)obj;
            return this.model.equals(other.model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.model.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        return new Db2CopyActionItemPropertySource(this.model);
    }

    private static class Db2CopyActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private static final Object KEY_OBJECT_IN_OWNER = new Object();
        private static final Object KEY_OBJECT_IN_NAME = new Object();
        private static final Object KEY_TEMPLATE_IN = new Object();
        private static final Object KEY_OBJECT_OUT_OWNER = new Object();
        private static final Object KEY_OBJECT_OUT_NAME = new Object();
        private static final Object KEY_TEMPLATE_OUT = new Object();
        private static final Object KEY_NATIVE = new Object();
        private static final Object KEY_UNCOMMITTED_READ = new Object();
        private static final Object KEY_LOCK = new Object();
        private static final Object KEY_DUPLICATE_KEY = new Object();
        private static final Object KEY_DUPLICATE_MAX = new Object();
        private static final Object KEY_REFI = new Object();
        private static final Object KEY_DELETE_ROWS = new Object();
        private static final Object KEY_ROWS = new Object();
        private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_OBJECT_IN_OWNER, Messages.Db2CopyActionItem_OBJECT_IN_OWNER), new PropertyDescriptor(KEY_OBJECT_IN_NAME, Messages.Db2CopyActionItem_OBJECT_IN_NAME), new PropertyDescriptor(KEY_TEMPLATE_IN, Messages.Db2CopyActionItem_TEMPLATE_IN), new PropertyDescriptor(KEY_OBJECT_OUT_OWNER, Messages.Db2CopyActionItem_OBJECT_OUT_OWNER), new PropertyDescriptor(KEY_OBJECT_OUT_NAME, Messages.Db2CopyActionItem_OBJECT_OUT_NAME), new PropertyDescriptor(KEY_TEMPLATE_OUT, Messages.Db2CopyActionItem_TEMPLATE_OUT), new PropertyDescriptor(KEY_NATIVE, Messages.Db2CopyActionItem_NATIVE), new PropertyDescriptor(KEY_UNCOMMITTED_READ, Messages.Db2CopyActionItem_UNCOMMITTED_READ), new PropertyDescriptor(KEY_LOCK, Messages.Db2CopyActionItem_LOCK), new PropertyDescriptor(KEY_DUPLICATE_KEY, Messages.Db2CopyActionItem_DUPLICATE_KEY), new PropertyDescriptor(KEY_DUPLICATE_MAX, Messages.Db2CopyActionItem_DUPLICATE_MAX), new PropertyDescriptor(KEY_REFI, Messages.Db2CopyActionItem_REFI), new PropertyDescriptor(KEY_DELETE_ROWS, Messages.Db2CopyActionItem_DELETE_ROWS), new PropertyDescriptor(KEY_ROWS, Messages.Db2CopyActionItem_ROWS)};
        private Db2CopyModel model;

        public Db2CopyActionItemPropertySource(Db2CopyModel model) {
            this.model = model;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return DESCRIPTORS;
        }

        public Object getEditableValue() {
            return null;
        }

        public Object getPropertyValue(Object id) {
            if (KEY_OBJECT_IN_OWNER.equals(id)) {
                return this.model.getObjectInOwner();
            }
            if (KEY_OBJECT_IN_NAME.equals(id)) {
                return this.model.getObjectInName();
            }
            if (KEY_TEMPLATE_IN.equals(id)) {
                return this.model.getTemplateInSet();
            }
            if (KEY_OBJECT_OUT_OWNER.equals(id)) {
                return this.model.getObjectOutOwner();
            }
            if (KEY_OBJECT_OUT_NAME.equals(id)) {
                return this.model.getObjectOutName();
            }
            if (KEY_TEMPLATE_OUT.equals(id)) {
                return this.model.getTemplateOutSet();
            }
            if (KEY_NATIVE.equals(id)) {
                return this.model.isNative() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_UNCOMMITTED_READ.equals(id)) {
                return this.model.isUncommittedRead() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_LOCK.equals(id)) {
                return this.model.getLock().getName();
            }
            if (KEY_DUPLICATE_KEY.equals(id)) {
                return this.model.isDuplicateKeyUpdate() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_DUPLICATE_MAX.equals(id)) {
                return this.model.getDuplicateMax();
            }
            if (KEY_REFI.equals(id)) {
                return this.model.isRefiIgnore() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_DELETE_ROWS.equals(id)) {
                return this.model.isDeleteRows() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_ROWS.equals(id)) {
                return this.model.getRows();
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

