/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public abstract class WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(WizardRunnable.class);
    private final List<Runnable> callbacks = new ArrayList<Runnable>();
    private Result<StringBuffer> lastResult;

    public void addCallback(Runnable callback) {
        this.callbacks.add(Objects.requireNonNull(callback, "Must provide a non-null callback"));
    }

    public boolean run() {
        try {
            final AtomicBoolean canClose = new AtomicBoolean();
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    canClose.set(WizardRunnable.this.preWizardClose(howIsGoing));
                }
            });
            if (!canClose.get()) {
                return false;
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            return false;
        }
        Job job = new Job(this.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                Result<StringBuffer> finalResult = WizardRunnable.this.execute(howIsGoing);
                WizardRunnable.this.setResult(finalResult);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WizardRunnable.this.showResult();
                        for (Runnable callback : (this).WizardRunnable.this.callbacks) {
                            callback.run();
                        }
                    }
                });
            }
        });
        return true;
    }

    protected abstract String getName();

    protected boolean preWizardClose(IHowIsGoing monitor) {
        return true;
    }

    protected abstract Result<StringBuffer> execute(IHowIsGoing var1);

    protected void setResult(Result<StringBuffer> lastResult) {
        this.lastResult = lastResult;
    }

    public Result<StringBuffer> getResult() {
        return this.lastResult;
    }

    public abstract void showResult();

    public abstract boolean isCompletedSuccessfully();
}

