/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.socket.func.VLM;
import com.ibm.etools.fm.ui.dialog.MemberLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.callback.ISelectedValueFormatter;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.ResourceContentProposals;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.etools.fm.ui.wizards.ViewLoadModuleModel;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ViewLoadModuleWizardPageFirst
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ViewLoadModuleModel command;
    private Combo wDataSet;
    private Button wDataSetLookup;
    private Combo wVolume;
    private Button wMembersListChosen;
    private Combo wMembersList;
    private Button wMembersListLookup;
    private Button wMembersRangeChosen;
    private Label wMembersRangeStartLabel;
    private Combo wMembersRangeStart;
    private Label wMembersRangeEndLabel;
    private Combo wMembersRangeEnd;
    private Button wSortByName;
    private Button wSortByAddress;
    private Button wDateFormYYYYDDD;
    private Button wDateFormYYMMDD;

    protected ViewLoadModuleWizardPageFirst(ViewLoadModuleModel params) {
        super(Messages.Title_VLM_WIZARD_PAGE1);
        this.command = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_VLM_WIZARD_PAGE_SPECIFY_PARAMS);
    }

    public void setPageComplete(boolean complete) {
        if (this.wMembersListChosen.getSelection()) {
            this.command.setMemberSpecification(ViewLoadModuleModel.MemberSpecification.LIST);
        } else if (this.wMembersRangeChosen.getSelection()) {
            this.command.setMemberSpecification(ViewLoadModuleModel.MemberSpecification.RANGE);
        }
        if (complete) {
            Volume vol = null;
            if (Volume.isValid((String)this.wVolume.getText(), (String)this.command.getSystem().getCodePage())) {
                vol = Volume.create((IPDHost)this.command.getSystem(), (String)this.wVolume.getText());
            }
            if (DataSet.isValidName((String)this.wDataSet.getText(), (String)this.command.getHostProvider().getCodePage())) {
                this.command.dataSet = vol == null ? DataSet.create((IPDHost)this.command.getSystem(), (String)this.wDataSet.getText()) : DataSet.create((Volume)vol, (String)this.wDataSet.getText());
                this.command.membersList.clear();
                this.command.membersRangeStart = "";
                this.command.membersRangeEnd = "";
                if (this.isSelected((Control)this.wMembersListChosen)) {
                    this.command.setMembersList(this.wMembersList.getText());
                } else if (this.isSelected((Control)this.wMembersRangeChosen)) {
                    this.command.membersRangeStart = this.wMembersRangeStart.getText();
                    this.command.membersRangeEnd = this.wMembersRangeEnd.getText();
                }
            }
            if (this.isSelected((Control)this.wSortByAddress)) {
                this.command.sortBy = VLM.VlmSortBy.ADDRESS;
            } else if (this.isSelected((Control)this.wSortByName)) {
                this.command.sortBy = VLM.VlmSortBy.NAME;
            }
            if (this.isSelected((Control)this.wDateFormYYYYDDD)) {
                this.command.dateForm = VLM.VlmDateForm.YYYYDDD;
            } else if (this.isSelected((Control)this.wDateFormYYMMDD)) {
                this.command.dateForm = VLM.VlmDateForm.YYMMDD;
            }
        }
        this.setEnabledIf((Control)this.wMembersListLookup, this.command.getSystem() != null);
        this.setEnabledIf((Control)this.wDataSetLookup, this.command.getSystem() != null);
        boolean membersViaList = this.command.getMemberSpecification() == ViewLoadModuleModel.MemberSpecification.LIST;
        this.setEnabledIf((Control)this.wMembersList, membersViaList);
        this.setEnabledIf((Control)this.wMembersListLookup, membersViaList && DataSet.isValidName((String)this.wDataSet.getText(), (String)this.command.getSystem().getCodePage()));
        boolean membersViaRange = this.command.getMemberSpecification() == ViewLoadModuleModel.MemberSpecification.RANGE;
        this.setEnabledIf((Control)this.wMembersRangeStartLabel, membersViaRange);
        this.setEnabledIf((Control)this.wMembersRangeStart, membersViaRange);
        this.setEnabledIf((Control)this.wMembersRangeEndLabel, membersViaRange);
        this.setEnabledIf((Control)this.wMembersRangeEnd, membersViaRange);
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 4;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)parent, (String)Messages.Label__DATA_SET, (Object)GUI.grid.d.left1());
        this.wDataSet = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)2));
        this.wDataSet.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        ResourceContentProposals.addTo(this.wDataSet, (IHostProvider)this.command.getSystem(), ((Object)((Object)this)).getClass().getCanonicalName() + "Resource", DataSet.class);
        new FMWizardPage.ManagedWidget(this, this.wDataSet, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__DATA_SET), this.command.getSystem()){

            @Override
            protected boolean isValid() {
                return DataSet.isValidName((String)ViewLoadModuleWizardPageFirst.this.wDataSet.getText(), (String)ViewLoadModuleWizardPageFirst.this.command.getSystem().getCodePage());
            }
        };
        this.wDataSetLookup = LookupButton.createLookupButtonLeft1(parent);
        LookupDialogFactory.defaults(this.wDataSetLookup, this.wDataSet, (IHostProvider)this.command).types(DataSet.class, Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                Member member;
                DataSet newDataSet = ((DataSetOrMember)zrl).asDataSet();
                ViewLoadModuleWizardPageFirst.this.wVolume.setText("");
                if (!newDataSet.equals((Object)ViewLoadModuleWizardPageFirst.this.command.dataSet)) {
                    ViewLoadModuleWizardPageFirst.this.command.membersList.clear();
                    ViewLoadModuleWizardPageFirst.this.wMembersList.setText("");
                    ViewLoadModuleWizardPageFirst.this.wMembersRangeStart.setText("");
                }
                if ((member = ((DataSetOrMember)zrl).asMember()) != null && ViewLoadModuleWizardPageFirst.this.isSelected((Control)ViewLoadModuleWizardPageFirst.this.wMembersListChosen)) {
                    ViewLoadModuleWizardPageFirst.this.addMemberToList(member);
                } else if (member == null) {
                    ViewLoadModuleWizardPageFirst.this.wMembersRangeStart.setText("");
                } else {
                    ViewLoadModuleWizardPageFirst.this.wMembersRangeStart.setText(member.getName());
                }
            }
        }).formatter(new ISelectedValueFormatter(){

            @Override
            public String getNewValue(IPDHost selectedHost, IZRL zrl) {
                return ((DataSetOrMember)zrl).asDataSet().getName();
            }
        }).create();
        GUI.label.left((Composite)parent, (String)Messages.Label__VOLUME, (Object)GUI.grid.d.left1());
        this.wVolume = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wVolume, ((Object)((Object)this)).getClass().getCanonicalName() + "Volume");
        new FMWizardPage.ManagedWidget(this, this.wVolume, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__VOLUME), this.command.getSystem()){

            @Override
            protected boolean isValid() {
                return ViewLoadModuleWizardPageFirst.this.wVolume.getText().isEmpty() || Volume.isValid((String)ViewLoadModuleWizardPageFirst.this.wVolume.getText(), (String)ViewLoadModuleWizardPageFirst.this.command.getSystem().getCodePage());
            }
        };
        Composite memberComp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)6, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        this.wMembersListChosen = GUI.button.radio((Composite)memberComp, (String)Messages.Label__MEMBER_LIST, (Object)GUI.grid.d.left1());
        new FMWizardPage.ManagedWidget(this, this.wMembersListChosen, this.command.getSystem()){

            @Override
            public void onChange(Event event) {
                if (ViewLoadModuleWizardPageFirst.this.isSelected((Control)ViewLoadModuleWizardPageFirst.this.wMembersListChosen)) {
                    ViewLoadModuleWizardPageFirst.this.unselect((Control)ViewLoadModuleWizardPageFirst.this.wMembersRangeChosen);
                }
            }
        };
        this.wMembersList = GUI.combo.editable((Composite)memberComp, (Object)GUI.grid.d.fillH((int)4));
        new ComboValueSaver(this.wMembersList, ((Object)((Object)this)).getClass().getCanonicalName() + "MembersList");
        new FMWizardPage.ManagedWidget(this, this.wMembersList, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__MEMBER_LIST), this.command.getSystem()){

            @Override
            protected boolean isValid() {
                return UIValidator.isValidMemberList(ViewLoadModuleWizardPageFirst.this.wMembersList.getText(), false, ViewLoadModuleWizardPageFirst.this.command.getSystem().getCodePage());
            }
        };
        this.wMembersListLookup = LookupButton.createLookupButtonLeft1(memberComp);
        this.wMembersListLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MemberLookupDialog dlg = new MemberLookupDialog(ViewLoadModuleWizardPageFirst.this.command.dataSet, "");
                if (dlg.open() == 0) {
                    for (Member member : dlg.getSelectedMembers()) {
                        ViewLoadModuleWizardPageFirst.this.addMemberToList(member);
                    }
                }
            }
        });
        this.wMembersRangeChosen = GUI.button.radio((Composite)memberComp, (String)Messages.Label__MEMBER_RANGE, (Object)GUI.grid.d.left1());
        new FMWizardPage.ManagedWidget(this, this.wMembersRangeChosen, this.command.getSystem()){

            @Override
            public void onChange(Event event) {
                if (ViewLoadModuleWizardPageFirst.this.isSelected((Control)ViewLoadModuleWizardPageFirst.this.wMembersRangeChosen)) {
                    ViewLoadModuleWizardPageFirst.this.unselect((Control)ViewLoadModuleWizardPageFirst.this.wMembersListChosen);
                }
                ViewLoadModuleWizardPageFirst.this.safeValidateManagedWidgets();
            }
        };
        this.wMembersRangeStartLabel = GUI.label.left((Composite)memberComp, (String)Messages.__FROM, (Object)GUI.grid.d.left1());
        this.wMembersRangeStart = GUI.combo.editable((Composite)memberComp, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMembersRangeStart, ((Object)((Object)this)).getClass().getCanonicalName() + "MemberRangeStart");
        new FMWizardPage.ManagedWidget(this, this.wMembersRangeStart, Messages.Msg_UTILITY_WIZARDS_MEMBER_RANGE_INVALID_START, this.command.getSystem()){

            @Override
            protected boolean isValid() {
                String text2 = ViewLoadModuleWizardPageFirst.this.wMembersRangeStart.getText();
                return text2.isEmpty() || UIValidator.isValidWildcardableMember(text2, ViewLoadModuleWizardPageFirst.this.command.getSystem().getCodePage());
            }
        };
        this.wMembersRangeStart.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusevent) {
                ViewLoadModuleWizardPageFirst.this.wMembersRangeEnd.setText(ViewLoadModuleWizardPageFirst.this.wMembersRangeStart.getText());
            }

            public void focusGained(FocusEvent focusevent) {
            }
        });
        this.wMembersRangeEndLabel = GUI.label.left((Composite)memberComp, (String)Messages.__TO, (Object)GUI.grid.d.left1());
        this.wMembersRangeEnd = GUI.combo.editable((Composite)memberComp, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMembersRangeEnd, ((Object)((Object)this)).getClass().getCanonicalName() + "MemberRangeEnd");
        new FMWizardPage.ManagedWidget(this, this.wMembersRangeEnd, Messages.Msg_UTILITY_WIZARDS_MEMBER_RANGE_INVALID_END, this.command.getSystem()){

            @Override
            protected boolean isValid() {
                String text2 = ViewLoadModuleWizardPageFirst.this.wMembersRangeEnd.getText();
                return text2.isEmpty() || UIValidator.isValidWildcardableMember(text2, ViewLoadModuleWizardPageFirst.this.command.getSystem().getCodePage());
            }
        };
        Group miscGroup = GUI.group((Composite)parent, (String)Messages.Title__MISCELLANEOUS_SETTINGS, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        GUI.label.left((Composite)miscGroup, (String)Messages.Label__SORT_BY, (Object)GUI.grid.d.left1());
        Composite sortByComp = GUI.composite((Composite)miscGroup, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
        this.wSortByAddress = GUI.button.radio((Composite)sortByComp, (String)Messages.__ADDRESS, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this.wSortByAddress, this.command.getSystem());
        this.wSortByName = GUI.button.radio((Composite)sortByComp, (String)Messages.__NAME, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this.wSortByName, this.command.getSystem());
        GUI.label.left((Composite)miscGroup, (String)Messages.Label__DATE_FORMAT, (Object)GUI.grid.d.left1());
        Composite dateFormComp = GUI.composite((Composite)miscGroup, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
        this.wDateFormYYYYDDD = GUI.button.radio((Composite)dateFormComp, (String)"YYYYDDD", (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this.wDateFormYYYYDDD, this.command.getSystem());
        this.wDateFormYYMMDD = GUI.button.radio((Composite)dateFormComp, (String)"YYMMDD", (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this.wDateFormYYMMDD, this.command.getSystem());
        this.refreshControlState();
        this.setControl((Control)parent);
    }

    private void addMemberToList(Member member) {
        if (!this.command.membersList.contains(member)) {
            this.command.membersList.add(member);
            Collections.sort(this.command.membersList);
            Object text2 = "";
            for (Member m : this.command.membersList) {
                text2 = !((String)text2).isEmpty() ? (String)text2 + "," + String.valueOf(m) : m.getName();
            }
            this.wMembersList.setText((String)text2);
        }
    }

    @Override
    protected void updateControlValues() {
        ViewLoadModuleModel command = this.command.clone();
        if (command.dataSet != null) {
            this.wDataSet.setText(command.dataSet.getName());
            if (command.dataSet.getVolume() != null) {
                this.wVolume.setText(command.dataSet.getVolume().getVolserID());
            }
        }
        if (command.getMemberSpecification() == ViewLoadModuleModel.MemberSpecification.LIST) {
            this.wMembersList.setText(ArrayUtils.join((Object[])command.membersList.toArray(), (String)",").toString());
            if (command.membersList.size() > 0) {
                if (command.membersRangeStart.isEmpty()) {
                    command.membersRangeStart = command.membersList.get(0).getName();
                }
                if (command.membersRangeEnd.isEmpty()) {
                    command.membersRangeEnd = command.membersList.get(command.membersList.size() - 1).getName();
                }
            }
            this.select((Control)this.wMembersListChosen);
        } else if (command.getMemberSpecification() == ViewLoadModuleModel.MemberSpecification.RANGE) {
            this.wMembersRangeStart.setText(command.membersRangeStart);
            if (command.membersRangeEnd != null && !command.membersRangeEnd.isEmpty()) {
                this.wMembersRangeEnd.setText(command.membersRangeEnd);
            }
            command.membersList.clear();
            this.select((Control)this.wMembersRangeChosen);
        }
        if (!this.isSelected((Control)this.wSortByName) && command.sortBy == VLM.VlmSortBy.ADDRESS) {
            this.select((Control)this.wSortByAddress);
        } else if (!this.isSelected((Control)this.wSortByAddress) && command.sortBy == VLM.VlmSortBy.NAME) {
            this.select((Control)this.wSortByName);
        }
        if (!this.isSelected((Control)this.wDateFormYYMMDD) && command.dateForm == VLM.VlmDateForm.YYYYDDD) {
            this.select((Control)this.wDateFormYYYYDDD);
        } else if (!this.isSelected((Control)this.wDateFormYYYYDDD) && command.dateForm == VLM.VlmDateForm.YYMMDD) {
            this.select((Control)this.wDateFormYYMMDD);
        }
        this.wDataSet.setFocus();
    }
}

