/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.SET;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.VLM;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class ViewLoadModuleModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MEMBER_SEPARATOR = ",";
    public DataSet dataSet = null;
    private MemberSpecification memType = MemberSpecification.LIST;
    public List<Member> membersList = new ArrayList<Member>();
    public String membersRangeStart = "";
    public String membersRangeEnd = "";
    public VLM.VlmSortBy sortBy = VLM.VlmSortBy.ADDRESS;
    public VLM.VlmDateForm dateForm = VLM.VlmDateForm.YYYYDDD;

    public ViewLoadModuleModel(IPDHost host) {
        super(host);
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        try {
            IEclipsePreferences systemOptsPrefs = InstanceScope.INSTANCE.getNode("com.ibm.etools.fm.ui.prefs.prtopts");
            Preferences node = systemOptsPrefs.node(this.getHostProvider().getDescription());
            String pageSkipVal = node.get("pageskip", "YES");
            String dumpVal = node.get("dump", "UPDOWN");
            String dataHdrVal = node.get("datahdr", "YES");
            String recLimitVal = node.get("reclimit", "(1,*)");
            String printLenVal = node.get("reclength", "80");
            String printTransVal = node.get("pagetrans", "ON");
            String headerPagVal = node.get("headerpage", "YES");
            SET set = new SET();
            set.setPageSkip(pageSkipVal);
            set.setPrintLen(Integer.parseInt(printLenVal));
            set.setDumpVal(dumpVal);
            set.setDataHdr(dataHdrVal);
            set.setRecLimit(recLimitVal);
            set.setPrintTrans(printTransVal);
            set.setHeaderPage(headerPagVal);
            Result result = UtilityFunctionRunner.execute((IPDHost)this.getHostProvider(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getHostProvider()), (UtilityFunction)set, (IHowIsGoing)monitor);
            if (result.getRC() != 0) {
                System.out.println(result.getDisplayMessage());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        VLM vlm = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), (UtilityFunction)vlm, (IHowIsGoing)monitor);
    }

    public VLM toUtilityFunction() {
        VLM vlm = new VLM();
        vlm.setValue((NewUtilityFunction.IUtilFuncParam)VLM.DSNIN, (Object)this.dataSet.getName(), this.getSystem());
        if (this.dataSet.getVolume() != null) {
            vlm.setValue((NewUtilityFunction.IUtilFuncParam)VLM.VOLSERIN, (Object)this.dataSet.getVolume().getVolserID(), this.getSystem());
        }
        if (this.memType == MemberSpecification.LIST) {
            vlm.setValue((NewUtilityFunction.IUtilFuncParam)VLM.MEMLIST, (Object)ArrayUtils.join((Object[])this.membersList.toArray(), (String)MEMBER_SEPARATOR).toString().toUpperCase(), this.getSystem());
        } else if (this.memType == MemberSpecification.RANGE) {
            vlm.setValue((NewUtilityFunction.IUtilFuncParam)VLM.MEMSTART, (Object)this.membersRangeStart.toUpperCase(), this.getSystem());
            vlm.setValue((NewUtilityFunction.IUtilFuncParam)VLM.MEMEND, (Object)this.membersRangeEnd.toUpperCase(), this.getSystem());
        } else {
            throw new IllegalStateException(this.memType.name());
        }
        vlm.setValue((NewUtilityFunction.IUtilFuncParam)VLM.SORTBY, (Object)this.sortBy, this.getSystem());
        vlm.setValue((NewUtilityFunction.IUtilFuncParam)VLM.DATEFORM, (Object)this.dateForm, this.getSystem());
        return vlm;
    }

    public void fromUtilityFunction(VLM vlm) {
        String memList;
        this.dataSet = Member.parse((IPDHost)this.getSystem(), (String)((String)vlm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)VLM.DSNIN, this.getSystem()))).asDataSet();
        String volserIn = (String)vlm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)VLM.VOLSERIN, this.getSystem());
        if (Volume.isValid((String)volserIn, (String)this.getSystem().getCodePage())) {
            this.dataSet.setVolume(Volume.create((IPDHost)this.getSystem(), (String)volserIn));
        }
        if (!(memList = (String)vlm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)VLM.MEMLIST, this.getSystem())).isEmpty()) {
            this.setMemberSpecification(MemberSpecification.LIST);
            this.setMembersList(memList);
        } else {
            this.setMemberSpecification(MemberSpecification.RANGE);
            this.membersRangeStart = (String)vlm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)VLM.MEMSTART, this.getSystem());
            this.membersRangeEnd = (String)vlm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)VLM.MEMEND, this.getSystem());
        }
        this.sortBy = (VLM.VlmSortBy)vlm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)VLM.SORTBY, this.getSystem());
        this.dateForm = (VLM.VlmDateForm)vlm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)VLM.DATEFORM, this.getSystem());
    }

    public void setMember(Member mem) {
        if (this.dataSet != null && !this.dataSet.equals((Object)mem.asDataSet())) {
            throw new IllegalArgumentException();
        }
        this.membersList.clear();
        this.membersRangeStart = "";
        this.membersRangeEnd = "";
        this.membersList.add(mem);
    }

    public void setMemberSpecification(MemberSpecification memberSpecification) {
        this.memType = Objects.requireNonNull(memberSpecification, "Must provide a non-null memberSpecification");
    }

    public MemberSpecification getMemberSpecification() {
        return this.memType;
    }

    public ViewLoadModuleModel clone() {
        ViewLoadModuleModel vlm = new ViewLoadModuleModel(this.getSystem());
        vlm.dataSet = (DataSet)this.getCloneOf(this.dataSet);
        vlm.memType = this.memType;
        vlm.membersList = (List)this.getCloneOf(this.membersList);
        vlm.membersRangeStart = this.membersRangeStart;
        vlm.membersRangeEnd = this.membersRangeEnd;
        vlm.sortBy = this.sortBy;
        vlm.dateForm = this.dateForm;
        return vlm;
    }

    public void setMembersList(String membersList) {
        ArrayList<Member> memList = new ArrayList<Member>();
        if (!membersList.isEmpty()) {
            String[] members;
            String[] stringArray = members = membersList.split(MEMBER_SEPARATOR);
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String member = stringArray[n2];
                memList.add(Member.create((DataSet)this.dataSet, (String)member));
                ++n2;
            }
        }
        this.membersList = memList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ViewLoadModuleModel) {
            ViewLoadModuleModel other = (ViewLoadModuleModel)((Object)obj);
            return this.getSystem().equals(other.getSystem()) && this.toUtilityFunction().equals((Object)other.toUtilityFunction());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.toUtilityFunction().hashCode();
    }

    public static enum MemberSpecification {
        LIST,
        RANGE;

    }
}

