/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.socket.func.VLM;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.ViewLoadModuleModel;
import com.ibm.etools.fm.ui.wizards.ViewLoadModuleRunnable;
import com.ibm.etools.fm.ui.wizards.ViewLoadModuleWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ViewLoadModuleActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static VLMActionItemPropertySource propSource;
    private ViewLoadModuleModel model;

    public ViewLoadModuleActionItem(ViewLoadModuleModel model) {
        super(ActionType.VLM, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.VLMActionItem_LABEL, this.getFullDatasetName(false));
    }

    @Override
    public String getToolTipText() {
        return MessageFormat.format(Messages.VLMActionItem_TOOLTIP, this.getFullDatasetName(true));
    }

    private String getFullDatasetName(boolean listAllMembers) {
        if (this.model.membersList != null && this.model.membersList.size() != 0) {
            if (this.model.membersList.size() > 1) {
                String members = this.model.membersList.toString();
                if (members.length() > 1) {
                    members = members.substring(1, members.length());
                }
                return this.model.dataSet.getFormattedName() + "(" + (listAllMembers ? members : "...") + ")";
            }
            return this.model.membersList.get(0).getFormattedName();
        }
        return this.model.dataSet.getFormattedName();
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        VLM function = new VLM();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        ViewLoadModuleModel model = new ViewLoadModuleModel(system);
        model.fromUtilityFunction(function);
        return new ViewLoadModuleActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        ViewLoadModuleRunnable runnable = new ViewLoadModuleRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final ViewLoadModuleModel clone = this.model.clone();
        ViewLoadModuleWizard wizard = new ViewLoadModuleWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                ViewLoadModuleActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public ViewLoadModuleActionItem clone() {
        ViewLoadModuleActionItem clone = new ViewLoadModuleActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ViewLoadModuleActionItem) {
            ViewLoadModuleActionItem other = (ViewLoadModuleActionItem)obj;
            return this.getSystem().equals(other.getSystem()) && this.model.toUtilityFunction().equals((Object)other.model.toUtilityFunction());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 37;
        r = 37 * r + this.getSystem().hashCode();
        r = 37 * r + this.model.toUtilityFunction().hashCode();
        return r;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new VLMActionItemPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    private static class VLMActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private ViewLoadModuleModel model;
        private IPropertyDescriptor[] propertyDescriptors;
        public Object KEY_DATA_SET = new Object();
        public Object KEY_VOLUME = new Object();
        public Object KEY_MEMBERS_LIST = new Object();
        public Object KEY_MEMBERS_RANGE_START = new Object();
        public Object KEY_MEMBERS_RANGE_END = new Object();
        public Object KEY_SORT_BY = new Object();
        public Object KEY_DATE_FORM = new Object();

        public VLMActionItemPropertySource(ViewLoadModuleModel model) {
            this.model = model;
            this.init();
        }

        public void setModel(ViewLoadModuleModel model) {
            this.model = model;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor(this.KEY_DATA_SET, Messages.Label__DATA_SET));
            temp.add(new PropertyDescriptor(this.KEY_VOLUME, Messages.Label__VOLUME));
            temp.add(new PropertyDescriptor(this.KEY_MEMBERS_LIST, Messages.Label__MEMBER_LIST));
            temp.add(new PropertyDescriptor(this.KEY_MEMBERS_RANGE_START, Messages.VLMActionItem_MEMBER_RANGE_START));
            temp.add(new PropertyDescriptor(this.KEY_MEMBERS_RANGE_END, Messages.VLMActionItem_MEMBER_RANGE_END));
            temp.add(new PropertyDescriptor(this.KEY_SORT_BY, Messages.Label__SORT_BY));
            temp.add(new PropertyDescriptor(this.KEY_DATE_FORM, Messages.Label__DATE_FORMAT));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object key) {
            if (this.KEY_DATA_SET.equals(key)) {
                return this.model.dataSet.getFormattedName();
            }
            if (this.KEY_VOLUME.equals(key)) {
                Volume volume = this.model.dataSet.getVolume();
                return volume == null ? null : volume.getVolserID();
            }
            if (this.KEY_MEMBERS_LIST.equals(key)) {
                StringBuffer sb = new StringBuffer();
                int counter = 0;
                for (Member member : this.model.membersList) {
                    if (counter != 0) {
                        sb.append(", ");
                    }
                    ++counter;
                    sb.append(member.getName());
                }
                return sb.toString();
            }
            if (this.KEY_MEMBERS_RANGE_START.equals(key)) {
                return this.model.membersRangeStart;
            }
            if (this.KEY_MEMBERS_RANGE_END.equals(key)) {
                return this.model.membersRangeEnd;
            }
            if (this.KEY_SORT_BY.equals(key)) {
                return this.model.sortBy;
            }
            if (this.KEY_DATE_FORM.equals(key)) {
                return this.model.dateForm;
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

