/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.wizards.RenameModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.views.systems.SorterEBCDIC;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import java.text.MessageFormat;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class RenameWizardPage
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(RenameWizardPage.class);
    private static final int COLUMN_RESOURCE = 0;
    private static final int COLUMN_NEW_NAME = 1;
    private TableViewer viewer;
    private final RenameModel model;
    private final RenameWizagePageConnector connector = new RenameWizagePageConnector();

    protected RenameWizardPage(RenameModel model) {
        super(Messages.RenameWizardPage_TITLE);
        this.model = model;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.RenameWizardPage_TITLE);
        this.setMessage(Messages.RenameWizardPage_ENTER_NEW_NAMES);
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        ScrolledComposite scrollComp = new ScrolledComposite(parent, 2816);
        scrollComp.setLayoutData((Object)GUI.grid.d.fillAll());
        scrollComp.setExpandHorizontal(true);
        scrollComp.setExpandVertical(true);
        Composite tableComp = new Composite((Composite)scrollComp, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableComp, 65540);
        TableViewerColumn cResource = new TableViewerColumn(this.viewer, 16384, 0);
        cResource.getColumn().setText(Messages.RenameWizardPage_COLUMN_TITLE_RESOURCE);
        cResource.setLabelProvider((CellLabelProvider)new RenameResourceColumnLabelProvider((LabelProvider)new SystemsLabelProvider()));
        TableViewerColumn cNewName = new TableViewerColumn(this.viewer, 16384, 1);
        cNewName.getColumn().setText(Messages.RenameWizardPage_COLUMN_TITLE_NEW_NAME);
        cNewName.setLabelProvider((CellLabelProvider)new RenameNewNameColumnLabelProvider());
        cNewName.setEditingSupport((EditingSupport)new RenameEditingSupport(this.viewer));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                TableItem[] selection;
                if (traverseEvent.detail == 4 && (selection = RenameWizardPage.this.viewer.getTable().getSelection()).length > 0) {
                    Object item = selection[0].getData();
                    traverseEvent.doit = false;
                    RenameWizardPage.this.viewer.editElement(item, 1);
                }
            }
        });
        this.viewer.setSorter((ViewerSorter)SorterEBCDIC.getInstance());
        this.viewer.setContentProvider((IContentProvider)new RenameContentProvider());
        this.viewer.setInput((Object)this.model);
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer), (int)26);
        scrollComp.setContent((Control)tableComp);
        tableLayout.setColumnData((Widget)cResource.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        tableLayout.setColumnData((Widget)cNewName.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        this.connector.listenTo(this.model);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
        }
        super.setVisible(visible);
        if (visible) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TableItem item = RenameWizardPage.this.viewer.getTable().getItem(0);
                    RenameWizardPage.this.viewer.editElement(item.getData(), 1);
                }
            });
        }
    }

    public String getValidationErrorMessage() {
        boolean foundSomethingToRename = false;
        for (RenameModel.RenameTask task : this.model.getRenameTasks()) {
            if (task.getNewName().isEmpty()) continue;
            foundSomethingToRename = true;
            if (task.isValid()) continue;
            return MessageFormat.format(Messages.RenameWizardPage_INVALID_NEW_NAME, task.getResource());
        }
        if (!foundSomethingToRename) {
            return Messages.RenameWizardPage_SPECIFY_MIN_ONE_NEW_NAME;
        }
        return null;
    }

    public void refreshDeletableList() {
        this.viewer.refresh();
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    private static class RenameContentProvider
    implements IStructuredContentProvider {
        private RenameContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object model) {
            return ((RenameModel)((Object)model)).getRenameTasks().toArray();
        }
    }

    private class RenameEditingSupport
    extends EditingSupport {
        private TextCellEditor textCellEditor;

        public RenameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.textCellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.textCellEditor;
        }

        protected Object getValue(Object element) {
            RenameModel.RenameTask renameTask = (RenameModel.RenameTask)element;
            if (renameTask.getNewName().isEmpty()) {
                return renameTask.getResource().getName();
            }
            return renameTask.getNewName();
        }

        protected void setValue(Object element, Object value) {
            RenameModel.RenameTask renameTask = (RenameModel.RenameTask)element;
            if (renameTask.getResource().getName().equals(value)) {
                value = "";
            }
            renameTask.setNewName((String)value);
            this.getViewer().update(element, null);
            RenameWizardPage.this.connector.doManualViewUpdate();
        }
    }

    private static class RenameNewNameColumnLabelProvider
    extends ColumnLabelProvider {
        private RenameNewNameColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            if (!((RenameModel.RenameTask)element).isValid()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            return super.getImage(element);
        }

        public Color getForeground(Object element) {
            RenameModel.RenameTask renameTask = (RenameModel.RenameTask)element;
            if (renameTask.getNewName().isEmpty()) {
                return Display.getDefault().getSystemColor(15);
            }
            if (!renameTask.isValid()) {
                return Display.getDefault().getSystemColor(3);
            }
            return super.getForeground(element);
        }

        public String getText(Object element) {
            String newName = ((RenameModel.RenameTask)element).getNewName();
            if (newName.isEmpty()) {
                return Messages.RenameWizardPage_CLICK_TO_ENTER_NAME;
            }
            return newName;
        }
    }

    private static class RenameResourceColumnLabelProvider
    extends ColumnLabelProvider {
        private final LabelProvider imageProvider;

        public RenameResourceColumnLabelProvider(LabelProvider imageProvider) {
            this.imageProvider = imageProvider;
        }

        public String getText(Object element) {
            return ((RenameModel.RenameTask)element).getResource().getFormattedName();
        }

        public Image getImage(Object element) {
            return this.imageProvider.getImage((Object)((RenameModel.RenameTask)element).getResource());
        }
    }

    private class RenameWizagePageConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private RenameWizagePageConnector() {
        }

        protected void updateModelFromViewImpl() {
        }

        protected void updateViewFromModelImpl() {
            String validationErrorMessage = RenameWizardPage.this.getValidationErrorMessage();
            RenameWizardPage.this.setPageComplete(validationErrorMessage == null);
            RenameWizardPage.this.setErrorMessage(validationErrorMessage);
        }
    }
}

