/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.wizards.RenameModel;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;

public class RenameRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final RenameModel model;

    public RenameRunnable(RenameModel model) {
        this.model = model;
    }

    @Override
    protected String getName() {
        return Messages.RenameRunnable_TASK_NAME;
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        monitor.beginTask(this.getName(), 3);
        monitor.worked(1);
        Result<StringBuffer> result = this.model.execute(monitor);
        for (RenameModel.RenameTask task : this.model.getRenameTasks()) {
            if (!task.getResult().isSuccessfulWithoutWarnings()) continue;
            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)task.getOriginalResource());
            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)task.getResource());
        }
        monitor.done();
        return result;
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().getRC() <= 4;
    }

    @Override
    public void showResult() {
        FMDialogWithText.showResultDump(this.getResult(), false, 4);
    }
}

