/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.IRenamable;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RenameModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    ArrayList<RenameTask> renameTasks = new ArrayList();

    public RenameModel(IPDHost host) {
        super(host);
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) {
        List<RenameTask> renameTasks = this.getRenameTasks();
        Result overallResult = new Result((Object)new StringBuffer());
        for (RenameTask task : renameTasks) {
            Result taskResult;
            String oldName = task.getResource().getFormattedName();
            try {
                if (task.getNewName().isEmpty()) {
                    taskResult = new Result(0);
                    ((StringBuffer)overallResult.getOutput()).append(MessageFormat.format(Messages.CommRenameCommand_SKIPPED_X, oldName));
                } else if (!task.getResource().isValidNewName(task.getNewName(), this.provider.getCodePage())) {
                    taskResult = new Result(8);
                    ((StringBuffer)overallResult.getOutput()).append(MessageFormat.format(Messages.CommRenameCommand_NO_VALID_NEW_NAME_FOR_X, oldName));
                } else {
                    taskResult = task.getResource().renameOnHost(task.getNewName(), monitor);
                    if (taskResult.isSuccessfulWithoutWarnings()) {
                        ((StringBuffer)overallResult.getOutput()).append(MessageFormat.format(Messages.CommRenameCommand_RENAMED_X_TO_Y, oldName, task.getNewName()));
                    } else {
                        ((StringBuffer)overallResult.getOutput()).append(MessageFormat.format(Messages.CommRenameCommand_FAILED_TO_RENAME_X_TO_Y, oldName, task.getNewName()));
                    }
                }
            }
            catch (InterruptedException e) {
                taskResult = new Result(4);
                ((StringBuffer)overallResult.getOutput()).append(MessageFormat.format(Messages.CommRenameCommand_OPERATION_CANCELLED_DURING_RENAME_X_TO_Y, oldName, task.getNewName()));
            }
            task.setResult((Result<StringBuffer>)taskResult);
            overallResult.addSubResult(taskResult);
            if (monitor.isCanceled()) break;
        }
        return overallResult;
    }

    public boolean addRenameTask(RenameTask task) {
        Objects.requireNonNull(task, "Must provide a non-null task");
        for (RenameTask existingTask : this.renameTasks) {
            if (!existingTask.getResource().equals(task.getResource())) continue;
            return false;
        }
        return this.renameTasks.add(task);
    }

    public List<RenameTask> getRenameTasks() {
        return Collections.unmodifiableList(this.renameTasks);
    }

    public void resetTasks() {
        for (RenameTask task : this.renameTasks) {
            task.reset();
        }
    }

    public RenameModel clone() {
        RenameModel clone = new RenameModel(this.getSystem());
        for (RenameTask task : this.renameTasks) {
            clone.addRenameTask(task);
        }
        return clone;
    }

    public static class RenameTask {
        private final IRenamable originalResource;
        private IRenamable resource;
        private String newName;
        private transient Result<StringBuffer> result;

        public RenameTask(IRenamable resource) {
            Objects.requireNonNull(resource, "Must provide a non-null resource");
            this.originalResource = (IRenamable)resource.clone();
            this.resource = resource;
            this.newName = "";
        }

        public boolean isValid() {
            if (this.newName.isEmpty()) {
                return true;
            }
            return this.originalResource.isValidNewName(this.newName, this.resource.getSystem().getCodePage());
        }

        public void reset() {
            this.resource = (IRenamable)this.originalResource.clone();
            this.result = null;
        }

        public void setResource(IRenamable resource) {
            this.resource = resource;
        }

        public IRenamable getOriginalResource() {
            return this.originalResource;
        }

        public IRenamable getResource() {
            return this.resource;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public Result<StringBuffer> getResult() {
            return this.result;
        }

        public void setResult(Result<StringBuffer> result) {
            this.result = result;
        }

        public String toString() {
            return this.resource.getFormattedName();
        }
    }
}

