/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.IRenamable;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.wizards.RenameModel;
import com.ibm.etools.fm.ui.wizards.RenameRunnable;
import com.ibm.etools.fm.ui.wizards.RenameWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class RenameActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TYPE_RENAMABLE = "renamable";
    public static final String KEY_FROM = "from";
    public static final String KEY_TO = "to";
    private static RenameActionItemPropertySource propSource;
    private RenameModel model;
    private static Comparator<RenameModel.RenameTask> CompareByFormattedName;

    static {
        CompareByFormattedName = new Comparator<RenameModel.RenameTask>(){

            @Override
            public int compare(RenameModel.RenameTask o1, RenameModel.RenameTask o2) {
                return o1.getOriginalResource().getFormattedName().compareTo(o2.getOriginalResource().getFormattedName());
            }
        };
    }

    public RenameActionItem(RenameModel model) {
        super(ActionType.RENAME, model.getSystem());
        this.model = model;
    }

    @Override
    public RenameActionItem clone() {
        return new RenameActionItem(this.model.clone());
    }

    @Override
    public String getDefaultLabel() {
        List<RenameModel.RenameTask> renameTasks = this.getRenameTasks();
        if (renameTasks.size() > 1) {
            int actualCount = 0;
            for (RenameModel.RenameTask renameTask : renameTasks) {
                if (renameTask.getNewName().length() <= 0 || !renameTask.isValid()) continue;
                ++actualCount;
            }
            if (actualCount == renameTasks.size()) {
                return MessageFormat.format(Messages.RenameActionItem_RENAME_RESOURCE, renameTasks.size());
            }
            return MessageFormat.format(Messages.RenameActionItem_RENAME_MULTIPLE_RESOURCE, actualCount, renameTasks.size());
        }
        return MessageFormat.format(Messages.RenameActionItem_RENAME, this.getAllRenameTaskAsString());
    }

    @Override
    public String getToolTipText() {
        return MessageFormat.format(Messages.RenameActionItem_RENAME_TOOLTIP, this.getAllRenameTaskAsString());
    }

    private String getAllRenameTaskAsString() {
        StringBuffer sb = new StringBuffer();
        for (RenameModel.RenameTask task : this.getRenameTasks()) {
            if (task.getNewName().length() > 0 && task.isValid()) {
                sb.append(MessageFormat.format(Messages.RenameActionItem_OLD_TO_NEW, task.getOriginalResource().getFormattedName(), task.getNewName()));
                continue;
            }
            sb.append(MessageFormat.format(Messages.RenameActionItem_SKIP_RESOURCE, task.getOriginalResource().getFormattedName()));
        }
        return sb.toString();
    }

    @Override
    public void saveTo(IMemento memento) {
        for (RenameModel.RenameTask task : this.model.getRenameTasks()) {
            IMemento child = memento.createChild(TYPE_RENAMABLE);
            child.putString(KEY_FROM, task.getOriginalResource().getFormattedName());
            child.putString(KEY_TO, task.getNewName());
        }
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        IMemento[] childMementos;
        RenameModel model = new RenameModel(system);
        IMemento[] iMementoArray = childMementos = memento.getChildren(TYPE_RENAMABLE);
        int n = childMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento iMemento = iMementoArray[n2];
            String from = iMemento.getString(KEY_FROM);
            String to = iMemento.getString(KEY_TO);
            IZRL zrl = ZRLs.parseZRL((IPDHost)system, (String)from);
            if (zrl instanceof IRenamable) {
                RenameModel.RenameTask task = new RenameModel.RenameTask((IRenamable)zrl);
                task.setNewName(to);
                model.addRenameTask(task);
            } else {
                logger.trace((Object)("Unable to load non-renamable zrl: " + String.valueOf(zrl)));
            }
            ++n2;
        }
        return new RenameActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        this.model.resetTasks();
        RenameRunnable runnable = new RenameRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        this.model.resetTasks();
        final RenameModel clone = this.model.clone();
        RenameWizard wizard = new RenameWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                RenameActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    private List<RenameModel.RenameTask> getRenameTasks() {
        ArrayList<RenameModel.RenameTask> list = new ArrayList<RenameModel.RenameTask>(this.model.getRenameTasks());
        Collections.sort(list, CompareByFormattedName);
        return list;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RenameActionItem) {
            RenameActionItem other = (RenameActionItem)obj;
            return this.getSystem().equals(other.getSystem()) && this.getAllRenameTaskAsString().equals(other.getAllRenameTaskAsString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 37;
        r = 37 * r + this.getSystem().hashCode();
        r = 37 * r + this.getAllRenameTaskAsString().hashCode();
        return r;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new RenameActionItemPropertySource(this);
        }
        propSource.setModel(this);
        return propSource;
    }

    private static class RenameActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private boolean initRequired = true;
        private RenameActionItem model;
        private TreeMap<String, String> oldToNew = new TreeMap();
        private IPropertyDescriptor[] propertyDescriptors;

        public RenameActionItemPropertySource(RenameActionItem model) {
            this.setModel(model);
        }

        public void setModel(RenameActionItem model) {
            this.model = model;
            this.initRequired = true;
        }

        private void init() {
            if (!this.initRequired) {
                return;
            }
            this.oldToNew.clear();
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            for (RenameModel.RenameTask task : this.model.getRenameTasks()) {
                this.oldToNew.put(task.getOriginalResource().getFormattedName(), task.getNewName());
                temp.add(new PropertyDescriptor((Object)task.getOriginalResource().getFormattedName(), task.getOriginalResource().getFormattedName()));
            }
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
            this.initRequired = false;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            this.init();
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                return this.oldToNew.get(id);
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

