/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.socket.func.DSP;
import com.ibm.etools.fm.ui.dialog.MemberLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.MemberSelectionCriteriaComposite;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.CompareWizardPageOld;
import com.ibm.etools.fm.ui.wizards.PrintModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.ByteStringComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PrintWizardPageResource
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(CompareWizardPageOld.class);
    private static final String COMMA = ",";
    private final PrintModel model;
    private PrintWizardPageResourceConnector connector = new PrintWizardPageResourceConnector();
    private Button wIoExit;
    private Combo wIoExitCustom;
    private Combo wBinaryRecordLength;
    private Combo wPosition;
    private Combo wNlrecs;
    private Combo wSkip;
    private Combo wInclude;
    private Combo wKey;
    private Button wIgnoreLength;
    private Button wPackUnpack;
    private Button wPackNone;
    private Button wPackSkip;
    private Button wAccessLogical;
    private Button wAccessCI;
    private Button wAccessBlocks;
    private Combo wMemberList;
    private Button wMemberListLookup;
    private MemberSelectionCriteriaComposite wMemberSelection;

    protected PrintWizardPageResource(PrintModel command) {
        super(Messages.LABEL_RESOURCE);
        this.setTitle(Messages.LABEL_RESOURCE);
        this.setMessage(Messages.LABEL_SPECIFY_RESOURCE);
        this.model = command;
    }

    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group memberGroup = GUI.group((Composite)parent, (String)Messages.LABEL_MEMBER_GROUP, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        GUI.label.left((Composite)memberGroup, (String)Messages.LABEL_MEMBER, (Object)GUI.grid.d.left1());
        this.wMemberList = GUI.combo.editable((Composite)memberGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMemberList, ((Object)((Object)this)).getClass().getCanonicalName() + "Members");
        this.wMemberListLookup = LookupButton.createLookupButtonLeft1((Composite)memberGroup);
        this.wMemberSelection = new MemberSelectionCriteriaComposite((Composite)memberGroup, 0, this.model.getMemberSelectionCriteria());
        this.wMemberSelection.setLayoutData(GUI.grid.d.fillH((int)3));
        final Combo getwExcludeMembers = this.wMemberSelection.getwExcludeMembers();
        getwExcludeMembers.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (!getwExcludeMembers.getText().equals("")) {
                    PrintWizardPageResource.this.filterMamberList(getwExcludeMembers);
                }
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.wMemberList.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (!getwExcludeMembers.getText().equals("")) {
                    PrintWizardPageResource.this.filterMamberList(getwExcludeMembers);
                }
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.wMemberListLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MemberLookupDialog dlg = new MemberLookupDialog((DataSet)PrintWizardPageResource.this.model.getResource(), getwExcludeMembers.getText());
                if (dlg.open() == 0) {
                    PrintWizardPageResource.this.wMemberListLookup.setFocus();
                    for (Member member : dlg.getSelectedMembers()) {
                        ArrayList<String> membersList = new ArrayList<String>(PrintWizardPageResource.this.model.getMemberListAsList());
                        if (membersList.contains(member.getName())) continue;
                        membersList.add(member.getName());
                        Collections.sort(membersList, new ByteStringComparator(PrintWizardPageResource.this.model.getSystem().getHostType()));
                        Object text2 = "";
                        for (String mem : membersList) {
                            text2 = !((String)text2).isEmpty() ? (String)text2 + PrintWizardPageResource.COMMA + mem : mem;
                        }
                        PrintWizardPageResource.this.wMemberList.setText((String)text2);
                    }
                    PrintWizardPageResource.this.model.fireModelChangeEvent();
                }
            }
        });
        Group recordGroup = GUI.group((Composite)parent, (String)Messages.LABEL_RECORD_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        GUI.label.left((Composite)recordGroup, (String)Messages.LABEL_RECORD_START, (Object)GUI.grid.d.left1());
        this.wPosition = GUI.combo.editable((Composite)recordGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wPosition, ((Object)((Object)this)).getClass().getCanonicalName() + "Position");
        GUI.label.left((Composite)recordGroup, (String)Messages.LABEL_RECORD_PRINT, (Object)GUI.grid.d.left1());
        this.wNlrecs = GUI.combo.editable((Composite)recordGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wNlrecs, ((Object)((Object)this)).getClass().getCanonicalName() + "NumRecords");
        GUI.label.left((Composite)recordGroup, (String)Messages.PrintWizardPageResource_SAMPLE_SKIP, (Object)GUI.grid.d.left1());
        this.wSkip = GUI.combo.editable((Composite)recordGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wSkip, ((Object)((Object)this)).getClass().getCanonicalName() + "Skip");
        GUI.label.left((Composite)recordGroup, (String)Messages.LABEL_RECORD_SAMPLING_INCLUDE, (Object)GUI.grid.d.left1());
        this.wInclude = GUI.combo.editable((Composite)recordGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wInclude, ((Object)((Object)this)).getClass().getCanonicalName() + "Include");
        GUI.label.left((Composite)recordGroup, (String)Messages.LABEL_RECORD_KEY, (Object)GUI.grid.d.left1());
        this.wKey = GUI.combo.editable((Composite)recordGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wKey, ((Object)((Object)this)).getClass().getCanonicalName() + "Key");
        GUI.label.left((Composite)recordGroup, (String)Messages.Label__BINARY_RECORD_LENGTH, (Object)GUI.grid.d.left1());
        this.wBinaryRecordLength = GUI.combo.editable((Composite)recordGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wBinaryRecordLength, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        Group miscGroup = GUI.group((Composite)parent, (String)Messages.LABEL_MISCELLANEOUS_GROUP, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wIgnoreLength = GUI.button.checkbox((Composite)miscGroup, (String)Messages.PrintWizardPageResource_IGNORE_RECLEN_MISMATCH, (Object)GUI.grid.d.fillH((int)3));
        this.wIoExit = GUI.button.checkbox((Composite)miscGroup, (String)Messages.Label__IO_EXIT, (Object)GUI.grid.d.left1());
        this.wIoExitCustom = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wIoExitCustom, ((Object)((Object)this)).getClass().getCanonicalName() + "CustomIOExit");
        GUI.label.left((Composite)miscGroup, (String)Messages.PrintWizard_PROCESS_BY, (Object)GUI.grid.d.left1());
        Composite processComp = GUI.composite((Composite)miscGroup, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.wAccessLogical = GUI.button.radio((Composite)processComp, (String)Messages.LOGICAL_RECORDS, (Object)GUI.grid.d.fillH((int)1));
        this.wAccessCI = GUI.button.radio((Composite)processComp, (String)Messages.CONTROL_INTERVALS, (Object)GUI.grid.d.fillH((int)1));
        this.wAccessBlocks = GUI.button.radio((Composite)processComp, (String)Messages.BLOCKS, (Object)GUI.grid.d.fillH((int)1));
        Composite packComp = GUI.composite((Composite)miscGroup, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        GUI.label.left((Composite)packComp, (String)Messages.LABEL_RECORD_PACK, (Object)GUI.grid.d.left1());
        this.wPackUnpack = GUI.button.radio((Composite)packComp, (String)Messages.PrintWizard_PACK_UNPACK, (Object)GUI.grid.d.fillH((int)1));
        GUI.grid.padding((Composite)packComp, (int)1);
        this.wPackNone = GUI.button.radio((Composite)packComp, (String)Messages.PrintWizard_PACK_NONE, (Object)GUI.grid.d.fillH((int)1));
        GUI.grid.padding((Composite)packComp, (int)1);
        this.wPackSkip = GUI.button.radio((Composite)packComp, (String)Messages.PrintWizard_PACK_SKIP, (Object)GUI.grid.d.fillH((int)1));
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wMemberList);
        this.connector.listenTo((Control)this.wIgnoreLength);
        this.connector.listenTo((Control)this.wIoExit);
        this.connector.listenTo((Control)this.wIoExitCustom);
        this.connector.listenTo((Control)this.wBinaryRecordLength);
        this.connector.listenTo((Control)this.wPosition);
        this.connector.listenTo((Control)this.wNlrecs);
        this.connector.listenTo((Control)this.wSkip);
        this.connector.listenTo((Control)this.wInclude);
        this.connector.listenTo((Control)this.wKey);
        this.connector.listenTo((Control)this.wPackUnpack);
        this.connector.listenTo((Control)this.wPackNone);
        this.connector.listenTo((Control)this.wPackSkip);
        this.connector.listenTo((Control)this.wAccessLogical);
        this.connector.listenTo((Control)this.wAccessCI);
        this.connector.listenTo((Control)this.wAccessBlocks);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.wMemberSelection.setResource(this.model.getResource());
            this.wMemberSelection.getConnector().doManualViewUpdate();
            this.connector.doManualViewUpdate();
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        int value;
        if (this.model.getPosition() != null && this.model.getPosition().trim().length() > 0) {
            try {
                value = Integer.parseInt(this.model.getPosition());
                if (value < 0 || value > 9999999) {
                    return Messages.PrintWizardPageResource_INVALID_POSITION;
                }
            }
            catch (Exception e) {
                return Messages.PrintWizardPageResource_INVALID_POSITION;
            }
        }
        if (this.model.getSmplskip() != null && this.model.getSmplskip().trim().length() > 0) {
            try {
                value = Integer.parseInt(this.model.getSmplskip());
                if (value < 0 || value > 9999999) {
                    return Messages.PrintWizardPageResource_INVALID_SAMPLE_INCLUDE;
                }
            }
            catch (Exception e) {
                return Messages.PrintWizardPageResource_INVALID_SAMPLE_INCLUDE;
            }
        }
        if (this.model.getSmplincl() != null && this.model.getSmplincl().trim().length() > 0) {
            try {
                value = Integer.parseInt(this.model.getSmplincl());
                if (value < 0 || value > 9999999) {
                    return Messages.PrintWizardPageResource_INVALID_SAMPLE_SKIP;
                }
            }
            catch (Exception e) {
                return Messages.PrintWizardPageResource_INVALID_SAMPLE_SKIP;
            }
        }
        if (this.model.getNlrecsAll() != null && this.model.getNlrecsAll().trim().length() > 0) {
            try {
                if (!(this.model.getNlrecs().equals(this.model.getNlrecsAll()) || (value = Integer.parseInt(this.model.getNlrecs())) >= 0 && value <= 999999999)) {
                    return Messages.PrintWizardPageResource_INVALID_RECORD_NUMBER;
                }
            }
            catch (Exception e) {
                return Messages.PrintWizardPageResource_INVALID_RECORD_NUMBER;
            }
        }
        if (this.model.getKeySet() != null & this.model.getKeySet().length() > 30) {
            return Messages.PrintWizardPageResource_INVALID_KEY_LENGTH;
        }
        if (this.model.isIoExit() && this.model.getPack() != DSP.DspPack.NONE) {
            return Messages.PrintWizardPageResource_INVALID_PACK;
        }
        if (!UIValidator.isValidMemberList(this.model.getMemberListSet(), false, this.model.getSystem().getCodePage()) && !UIValidator.isValidWildcardableMember(this.model.getMemberListSet(), this.model.getSystem().getCodePage())) {
            return Messages.PrintWizardPageResource_INVALID_MEM_LIST;
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    private void filterMamberList(Combo getwExcludeMembers) {
        List<String> memberList = new ArrayList<String>(Arrays.asList(this.wMemberList.getText().split(COMMA)));
        ArrayList<String> excludeList = new ArrayList<String>(Arrays.asList(getwExcludeMembers.getText().split(COMMA)));
        for (String exclude : excludeList) {
            memberList = memberList.stream().filter(s -> !s.matches(exclude.replaceAll("\\*", "\\\\w*"))).collect(Collectors.toList());
        }
        this.wMemberList.setText(String.join((CharSequence)COMMA, memberList));
    }

    private class PrintWizardPageResourceConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private PrintWizardPageResourceConnector() {
        }

        protected void updateModelFromViewImpl() {
            PrintWizardPageResource.this.model.setMemberList(PrintWizardPageResource.this.wMemberList.getText());
            PrintWizardPageResource.this.model.setIgnoreLength(PrintWizardPageResource.this.wIgnoreLength.getSelection());
            PrintWizardPageResource.this.model.setIoExit(PrintWizardPageResource.this.wIoExit.getSelection());
            PrintWizardPageResource.this.model.setIoExitCustom(PrintWizardPageResource.this.wIoExitCustom.getText());
            PrintWizardPageResource.this.model.setBinaryRecordLength(PrintWizardPageResource.this.wBinaryRecordLength.getText());
            PrintWizardPageResource.this.model.setPosition(PrintWizardPageResource.this.wPosition.getText());
            PrintWizardPageResource.this.model.setNlrecs(PrintWizardPageResource.this.wNlrecs.getText());
            PrintWizardPageResource.this.model.setSmplskip(PrintWizardPageResource.this.wSkip.getText());
            PrintWizardPageResource.this.model.setSmplincl(PrintWizardPageResource.this.wInclude.getText());
            PrintWizardPageResource.this.model.setKey(PrintWizardPageResource.this.wKey.getText());
            if (PrintWizardPageResource.this.wPackUnpack.getSelection()) {
                PrintWizardPageResource.this.model.setPack(DSP.DspPack.UNPACK);
            } else if (PrintWizardPageResource.this.wPackNone.getSelection()) {
                PrintWizardPageResource.this.model.setPack(DSP.DspPack.NONE);
            } else if (PrintWizardPageResource.this.wPackSkip.getSelection()) {
                PrintWizardPageResource.this.model.setPack(DSP.DspPack.SKIP);
            }
            if (PrintWizardPageResource.this.wAccessLogical.getSelection()) {
                PrintWizardPageResource.this.model.setProcessBy(PrintModel.AccessType.LogicalRecord);
            } else if (PrintWizardPageResource.this.wAccessCI.getSelection()) {
                PrintWizardPageResource.this.model.setProcessBy(PrintModel.AccessType.ControlInterval);
            } else if (PrintWizardPageResource.this.wAccessBlocks.getSelection()) {
                PrintWizardPageResource.this.model.setProcessBy(PrintModel.AccessType.Block);
            }
            PrintWizardPageResource.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            IZRL resource = PrintWizardPageResource.this.model.getResource();
            PrintWizardPageResource.this.wMemberSelection.setResource(resource);
            this.updateComboFromModelIfNeeded(PrintWizardPageResource.this.wMemberList, PrintWizardPageResource.this.model.getMemberList());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageResource.this.wIgnoreLength, PrintWizardPageResource.this.model.isIgnoreLength());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageResource.this.wIoExit, PrintWizardPageResource.this.model.isIoExit());
            this.updateComboFromModelIfNeeded(PrintWizardPageResource.this.wIoExitCustom, PrintWizardPageResource.this.model.getIoExitCustom());
            this.updateComboFromModelIfNeeded(PrintWizardPageResource.this.wBinaryRecordLength, PrintWizardPageResource.this.model.getBinaryRecordLengthSet());
            this.updateComboFromModelIfNeeded(PrintWizardPageResource.this.wPosition, PrintWizardPageResource.this.model.getPosition());
            this.updateComboFromModelIfNeeded(PrintWizardPageResource.this.wNlrecs, PrintWizardPageResource.this.model.getNlrecs());
            this.updateComboFromModelIfNeeded(PrintWizardPageResource.this.wSkip, PrintWizardPageResource.this.model.getSmplskip());
            this.updateComboFromModelIfNeeded(PrintWizardPageResource.this.wInclude, PrintWizardPageResource.this.model.getSmplincl());
            PrintWizardPageResource.this.wPackUnpack.setSelection(PrintWizardPageResource.this.model.getPack() == DSP.DspPack.UNPACK);
            PrintWizardPageResource.this.wPackNone.setSelection(PrintWizardPageResource.this.model.getPack() == DSP.DspPack.NONE);
            PrintWizardPageResource.this.wPackSkip.setSelection(PrintWizardPageResource.this.model.getPack() == DSP.DspPack.SKIP);
            PrintWizardPageResource.this.wAccessLogical.setSelection(PrintWizardPageResource.this.model.getProcessBy() == PrintModel.AccessType.LogicalRecord);
            PrintWizardPageResource.this.wAccessCI.setSelection(PrintWizardPageResource.this.model.getProcessBy() == PrintModel.AccessType.ControlInterval);
            PrintWizardPageResource.this.wAccessBlocks.setSelection(PrintWizardPageResource.this.model.getProcessBy() == PrintModel.AccessType.Block);
            boolean resourceHasMembers = resource instanceof DataSet && ((DataSet)resource).getHasMembers();
            PrintWizardPageResource.this.wMemberList.setEnabled(resourceHasMembers);
            PrintWizardPageResource.this.wMemberListLookup.setEnabled(resourceHasMembers);
            PrintWizardPageResource.this.wBinaryRecordLength.setEnabled(resource instanceof UssFile);
            if (resource instanceof DataSet) {
                DataSetType type = ((DataSet)resource).getType();
                PrintWizardPageResource.this.wKey.setEnabled(type == DataSetType.RRDS || type == DataSetType.KSDS || type == DataSetType.KSDSIAM);
            } else if (resource instanceof CicsFile) {
                CicsFile cicsFile = (CicsFile)resource;
                PrintWizardPageResource.this.wKey.setEnabled(cicsFile.getKeyLength() != -1 && cicsFile.getKeyStartLocation() != -1);
            } else {
                PrintWizardPageResource.this.wKey.setEnabled(false);
            }
            PrintWizardPageResource.this.wIoExitCustom.setEnabled(PrintWizardPageResource.this.model.isIoExit());
            DataSetType.AccessMethod accessMethod = null;
            if (PrintWizardPageResource.this.model.getResource() instanceof DataSet) {
                accessMethod = ((DataSet)PrintWizardPageResource.this.model.getResource()).getType().getAccessMethod();
            }
            PrintWizardPageResource.this.wAccessCI.setEnabled(accessMethod == DataSetType.AccessMethod.VSAM);
            PrintWizardPageResource.this.wAccessBlocks.setEnabled(accessMethod == DataSetType.AccessMethod.QSAM);
            String validationErrorMessage = PrintWizardPageResource.this.getValidationErrorMessage();
            PrintWizardPageResource.this.setPageComplete(validationErrorMessage == null);
            PrintWizardPageResource.this.setErrorMessage(validationErrorMessage);
        }
    }
}

