/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.socket.func.DSP;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.callback.ISelectedValueFormatter;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.dialog.lookup.filter.DefaultLookupFilter;
import com.ibm.etools.fm.ui.dialog.lookup.filter.ILookupFilterProvider;
import com.ibm.etools.fm.ui.widget.TemplateWithOffsetComposite;
import com.ibm.etools.fm.ui.wizards.PrintModel;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PrintWizardPageFirst
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final PrintModel model;
    private PrintWizardPageFirstConnector connector = new PrintWizardPageFirstConnector();
    private Combo wResource;
    private Combo wResourceVolser;
    private TemplateWithOffsetComposite wTemplateComponent;
    private Button wFormatCharacter;
    private Button wFormatHex;
    private Button wFormatSingle;
    private Button wFormatTabular;
    private Button wReferenceNumber;
    private Button wRedefinedFields;
    private Button wPictureClause;
    private Button wStartLocation;
    private Button wStructure;
    private Button wLeftJustifyNumericFields;
    private Button wShowFieldType;
    private Button wRecordLength;
    private Button wCcsid;
    private Button wIncludeMQ;

    protected PrintWizardPageFirst(PrintModel command) {
        super(Messages.Basic_SETTINGS);
        this.setTitle(Messages.Basic_SETTINGS);
        this.setMessage(Messages.PrintWizard_ENTER_BASIC_PRINT_OPTIONS);
        this.model = command;
    }

    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group inputGroup = GUI.group((Composite)parent, (String)Messages.PrintWizard_RESOURCE, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        GUI.label.left((Composite)inputGroup, (String)Messages.Label__RESOURCE, (Object)GUI.grid.d.left1());
        this.wResource = GUI.combo.editable((Composite)inputGroup, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)inputGroup), this.wResource, (IHostProvider)this.model).types(ZRLs.getAllResourceTypesForZos()).formatter(new ISelectedValueFormatter(){

            @Override
            public String getNewValue(IPDHost selectedHost, IZRL zrl) {
                return PrintWizardPageFirst.this.model.getResource().getFormattedName();
            }
        }).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                IZRL resource = PrintWizardPageFirst.this.model.getResource();
                if (resource != null) {
                    return DefaultLookupFilter.getDatasetNameOrFallbackToZrlThenString(resource, resource.getFormattedName());
                }
                return combo2.getText();
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                PrintWizardPageFirst.this.model.setResource(zrl);
                PrintWizardPageFirst.this.model.fireModelChangeEvent();
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        GUI.label.left((Composite)inputGroup, (String)Messages.Label__VOLUME, (Object)GUI.grid.d.left1());
        this.wResourceVolser = GUI.combo.editable((Composite)inputGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wResourceVolser, ((Object)((Object)this)).getClass().getCanonicalName() + "ResourceVolume");
        GUI.grid.padding((Composite)inputGroup, (int)1);
        Group templateGroup = GUI.group((Composite)parent, (String)Messages.PrintWizard_TEMPLATE, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wTemplateComponent = new TemplateWithOffsetComposite((Composite)templateGroup, 0, this.model.getTemplate(), String.valueOf(((Object)((Object)this)).getClass()) + "Template", false){

            @Override
            protected void onViewUpdated() {
                PrintWizardPageFirst.this.connector.updateViewFromModelImpl();
            }
        };
        this.wTemplateComponent.setLayoutData(GUI.grid.d.fillH((int)2));
        Group formatGroup = GUI.group((Composite)parent, (String)Messages.PrintWizard_FORMAT, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        Composite formatComp = GUI.composite((Composite)formatGroup, (Layout)GUI.grid.l.noMargins((int)4, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.wFormatCharacter = GUI.button.radio((Composite)formatComp, (String)Messages.PrintWizard_FORMAT_CHARACTER, (Object)GUI.grid.d.fillH((int)1));
        this.wFormatHex = GUI.button.radio((Composite)formatComp, (String)Messages.PrintWizard_FORMAT_HEXADECIMAL, (Object)GUI.grid.d.fillH((int)1));
        this.wFormatSingle = GUI.button.radio((Composite)formatComp, (String)Messages.PrintWizard_FORMAT_SINGLE_RECORD, (Object)GUI.grid.d.fillH((int)1));
        this.wFormatTabular = GUI.button.radio((Composite)formatComp, (String)Messages.PrintWizard_FORMAT_TABULAR, (Object)GUI.grid.d.fillH((int)1));
        Group miscGroup = GUI.group((Composite)parent, (String)Messages.PrintWizard_FORMAT_OPTIONS, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wReferenceNumber = GUI.button.checkbox((Composite)miscGroup, (String)Messages.LABEL_MISCELLANEOUS_GROUP_REF, (Object)GUI.grid.d.fillH((int)1));
        this.wRedefinedFields = GUI.button.checkbox((Composite)miscGroup, (String)Messages.LABEL_MISCELLANEOUS_GROUP_RDF, (Object)GUI.grid.d.fillH((int)1));
        this.wPictureClause = GUI.button.checkbox((Composite)miscGroup, (String)Messages.LABEL_MISCELLANEOUS_GROUP_PIC, (Object)GUI.grid.d.fillH((int)1));
        this.wStartLocation = GUI.button.checkbox((Composite)miscGroup, (String)Messages.LABEL_MISCELLANEOUS_GROUP_SLOC, (Object)GUI.grid.d.fillH((int)1));
        this.wStructure = GUI.button.checkbox((Composite)miscGroup, (String)Messages.LABEL_MISCELLANEOUS_GROUP_STR, (Object)GUI.grid.d.fillH((int)1));
        this.wLeftJustifyNumericFields = GUI.button.checkbox((Composite)miscGroup, (String)Messages.LABEL_MISCELLANEOUS_GROUP_JUST, (Object)GUI.grid.d.fillH((int)1));
        this.wShowFieldType = GUI.button.checkbox((Composite)miscGroup, (String)Messages.LABEL_MISCELLANEOUS_GROUP_TYPE, (Object)GUI.grid.d.fillH((int)1));
        this.wRecordLength = GUI.button.checkbox((Composite)miscGroup, (String)Messages.LABEL_MISCELLANEOUS_GROUP_RLEN, (Object)GUI.grid.d.fillH((int)1));
        this.wCcsid = GUI.button.checkbox((Composite)miscGroup, (String)Messages.PrintWizardPageFirst_LABEL_SHOW_FIELD_CCSID, (Object)GUI.grid.d.fillH((int)1));
        this.wIncludeMQ = GUI.button.checkbox((Composite)miscGroup, (String)Messages.EditorOptionDialog_MQ_INCLUDE_DESCRIPTORS, (Object)GUI.grid.d.fillH((int)1));
        this.wIncludeMQ.setToolTipText(Messages.EditorOptionDialog_MQ_INCLUDE_DESCRIPTORS_TIP);
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wResource);
        this.connector.listenTo((Control)this.wResourceVolser);
        this.connector.listenTo((Control)this.wTemplateComponent);
        this.connector.listenTo((Control)this.wFormatCharacter);
        this.connector.listenTo((Control)this.wFormatHex);
        this.connector.listenTo((Control)this.wFormatSingle);
        this.connector.listenTo((Control)this.wFormatTabular);
        this.connector.listenTo((Control)this.wReferenceNumber);
        this.connector.listenTo((Control)this.wRedefinedFields);
        this.connector.listenTo((Control)this.wPictureClause);
        this.connector.listenTo((Control)this.wStartLocation);
        this.connector.listenTo((Control)this.wStructure);
        this.connector.listenTo((Control)this.wLeftJustifyNumericFields);
        this.connector.listenTo((Control)this.wShowFieldType);
        this.connector.listenTo((Control)this.wRecordLength);
        this.connector.listenTo((Control)this.wCcsid);
        this.connector.listenTo((Control)this.wIncludeMQ);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.wTemplateComponent.getConnector().doManualViewUpdate();
            this.connector.doManualViewUpdate();
            if (this.wResource.getText().isEmpty()) {
                this.wResource.setFocus();
            }
        }
        super.setVisible(visible);
        if (!visible) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        String validationResult = PrintWizardPageFirst.this.model.validateResourceTypes(howIsGoing);
                        if (validationResult != null) {
                            throw new IllegalArgumentException(validationResult);
                        }
                    }
                });
                this.getContainer().getCurrentPage().setVisible(true);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                if (t instanceof IllegalArgumentException) {
                    PDDialogs.openErrorThreadSafe((String)Messages.Cannot_PROGRESS_SEE_ERROR_BELOW, (String)t.getMessage(), (Throwable)t);
                }
                IWizardPage newPage = this.getWizard().getStartingPage();
                this.getContainer().showPage(newPage);
                newPage.setPreviousPage(null);
            }
        }
    }

    public String getValidationErrorMessage() {
        if (this.model.getSystem() == null) {
            return Messages.VALID_SYSTEM_REQUIRED;
        }
        if (this.model.getResource() == null) {
            return Messages.PrintWizardPageFirst_INVALID_RESOURCE;
        }
        if (!this.model.getResource().getSystem().equals(this.model.getSystem())) {
            return Messages.PrintWizardPageFirst_SYSTEM_MISMATCH;
        }
        if (this.model.getResourceVolume() != null && this.model.getResourceVolume().length() > 0 && !Volume.isValid((String)this.model.getResourceVolume(), (String)this.model.getSystem().getCodePage())) {
            return Messages.PrintWizardPageFirst_INVALID_VOLUME;
        }
        if (this.model.isResourceLoaded() && !this.model.isResourceDataSetWithMembers() && (this.model.getSingleSourceMemberSelected() != null || this.model.isMultipleMembersSelected(false))) {
            return Messages.PrintWizardPageFirst_RESOUCE_CANT_HAVE_MEMBER;
        }
        if (this.wTemplateComponent.getValidationErrorMessage() != null) {
            return this.wTemplateComponent.getValidationErrorMessage();
        }
        if ((this.model.getFormat() == DSP.DspFormat.SNGL || this.model.getFormat() == DSP.DspFormat.TABL) && this.model.getTemplate().getTemplate() == null) {
            return Messages.PrintWizardPageTemplate_SGNL_TABL_REQ_TEMPLATE;
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    private class PrintWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private PrintWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (PrintWizardPageFirst.this.wTemplateComponent.getConnector().isHandlingViewUpdate()) {
                logger.trace((Object)"ignoring model update because template component is updating view");
                return;
            }
            if (PrintWizardPageFirstConnector.focussed((Control)PrintWizardPageFirst.this.wResource)) {
                PrintWizardPageFirst.this.model.setResource(PrintWizardPageFirst.this.wResource.getText());
            }
            if (PrintWizardPageFirstConnector.focussed((Control)PrintWizardPageFirst.this.wResourceVolser)) {
                PrintWizardPageFirst.this.model.setResourceVolume(PrintWizardPageFirst.this.wResourceVolser.getText());
            }
            if (PrintWizardPageFirst.this.wFormatCharacter.getSelection()) {
                PrintWizardPageFirst.this.model.setFormat(DSP.DspFormat.CHAR);
            } else if (PrintWizardPageFirst.this.wFormatHex.getSelection()) {
                PrintWizardPageFirst.this.model.setFormat(DSP.DspFormat.HEX);
            } else if (PrintWizardPageFirst.this.wFormatSingle.getSelection()) {
                PrintWizardPageFirst.this.model.setFormat(DSP.DspFormat.SNGL);
            } else if (PrintWizardPageFirst.this.wFormatTabular.getSelection()) {
                PrintWizardPageFirst.this.model.setFormat(DSP.DspFormat.TABL);
            }
            PrintWizardPageFirst.this.model.setReferenceNumber(PrintWizardPageFirst.this.wReferenceNumber.getSelection());
            PrintWizardPageFirst.this.model.setRedefinedFields(PrintWizardPageFirst.this.wRedefinedFields.getSelection());
            PrintWizardPageFirst.this.model.setPictureClause(PrintWizardPageFirst.this.wPictureClause.getSelection());
            PrintWizardPageFirst.this.model.setStartLocation(PrintWizardPageFirst.this.wStartLocation.getSelection());
            PrintWizardPageFirst.this.model.setStructure(PrintWizardPageFirst.this.wStructure.getSelection());
            PrintWizardPageFirst.this.model.setJustifyNumericFields(PrintWizardPageFirst.this.wLeftJustifyNumericFields.getSelection());
            PrintWizardPageFirst.this.model.setShowFieldType(PrintWizardPageFirst.this.wShowFieldType.getSelection());
            PrintWizardPageFirst.this.model.setRecordLength(PrintWizardPageFirst.this.wRecordLength.getSelection());
            PrintWizardPageFirst.this.model.setShowingCcsid(PrintWizardPageFirst.this.wCcsid.getSelection());
            PrintWizardPageFirst.this.model.setIncludeMd(PrintWizardPageFirst.this.wIncludeMQ.getSelection());
            PrintWizardPageFirst.this.model.fireModelChangeEvent();
        }

        protected void updateViewFromModelImpl() {
            Volume volume;
            this.updateComboFromModelIfNeeded(PrintWizardPageFirst.this.wResource, this.getResourceRep());
            if (PrintWizardPageFirst.this.model.getResource() instanceof DataSet && (volume = ((DataSet)PrintWizardPageFirst.this.model.getResource()).getVolume()) != null) {
                this.updateComboFromModelIfNeeded(PrintWizardPageFirst.this.wResourceVolser, volume.getVolserID());
            }
            PrintWizardPageFirst.this.wFormatCharacter.setSelection(PrintWizardPageFirst.this.model.getFormat() == DSP.DspFormat.CHAR);
            PrintWizardPageFirst.this.wFormatHex.setSelection(PrintWizardPageFirst.this.model.getFormat() == DSP.DspFormat.HEX);
            PrintWizardPageFirst.this.wFormatSingle.setSelection(PrintWizardPageFirst.this.model.getFormat() == DSP.DspFormat.SNGL);
            PrintWizardPageFirst.this.wFormatTabular.setSelection(PrintWizardPageFirst.this.model.getFormat() == DSP.DspFormat.TABL);
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wReferenceNumber, PrintWizardPageFirst.this.model.isReferenceNumber());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wRedefinedFields, PrintWizardPageFirst.this.model.isRedefinedFields());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wPictureClause, PrintWizardPageFirst.this.model.isPictureClause());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wStartLocation, PrintWizardPageFirst.this.model.isStartLocation());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wStructure, PrintWizardPageFirst.this.model.isStructure());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wLeftJustifyNumericFields, PrintWizardPageFirst.this.model.isLeftJustifyNumericFields());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wShowFieldType, PrintWizardPageFirst.this.model.isShowFieldType());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wRecordLength, PrintWizardPageFirst.this.model.isRecordLength());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wCcsid, PrintWizardPageFirst.this.model.isShowingCcsid());
            this.updateButtonSelectionFromModelIfNeeded(PrintWizardPageFirst.this.wIncludeMQ, PrintWizardPageFirst.this.model.isIncludeMd());
            PrintWizardPageFirst.this.wCcsid.setEnabled(PrintWizardPageFirst.this.model.getTemplate().getTemplate() != null && PrintWizardPageFirst.this.model.getFormat() == DSP.DspFormat.SNGL);
            String validationErrorMessage = PrintWizardPageFirst.this.getValidationErrorMessage();
            PrintWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            PrintWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }

        public String getResourceRep() {
            Object oldResourceText = PrintWizardPageFirst.this.model.getResourceSet();
            if (PrintWizardPageFirst.this.model.getSingleSourceMemberSelected() != null) {
                oldResourceText = (String)oldResourceText + "(" + PrintWizardPageFirst.this.model.getSingleSourceMemberSelected() + ")";
            } else if (PrintWizardPageFirst.this.model.isMultipleMembersSelected(false)) {
                oldResourceText = (String)oldResourceText + "(...)";
            }
            return oldResourceText;
        }
    }
}

