/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.wizards.FMWizardResultHelper;
import com.ibm.etools.fm.ui.wizards.PrintModel;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;

public class PrintRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final PrintModel model;

    public PrintRunnable(PrintModel model) {
        this.model = model;
    }

    @Override
    protected String getName() {
        return "Printing";
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result<StringBuffer> result;
        monitor.beginTask(this.getName(), 3);
        monitor.worked(1);
        try {
            result = this.model.execute(monitor);
        }
        catch (InterruptedException e) {
            result = null;
        }
        monitor.worked(1);
        if (result != null && result.getRC() <= 4) {
            result.reformatOutput();
            FMWizardResultHelper.displayResult(result, Messages.PrintRunnable_PRINT_FAILED, monitor);
            monitor.worked(1);
        }
        monitor.done();
        return result;
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().getRC() <= 4;
    }

    @Override
    public void showResult() {
        FMDialogWithText.showResultDump(this.getResult(), false, 4);
    }
}

