/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.socket.func.DSP;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.SET;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.MemberSelectionCriteriaModel;
import com.ibm.etools.fm.ui.widget.TemplateWithOffsetModel;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.core.model.IRefreshable;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Objects;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class PrintModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MULTI_MEMBER_PLACEHOLDER = "...";
    private static final String NLRECS_ALL = "ALL";
    private String resource = "";
    private String resourceVolume = "";
    private IRefreshable resourceLoaded = null;
    private String memberList = "";
    private MemberSelectionCriteriaModel memberSelectionCriteria = new MemberSelectionCriteriaModel(this.getSystem());
    private boolean ioExit = false;
    private String ioExitCustom = "";
    private String binaryRecordLength = "";
    private AccessType processBy = AccessType.LogicalRecord;
    private DSP.DspFormat format = DSP.DspFormat.CHAR;
    private String position = "0";
    private String key = "";
    private String smplincl = "";
    private String smplskip = "";
    private String nlrecs = "ALL";
    private DSP.DspPack pack = DSP.DspPack.UNPACK;
    private String proc = "";
    private String memproc = "";
    private boolean referenceNumber = false;
    private boolean redefinedFields = false;
    private boolean pictureClause = false;
    private boolean startLocation = false;
    private boolean structure = false;
    private boolean leftJustifyNumericFields = false;
    private boolean showFieldType = false;
    private boolean recordLength = false;
    private boolean ignoreLength = false;
    private boolean showingCcsid = false;
    private boolean includeMd = false;
    private TemplateWithOffsetModel templateModel = new TemplateWithOffsetModel(this.getSystem());

    public PrintModel(IPDHost host) {
        super(host);
        this.templateModel.setEventDelegate(this);
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        try {
            IEclipsePreferences systemOptsPrefs = InstanceScope.INSTANCE.getNode("com.ibm.etools.fm.ui.prefs.prtopts");
            Preferences node = systemOptsPrefs.node(this.getHostProvider().getDescription());
            String dumpVal = node.get("dump", "UPDOWN");
            String dataHdrVal = node.get("datahdr", "YES");
            String recLimitVal = node.get("reclimit", "(1,*)");
            SET set = new SET();
            set.setDumpVal(dumpVal);
            set.setDataHdr(dataHdrVal);
            set.setRecLimit(recLimitVal);
            Result result = UtilityFunctionRunner.execute((IPDHost)this.getHostProvider(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getHostProvider()), (UtilityFunction)set, (IHowIsGoing)monitor);
            if (result.getRC() != 0) {
                System.out.println(result.getDisplayMessage());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        DSP dsp = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), (UtilityFunction)dsp, (IHowIsGoing)monitor);
    }

    public DSP toUtilityFunction() {
        ArrayList<String> memberListAsList;
        DSP dsp = new DSP();
        IZRL resource = this.getResource();
        if (resource != null) {
            Volume vol;
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.DSNIN, (Object)resource.getFormattedName(), this.getSystem());
            if (resource instanceof DataSet && (vol = ((DataSet)resource).getVolume()) != null) {
                dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.VOLSERIN, (Object)vol.getVolserID(), this.getSystem());
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        MemberSelectionCriteriaModel mscm = this.getMemberSelectionCriteria();
        if (mscm.isUsingRange()) {
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.MEMSTART, (Object)mscm.getMembersRangeStart(), this.getSystem());
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.MEMEND, (Object)mscm.getMembersRangeEnd(), this.getSystem());
        }
        if (mscm.isUsingCreated()) {
            Calendar membersCreatedStart = mscm.getMembersCreatedStart();
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.CRESTART, (Object)dateFormat.format(membersCreatedStart.getTime()), this.getSystem());
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.CREEND, (Object)dateFormat.format(mscm.getMembersCreatedEnd().getTime()), this.getSystem());
        }
        if (mscm.isUsingChanged()) {
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.CHGSTART, (Object)dateFormat.format(mscm.getMembersChangedStart().getTime()), this.getSystem());
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.CHGEND, (Object)dateFormat.format(mscm.getMembersChangedEnd().getTime()), this.getSystem());
        }
        if (mscm.isUsingUserID()) {
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.UIDSTART, (Object)mscm.getMembersUserIDStart(), this.getSystem());
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.UIDEND, (Object)mscm.getMembersUserIDEnd(), this.getSystem());
        }
        if ((memberListAsList = this.getMemberListAsList()).size() == 1) {
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.MEMBER, (Object)this.getMemberList(), this.getSystem());
        } else {
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.MEMLIST, (Object)this.getMemberList(), this.getSystem());
        }
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.USEIOXIN, (Object)this.isIoExit(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.IOXIN, (Object)this.getIoExitCustom(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.BINRECIN, (Object)this.getBinaryRecordLength(), this.getSystem());
        if (resource instanceof DataSet) {
            if (((DataSet)resource).getType().getAccessMethod() == DataSetType.AccessMethod.VSAM) {
                dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.CIACCESS, (Object)(this.getProcessBy() == AccessType.ControlInterval ? 1 : 0), this.getSystem());
            } else if (((DataSet)resource).getType().getAccessMethod() == DataSetType.AccessMethod.QSAM) {
                dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.BLKACCESS, (Object)(this.getProcessBy() == AccessType.Block ? 1 : 0), this.getSystem());
            }
        }
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.FORMAT, (Object)this.getFormat(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.POSITION, (Object)this.getPosition(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.KEY, (Object)this.getKey(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.SMPLINCL, (Object)this.getSmplincl(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.SMPLSKIP, (Object)this.getSmplskip(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.NLRECS, (Object)this.getNlrecs(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.PACK, (Object)this.getPack(), this.getSystem());
        if (!this.getProc().isEmpty()) {
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.PROC, (Object)this.getProc(), this.getSystem());
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.MEMPROC, (Object)this.getMemproc(), this.getSystem());
        }
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.REF, (Object)this.isReferenceNumber(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.RDF, (Object)this.isRedefinedFields(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.PIC, (Object)this.isPictureClause(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.SLOC, (Object)this.isStartLocation(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.STR, (Object)this.isStructure(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.JUST, (Object)this.isLeftJustifyNumericFields(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.TYPE, (Object)this.isShowFieldType(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.RLEN, (Object)this.isRecordLength(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.IGNLEN, (Object)this.isIgnoreLength(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.CCISD, (Object)this.isShowingCcsid(), this.getSystem());
        dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.INCLUDEMD, (Object)this.isIncludeMd(), this.getSystem());
        if (this.getTemplate().getTemplate() != null) {
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.TCIN, (Object)this.getTemplate().getTemplate().getFormattedName(), this.getSystem());
            dsp.setValue((NewUtilityFunction.IUtilFuncParam)DSP.OFFSETIN, (Object)this.getTemplate().getOffsetsForHost(), this.getSystem());
        }
        return dsp;
    }

    public void fromUtilityFunction(DSP dsp) {
        this.setResource((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.DSNIN, this.getSystem()));
        this.setResourceVolume((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.VOLSERIN, this.getSystem()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        MemberSelectionCriteriaModel mscm = this.getMemberSelectionCriteria();
        String memStart = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.MEMSTART, this.getSystem());
        String memEnd = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.MEMEND, this.getSystem());
        mscm.setUsingRange(memStart.length() > 0 && memEnd.length() > 0);
        mscm.setMembersRangeStart(memStart);
        mscm.setMembersRangeEnd(memEnd);
        String creStart = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CRESTART, this.getSystem());
        String creEnd = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CREEND, this.getSystem());
        mscm.setUsingCreated(creStart.length() > 0 && creEnd.length() > 0);
        mscm.setMembersCreatedStart(creStart, dateFormat);
        mscm.setMembersCreatedEnd(creEnd, dateFormat);
        String chgStart = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CHGSTART, this.getSystem());
        String chgEnd = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CHGEND, this.getSystem());
        mscm.setUsingChanged(chgStart.length() > 0 && chgEnd.length() > 0);
        mscm.setMembersChangedStart(chgStart, dateFormat);
        mscm.setMembersChangedEnd(chgEnd, dateFormat);
        String uidStart = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.UIDSTART, this.getSystem());
        String uidEnd = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.UIDEND, this.getSystem());
        mscm.setUsingUserID(uidStart.length() > 0 && uidEnd.length() > 0);
        mscm.setMembersUserIDStart(uidStart);
        mscm.setMembersUserIDEnd(uidEnd);
        String memList = (String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.MEMLIST, this.getSystem());
        if (!memList.isEmpty()) {
            this.setMemberList(memList);
        } else {
            this.setMemberList((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.MEMBER, this.getSystem()));
        }
        this.setIoExit((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.USEIOXIN, this.getSystem()));
        this.setIoExitCustom((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.IOXIN, this.getSystem()));
        this.setBinaryRecordLength((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.BINRECIN, this.getSystem()));
        if (((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CIACCESS, this.getSystem())).booleanValue()) {
            this.setProcessBy(AccessType.ControlInterval);
        } else if (((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.BLKACCESS, this.getSystem())).booleanValue()) {
            this.setProcessBy(AccessType.Block);
        } else {
            this.setProcessBy(AccessType.LogicalRecord);
        }
        this.setFormat((DSP.DspFormat)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.FORMAT, this.getSystem()));
        this.setPosition((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.POSITION, this.getSystem()));
        this.setKey((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.KEY, this.getSystem()));
        this.setSmplincl((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.SMPLINCL, this.getSystem()));
        this.setSmplskip((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.SMPLSKIP, this.getSystem()));
        this.setNlrecs((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.NLRECS, this.getSystem()));
        this.setPack((DSP.DspPack)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.PACK, this.getSystem()));
        this.setProc((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.PROC, this.getSystem()));
        this.setMemproc((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.MEMPROC, this.getSystem()));
        this.setReferenceNumber((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.REF, this.getSystem()));
        this.setRedefinedFields((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.RDF, this.getSystem()));
        this.setPictureClause((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.PIC, this.getSystem()));
        this.setStartLocation((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.SLOC, this.getSystem()));
        this.setStructure((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.STR, this.getSystem()));
        this.setJustifyNumericFields((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.JUST, this.getSystem()));
        this.setShowFieldType((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.TYPE, this.getSystem()));
        this.setRecordLength((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.RLEN, this.getSystem()));
        this.setIgnoreLength((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.IGNLEN, this.getSystem()));
        this.setShowingCcsid((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CCISD, this.getSystem()));
        this.setIncludeMd((Boolean)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.INCLUDEMD, this.getSystem()));
        this.templateModel = this.getTemplate();
        this.templateModel.setTemplate((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.TCIN, this.getSystem()));
        this.templateModel.setOffset((String)dsp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.OFFSETIN, this.getSystem()));
    }

    public void setResource(IZRL oldZrl) {
        DataSet oldDataSet;
        Objects.requireNonNull(oldZrl, "Please provide a non-null oldZRL IZRL.");
        this.memberList = "";
        this.memberSelectionCriteria.clear();
        this.resource = oldZrl.getFormattedName();
        if (oldZrl instanceof IRefreshable && ((IRefreshable)oldZrl).getConfirmedExists()) {
            this.resourceLoaded = (IRefreshable)oldZrl;
        }
        DataSet dataSet = oldDataSet = oldZrl instanceof DataSet ? (DataSet)oldZrl : null;
        if (oldZrl instanceof Member) {
            Member member = (Member)oldZrl;
            oldDataSet = member.asDataSet();
            this.resource = oldDataSet.getFormattedName();
            this.resourceLoaded = oldDataSet;
            this.memberList = member.getName();
        }
        if (oldDataSet != null) {
            this.resourceVolume = oldDataSet.getVolume() != null ? oldDataSet.getVolume().getVolserID() : "";
        }
    }

    public void setResource(String resource) {
        int memStart = ((String)resource).indexOf("(");
        int memEnd = ((String)resource).indexOf(")");
        if (memStart >= 0 && memStart < memEnd) {
            String mem = ((String)resource).substring(memStart + 1, memEnd);
            resource = ((String)resource).substring(0, memStart);
            if (!MULTI_MEMBER_PLACEHOLDER.equals(mem)) {
                if (UIValidator.isValidWildcardableMember(mem, this.getSystem().getCodePage()) || UIValidator.isValidMemberList(mem, false, this.getSystem().getCodePage())) {
                    this.memberList = mem;
                    this.memberSelectionCriteria.clear();
                } else {
                    resource = (String)resource + "()";
                    this.memberList = "";
                    this.memberSelectionCriteria.clear();
                }
            }
        } else {
            this.memberList = "";
            this.memberSelectionCriteria.clear();
        }
        this.resource = resource;
    }

    public void setTemplate(TemplateWithOffsetModel template) {
        this.templateModel = template;
    }

    public void setMemberList(String memberList) {
        this.memberList = memberList;
    }

    public void setIoExit(boolean ioExit) {
        this.ioExit = ioExit;
    }

    public void setIoExitCustom(String ioExitCustom) {
        this.ioExitCustom = ioExitCustom;
    }

    public void setBinaryRecordLength(String binaryRecordLength) {
        this.binaryRecordLength = binaryRecordLength;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setMemberSelectionCriteria(MemberSelectionCriteriaModel memberSelectionCriteria) {
        this.memberSelectionCriteria = memberSelectionCriteria;
    }

    public void setProcessBy(AccessType processBy) {
        this.processBy = processBy;
    }

    public void setFormat(DSP.DspFormat format) {
        this.format = format;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSmplincl(String smplincl) {
        this.smplincl = smplincl;
    }

    public void setSmplskip(String smplskip) {
        this.smplskip = smplskip;
    }

    public void setNlrecs(String nlrecs) {
        this.nlrecs = nlrecs;
    }

    public void setPack(DSP.DspPack pack) {
        this.pack = pack;
    }

    public void setProc(String proc) {
        this.proc = proc;
    }

    public void setMemproc(String memproc) {
        this.memproc = memproc;
    }

    public void setReferenceNumber(boolean ref) {
        this.referenceNumber = ref;
    }

    public void setRedefinedFields(boolean rdf) {
        this.redefinedFields = rdf;
    }

    public void setPictureClause(boolean pic) {
        this.pictureClause = pic;
    }

    public void setStartLocation(boolean sloc) {
        this.startLocation = sloc;
    }

    public void setStructure(boolean str) {
        this.structure = str;
    }

    public void setJustifyNumericFields(boolean just) {
        this.leftJustifyNumericFields = just;
    }

    public void setShowFieldType(boolean type) {
        this.showFieldType = type;
    }

    public void setRecordLength(boolean rlen) {
        this.recordLength = rlen;
    }

    public void setIgnoreLength(boolean ignlen) {
        this.ignoreLength = ignlen;
    }

    public void setShowingCcsid(boolean ccsid) {
        this.showingCcsid = ccsid;
    }

    public TemplateWithOffsetModel getTemplate() {
        return this.templateModel;
    }

    public String getMemberListSet() {
        return this.memberList;
    }

    public String getResourceSet() {
        return this.resource;
    }

    public String getSingleSourceMemberSelected() {
        if (this.getResource() instanceof DataSet) {
            if (this.memberSelectionCriteria.isNoMemberSelected() && this.memberList.indexOf(",") == -1 && !this.memberList.isEmpty()) {
                return this.memberList;
            }
            if (this.memberSelectionCriteria.isSingleMemberSelected() && this.memberList.isEmpty()) {
                return this.memberSelectionCriteria.getMembersRangeStart();
            }
        }
        return null;
    }

    public boolean isMultipleMembersSelected(boolean ignorePossibles) {
        boolean multipleSrcMembers = false;
        if (this.getResource() instanceof DataSet) {
            multipleSrcMembers = this.memberList.indexOf(",") >= 0;
            multipleSrcMembers = multipleSrcMembers || this.memberSelectionCriteria.isUsingRange() && !this.memberSelectionCriteria.getMembersRangeStart().equals(this.memberList);
            multipleSrcMembers = multipleSrcMembers || this.memberSelectionCriteria.isMultipleMembersSelected(ignorePossibles);
        }
        return multipleSrcMembers;
    }

    public String getMemberList() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> membersAsList = this.getMemberListAsList();
        for (String member : membersAsList) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(member);
        }
        return sb.toString();
    }

    public ArrayList<String> getMemberListAsList() {
        ArrayList<String> resultList = new ArrayList<String>();
        if (this.getResource() instanceof DataSet) {
            if (UIValidator.isValidMemberList(this.memberList, false, this.getSystem().getCodePage())) {
                String[] splitList;
                String[] stringArray = splitList = this.memberList.split(",");
                int n = splitList.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (Member.isValidName((String)string.toUpperCase(), (String)this.getSystem().getCodePage())) {
                        resultList.add(string);
                    }
                    ++n2;
                }
            } else if (UIValidator.isValidWildcardableMember(this.memberList, this.getSystem().getCodePage())) {
                resultList.add(this.memberList);
            }
        }
        return resultList;
    }

    public boolean isIoExit() {
        return this.ioExit;
    }

    public String getIoExitCustom() {
        return this.ioExitCustom;
    }

    public String getBinaryRecordLengthSet() {
        return this.binaryRecordLength;
    }

    public String getBinaryRecordLength() {
        if (this.getResource() instanceof UssFile) {
            try {
                int binreclen = Integer.parseInt(this.binaryRecordLength);
                if (binreclen > 1 || binreclen < 32760) {
                    return this.binaryRecordLength;
                }
                return "";
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return "";
    }

    public String getPosition() {
        return this.position;
    }

    public MemberSelectionCriteriaModel getMemberSelectionCriteria() {
        return this.memberSelectionCriteria;
    }

    public String validateResourceTypes(IHowIsGoing monitor) throws InterruptedException {
        IZRL zrl = this.getResource();
        if (zrl instanceof DataSetOrMember) {
            DataSet dataSet = ((DataSetOrMember)zrl).asDataSet();
            if (!(this.resourceLoaded instanceof DataSet && dataSet.equalsWithVolumes((Object)this.resourceLoaded) && dataSet.getConfirmedExists())) {
                Result result = dataSet.refreshSelf(monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    return Messages.DSPCommand_UNABLE_TO_VERIFY_EXISTENCE + String.valueOf(result.getMessagesCombined());
                }
                this.resourceLoaded = dataSet;
            }
            if (!dataSet.getConfirmedExists()) {
                return Messages.DSPCommand_DATA_SET_DOES_NOT_EXIST;
            }
            if (!dataSet.getHasMembers()) {
                this.memberSelectionCriteria.clear();
                this.memberList = "";
            }
        } else if (zrl instanceof CicsFile) {
            CicsFile cicsFile = (CicsFile)zrl;
            if (!(this.resourceLoaded instanceof CicsFile) || !zrl.equals(this.resourceLoaded)) {
                cicsFile.refreshSelf(monitor);
                this.resourceLoaded = cicsFile;
            }
            if (!cicsFile.getConfirmedExists()) {
                return Messages.DSPCommand_RESOURCE_NO_EXIST;
            }
            if (!cicsFile.isOpen()) {
                return Messages.DSPCommand_CICS_FILE_CLOSED;
            }
        }
        return null;
    }

    public IZRL getResource() {
        if (this.getSystem() != null && ZRLs.isParseable((IPDHost)this.getSystem(), (String)this.resource)) {
            if (this.isResourceLoaded()) {
                return this.resourceLoaded;
            }
            return this.getResourceParsed();
        }
        return null;
    }

    public IZRL getResourceParsed() {
        IZRL parsedResource = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.resource);
        if (parsedResource instanceof DataSet && Volume.isValid((String)this.resourceVolume, (String)this.getSystem().getCodePage())) {
            ((DataSet)parsedResource).setVolume(Volume.create((IPDHost)this.getSystem(), (String)this.resourceVolume));
        }
        return parsedResource;
    }

    public boolean isResourceLoaded() {
        boolean useLoadedResource = false;
        if (this.resourceLoaded instanceof DataSet && ((DataSet)this.resourceLoaded).equalsWithVolumes((Object)this.getResourceParsed())) {
            useLoadedResource = true;
        } else if (this.resourceLoaded instanceof CicsFile && this.resourceLoaded.equals(this.getResourceParsed())) {
            useLoadedResource = true;
        }
        return useLoadedResource;
    }

    public boolean isResourceDataSetWithMembers() {
        IZRL src = this.getResource();
        if (src instanceof DataSet) {
            return ((DataSet)src).getHasMembers();
        }
        return false;
    }

    public AccessType getProcessBy() {
        DataSetType.AccessMethod accessMethod;
        if ((this.getTemplate().getTemplate() != null || this.getFormat() == DSP.DspFormat.SNGL || this.getFormat() == DSP.DspFormat.TABL) && this.processBy == AccessType.Block) {
            return AccessType.LogicalRecord;
        }
        IZRL zrl = this.getResource();
        if (zrl instanceof DataSet && ((accessMethod = ((DataSet)zrl).getType().getAccessMethod()) != DataSetType.AccessMethod.QSAM && this.processBy == AccessType.Block || accessMethod != DataSetType.AccessMethod.VSAM && this.processBy == AccessType.ControlInterval)) {
            return AccessType.LogicalRecord;
        }
        return this.processBy;
    }

    public DSP.DspFormat getFormat() {
        return this.format;
    }

    public String getKeySet() {
        return this.key;
    }

    public String getKey() {
        boolean canHaveKey = false;
        IZRL currResource = this.getResource();
        if (currResource instanceof DataSet) {
            DataSetType type = ((DataSet)currResource).getType();
            canHaveKey = type == DataSetType.KSDS || type == DataSetType.KSDSIAM || type == DataSetType.RRDS;
        } else if (currResource instanceof CicsFile) {
            CicsFile cicsFile = (CicsFile)currResource;
            boolean bl = canHaveKey = cicsFile.getKeyLength() != -1 && cicsFile.getKeyStartLocation() != -1;
        }
        if (canHaveKey) {
            String key = this.key;
            if (key.length() > 30) {
                key = key.substring(0, 30);
            }
            return key;
        }
        return "";
    }

    public String getSmplincl() {
        return this.smplincl;
    }

    public String getSmplskip() {
        return this.smplskip;
    }

    public String getNlrecs() {
        return this.nlrecs;
    }

    public DSP.DspPack getPack() {
        if (this.getResource() instanceof UssFile) {
            return DSP.DspPack.NONE;
        }
        return this.pack;
    }

    public String getProc() {
        return this.proc;
    }

    public String getMemproc() {
        return this.memproc;
    }

    public boolean isReferenceNumber() {
        return this.referenceNumber;
    }

    public boolean isRedefinedFields() {
        return this.redefinedFields;
    }

    public boolean isPictureClause() {
        return this.pictureClause;
    }

    public boolean isStartLocation() {
        return this.startLocation;
    }

    public boolean isStructure() {
        return this.structure;
    }

    public boolean isLeftJustifyNumericFields() {
        return this.leftJustifyNumericFields;
    }

    public boolean isShowFieldType() {
        return this.showFieldType;
    }

    public boolean isRecordLength() {
        return this.recordLength;
    }

    public boolean isIgnoreLength() {
        return this.ignoreLength;
    }

    public boolean isShowingCcsid() {
        return this.getTemplate().getTemplate() != null && this.getFormat() == DSP.DspFormat.SNGL && this.showingCcsid;
    }

    public String getNlrecsAll() {
        return NLRECS_ALL;
    }

    private PrintModel clone(PrintModel dsp) {
        dsp.setResource(this.getResource());
        dsp.setMemberList(this.getMemberList());
        dsp.setResourceVolume(this.getResourceVolume());
        dsp.setIoExit(this.isIoExit());
        dsp.setIoExitCustom(this.getIoExitCustom());
        dsp.setBinaryRecordLength(this.getBinaryRecordLength());
        dsp.setProcessBy(this.getProcessBy());
        dsp.setFormat(this.getFormat());
        dsp.setPosition(this.getPosition());
        dsp.setKey(this.getKey());
        dsp.setSmplincl(this.getSmplincl());
        dsp.setSmplskip(this.getSmplskip());
        dsp.setNlrecs(this.getNlrecs());
        dsp.setPack(this.getPack());
        dsp.setProc(this.getProc());
        dsp.setMemproc(this.getMemproc());
        dsp.setReferenceNumber(this.isReferenceNumber());
        dsp.setRedefinedFields(this.isRedefinedFields());
        dsp.setPictureClause(this.isPictureClause());
        dsp.setStartLocation(this.isStartLocation());
        dsp.setStructure(this.isStructure());
        dsp.setJustifyNumericFields(this.isLeftJustifyNumericFields());
        dsp.setShowFieldType(this.isShowFieldType());
        dsp.setRecordLength(this.isRecordLength());
        dsp.setIgnoreLength(this.isIgnoreLength());
        dsp.setShowingCcsid(this.isShowingCcsid());
        dsp.setTemplate(this.getTemplate().clone());
        dsp.setMemberSelectionCriteria((MemberSelectionCriteriaModel)((Object)this.getMemberSelectionCriteria().clone()));
        dsp.setIncludeMd(this.isIncludeMd());
        return dsp;
    }

    public PrintModel clone() {
        PrintModel dsp = new PrintModel(this.getHostProvider());
        return this.clone(dsp);
    }

    public void setResourceVolume(String resourceVolume) {
        this.resourceVolume = resourceVolume;
    }

    public String getResourceVolume() {
        return this.resourceVolume;
    }

    public boolean isIncludeMd() {
        return this.includeMd;
    }

    public void setIncludeMd(boolean includeMd) {
        this.includeMd = includeMd;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrintModel) {
            PrintModel other = (PrintModel)((Object)obj);
            return this.getSystem().equals(other.getSystem()) && this.toUtilityFunction().equals((Object)other.toUtilityFunction());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.toUtilityFunction().hashCode();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AccessType {
        LogicalRecord{

            public String toString() {
                return "Logical Access";
            }
        }
        ,
        ControlInterval{

            public String toString() {
                return "CIACCESS";
            }
        }
        ,
        Block{

            public String toString() {
                return "BLKACCESS";
            }
        };

    }
}

