/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.socket.func.DSP;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.PrintModel;
import com.ibm.etools.fm.ui.wizards.PrintRunnable;
import com.ibm.etools.fm.ui.wizards.PrintWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PrintActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private PrintModel model = null;
    private static DSPActionItemPropertySource propSource;

    public PrintActionItem(PrintModel model) {
        super(ActionType.DSP, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        Member template = this.model.getTemplate().getTemplate();
        if (template == null) {
            return MessageFormat.format(Messages.DSPActionItem_PRINT_LABEL, this.getFullResourceName(false));
        }
        return MessageFormat.format(Messages.DSPActionItem_PRINT_XXX_USING_TEMPLATE_YYY, this.getFullResourceName(false), template.getFormattedName());
    }

    private String getFullResourceName(boolean listAllMembers) {
        if (this.model.isMultipleMembersSelected(false)) {
            return this.model.getResource().getFormattedName() + "(" + (listAllMembers ? this.model.getMemberList() : "...") + ")";
        }
        if (this.model.getSingleSourceMemberSelected() != null) {
            return this.model.getResource().getFormattedName() + "(" + this.model.getSingleSourceMemberSelected() + ")";
        }
        IZRL resource = this.model.getResource();
        if (resource != null) {
            return resource.getFormattedName();
        }
        return "unknown";
    }

    @Override
    public void saveTo(IMemento memento) {
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        DSP function = new DSP();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        PrintModel model = new PrintModel(system);
        model.fromUtilityFunction(function);
        return new PrintActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        PrintRunnable runnable = new PrintRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final PrintModel clone = this.model.clone();
        PrintWizard wizard = new PrintWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                PrintActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public PrintActionItem clone() {
        PrintActionItem clone = new PrintActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object action) {
        if (action instanceof PrintActionItem) {
            PrintActionItem other = (PrintActionItem)action;
            return this.getSystem().equals(other.getSystem()) && this.model.toUtilityFunction().equals((Object)other.model.toUtilityFunction());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 37;
        r = 37 * r + this.getSystem().hashCode();
        r = 37 * r + this.model.toUtilityFunction().hashCode();
        return r;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new DSPActionItemPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    private static class DSPActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private PrintModel model;
        private IPropertyDescriptor[] propertyDescriptors;
        private String resource = "resource";
        private String resourceVolume = "resourceVolume";
        private String memberList = "memberList";
        private String membersRangeStart = "membersRangeStart";
        private String membersRangeEnd = "membersRangeEnd";
        private String membersCreatedStart = "membersCreatedStart";
        private String membersCreatedEnd = "membersCreatedEnd";
        private String membersChangedStart = "membersChangedStart";
        private String membersChangedEnd = "membersChangedEnd";
        private String membersUserIDStart = "membersUserIDStart";
        private String membersUserIDEnd = "membersUserIDEnd";
        private String ioExit = "ioExit";
        private String binaryRecordLength = "binaryRecordLength";
        private String processBy = "AccessType";
        private String format = "format";
        private String position = "position";
        private String key = "key";
        private String smplincl = "smplincl";
        private String smplskip = "smplskip";
        private String nlrecs = "nlrecs";
        private String pack = "pack";
        private String ref = "ref";
        private String rdf = "rdf";
        private String pic = "pic";
        private String sloc = "sloc";
        private String str = "str";
        private String just = "just";
        private String type = "type";
        private String rlen = "rlen";
        private String ignlen = "ignlen";
        private String ccsid = "ccsid";
        private String template = "template";
        private String offset = "offset";
        public String includeMD = "includeMD";

        public DSPActionItemPropertySource(PrintModel model) {
            this.model = model;
            this.init();
        }

        public void setModel(PrintModel model) {
            this.model = model;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.resource, Messages.Label__RESOURCE));
            temp.add(new PropertyDescriptor((Object)this.resourceVolume, Messages.Label__VOLUME));
            temp.add(new PropertyDescriptor((Object)this.memberList, Messages.LABEL_MEMBER));
            temp.add(new PropertyDescriptor((Object)this.membersRangeStart, Messages.DSPActionItem_MEMBER_RANGE_START));
            temp.add(new PropertyDescriptor((Object)this.membersRangeEnd, Messages.DSPActionItem_MEMBER_RANGE_END));
            temp.add(new PropertyDescriptor((Object)this.membersCreatedStart, Messages.DSPActionItem_CREATED_START));
            temp.add(new PropertyDescriptor((Object)this.membersCreatedEnd, Messages.DSPActionItem_CREATED_END));
            temp.add(new PropertyDescriptor((Object)this.membersChangedStart, Messages.DSPActionItem_CHANGE_START));
            temp.add(new PropertyDescriptor((Object)this.membersChangedEnd, Messages.DSPActionItem_CHANGE_END));
            temp.add(new PropertyDescriptor((Object)this.membersUserIDStart, Messages.DSPActionItem_USER_ID_START));
            temp.add(new PropertyDescriptor((Object)this.membersUserIDEnd, Messages.DSPActionItem_USER_ID_END));
            temp.add(new PropertyDescriptor((Object)this.ioExit, Messages.Label__IO_EXIT));
            temp.add(new PropertyDescriptor((Object)this.binaryRecordLength, Messages.Label__BINARY_RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.processBy, Messages.PrintWizard_PROCESS_BY));
            temp.add(new PropertyDescriptor((Object)this.format, Messages.PrintWizard_FORMAT));
            temp.add(new PropertyDescriptor((Object)this.position, Messages.LABEL_RECORD_START));
            temp.add(new PropertyDescriptor((Object)this.key, Messages.LABEL_RECORD_KEY));
            temp.add(new PropertyDescriptor((Object)this.smplincl, Messages.LABEL_RECORD_SAMPLING_INCLUDE));
            temp.add(new PropertyDescriptor((Object)this.smplskip, Messages.PrintWizardPageResource_SAMPLE_SKIP));
            temp.add(new PropertyDescriptor((Object)this.nlrecs, Messages.LABEL_RECORD_PRINT));
            temp.add(new PropertyDescriptor((Object)this.pack, Messages.LABEL_RECORD_PACK));
            temp.add(new PropertyDescriptor((Object)this.ref, Messages.LABEL_MISCELLANEOUS_GROUP_REF));
            temp.add(new PropertyDescriptor((Object)this.rdf, Messages.LABEL_MISCELLANEOUS_GROUP_RDF));
            temp.add(new PropertyDescriptor((Object)this.pic, Messages.LABEL_MISCELLANEOUS_GROUP_PIC));
            temp.add(new PropertyDescriptor((Object)this.sloc, Messages.LABEL_MISCELLANEOUS_GROUP_SLOC));
            temp.add(new PropertyDescriptor((Object)this.str, Messages.LABEL_MISCELLANEOUS_GROUP_STR));
            temp.add(new PropertyDescriptor((Object)this.just, Messages.LABEL_MISCELLANEOUS_GROUP_JUST));
            temp.add(new PropertyDescriptor((Object)this.type, Messages.LABEL_MISCELLANEOUS_GROUP_TYPE));
            temp.add(new PropertyDescriptor((Object)this.rlen, Messages.LABEL_MISCELLANEOUS_GROUP_RLEN));
            temp.add(new PropertyDescriptor((Object)this.ignlen, Messages.LABEL_MISCELLANEOUS_GROUP_IGNLEN));
            temp.add(new PropertyDescriptor((Object)this.template, Messages.Label__TEMPLATE));
            temp.add(new PropertyDescriptor((Object)this.offset, Messages.Label__FIELD_OFFSETS));
            temp.add(new PropertyDescriptor((Object)this.ccsid, Messages.PrintActionItem_LABEL_ShowingFieldCCSIDs));
            temp.add(new PropertyDescriptor((Object)this.includeMD, Messages.EditorOptionDialog_MQ_INCLUDE_DESCRIPTORS));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.resource)) {
                    return this.model.getResourceSet();
                }
                if (id.equals(this.resourceVolume)) {
                    return this.model.getResourceVolume();
                }
                if (id.equals(this.memberList)) {
                    return this.model.getMemberList();
                }
                if (id.equals(this.membersRangeStart)) {
                    if (!this.model.getMemberSelectionCriteria().isUsingRange()) {
                        return "";
                    }
                    return this.model.getMemberSelectionCriteria().getMembersRangeStart();
                }
                if (id.equals(this.membersRangeEnd)) {
                    if (!this.model.getMemberSelectionCriteria().isUsingRange()) {
                        return "";
                    }
                    return this.model.getMemberSelectionCriteria().getMembersRangeEnd();
                }
                if (id.equals(this.membersCreatedStart)) {
                    if (!this.model.getMemberSelectionCriteria().isUsingCreated()) {
                        return "";
                    }
                    return this.model.getMemberSelectionCriteria().getMembersCreatedStartFormatted();
                }
                if (id.equals(this.membersCreatedEnd)) {
                    if (!this.model.getMemberSelectionCriteria().isUsingCreated()) {
                        return "";
                    }
                    return this.model.getMemberSelectionCriteria().getMembersCreatedEndFormatted();
                }
                if (id.equals(this.membersChangedStart)) {
                    if (!this.model.getMemberSelectionCriteria().isUsingChanged()) {
                        return "";
                    }
                    return this.model.getMemberSelectionCriteria().getMembersChangedStartFormatted();
                }
                if (id.equals(this.membersChangedEnd)) {
                    if (!this.model.getMemberSelectionCriteria().isUsingChanged()) {
                        return "";
                    }
                    return this.model.getMemberSelectionCriteria().getMembersChangedEndFormatted();
                }
                if (id.equals(this.membersUserIDStart)) {
                    if (!this.model.getMemberSelectionCriteria().isUsingUserID()) {
                        return "";
                    }
                    return this.model.getMemberSelectionCriteria().getMembersUserIDStart();
                }
                if (id.equals(this.membersUserIDEnd)) {
                    if (!this.model.getMemberSelectionCriteria().isUsingUserID()) {
                        return "";
                    }
                    return this.model.getMemberSelectionCriteria().getMembersUserIDEnd();
                }
                if (id.equals(this.ioExit)) {
                    if (!this.model.isIoExit()) {
                        return "";
                    }
                    return this.model.getIoExitCustom();
                }
                if (id.equals(this.binaryRecordLength)) {
                    return this.model.getBinaryRecordLength();
                }
                if (id.equals(this.processBy)) {
                    return this.model.getProcessBy().toString();
                }
                if (id.equals(this.format)) {
                    return this.model.getFormat().toString();
                }
                if (id.equals(this.position)) {
                    return this.model.getPosition();
                }
                if (id.equals(this.key)) {
                    return this.model.getKey();
                }
                if (id.equals(this.smplincl)) {
                    return this.model.getSmplincl();
                }
                if (id.equals(this.smplskip)) {
                    return this.model.getSmplskip();
                }
                if (id.equals(this.nlrecs)) {
                    return this.model.getNlrecs();
                }
                if (id.equals(this.pack)) {
                    return this.model.getPack().toString();
                }
                if (id.equals(this.ref)) {
                    return this.model.isReferenceNumber();
                }
                if (id.equals(this.rdf)) {
                    return this.model.isRedefinedFields();
                }
                if (id.equals(this.pic)) {
                    return this.model.isPictureClause();
                }
                if (id.equals(this.sloc)) {
                    return this.model.isStartLocation();
                }
                if (id.equals(this.str)) {
                    return this.model.isStructure();
                }
                if (id.equals(this.just)) {
                    return this.model.isLeftJustifyNumericFields();
                }
                if (id.equals(this.type)) {
                    return this.model.isShowFieldType();
                }
                if (id.equals(this.rlen)) {
                    return this.model.isRecordLength();
                }
                if (id.equals(this.ignlen)) {
                    return this.model.isIgnoreLength();
                }
                if (id.equals(this.ccsid)) {
                    return this.model.isShowingCcsid();
                }
                if (id.equals(this.template)) {
                    return this.model.getTemplate().getTemplateSet();
                }
                if (id.equals(this.offset)) {
                    return this.model.getTemplate().getOffsets();
                }
                if (id.equals(this.includeMD)) {
                    return this.model.isIncludeMd();
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

