/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.etools.fm.ui.wizards.GenerateModel;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GenerateWizardPage2
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validFillChar = Pattern.compile("^([^']|C'[a-zA-Z]'|X'[0-9a-fA-F]{2}')$");
    private static final Pattern validBinChar = Pattern.compile("^[0-9a-fA-F]{1,2}$");
    private final GenerateModel params;
    private Button wUseFillCharacter;
    private Button[] wFillCharacter = new Button[5];
    private Label wFillCharacterCharLabel;
    private Combo wFillCharacterChar;
    private Label wFillCharacterBinCharLabel;
    private Combo wFillCharacterBinChar;
    private Combo wSequenceFieldPosition;
    private Combo wSequenceFieldIncrement;
    private Combo wSequenceFieldLength;

    public GenerateWizardPage2(GenerateModel params) {
        super(Messages.Title_GENERATE_WIZARD_PAGE2);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_GENERATE_WIZARD_PAGE2_SPECIFY_OPTIONS);
    }

    public void setPageComplete(boolean complete) {
        if (this.wUseFillCharacter != null) {
            this.setFillCharEnabled(this.wUseFillCharacter.getSelection());
        }
        if (this.wFillCharacter[3] != null) {
            if (this.wFillCharacterCharLabel != null) {
                this.wFillCharacterCharLabel.setEnabled(this.wFillCharacter[3].getSelection() && this.wUseFillCharacter.getSelection());
            }
            if (this.wFillCharacterChar != null) {
                this.wFillCharacterChar.setEnabled(this.wFillCharacter[3].getSelection() && this.wUseFillCharacter.getSelection());
            }
        }
        if (this.wFillCharacter[4] != null) {
            if (this.wFillCharacterBinCharLabel != null) {
                this.wFillCharacterBinCharLabel.setEnabled(this.wFillCharacter[4].getSelection() && this.wUseFillCharacter.getSelection());
            }
            if (this.wFillCharacterBinChar != null) {
                this.wFillCharacterBinChar.setEnabled(this.wFillCharacter[4].getSelection() && this.wUseFillCharacter.getSelection());
            }
        }
        if (complete) {
            if (this.wUseFillCharacter != null && !this.wUseFillCharacter.getSelection()) {
                this.params.fillCharacter = null;
            }
            if (this.wFillCharacter[0] != null && this.wFillCharacter[0].getSelection()) {
                this.params.fillCharacter = GenerateModel.FillCharacter.AN;
            }
            if (this.wFillCharacter[1] != null && this.wFillCharacter[1].getSelection()) {
                this.params.fillCharacter = GenerateModel.FillCharacter.BIN;
            }
            if (this.wFillCharacter[2] != null && this.wFillCharacter[2].getSelection()) {
                this.params.fillCharacter = GenerateModel.FillCharacter.RAND;
            }
            if (this.wFillCharacter[3] != null && this.wFillCharacter[3].getSelection()) {
                this.params.fillCharacter = GenerateModel.FillCharacter.Character;
            }
            if (this.wFillCharacterChar != null) {
                this.params.fillCharacterChar = this.wFillCharacterChar.getText();
            }
            if (this.wFillCharacter[4] != null && this.wFillCharacter[4].getSelection()) {
                this.params.fillCharacter = GenerateModel.FillCharacter.BinaryCharacter;
            }
            if (this.wFillCharacterBinChar != null) {
                this.params.fillCharacterBinChar = this.wFillCharacterBinChar.getText();
            }
            if (this.wSequenceFieldPosition != null) {
                this.params.sequenceFieldPosition = this.wSequenceFieldPosition.getText();
            }
            if (this.wSequenceFieldIncrement != null) {
                this.params.sequenceFieldIncrement = this.wSequenceFieldIncrement.getText();
            }
            if (this.wSequenceFieldLength != null) {
                this.params.sequenceFieldLength = this.wSequenceFieldLength.getText();
            }
        }
        super.setPageComplete(complete);
    }

    private void setFillCharEnabled(boolean enabled) {
        int i = 0;
        while (i < this.wFillCharacter.length) {
            if (this.wFillCharacter[i] != null) {
                this.wFillCharacter[i].setEnabled(enabled);
            }
            ++i;
        }
        if (this.wFillCharacterCharLabel != null) {
            this.wFillCharacterCharLabel.setEnabled(enabled);
        }
        if (this.wFillCharacterChar != null) {
            this.wFillCharacterChar.setEnabled(enabled);
        }
        if (this.wFillCharacterBinCharLabel != null) {
            this.wFillCharacterBinCharLabel.setEnabled(enabled);
        }
        if (this.wFillCharacterBinChar != null) {
            this.wFillCharacterBinChar.setEnabled(enabled);
        }
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 2;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)compWidth, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.wUseFillCharacter = GUI.button.checkbox((Composite)parent, (String)Messages._GENERATE_WIZARD_USE_FILL_CHARACTER, (Object)GUI.grid.d.fillH((int)compWidth));
        new FMWizardPage.ManagedWidget(this, this.wUseFillCharacter, this.params.getSystem()){

            @Override
            public void onChange(Event event) {
                GenerateWizardPage2.this.unselect((Control[])GenerateWizardPage2.this.wFillCharacter);
                super.onChange(event);
            }
        };
        Group wFillCharacterGroup = GUI.group((Composite)parent, (String)Messages.Title_GENERATE_WIZARD_PAGE2_FILL_CHARACTER, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        this.wFillCharacter[0] = GUI.button.radio((Composite)wFillCharacterGroup, (String)Messages._GENERATE_WIZARD_FILL_CHARACTER_CONSECUTIVE_ALPHANUMERIC, (Object)GUI.grid.d.fillH((int)4));
        this.wFillCharacter[1] = GUI.button.radio((Composite)wFillCharacterGroup, (String)Messages._GENERATE_WIZARD_FILL_CHARACTER_CONSECUTIVE_BINARY, (Object)GUI.grid.d.fillH((int)4));
        this.wFillCharacter[2] = GUI.button.radio((Composite)wFillCharacterGroup, (String)Messages._GENERATE_WIZARD_FILL_CHARACTER_RANDOM_BINARY, (Object)GUI.grid.d.fillH((int)4));
        this.wFillCharacter[3] = GUI.button.radio((Composite)wFillCharacterGroup, (String)Messages._GENERATE_WIZARD_FILL_CHARACTER_SPECIFIC, (Object)GUI.grid.d.fillH((int)2));
        this.wFillCharacterCharLabel = GUI.label((Composite)wFillCharacterGroup, (String)Messages.Label__CHARACTER, (Object)GUI.grid.d.horiz((int)131072, (boolean)false, (int)1), (int)131072);
        this.wFillCharacterChar = GUI.combo.editable((Composite)wFillCharacterGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wFillCharacterChar, ((Object)((Object)this)).getClass().getCanonicalName() + "Character");
        new FMWizardPage.ManagedWidget(this, this.wFillCharacterChar, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__CHARACTER), this.params.getSystem()){

            @Override
            protected boolean isValid() {
                if (!GenerateWizardPage2.this.isSelected((Control)GenerateWizardPage2.this.wFillCharacter[3])) {
                    return true;
                }
                return validFillChar.matcher(GenerateWizardPage2.this.wFillCharacterChar.getText()).matches();
            }
        };
        this.wFillCharacter[4] = GUI.button.radio((Composite)wFillCharacterGroup, (String)Messages._GENERATE_WIZARD_FILL_CHARACTER_SPECIFIC_BINARY, (Object)GUI.grid.d.fillH((int)2));
        this.wFillCharacterBinCharLabel = GUI.label((Composite)wFillCharacterGroup, (String)Messages.Label__BINARY_CHARACTER, (Object)GUI.grid.d.horiz((int)131072, (boolean)false, (int)1), (int)131072);
        this.wFillCharacterBinChar = GUI.combo.editable((Composite)wFillCharacterGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wFillCharacterBinChar, ((Object)((Object)this)).getClass().getCanonicalName() + "BinaryCharacter");
        new FMWizardPage.ManagedWidget(this, this.wFillCharacterBinChar, Messages.GenerateWizardPage2_BINARY_CHAR_INVALID, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                if (!GenerateWizardPage2.this.isSelected((Control)GenerateWizardPage2.this.wFillCharacter[4])) {
                    return true;
                }
                return validBinChar.matcher(GenerateWizardPage2.this.wFillCharacterBinChar.getText()).matches();
            }
        };
        new FMWizardPage.ManagedWidget(this.wFillCharacter, this.params.getSystem());
        Group sequenceGroup = GUI.group((Composite)parent, (String)Messages.Title_GENERATE_WIZARD_PAGE2_SEQUENCE_FIELD, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)sequenceGroup, (String)Messages.Label__POSITION, (Object)GUI.grid.d.left1());
        this.wSequenceFieldPosition = GUI.combo.editable((Composite)sequenceGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer sfpNf = NumberForcer.addTo(this.wSequenceFieldPosition, ((Object)((Object)this)).getClass().getCanonicalName() + "Position");
        sfpNf.setLowerBound(1, true);
        new ComboValueSaver(this.wSequenceFieldPosition, ((Object)((Object)this)).getClass().getCanonicalName() + "SequenceFieldPos");
        new FMWizardPage.ManagedWidget(this.wSequenceFieldPosition, this.params.getSystem());
        GUI.label.left((Composite)sequenceGroup, (String)Messages.Label__INCREMENT, (Object)GUI.grid.d.left1());
        this.wSequenceFieldIncrement = GUI.combo.editable((Composite)sequenceGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wSequenceFieldIncrement, ((Object)((Object)this)).getClass().getCanonicalName() + "Increment");
        new ComboValueSaver(this.wSequenceFieldIncrement, ((Object)((Object)this)).getClass().getCanonicalName() + "SequenceFieldInc");
        new FMWizardPage.ManagedWidget(this.wSequenceFieldIncrement, this.params.getSystem());
        GUI.label.left((Composite)sequenceGroup, (String)Messages.Label__LENGTH, (Object)GUI.grid.d.left1());
        this.wSequenceFieldLength = GUI.combo.editable((Composite)sequenceGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer sflNf = NumberForcer.addTo(this.wSequenceFieldLength, ((Object)((Object)this)).getClass().getCanonicalName() + "Length");
        sflNf.setLowerBound(1, true);
        sflNf.setUpperBound(9, true);
        new ComboValueSaver(this.wSequenceFieldLength, ((Object)((Object)this)).getClass().getCanonicalName() + "SequenceFieldLen");
        new FMWizardPage.ManagedWidget(this.wSequenceFieldLength, this.params.getSystem());
        this.refreshControlState();
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        GenerateModel params = this.params.clone();
        if (params.fillCharacter != null) {
            this.wUseFillCharacter.setSelection(true);
        }
        this.wFillCharacterChar.setText(params.fillCharacterChar);
        this.wFillCharacterBinChar.setText(params.fillCharacterBinChar);
        this.wFillCharacter[0].setSelection(params.fillCharacter == GenerateModel.FillCharacter.AN);
        this.wFillCharacter[1].setSelection(params.fillCharacter == GenerateModel.FillCharacter.BIN);
        this.wFillCharacter[2].setSelection(params.fillCharacter == GenerateModel.FillCharacter.RAND);
        this.wFillCharacter[3].setSelection(params.fillCharacter == GenerateModel.FillCharacter.Character);
        this.wFillCharacter[4].setSelection(params.fillCharacter == GenerateModel.FillCharacter.BinaryCharacter);
        this.wSequenceFieldPosition.setText(params.sequenceFieldPosition);
        this.wSequenceFieldIncrement.setText(params.sequenceFieldIncrement);
        this.wSequenceFieldLength.setText(params.sequenceFieldLength);
    }
}

