/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.socket.func.DSG;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.widget.ResourceContentProposals;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.etools.fm.ui.wizards.GenerateModel;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class GenerateWizardPage1
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final GenerateModel params;
    private Combo wResource;
    private Combo wVolume;
    private Combo wTemplate;
    private Button wTemplateEdit;
    private Combo wRecordLength;
    private Combo wBinaryRecordLength;
    private Combo wNumberOfRecords;
    private Button wInvokeIOExit;
    private Combo wIOExit;
    private Button[] wDisposition = new Button[2];
    private Button wISPFPacking;

    protected GenerateWizardPage1(GenerateModel params) {
        super(Messages.Title_GENERATE_WIZARD_PAGE1);
        this.setMessage(Messages.Msg_GENERATE_WIZARD_PAGE1_SPECIFY_OPTIONS);
        this.setPageComplete(false);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
    }

    public void setPageComplete(boolean complete) {
        this.setEnabledIf((Control)this.wIOExit, this.isSelected((Control)this.wInvokeIOExit));
        this.setEnabledIf((Control)this.wISPFPacking, this.wResource != null && ZRLs.isParseable((IPDHost)this.params.getSystem(), (String)this.wResource.getText()) && ZRLs.parseZRL((IPDHost)this.params.getSystem(), (String)this.wResource.getText()) instanceof DataSetOrMember);
        this.setEnabledIf((Control)this.wBinaryRecordLength, this.wResource != null && ZRLs.isParseable((IPDHost)this.params.getSystem(), (String)this.wResource.getText()) && ZRLs.parseZRL((IPDHost)this.params.getSystem(), (String)this.wResource.getText()) instanceof UssFile);
        this.setEnabledIf((Control)this.wTemplateEdit, this.wTemplate != null && Member.isParseable((String)this.wTemplate.getText(), (boolean)true, (String)this.params.getSystem().getCodePage()));
        if (complete) {
            if (this.wResource != null) {
                this.params.resource = ZRLs.parseZRL((IPDHost)this.params.getSystem(), (String)this.wResource.getText());
            }
            if (this.wVolume != null && this.params.resource != null) {
                String volser = this.wVolume.getText();
                this.params.setResourceVolume(volser);
            }
            if (this.wTemplate != null) {
                this.params.template = this.wTemplate.getText();
            }
            if (this.wRecordLength != null) {
                this.params.recordLength = this.wRecordLength.getText();
            }
            if (this.wBinaryRecordLength != null) {
                this.params.binaryRecordLength = this.params.resource instanceof UssFile ? this.wBinaryRecordLength.getText() : "";
            }
            if (this.wNumberOfRecords != null) {
                this.params.numberOfRecords = this.wNumberOfRecords.getText();
            }
            if (this.wInvokeIOExit != null) {
                this.params.invokeIOExit = this.wInvokeIOExit.getSelection();
            }
            if (this.wIOExit != null) {
                this.params.ioExit = this.wIOExit.getText();
            }
            if (this.wDisposition[0] != null && this.wDisposition[0].getSelection()) {
                this.params.disposition = DSG.DsgDisp.MOD;
            } else if (this.wDisposition[1] != null && this.wDisposition[1].getSelection()) {
                this.params.disposition = DSG.DsgDisp.OLD;
            }
            this.params.ispfPacking = this.isSelected((Control)this.wISPFPacking);
        }
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 4;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)compWidth, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)parent, (String)Messages.Label__RESOURCE, (Object)GUI.grid.d.left1());
        this.wResource = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(parent), this.wResource, (IHostProvider)this.params).types(ZRLs.getAllResourceTypesForZos()).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                GenerateWizardPage1.this.wVolume.setText("");
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        new FMWizardPage.ManagedWidget(this, this.wResource, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__RESOURCE), this.params.getSystem()){

            @Override
            protected boolean isValid() {
                return ZRLs.isParseable((IPDHost)GenerateWizardPage1.this.params.getSystem(), (String)GenerateWizardPage1.this.wResource.getText());
            }
        };
        GUI.grid.padding((Composite)parent, (int)1);
        GUI.label.left((Composite)parent, (String)Messages.Label__VOLUME, (Object)GUI.grid.d.left1());
        this.wVolume = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wVolume, ((Object)((Object)this)).getClass().getCanonicalName() + "Volume");
        new FMWizardPage.ManagedWidget(this, this.wVolume, Messages.INVALID_VOLSER, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                String volser = GenerateWizardPage1.this.wVolume.getText();
                return volser.isEmpty() || Volume.isValid((String)volser, (String)GenerateWizardPage1.this.params.getSystem().getCodePage());
            }
        };
        GUI.grid.padding((Composite)parent, (int)2);
        GUI.label.left((Composite)parent, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        Composite templateNameComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.wTemplate = GUI.combo.editable((Composite)templateNameComposite, (Object)GUI.grid.d.fillH((int)1));
        ResourceContentProposals.addTo(this.wTemplate, (IHostProvider)this.params.getSystem(), ((Object)((Object)this)).getClass().getCanonicalName() + "Template", Member.class);
        new FMWizardPage.ManagedWidget(this, this.wTemplate, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__TEMPLATE), this.params.getSystem()){

            @Override
            protected boolean isValid() {
                return GenerateWizardPage1.this.isEmpty(GenerateWizardPage1.this.wTemplate) || Member.isParseable((String)GenerateWizardPage1.this.wTemplate.getText(), (boolean)true, (String)GenerateWizardPage1.this.params.getSystem().getCodePage());
            }
        };
        this.wTemplateEdit = GUI.button.push((Composite)templateNameComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String templateText = GenerateWizardPage1.this.wTemplate.getText();
                DataSetOrMember parsed = Member.parse((IPDHost)GenerateWizardPage1.this.params.getSystem(), (String)templateText);
                TemplateEditorUtilities.openTemplateEditSession((IZRL)parsed.asMember());
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(parent), this.wTemplate, (IHostProvider)this.params).types(Member.class).create();
        Group basicGroup = GUI.group((Composite)parent, (String)Messages.Title__BASIC_OPTIONS, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)basicGroup, (String)Messages.Label__RECORD_LENGTH, (Object)GUI.grid.d.left1());
        this.wRecordLength = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer fRL = NumberForcer.addTo(this.wRecordLength, ((Object)((Object)this)).getClass().getCanonicalName() + "RecordLength");
        fRL.setLowerBound(1, true);
        fRL.setUpperBound(9999999, true);
        new FMWizardPage.ManagedWidget(this.wRecordLength, this.params.getSystem());
        GUI.label.left((Composite)basicGroup, (String)Messages.Label__BINARY_RECORD_LENGTH, (Object)GUI.grid.d.left1());
        this.wBinaryRecordLength = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wBinaryRecordLength, ((Object)((Object)this)).getClass().getCanonicalName() + "BinaryRecordLength");
        new FMWizardPage.ManagedWidget(this.wBinaryRecordLength, this.params.getSystem());
        GUI.label.left((Composite)basicGroup, (String)Messages.Label__NUMBER_OF_RECORDS, (Object)GUI.grid.d.left1());
        this.wNumberOfRecords = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer fNoR = NumberForcer.addTo(this.wNumberOfRecords, ((Object)((Object)this)).getClass().getCanonicalName() + "NumberOfRecords");
        fNoR.setLowerBound(1, true);
        fNoR.setUpperBound(9999999, true);
        new FMWizardPage.ManagedWidget(this, this.wNumberOfRecords, Messages.Msg_GENERATE_WIZARD_PAGE1_SPECIFY_NUMBER_RECORDS, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                return GenerateWizardPage1.this.wNumberOfRecords.getText().length() > 0;
            }
        };
        this.wISPFPacking = GUI.button.checkbox((Composite)basicGroup, (String)Messages._GENERATE_WIZARD_USE_ISPF_PACKING, (Object)GUI.grid.d.fillH((int)2));
        new FMWizardPage.ManagedWidget(this, this.wISPFPacking, Messages.GenerateWizardPage1_ISPF_PACKING_WITH_DISP_MOD_CAUSES_ERRORS, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                return !GenerateWizardPage1.this.isSelected((Control)GenerateWizardPage1.this.wDisposition[0]) || !GenerateWizardPage1.this.isSelected((Control)GenerateWizardPage1.this.wISPFPacking);
            }
        };
        this.wInvokeIOExit = GUI.button.checkbox((Composite)basicGroup, (String)Messages._GENERATE_WIZARD_INVOKE_IO_EXIT, (Object)GUI.grid.d.left1());
        new FMWizardPage.ManagedWidget(this.wInvokeIOExit, this.params.getSystem());
        this.wIOExit = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)3));
        new ComboValueSaver(this.wIOExit, ((Object)((Object)this)).getClass().getCanonicalName() + "IOExit");
        new FMWizardPage.ManagedWidget(this.wIOExit, this.params.getSystem());
        Group dispositionGroup = GUI.group((Composite)parent, (String)Messages.Title__DISPOSITION, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        this.wDisposition[0] = GUI.button.radio((Composite)dispositionGroup, (String)Messages._GENERATE_WIZARD_MOD_APPEND_RECORDS, (Object)GUI.grid.d.fillH((int)2));
        this.wDisposition[1] = GUI.button.radio((Composite)dispositionGroup, (String)Messages._GENERATE_WIZARD_OLD_REUSE_OVERWRITE_RECORDS, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wDisposition, Messages.Msg_GENERATE_WIZARD_PAGE1_SPECIFY_DISPOSITION, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                if (Member.isParseable((String)GenerateWizardPage1.this.wResource.getText(), (boolean)true, (String)this.ipdHost.getCodePage())) {
                    return GenerateWizardPage1.this.isSelected((Control)GenerateWizardPage1.this.wDisposition[1]);
                }
                return GenerateWizardPage1.this.isSelected((Control)GenerateWizardPage1.this.wDisposition[0]) || GenerateWizardPage1.this.isSelected((Control)GenerateWizardPage1.this.wDisposition[1]);
            }
        };
        this.refreshControlState();
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        GenerateModel params = this.params.clone();
        if (params.resource != null) {
            Volume volume;
            this.wResource.setText(params.resource.getFormattedName());
            if (params.resource instanceof DataSetOrMember && (volume = ((DataSetOrMember)params.resource).asDataSet().getVolume()) != null) {
                this.wVolume.setText(volume.getVolserID());
            }
        }
        this.wTemplate.setText(params.template);
        this.wRecordLength.setText(params.recordLength);
        this.wBinaryRecordLength.setText(params.binaryRecordLength);
        this.wNumberOfRecords.setText(params.numberOfRecords);
        if (params.invokeIOExit) {
            this.wInvokeIOExit.setSelection(true);
        }
        this.wIOExit.setText(params.ioExit);
        this.wISPFPacking.setSelection(params.ispfPacking);
        this.wDisposition[0].setSelection(params.disposition == DSG.DsgDisp.MOD);
        this.wDisposition[1].setSelection(params.disposition == DSG.DsgDisp.OLD);
        this.wResource.setFocus();
        if (Member.isParseable((String)this.wResource.getText(), (boolean)true, (String)params.getSystem().getCodePage())) {
            this.unselect((Control)this.wDisposition[0]);
            this.select((Control)this.wDisposition[1]);
        }
    }
}

