/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.views.systems.FMSystemsTreeUpdater;
import com.ibm.etools.fm.ui.wizards.GenerateModel;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class GenerateRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final GenerateModel model;

    public GenerateRunnable(GenerateModel model) {
        this.model = model;
    }

    @Override
    protected String getName() {
        return Messages.GenerateRunnable_TASK_NAME;
    }

    @Override
    protected boolean preWizardClose(IHowIsGoing monitor) {
        try {
            Result<?> result = this.model.checkExists(monitor);
            if (result != null) {
                return result.getRC() == 0;
            }
        }
        catch (InterruptedException e) {
            logger.trace((Object)"Interrupted: ", (Throwable)e);
        }
        return false;
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result<StringBuffer> result;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)monitor.getMonitor()));
        monitor.beginTask(this.getName(), 3000);
        monitor.worked(1000);
        try {
            result = this.model.execute(PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)subMon.newChild(100)));
        }
        catch (InterruptedException e) {
            result = null;
        }
        monitor.worked(1000);
        if (result != null && result.getRC() <= 4) {
            if (this.model.resource instanceof Member) {
                FMSystemsTreeUpdater.refreshDataSetsRelatedTo((Member)this.model.resource);
            } else if (this.model.resource instanceof CicsTemporaryStorage) {
                FMSystemsTreeUpdater.refreshCicsQueriesRelatedTo((CicsResource)this.model.resource);
            }
        }
        monitor.done();
        return result;
    }

    @Override
    public void showResult() {
        FMDialogWithText.showResultDump(this.getResult(), false, 0);
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().isSuccessfulWithoutWarnings();
    }
}

