/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.core.socket.func.DSG;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.views.systems.FMSystemsTreeUpdater;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizard;
import com.ibm.etools.fm.ui.wizards.AllocateHFSModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.core.model.IRefreshable;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.core.util.TypedRunnable;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;

public class GenerateModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(GenerateModel.class);
    public IZRL resource = null;
    public String template = "";
    public String recordLength = "";
    public String binaryRecordLength = "";
    public String numberOfRecords = "10";
    public boolean invokeIOExit = false;
    public String ioExit = "";
    public DSG.DsgDisp disposition = DSG.DsgDisp.MOD;
    public boolean ispfPacking = false;
    public FillCharacter fillCharacter = null;
    public String fillCharacterChar = "";
    public String fillCharacterBinChar = "";
    public String sequenceFieldPosition = "";
    public String sequenceFieldIncrement = "";
    public String sequenceFieldLength = "";

    public GenerateModel(IPDHost host) {
        super(host);
    }

    public DSG toUtilityFunction() {
        Volume volume;
        DSG dsg = new DSG();
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.DSNOUT, (Object)this.resource.getFormattedName(), this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.RECSIZE, (Object)this.recordLength, this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.NLRECS, (Object)this.numberOfRecords, this.getSystem());
        if (this.resource instanceof DataSetOrMember && (volume = ((DataSetOrMember)this.resource).asDataSet().getVolume()) != null) {
            dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.VOLSEROUT, (Object)volume.getVolserID(), this.getSystem());
        }
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.BINRECOUT, (Object)this.binaryRecordLength, this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.USEIOXOUT, (Object)this.invokeIOExit, this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.IOXOUT, (Object)this.ioExit, this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.DISP, (Object)this.disposition, this.getSystem());
        if (this.fillCharacter != null) {
            switch (this.fillCharacter) {
                case Character: {
                    dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.FILLCHAR, (Object)this.fillCharacterChar, this.getSystem());
                    break;
                }
                case BinaryCharacter: {
                    Object fillCharBinChar = this.fillCharacterBinChar;
                    if (((String)fillCharBinChar).length() == 1) {
                        fillCharBinChar = "0" + (String)fillCharBinChar;
                    }
                    dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.FILLCHAR, (Object)("X'" + (String)fillCharBinChar + "'"), this.getSystem());
                    break;
                }
                default: {
                    dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.FILLCHAR, (Object)this.fillCharacter.name(), this.getSystem());
                }
            }
        }
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.KEYLOC, (Object)this.sequenceFieldPosition, this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.KEYLEN, (Object)this.sequenceFieldLength, this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.INCR, (Object)this.sequenceFieldIncrement, this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.PACK, (Object)(this.ispfPacking ? DSG.DsgPack.PACK : DSG.DsgPack.NONE), this.getSystem());
        dsg.setValue((NewUtilityFunction.IUtilFuncParam)DSG.TCOUT, (Object)this.template, this.getSystem());
        return dsg;
    }

    public void fromUtilityFunction(DSG dsg) {
        this.resource = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)((String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.DSNOUT, this.getSystem())));
        this.recordLength = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.RECSIZE, this.getSystem());
        this.numberOfRecords = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.NLRECS, this.getSystem());
        this.setResourceVolume((String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.VOLSEROUT, this.getSystem()));
        this.binaryRecordLength = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.BINRECOUT, this.getSystem());
        this.invokeIOExit = (Boolean)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.USEIOXOUT, this.getSystem());
        this.ioExit = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.IOXOUT, this.getSystem());
        this.disposition = (DSG.DsgDisp)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.DISP, this.getSystem());
        String fillChar = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.FILLCHAR, this.getSystem());
        try {
            this.fillCharacter = FillCharacter.valueOf(fillChar);
        }
        catch (IllegalArgumentException e) {
            if (StringUtils.isHexEntry((String)fillChar)) {
                this.fillCharacter = FillCharacter.BinaryCharacter;
                this.fillCharacterBinChar = fillChar.substring(2, fillChar.length() - 1);
            }
            this.fillCharacter = FillCharacter.Character;
            this.fillCharacterChar = fillChar;
        }
        this.sequenceFieldPosition = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.KEYLOC, this.getSystem());
        this.sequenceFieldLength = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.KEYLEN, this.getSystem());
        this.sequenceFieldIncrement = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.INCR, this.getSystem());
        this.ispfPacking = dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.PACK, this.getSystem()) == DSG.DsgPack.PACK;
        this.template = (String)dsg.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSG.TCOUT, this.getSystem());
    }

    public Result<?> checkExists(IHowIsGoing monitor) throws InterruptedException {
        Result result = new Result((Object)new StringBuffer());
        if (this.resource instanceof IRefreshable) {
            IRefreshable iRefreshable = (IRefreshable)this.resource;
            result = iRefreshable.refreshExistence(monitor);
            if (!iRefreshable.getConfirmedExists()) {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)monitor.getMonitor()), (int)100);
                if (iRefreshable instanceof UssFile) {
                    AllocateHFSModel ufal = new AllocateHFSModel(this.getHostProvider(), iRefreshable.getFormattedName());
                    Result<StringBuffer> tryAllocateUSSFile = ufal.execute(PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)subMon.newChild(30)));
                    if (tryAllocateUSSFile.hasError()) {
                        return tryAllocateUSSFile;
                    }
                    FMSystemsTreeUpdater.refreshFilesRelatedTo((UssFile)iRefreshable);
                } else if (iRefreshable instanceof DataSet) {
                    Result<StringBuffer> tryAllocateDataSet = this.tryAllocateDataSet((DataSet)iRefreshable, subMon.newChild(30));
                    if (tryAllocateDataSet.hasError()) {
                        return tryAllocateDataSet;
                    }
                } else if (!(iRefreshable instanceof Member) && !(iRefreshable instanceof CicsTemporaryStorage)) {
                    result.setRC(8);
                    result.add(MessageFormat.format(Messages.CommDSGCommand_NONEXISTANT_RESOURCE, iRefreshable.getName()));
                    return result;
                }
            }
        }
        return result;
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        Result result;
        DSG dsg = this.toUtilityFunction();
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            result = UtilityFunctionRunner.execute((IPDHost)this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), (UtilityFunction)dsg, (IHowIsGoing)monitor);
        }
        catch (InterruptedException e) {
            result = new Result(4);
            result.add(Messages.CommDSGCommand_CANCELLED_DATA_MAYBE_GENERATED);
        }
        return result;
    }

    private Result<StringBuffer> tryAllocateDataSet(DataSet dataSet, SubMonitor subMon) throws InterruptedException {
        DataSet ds = (DataSet)this.resource;
        AllocateDataSetModel allocateParams = new AllocateDataSetModel();
        allocateParams.setHost(this.getSystem());
        allocateParams.setDataSetName(ds.getFormattedName());
        allocateParams.setDataSetType(DataSetType.PS);
        allocateParams.setQSAMvolumeSerial(ds.getVolume() == null ? "" : ds.getVolume().getVolserID());
        allocateParams.setQSAMrecordLength(this.recordLength);
        allocateParams.setQSAMrecordFormat(DSAQ.QsamRecordFormat.FB);
        final AllocateDataSetWizard wizard = AllocateDataSetWizard.create(allocateParams);
        final CountDownLatch latch = new CountDownLatch(1);
        final Result result = new Result(0);
        final AtomicInteger wizardOpenRCRef = new AtomicInteger(0);
        wizard.getRunnable().addCallback((Runnable)new TypedRunnable<Result<StringBuffer>, Void>(){

            public Void run(Result<StringBuffer> in) {
                if (!wizard.getRunnable().isCompletedSuccessfully()) {
                    result.setRC(8);
                    result.add(Messages.CommDSGCommand_DATASET_ALLOCATION_FAILED);
                }
                latch.countDown();
                return null;
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int returnValue = PDScrollableWizardDialog.openWizard((IWizard)wizard);
                wizardOpenRCRef.set(returnValue);
            }
        });
        int wizardReturn = wizardOpenRCRef.get();
        if (wizardReturn == 1) {
            result.setRC(8);
            result.add(Messages.CommDSGCommand_DATASET_ALLOCATION_CANCELLED_BY_USER);
            latch.countDown();
        }
        latch.await();
        return result;
    }

    public GenerateModel clone() {
        GenerateModel newParams = new GenerateModel(this.getHostProvider());
        newParams.resource = (IZRL)this.getCloneOf(this.resource);
        newParams.template = this.template;
        newParams.recordLength = this.recordLength;
        newParams.binaryRecordLength = this.binaryRecordLength;
        newParams.numberOfRecords = this.numberOfRecords;
        newParams.invokeIOExit = this.invokeIOExit;
        newParams.ioExit = this.ioExit;
        newParams.disposition = this.disposition;
        newParams.ispfPacking = this.ispfPacking;
        newParams.fillCharacter = this.fillCharacter;
        newParams.fillCharacterChar = this.fillCharacterChar;
        newParams.fillCharacterBinChar = this.fillCharacterBinChar;
        newParams.sequenceFieldPosition = this.sequenceFieldPosition;
        newParams.sequenceFieldIncrement = this.sequenceFieldIncrement;
        newParams.sequenceFieldLength = this.sequenceFieldLength;
        return newParams;
    }

    public void setResourceVolume(String volser) {
        if (this.resource instanceof DataSetOrMember && Volume.isValid((String)volser, (String)this.getSystem().getCodePage())) {
            DataSet dataSet = ((DataSetOrMember)this.resource).asDataSet();
            Volume volume = Volume.create((IPDHost)this.getSystem(), (String)volser);
            dataSet.setVolume(volume);
        } else {
            logger.trace((Object)("Couldn't set volume of " + volser));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof GenerateModel) {
            GenerateModel other = (GenerateModel)((Object)obj);
            return this.getSystem().equals(other.getSystem()) && this.toUtilityFunction().equals((Object)other.toUtilityFunction());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.toUtilityFunction().hashCode();
    }

    public static enum FillCharacter {
        AN,
        BIN,
        RAND,
        Character,
        BinaryCharacter;

    }
}

