/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.socket.func.DSG;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.GenerateModel;
import com.ibm.etools.fm.ui.wizards.GenerateRunnable;
import com.ibm.etools.fm.ui.wizards.GenerateWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class GenerateActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private GenerateModel model;
    private static DSGActionItemPropertySource propSource = null;

    public GenerateActionItem(GenerateModel model) {
        super(ActionType.DSG, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.DSGActionItem_LABEL, this.model.resource.getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        DSG function = new DSG();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        GenerateModel model = new GenerateModel(system);
        model.fromUtilityFunction(function);
        return new GenerateActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        GenerateRunnable runnable = new GenerateRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final GenerateModel clone = this.model.clone();
        GenerateWizard wizard = new GenerateWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                GenerateActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public GenerateActionItem clone() {
        GenerateActionItem clone = new GenerateActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GenerateActionItem) {
            GenerateActionItem other = (GenerateActionItem)obj;
            return this.getSystem().equals(other.getSystem()) && this.model.toUtilityFunction().equals((Object)other.model.toUtilityFunction());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 37;
        r = 37 * r + this.getSystem().hashCode();
        r = 37 * r + this.model.toUtilityFunction().hashCode();
        return r;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new DSGActionItemPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    public GenerateModel getModel() {
        return this.model;
    }

    public void setModel(GenerateModel model) {
        this.model = model;
    }

    private static class DSGActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private GenerateModel model;
        private IPropertyDescriptor[] propertyDescriptors;
        public String resource = "resource";
        private String volume = "volume";
        public String template = "template";
        public String recordLength = "recordLength";
        public String binaryRecordLength = "binaryRecordLength";
        public String numberOfRecords = "numberOfRecords";
        public String ioExit = "ioExit";
        public String disposition = "disposition";
        public String ispfPacking = "ispfPacking";
        public String fillCharacter = "fillCharacter";
        public String fillCharacterChar = "fillCharacterChar";
        public String fillCharacterBinChar = "fillCharacterBinChar";
        public String sequenceFieldPosition = "sequenceFieldPosition";
        public String sequenceFieldIncrement = "sequenceFieldIncrement";
        public String sequenceFieldLength = "sequenceFieldLength";

        public DSGActionItemPropertySource(GenerateModel model) {
            this.model = model;
            this.init();
        }

        public void setModel(GenerateModel model) {
            this.model = model;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.resource, Messages.Label__RESOURCE));
            temp.add(new PropertyDescriptor((Object)this.volume, Messages.Label__VOLUME));
            temp.add(new PropertyDescriptor((Object)this.template, Messages.Label__TEMPLATE));
            temp.add(new PropertyDescriptor((Object)this.recordLength, Messages.Label__RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.binaryRecordLength, Messages.Label__BINARY_RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.numberOfRecords, Messages.Label__NUMBER_OF_RECORDS));
            temp.add(new PropertyDescriptor((Object)this.ioExit, Messages._GENERATE_WIZARD_INVOKE_IO_EXIT));
            temp.add(new PropertyDescriptor((Object)this.disposition, Messages.Title__DISPOSITION));
            temp.add(new PropertyDescriptor((Object)this.ispfPacking, Messages._GENERATE_WIZARD_USE_ISPF_PACKING));
            temp.add(new PropertyDescriptor((Object)this.fillCharacter, Messages.Title_GENERATE_WIZARD_PAGE2_FILL_CHARACTER));
            temp.add(new PropertyDescriptor((Object)this.fillCharacterChar, Messages.Label__CHARACTER));
            temp.add(new PropertyDescriptor((Object)this.fillCharacterBinChar, Messages.Label__BINARY_CHARACTER));
            temp.add(new PropertyDescriptor((Object)this.sequenceFieldPosition, Messages.DSGActionItem_SEQUENCE_FIELD_POSITION));
            temp.add(new PropertyDescriptor((Object)this.sequenceFieldIncrement, Messages.DSGActionItem_SEQUENCE_FIELD_INCREMENT));
            temp.add(new PropertyDescriptor((Object)this.sequenceFieldLength, Messages.DSGActionItem_SEQUENCE_FIELD_LENGTH));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.resource)) {
                    return this.model.resource.getFormattedName();
                }
                if (id.equals(this.volume)) {
                    if (this.model.resource instanceof DataSetOrMember) {
                        return ((DataSetOrMember)this.model.resource).asDataSet().getVolume();
                    }
                } else {
                    if (id.equals(this.template)) {
                        return this.model.template;
                    }
                    if (id.equals(this.recordLength)) {
                        return this.model.recordLength;
                    }
                    if (id.equals(this.binaryRecordLength)) {
                        return this.model.binaryRecordLength;
                    }
                    if (id.equals(this.numberOfRecords)) {
                        return this.model.numberOfRecords;
                    }
                    if (id.equals(this.ioExit)) {
                        if (!this.model.invokeIOExit) {
                            return "";
                        }
                        return this.model.ioExit;
                    }
                    if (id.equals(this.disposition)) {
                        return this.model.disposition;
                    }
                    if (id.equals(this.ispfPacking)) {
                        return this.model.ispfPacking;
                    }
                    if (id.equals(this.fillCharacter)) {
                        if (this.model.fillCharacter == null) {
                            return "";
                        }
                        switch (this.model.fillCharacter) {
                            case AN: {
                                return Messages._GENERATE_WIZARD_FILL_CHARACTER_CONSECUTIVE_ALPHANUMERIC;
                            }
                            case BIN: {
                                return Messages._GENERATE_WIZARD_FILL_CHARACTER_CONSECUTIVE_BINARY;
                            }
                            case RAND: {
                                return Messages._GENERATE_WIZARD_FILL_CHARACTER_RANDOM_BINARY;
                            }
                            case Character: {
                                return Messages._GENERATE_WIZARD_FILL_CHARACTER_SPECIFIC;
                            }
                            case BinaryCharacter: {
                                return Messages._GENERATE_WIZARD_FILL_CHARACTER_SPECIFIC_BINARY;
                            }
                        }
                        return null;
                    }
                    if (id.equals(this.fillCharacterChar)) {
                        if (this.model.fillCharacter != GenerateModel.FillCharacter.Character) {
                            return "";
                        }
                        return this.model.fillCharacterChar;
                    }
                    if (id.equals(this.fillCharacterBinChar)) {
                        if (this.model.fillCharacter != GenerateModel.FillCharacter.BinaryCharacter) {
                            return "";
                        }
                        return this.model.fillCharacterBinChar;
                    }
                    if (id.equals(this.sequenceFieldPosition)) {
                        return this.model.sequenceFieldPosition;
                    }
                    if (id.equals(this.sequenceFieldIncrement)) {
                        return this.model.sequenceFieldIncrement;
                    }
                    if (id.equals(this.sequenceFieldLength)) {
                        return this.model.sequenceFieldLength;
                    }
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

