/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class FMWizardPage
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final int MAX_ENCRYPT_HOST_VER = 150105;
    protected static final PDLogger logger = PDLogger.get(FMWizardPage.class);
    private HashMap<Object, ManagedWidget> managedWidgets = new HashMap();
    private boolean ignoreManagedWidgetsEvents = false;

    protected FMWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    protected boolean isWidgetValid(Object widget) {
        if (widget == null) {
            return false;
        }
        return this.managedWidgets.get(widget).isValid();
    }

    public void createControl(Composite parent) {
        logger.warn((Object)"Default FM Wizard Page dialog contents are being created - createControl() should be overridden");
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.refreshControlState();
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.refreshControlState();
        }
        super.setVisible(visible);
    }

    public final void refreshControlState() {
        this.ignoreManagedWidgetsEvents = true;
        this.updateControlValues();
        this.ignoreManagedWidgetsEvents = false;
        this.validateManagedWidgets();
    }

    private final void validateManagedWidgets() {
        ManagedWidget invalidWidget = null;
        for (Map.Entry<Object, ManagedWidget> entry : this.managedWidgets.entrySet()) {
            ManagedWidget managedWidget = entry.getValue();
            if (managedWidget.isValid()) continue;
            invalidWidget = managedWidget;
            logger.trace((Object)("Managed widget is invalid, key=" + String.valueOf(entry.getKey()) + " and manager=" + String.valueOf(managedWidget)));
            break;
        }
        this.setErrorMessage(invalidWidget == null ? null : invalidWidget.errorMsg);
        this.setPageComplete(invalidWidget == null);
    }

    public final void safeValidateManagedWidgets() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FMWizardPage.this.validateManagedWidgets();
            }
        });
    }

    protected abstract void updateControlValues();

    public String toString() {
        return this.getName();
    }

    private static <C extends IWizardPage> C getPage(Class<C> clazz, IWizardPage[] pages) {
        IWizardPage[] iWizardPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (clazz.isAssignableFrom(page.getClass())) {
                return (C)page;
            }
            ++n2;
        }
        logger.debug(new Object[]{"No page found of class ", clazz.getName()});
        return null;
    }

    protected <C extends IWizardPage> C getPage(Class<C> clazz) {
        return FMWizardPage.getPage(clazz, this.getWizard().getPages());
    }

    protected boolean isEmpty(Text control) {
        if (control == null) {
            return true;
        }
        return control.getText().isEmpty();
    }

    protected boolean isEmpty(Combo control) {
        if (control == null) {
            return true;
        }
        return control.getText().isEmpty();
    }

    protected boolean isSelected(Control selectableWidget) {
        if (selectableWidget == null) {
            return false;
        }
        if (selectableWidget instanceof Button) {
            return ((Button)selectableWidget).getSelection();
        }
        throw new IllegalArgumentException();
    }

    private static void setSelected(Control selectableWidget, boolean selected) {
        if (selectableWidget == null) {
            return;
        }
        if (!(selectableWidget instanceof Button)) {
            throw new IllegalArgumentException();
        }
        ((Button)selectableWidget).setSelection(selected);
    }

    protected void select(Control selectableWidget) {
        FMWizardPage.setSelected(selectableWidget, true);
    }

    protected void unselect(Control selectableWidget) {
        FMWizardPage.setSelected(selectableWidget, false);
    }

    protected void unselect(Control[] selectableWidgets) {
        Control[] controlArray = selectableWidgets;
        int n = selectableWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control selectableWidget = controlArray[n2];
            FMWizardPage.setSelected(selectableWidget, false);
            ++n2;
        }
    }

    protected void select(Control[] selectableWidgets) {
        Control[] controlArray = selectableWidgets;
        int n = selectableWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control selectableWidget = controlArray[n2];
            FMWizardPage.setSelected(selectableWidget, true);
            ++n2;
        }
    }

    protected void enable(Control widget) {
        this.setEnabledIf(widget, true);
    }

    protected void enable(Control[] widgets) {
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control widget = controlArray[n2];
            this.setEnabledIf(widget, true);
            ++n2;
        }
    }

    protected void disable(Control widget) {
        this.setEnabledIf(widget, false);
    }

    protected void disable(Control[] widgets) {
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control widget = controlArray[n2];
            this.setEnabledIf(widget, false);
            ++n2;
        }
    }

    protected void setEnabled(boolean enabled, Control[] widgets) {
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control widget = controlArray[n2];
            this.setEnabledIf(widget, enabled);
            ++n2;
        }
    }

    protected void setEnabledIf(Control widget, boolean enabled) {
        if (widget == null) {
            return;
        }
        widget.setEnabled(enabled);
    }

    protected class ManagedWidget
    implements Listener {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private final String errorMsg;
        private final String name;
        private boolean hasCustomValidation = true;
        IPDHost ipdHost = null;

        protected ManagedWidget(Object widget, IPDHost host) {
            this(widget, null, host);
            this.ipdHost = host;
        }

        protected ManagedWidget(Object widget, String errorMessage, IPDHost host) {
            Objects.requireNonNull(widget, "Must provide a non-null widget");
            this.ipdHost = host;
            this.errorMsg = errorMessage;
            FMWizardPage.this.managedWidgets.put(widget, this);
            if (widget instanceof Object[]) {
                Object[] widgetArray;
                Object[] objectArray = widgetArray = (Object[])widget;
                int n = widgetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object currentWidget = objectArray[n2];
                    this.subscribeToChanges(currentWidget);
                    ++n2;
                }
            } else {
                this.subscribeToChanges(widget);
            }
            this.isValid();
            if (this.errorMsg != null && !this.hasCustomValidation) {
                logger.warn((Object)("Useless error message for " + String.valueOf(widget) + " will never be shown (in " + String.valueOf(((Object)((Object)FMWizardPage.this)).getClass()) + ")"));
            }
            String tmpName = widget.getClass().getSimpleName() + " - " + errorMessage;
            if (widget instanceof Combo && ComboValueSaver.getInstance((Combo)((Combo)widget)) != null) {
                tmpName = tmpName + " - CVS=" + ComboValueSaver.getInstance((Combo)((Combo)widget)).getId();
            }
            this.name = tmpName;
        }

        private void subscribeToChanges(Object widget) {
            if (widget instanceof Button) {
                ((Button)widget).addListener(13, (Listener)this);
            } else if (widget instanceof Text) {
                ((Text)widget).addListener(24, (Listener)this);
            } else if (widget instanceof Combo) {
                Combo combo2 = (Combo)widget;
                if ((combo2.getStyle() & 8) != 8) {
                    combo2.addListener(24, (Listener)this);
                }
                combo2.addListener(13, (Listener)this);
            } else if (widget instanceof DateTime) {
                ((DateTime)widget).addListener(13, (Listener)this);
            } else {
                logger.warn((Object)("Unknown widget can't be managed: " + widget.getClass().getName()));
            }
        }

        public String toString() {
            return this.name;
        }

        protected boolean isValid() {
            this.hasCustomValidation = false;
            return true;
        }

        public void handleEvent(Event event) {
            if (FMWizardPage.this.ignoreManagedWidgetsEvents) {
                return;
            }
            try {
                this.onChange(event);
            }
            catch (Exception e) {
                logger.debug((Object)"Uncaught exception in managed widget's onChange", (Throwable)e);
            }
            FMWizardPage.this.validateManagedWidgets();
        }

        public void onChange(Event event) {
        }
    }
}

