/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import java.util.Objects;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.Wizard;

public abstract class FMBaseWizard<T>
extends Wizard {
    private T model;
    private WizardRunnable runnable;

    protected FMBaseWizard(T model, String title, WizardRunnable runnable, boolean needsProgressMonitor) {
        this.model = Objects.requireNonNull(model, "Must provide a non-null model.");
        this.runnable = Objects.requireNonNull(runnable, "Must provide a non-null runnable.");
        this.setWindowTitle(title);
        TrayDialog.setDialogHelpAvailable((boolean)false);
        this.setNeedsProgressMonitor(needsProgressMonitor);
    }

    public WizardRunnable getRunnable() {
        return this.runnable;
    }

    protected T getModel() {
        return this.model;
    }

    public boolean performFinish() {
        if (!this.runnable.isCompletedSuccessfully()) {
            return this.runnable.run();
        }
        return true;
    }
}

