/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.IDeletable;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.UssFileType;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class DeleteRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final List<IDeletable> objectsToDelete;

    public DeleteRunnable(List<IDeletable> objectsToDelete) {
        this.objectsToDelete = objectsToDelete;
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        monitor.beginTask(Messages.Job__DELETING, this.objectsToDelete.size());
        Result finalResult = new Result();
        ArrayList<DataSet> dataSetsWithChangedMembers = new ArrayList<DataSet>();
        int i = 0;
        while (i < this.objectsToDelete.size() && !monitor.isCanceled()) {
            IDeletable deletable = this.objectsToDelete.get(i);
            monitor.subTask(deletable.getFormattedName());
            Result deletableResult = new Result();
            finalResult.addSubResult(deletableResult);
            try {
                Result result = deletable.deleteOnHost(monitor);
                int fmnbc251Loc = -1;
                if (!result.isSuccessfulWithoutWarnings() && deletable instanceof UssFile && ((UssFile)deletable).getType() == UssFileType.Dir && result.getOutput() != null && (fmnbc251Loc = ((StringBuffer)result.getOutput()).toString().indexOf("FMNBC251")) >= 0 && ((StringBuffer)result.getOutput()).toString().indexOf("136") > fmnbc251Loc) {
                    result = ((UssFile)deletable).deleteDirectoryWithFilesOnHost(monitor);
                }
                if (result.isSuccessfulWithoutWarnings()) {
                    deletableResult.add(MessageFormat.format(Messages.DeleteWizard_X_DELETED_SUCCESSFULLY, deletable.getFormattedName()));
                    DeleteRunnable.removeFromTree(deletable);
                    if (deletable instanceof Member) {
                        dataSetsWithChangedMembers.add(((Member)deletable).asDataSet());
                    }
                } else {
                    if (result.getOutput() != null) {
                        deletableResult.add(((StringBuffer)result.getOutput()).toString());
                    } else {
                        deletableResult.add(MessageFormat.format(Messages.DeleteWizard_DELETION_FAIL, deletable.getFormattedName()));
                    }
                    deletableResult.setRC(8);
                }
            }
            catch (InterruptedException e) {
                deletableResult.add(MessageFormat.format(Messages.DeleteWizard_DELETE_INTERRUPTED_X_MAYBE_NOT_DELETED, deletable.getFormattedName()));
                deletableResult.setRC(4);
                PDSystemsTreeUpdater.refreshAllRelatedTo((Object)deletable);
                monitor.done();
                return finalResult;
            }
            catch (Exception e) {
                deletableResult.add(MessageFormat.format(Messages.DeleteWizard_EXCEPTION_DELETING_X, deletable.getFormattedName()));
                deletableResult.add((Throwable)e);
            }
            monitor.worked(1);
            ++i;
        }
        ContentCache<DataSet, List<Member>> dsContentCache = FMTreeContentHolder.getInstance().getDataSetContent().getDataSetContentCache();
        for (DataSet ds : dataSetsWithChangedMembers) {
            dsContentCache.unloadContent((Object)ds);
        }
        PDSystemsView.tryRefresh();
        monitor.done();
        return finalResult;
    }

    private static void removeFromTree(IDeletable deletable) {
        ArrayList<Object> itemsToRemove = new ArrayList<Object>();
        itemsToRemove.add(deletable);
        if (deletable instanceof DataSet && ((DataSet)deletable).getType().getAccessMethod() == DataSetType.AccessMethod.VSAM) {
            DataSet dataSet = (DataSet)deletable;
            List associatedDataSets = dataSet.getAssociatedDataSets();
            for (DataSet associatedDataSet : associatedDataSets) {
                if (itemsToRemove.contains(associatedDataSet)) continue;
                itemsToRemove.add(associatedDataSet);
            }
        }
        for (IDeletable iDeletable : itemsToRemove) {
            List nodesForItemsToRemove = PDTreeContentHolder.getInstance().getNodesFor((Object)iDeletable);
            for (SystemsTreeNode nodeOfDeletedItem : nodesForItemsToRemove) {
                PDSystemsTreeUpdater.refreshAllRelatedTo((Object)nodeOfDeletedItem.getDataObject());
            }
        }
    }

    @Override
    protected String getName() {
        return Messages.DeleteWizard_DELETING;
    }

    @Override
    public void showResult() {
        FMDialogWithText.showResultDump(this.getResult(), false, 4);
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().getRC() <= 4;
    }
}

