/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.IDeletable;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.wizards.DeleteWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class DeleteActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TYPE_DELETABLE = "deletable";
    public static final String KEY_DELETABLE_NAME = "name";
    private static Comparator<IDeletable> CompareByFormattedName = new Comparator<IDeletable>(){

        @Override
        public int compare(IDeletable o1, IDeletable o2) {
            return o1.getFormattedName().compareTo(o2.getFormattedName());
        }
    };
    private static DeleteActionItemPropertySource propSource;
    private List<IDeletable> objectsToDelete;

    public DeleteActionItem(List<IDeletable> objectsToDelete) {
        super(ActionType.DELETE, objectsToDelete.get(0).getSystem());
        this.objectsToDelete = new ArrayList<IDeletable>(objectsToDelete);
    }

    @Override
    public DeleteActionItem clone() {
        return new DeleteActionItem(new ArrayList<IDeletable>(this.objectsToDelete));
    }

    @Override
    public String getDefaultLabel() {
        if (this.objectsToDelete.size() == 1) {
            return MessageFormat.format(Messages.DeleteActionItem_DELETE, this.objectsToDelete.get(0).getFormattedName());
        }
        return MessageFormat.format(Messages.DeleteActionItem_DELETE_X_RESOURCES, this.objectsToDelete.size());
    }

    @Override
    public String getToolTipText() {
        StringBuilder sb = new StringBuilder();
        if (this.objectsToDelete.size() > 0) {
            sb.append(Messages.DeleteActionItem_DELETE_TOOLTIP);
            for (IDeletable deletable : this.objectsToDelete) {
                sb.append("\n");
                sb.append(deletable.getFormattedName());
            }
        } else {
            sb.append(Messages.DeleteActionItem_DELETE_NOTHING);
        }
        return sb.toString();
    }

    @Override
    public void saveTo(IMemento memento) {
        for (IDeletable deletable : this.objectsToDelete) {
            IMemento child = memento.createChild(TYPE_DELETABLE);
            child.putString(KEY_DELETABLE_NAME, deletable.getFormattedName());
        }
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        IMemento[] childMementos = memento.getChildren(TYPE_DELETABLE);
        ArrayList<IDeletable> toDelete = new ArrayList<IDeletable>();
        IMemento[] iMementoArray = childMementos;
        int n = childMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento iMemento = iMementoArray[n2];
            String name = iMemento.getString(KEY_DELETABLE_NAME);
            IZRL zrl = ZRLs.parseZRL((IPDHost)system, (String)name);
            if (zrl instanceof IDeletable) {
                toDelete.add((IDeletable)zrl);
            } else {
                logger.trace((Object)("Unable to load non-deletable zrl: " + String.valueOf(zrl)));
            }
            ++n2;
        }
        if (toDelete.size() > 0) {
            return new DeleteActionItem(toDelete);
        }
        logger.trace((Object)"No deletables could be loaded for DeleteActionItem, returning null");
        return null;
    }

    @Override
    public void execute() {
        this.modify();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final ArrayList<IDeletable> clone = new ArrayList<IDeletable>(this.objectsToDelete);
        DeleteWizard wizard = new DeleteWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                DeleteActionItem.this.objectsToDelete = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DeleteActionItem) {
            DeleteActionItem other = (DeleteActionItem)obj;
            if (this.objectsToDelete.size() == other.objectsToDelete.size()) {
                Collections.sort(this.objectsToDelete, CompareByFormattedName);
                Collections.sort(other.objectsToDelete, CompareByFormattedName);
                int i = 0;
                while (i < this.objectsToDelete.size()) {
                    if (!this.objectsToDelete.get(i).equals(other.objectsToDelete.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        Collections.sort(this.objectsToDelete, CompareByFormattedName);
        return this.objectsToDelete.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new DeleteActionItemPropertySource(this.objectsToDelete);
        }
        propSource.setModel(this.objectsToDelete);
        return propSource;
    }

    private static class DeleteActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private boolean initRequired = true;
        private List<IDeletable> objectsToDelete;
        private IPropertyDescriptor[] propertyDescriptors;
        private static final String PROPERTY_ID = "itemsToDelete";
        private static final String PROPERTY_DISPLAY = Messages.DeleteActionItem_ITEMS_TO_DELETE;

        public DeleteActionItemPropertySource(List<IDeletable> objectsToDelete) {
            this.setModel(objectsToDelete);
        }

        public void setModel(List<IDeletable> objectsToDelete) {
            this.objectsToDelete = objectsToDelete;
            this.initRequired = true;
        }

        private void init() {
            if (!this.initRequired) {
                return;
            }
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)PROPERTY_ID, PROPERTY_DISPLAY));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
            this.initRequired = false;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            this.init();
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object arg) {
            String id;
            if (arg instanceof String && (id = (String)arg).equals(PROPERTY_ID)) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < this.objectsToDelete.size()) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(this.objectsToDelete.get(i).getFormattedName());
                    ++i;
                }
                return sb;
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

