/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.socket.func.DSG;
import com.ibm.etools.fm.ui.dialog.NewMemberDialog;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.views.systems.handlers.CreateMember;
import com.ibm.etools.fm.ui.wizards.GenerateModel;
import com.ibm.etools.fm.ui.wizards.GenerateRunnable;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CreateMemberActionItem
extends ActionItem {
    private GenerateModel model;
    private static CreateMemberActionItemPropertySource propSource = null;

    public CreateMemberActionItem(GenerateModel model) {
        super(ActionType.CREATE_MEMBER, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.CreateMemberActionItem_0, this.model.resource.getFormattedName());
    }

    @Override
    public void execute() {
        this.beginExecution();
        GenerateRunnable runnable = CreateMember.getCustomCreateMemberRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        final GenerateModel clone = this.model.clone();
        if (clone.resource instanceof DataSetOrMember) {
            this.beginExecution();
            NewMemberDialog dialog = new NewMemberDialog(clone.getSystem(), (DataSetOrMember)clone.resource);
            if (dialog.open() == 1) {
                this.finishExecution(true);
            } else {
                clone.resource = dialog.getNewMember();
                GenerateRunnable runnable = CreateMember.getCustomCreateMemberRunnable(clone);
                runnable.addCallback(new Runnable(){

                    @Override
                    public void run() {
                        CreateMemberActionItem.this.model = clone;
                    }
                });
                runnable.addCallback(this.getUpdateStateCallback(runnable));
                runnable.addCallback(this.getFinishExecutionCallBack());
                runnable.run();
            }
        }
    }

    @Override
    public CreateMemberActionItem clone() {
        CreateMemberActionItem clone = new CreateMemberActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        DSG function = new DSG();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        GenerateModel model = new GenerateModel(system);
        model.fromUtilityFunction(function);
        return new CreateMemberActionItem(model);
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new CreateMemberActionItemPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    @Override
    public void saveTo(IMemento memento) {
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CreateMemberActionItem) {
            CreateMemberActionItem other = (CreateMemberActionItem)obj;
            return this.getSystem().equals(other.getSystem()) && this.model.toUtilityFunction().equals((Object)other.model.toUtilityFunction());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 37;
        r = 37 * r + this.getSystem().hashCode();
        r = 37 * r + this.model.toUtilityFunction().hashCode();
        return r;
    }

    private static class CreateMemberActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private GenerateModel model;
        private IPropertyDescriptor[] propertyDescriptors;
        public String resource = "resource";

        public CreateMemberActionItemPropertySource(GenerateModel model) {
            this.model = model;
            this.init();
        }

        public void setModel(GenerateModel model) {
            this.model = model;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.resource, Messages.Label__RESOURCE));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object arg) {
            String id;
            if (arg instanceof String && (id = (String)arg).equals(this.resource)) {
                return this.model.resource.getFormattedName();
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

