/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.widget.TemplateWithOffsetComposite;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.Objects;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CopyWizardPageTemplate
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final CopyModel params;
    private TemplateWithOffsetComposite wSourceTemplate;
    private TemplateWithOffsetComposite wDestTemplate;
    private Button wUserFieldMapping;

    public CopyWizardPageTemplate(CopyModel params) {
        super(Messages.Title__TEMPLATE_SELECTION);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_COPY_WIZARD_PAGE_TEMPLATE_SPECIFY_TEMPLATES);
    }

    public void setPageComplete(boolean complete) {
        String errMsg = this.wSourceTemplate.getValidationErrorMessage();
        if (errMsg == null) {
            errMsg = this.wDestTemplate.getValidationErrorMessage();
        }
        boolean bl = complete = complete && errMsg == null;
        if (complete && this.getContainer().getCurrentPage() == this && this.wUserFieldMapping != null) {
            this.params.setUseDefaultMappingCopyCorresponding(this.wUserFieldMapping.getSelection());
        }
        this.setEnabledIf((Control)this.wUserFieldMapping, this.params.getDestTemplate().getTemplate() != null);
        super.setPageComplete(complete);
    }

    public void setErrorMessage(String errMsg) {
        if (errMsg == null) {
            errMsg = this.wDestTemplate.getValidationErrorMessage();
        }
        if (errMsg == null) {
            errMsg = this.wSourceTemplate.getValidationErrorMessage();
        }
        super.setErrorMessage(errMsg);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 2;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group sourceGroup = GUI.group((Composite)parent, (String)Messages.Title__COPY_WIZARD_SOURCE_TEMPLATE, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.wSourceTemplate = new TemplateWithOffsetComposite((Composite)sourceGroup, 0, this.params.getSourceTemplate(), String.valueOf(((Object)((Object)this)).getClass()) + "Source", true){

            @Override
            protected void onViewUpdated() {
                CopyWizardPageTemplate.this.safeValidateManagedWidgets();
            }
        };
        this.wSourceTemplate.setLayoutData(GUI.grid.d.fillH((int)1));
        Group destGroup = GUI.group((Composite)parent, (String)Messages.Title__COPY_WIZARD_DESTINATION_TEMPLATE, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.wDestTemplate = new TemplateWithOffsetComposite((Composite)destGroup, 0, this.params.getDestTemplate(), String.valueOf(((Object)((Object)this)).getClass()) + "Dest", true){

            @Override
            protected void onViewUpdated() {
                CopyWizardPageTemplate.this.safeValidateManagedWidgets();
            }
        };
        this.wDestTemplate.setLayoutData(GUI.grid.d.fillH((int)1));
        this.wUserFieldMapping = GUI.button.checkbox((Composite)destGroup, (String)Messages._COPY_WIZARD_USE_TEMPLATE_FIELD_MAPPING, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wUserFieldMapping, this.params.getSystem());
        this.updateControlValues();
        this.setControl((Control)parent);
    }

    @Override
    protected void updateControlValues() {
        this.wSourceTemplate.getConnector().doManualViewUpdate();
        this.wDestTemplate.getConnector().doManualViewUpdate();
        CopyModel tempParams = this.params.clone();
        this.wUserFieldMapping.setSelection(tempParams.isUseDefaultMappingCopyCorresponding());
    }
}

