/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.socket.func.DSC;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CopyWizardPageOptions2
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final CopyModel params;
    private Combo wSourceBinaryRecordLength;
    private Button wSourceAdjustStart;
    private Button wSourceIOExitSpecified;
    private Combo wSourceIOExit;
    private Combo wDestBinaryRecordLength;
    private Button wDestAdjustStart;
    private Button wDestIOExitSpecified;
    private Combo wDestIOExit;
    private Combo wSampleSkip;
    private Combo wSampleInclude;
    private Button wFormatXml;
    private Button wIncludeMQ;
    private Button wMQDestructiveRead;

    public CopyWizardPageOptions2(CopyModel params) {
        super(Messages.Title__ADVANCED_OPTIONS);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Title_COPY_WIZARD_PAGE_OPTIONS2);
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            if (this.wSourceBinaryRecordLength != null) {
                this.params.setSourceBinaryRecordLength(this.wSourceBinaryRecordLength.getText());
            }
            this.params.setSourceAdjustStart(this.isSelected((Control)this.wSourceAdjustStart));
            this.params.setSourceIOExitSpecified(this.isSelected((Control)this.wSourceIOExitSpecified));
            if (this.wSourceIOExit != null) {
                this.params.setSourceIOExit(this.wSourceIOExit.getText());
            }
            if (this.wDestBinaryRecordLength != null) {
                this.params.setDestBinaryRecordLength(this.wDestBinaryRecordLength.getText());
            }
            this.params.setDestAdjustStart(this.isSelected((Control)this.wDestAdjustStart));
            this.params.setDestIOExitSpecified(this.isSelected((Control)this.wDestIOExitSpecified));
            if (this.wDestIOExit != null) {
                this.params.setDestIOExit(this.wDestIOExit.getText());
            }
            if (this.wSampleSkip != null) {
                this.params.setSampleSkip(this.wSampleSkip.getText());
            }
            if (this.wSampleInclude != null) {
                this.params.setSampleInclude(this.wSampleInclude.getText());
            }
            if (this.wFormatXml != null && this.params.getSourceTemplate().getTemplate() != null) {
                this.params.setFormatInXml(this.wFormatXml.getSelection());
            }
            this.params.setIncludeMd(this.wIncludeMQ.getSelection());
            this.params.setMqDestructiveRead(this.wMQDestructiveRead.getSelection());
        }
        this.setEnabledIf((Control)this.wSourceBinaryRecordLength, this.params.getSourceResourceZRL() instanceof UssFile);
        this.setEnabledIf((Control)this.wDestBinaryRecordLength, this.params.getDestResourceZRL() instanceof UssFile);
        this.setEnabledIf((Control)this.wSourceIOExitSpecified, this.params.getPacking() == DSC.DscPack.NONE);
        this.setEnabledIf((Control)this.wSourceIOExit, this.isSelected((Control)this.wSourceIOExitSpecified) && this.params.getPacking() == DSC.DscPack.NONE);
        this.setEnabledIf((Control)this.wDestIOExitSpecified, this.params.getPacking() == DSC.DscPack.NONE);
        this.setEnabledIf((Control)this.wDestIOExit, this.isSelected((Control)this.wDestIOExitSpecified) && this.params.getPacking() == DSC.DscPack.NONE);
        this.setEnabledIf((Control)this.wFormatXml, this.params.getSourceTemplate().getTemplate() != null);
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 4;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group fromGroup = GUI.group((Composite)parent, (String)Messages.Title__SOURCE_OPTIONS, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        this.wSourceAdjustStart = GUI.button.checkbox((Composite)fromGroup, (String)Messages.__ADJUST_INPUT_FOR_RDW, (Object)GUI.grid.d.fillH((int)4));
        new FMWizardPage.ManagedWidget(this, this.wSourceAdjustStart, this.params.getSystem());
        GUI.label.left((Composite)fromGroup, (String)Messages.Label__BINARY_RECORD_LENGTH, (Object)GUI.grid.d.left1());
        this.wSourceBinaryRecordLength = GUI.combo.editable((Composite)fromGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wSourceBinaryRecordLength, ((Object)((Object)this)).getClass().getCanonicalName() + "SourceBinaryRecLen");
        new FMWizardPage.ManagedWidget(this, this.wSourceBinaryRecordLength, this.params.getSystem());
        this.wSourceIOExitSpecified = GUI.button.checkbox((Composite)fromGroup, (String)Messages.Label__IO_EXIT, (Object)GUI.grid.d.left1());
        new FMWizardPage.ManagedWidget(this, this.wSourceIOExitSpecified, this.params.getSystem()){

            @Override
            public void onChange(Event event) {
                if (!CopyWizardPageOptions2.this.isSelected((Control)CopyWizardPageOptions2.this.wSourceIOExitSpecified)) {
                    CopyWizardPageOptions2.this.wSourceIOExit.setText("");
                }
            }
        };
        this.wSourceIOExit = GUI.combo.editable((Composite)fromGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wSourceIOExit, ((Object)((Object)this)).getClass().getCanonicalName() + "SourceIOExit");
        new FMWizardPage.ManagedWidget(this, this.wSourceIOExit, this.params.getSystem());
        Group toGroup = GUI.group((Composite)parent, (String)Messages.Title__DESTINATION_OPTIONS, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        this.wDestAdjustStart = GUI.button.checkbox((Composite)toGroup, (String)Messages.__ADJUST_OUTPUT_FOR_RDW, (Object)GUI.grid.d.fillH((int)4));
        new FMWizardPage.ManagedWidget(this, this.wDestAdjustStart, this.params.getSystem());
        GUI.label.left((Composite)toGroup, (String)Messages.Label__BINARY_RECORD_LENGTH, (Object)GUI.grid.d.left1());
        this.wDestBinaryRecordLength = GUI.combo.editable((Composite)toGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wDestBinaryRecordLength, ((Object)((Object)this)).getClass().getCanonicalName() + "DestBinaryRecLen");
        new FMWizardPage.ManagedWidget(this, this.wDestBinaryRecordLength, this.params.getSystem());
        this.wDestIOExitSpecified = GUI.button.checkbox((Composite)toGroup, (String)Messages.Label__IO_EXIT, (Object)GUI.grid.d.left1());
        new FMWizardPage.ManagedWidget(this, this.wDestIOExitSpecified, this.params.getSystem()){

            @Override
            public void onChange(Event event) {
                if (!CopyWizardPageOptions2.this.isSelected((Control)CopyWizardPageOptions2.this.wDestIOExitSpecified)) {
                    CopyWizardPageOptions2.this.wDestIOExit.setText("");
                }
            }
        };
        this.wDestIOExit = GUI.combo.editable((Composite)toGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wDestIOExit, ((Object)((Object)this)).getClass().getCanonicalName() + "DestIOExit");
        new FMWizardPage.ManagedWidget(this, this.wDestIOExit, this.params.getSystem());
        Group sampleGroup = GUI.group((Composite)parent, (String)Messages.Title__RECORD_SAMPLING_OPTIONS, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        GUI.label.left((Composite)sampleGroup, (String)Messages.Label__SKIP, (Object)GUI.grid.d.left1());
        this.wSampleSkip = GUI.combo.editable((Composite)sampleGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfSS = NumberForcer.addTo(this.wSampleSkip, ((Object)((Object)this)).getClass().getCanonicalName() + "SampleSkip");
        nfSS.setUpperBound(9999999, true);
        new FMWizardPage.ManagedWidget(this, this.wSampleSkip, this.params.getSystem());
        GUI.label.left((Composite)sampleGroup, (String)Messages.Label__INCLUDE, (Object)GUI.grid.d.left1());
        this.wSampleInclude = GUI.combo.editable((Composite)sampleGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfSI = NumberForcer.addTo(this.wSampleInclude, ((Object)((Object)this)).getClass().getCanonicalName() + "SampleInclude");
        nfSI.setUpperBound(9999999, true);
        new FMWizardPage.ManagedWidget(this, this.wSampleInclude, Messages.Msg_COPY_WIZARD_PAGE_OPTIONS2_SKIP_REQUIRES_BOTH, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                return CopyWizardPageOptions2.this.isEmpty(CopyWizardPageOptions2.this.wSampleSkip) && CopyWizardPageOptions2.this.isEmpty(CopyWizardPageOptions2.this.wSampleInclude) || !CopyWizardPageOptions2.this.isEmpty(CopyWizardPageOptions2.this.wSampleSkip) && !CopyWizardPageOptions2.this.isEmpty(CopyWizardPageOptions2.this.wSampleInclude);
            }
        };
        Group miscGroup = GUI.group((Composite)parent, (String)Messages.CopyWizardPageOptions2_MISC_OPTIONS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        this.wFormatXml = GUI.button.checkbox((Composite)miscGroup, (String)Messages.CopyWizardPageOptions2_OUTPUT_IN_XML_FORMAT, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wFormatXml, this.params.getSystem());
        this.wIncludeMQ = GUI.button.checkbox((Composite)miscGroup, (String)Messages.EditorOptionDialog_MQ_INCLUDE_DESCRIPTORS, (Object)GUI.grid.d.fillH((int)1));
        this.wIncludeMQ.setToolTipText(Messages.EditorOptionDialog_MQ_INCLUDE_DESCRIPTORS_TIP);
        new FMWizardPage.ManagedWidget(this, this.wIncludeMQ, this.params.getSystem());
        this.wMQDestructiveRead = GUI.button.checkbox((Composite)miscGroup, (String)Messages.CopyWizardPageOptions2_0, (Object)GUI.grid.d.fillH((int)1));
        this.wMQDestructiveRead.setToolTipText(Messages.CopyWizardPageOptions2_MQ_DESTRUCTIVE_READ_TIP);
        new FMWizardPage.ManagedWidget(this, this.wMQDestructiveRead, this.params.getSystem());
        this.updateControlValues();
        this.setControl((Control)parent);
    }

    @Override
    protected void updateControlValues() {
        CopyModel tempParams = this.params.clone();
        this.wSourceBinaryRecordLength.setText(tempParams.getSourceBinaryRecordLength());
        if (tempParams.isSourceAdjustStart()) {
            this.select((Control)this.wSourceAdjustStart);
        }
        if (tempParams.isSourceIOExitSpecified()) {
            this.select((Control)this.wSourceIOExitSpecified);
        }
        this.wSourceIOExit.setText(tempParams.getSourceIOExit());
        this.wDestBinaryRecordLength.setText(tempParams.getDestBinaryRecordLength());
        if (tempParams.isDestAdjustStart()) {
            this.select((Control)this.wDestAdjustStart);
        }
        if (tempParams.isDestIOExitSpecified()) {
            this.select((Control)this.wDestIOExitSpecified);
        }
        this.wDestIOExit.setText(tempParams.getDestIOExit());
        this.wSampleSkip.setText(tempParams.getSampleSkip());
        this.wSampleInclude.setText(tempParams.getSampleInclude());
        this.wFormatXml.setSelection(tempParams.isFormatInXml());
        this.wIncludeMQ.setSelection(tempParams.isIncludeMd());
        this.wMQDestructiveRead.setSelection(tempParams.getMqDestructiveRead());
        this.safeValidateManagedWidgets();
    }

    public IWizardPage getNextPage() {
        if (this.params.isFormatInXml()) {
            return super.getNextPage();
        }
        return null;
    }
}

