/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.socket.func.DSC;
import com.ibm.etools.fm.jhost.core.util.EnumUtils;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import java.util.Objects;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CopyWizardPageOptions1
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final CopyModel params;
    private Button[] wUpdateStatistics = new Button[3];
    private Button wOverwriteExistingRecords;
    private Button wKsdsUpdate;
    private Label wSkipRecordsLabel;
    private Combo wSkipRecords;
    private Label wVsamKeyLabel;
    private Combo wVsamKey;
    private Combo wNumberRecords;
    private Button wReplaceMembers;
    private Button wIgnoreRecordLength;
    private Label wPackLabel;
    private Combo wPack;

    public CopyWizardPageOptions1(CopyModel params) {
        super(Messages.CopyWizardPageOptions1_ADDITIONAL_OPTIONS);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Title_COPY_WIZARD_PAGE_OPTIONS1);
    }

    public void setPageComplete(boolean complete) {
        if (complete && this.getContainer().getCurrentPage() == this) {
            if (this.isSelected((Control)this.wUpdateStatistics[0])) {
                this.params.setUpdateStatistics(DSC.DscStats.OFF);
            } else if (this.isSelected((Control)this.wUpdateStatistics[1])) {
                this.params.setUpdateStatistics(DSC.DscStats.ON);
            } else if (this.isSelected((Control)this.wUpdateStatistics[2])) {
                this.params.setUpdateStatistics(DSC.DscStats.FORCE);
            }
            if (this.wOverwriteExistingRecords != null) {
                this.params.setOverwriteExistingRecords(this.wOverwriteExistingRecords.getSelection());
            }
            if (this.wKsdsUpdate != null) {
                this.params.setKsdsUpdate(this.wKsdsUpdate.getSelection());
            }
            if (this.wSkipRecords != null) {
                this.params.setSkipRecords(this.wSkipRecords.getText());
            }
            if (this.wVsamKey != null) {
                this.params.setVsamKey(this.wVsamKey.getText());
            }
            if (this.wNumberRecords != null) {
                this.params.setNumberRecords(this.wNumberRecords.getText());
            }
            if (this.wReplaceMembers != null) {
                this.params.setReplaceMembers(this.wReplaceMembers.getSelection());
            }
            if (this.wIgnoreRecordLength != null) {
                this.params.setIgnoreRecordLength(this.wIgnoreRecordLength.getSelection());
            }
            if (this.wPack != null) {
                this.params.setPacking((DSC.DscPack)EnumUtils.lookup(DSC.DscPack.class, (String)this.wPack.getText()));
            }
        }
        this.setEnabledIf((Control)this.wSkipRecordsLabel, this.isEmpty(this.wVsamKey));
        this.setEnabledIf((Control)this.wSkipRecords, this.isEmpty(this.wVsamKey));
        DataSetType sourceType = this.params.getSourceResourceZRL() instanceof DataSet ? ((DataSet)this.params.getSourceResourceZRL()).getType() : DataSetType.UNKNOWN;
        this.setEnabledIf((Control)this.wPackLabel, sourceType.getAccessMethod() != DataSetType.AccessMethod.VSAM);
        this.setEnabledIf((Control)this.wPack, sourceType.getAccessMethod() != DataSetType.AccessMethod.VSAM);
        boolean enableKey = false;
        if (this.params.getSourceResourceZRL() instanceof DataSet) {
            DataSetType type = ((DataSet)this.params.getSourceResourceZRL()).getType();
            boolean bl = enableKey = type == DataSetType.RRDS || type == DataSetType.KSDS || type == DataSetType.KSDSIAM;
            if (type != DataSetType.KSDS || this.wOverwriteExistingRecords.getSelection()) {
                this.wKsdsUpdate.setSelection(false);
                this.wKsdsUpdate.setEnabled(false);
            } else if (!this.wOverwriteExistingRecords.getSelection()) {
                this.wKsdsUpdate.setEnabled(true);
            }
        } else if (this.params.getSourceResourceZRL() instanceof CicsFile) {
            CicsFile cicsFile = (CicsFile)this.params.getSourceResourceZRL();
            enableKey = cicsFile.getKeyLength() != -1 && cicsFile.getKeyStartLocation() != -1;
        }
        enableKey = enableKey && this.isEmpty(this.wSkipRecords);
        this.setEnabledIf((Control)this.wVsamKeyLabel, enableKey);
        this.setEnabledIf((Control)this.wVsamKey, enableKey);
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 4;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group recordsGroup = GUI.group((Composite)parent, (String)Messages.Title__COPY_WIZARD_RECORD_COPYING_OPTIONS, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        GUI.label.left((Composite)recordsGroup, (String)Messages.Label__SKIP_RECORDS, (Object)GUI.grid.d.left1());
        this.wSkipRecords = GUI.combo.editable((Composite)recordsGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wSkipRecords, ((Object)((Object)this)).getClass().getCanonicalName() + "SkipRecords");
        new FMWizardPage.ManagedWidget(this, this.wSkipRecords, this.params.getSystem()){

            @Override
            public void onChange(Event event) {
                if (!CopyWizardPageOptions1.this.isEmpty(CopyWizardPageOptions1.this.wSkipRecords)) {
                    CopyWizardPageOptions1.this.wVsamKey.setText("");
                }
            }
        };
        GUI.label.left((Composite)recordsGroup, (String)Messages.Label__VSAM_KEY, (Object)GUI.grid.d.left1());
        this.wVsamKey = GUI.combo.editable((Composite)recordsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wVsamKey, ((Object)((Object)this)).getClass().getCanonicalName() + "VsamKey");
        new FMWizardPage.ManagedWidget(this, this.wVsamKey, this.params.getSystem()){

            @Override
            public void onChange(Event event) {
                if (!CopyWizardPageOptions1.this.isEmpty(CopyWizardPageOptions1.this.wVsamKey)) {
                    CopyWizardPageOptions1.this.wSkipRecords.setText("");
                }
            }
        };
        GUI.label.left((Composite)recordsGroup, (String)Messages.Label__RECORDS_TO_COPY, (Object)GUI.grid.d.left1());
        this.wNumberRecords = GUI.combo.editable((Composite)recordsGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer numberRecordsForcer = NumberForcer.addTo(this.wNumberRecords, ((Object)((Object)this)).getClass().getCanonicalName() + "NumberRecords");
        numberRecordsForcer.setLowerBound(1, true);
        this.wNumberRecords.setToolTipText(numberRecordsForcer.getToolTip() + Messages.ToolTip__BLANK_DEFAULTS_TO_ALL);
        new FMWizardPage.ManagedWidget(this, this.wNumberRecords, this.params.getSystem());
        this.wPackLabel = GUI.label.left((Composite)recordsGroup, (String)Messages.Label__PACKING_POLICY, (Object)GUI.grid.d.left1());
        this.wPack = GUI.combo.readOnly((Composite)recordsGroup, (Object)GUI.grid.d.fillH((int)1), (Object[])DSC.DscPack.values());
        new ComboValueSaver(this.wPack, ((Object)((Object)this)).getClass().getCanonicalName() + "Pack");
        new FMWizardPage.ManagedWidget(this, this.wPack, this.params.getSystem());
        this.wOverwriteExistingRecords = GUI.button.checkbox((Composite)recordsGroup, (String)Messages.__OVERWRITE_EXISTING_RECORDS, (Object)GUI.grid.d.fillH((int)2));
        this.wOverwriteExistingRecords.setToolTipText(Messages.ToolTip_OVERRITE_EXISTING_RECORD);
        new FMWizardPage.ManagedWidget(this, this.wOverwriteExistingRecords, this.params.getSystem());
        this.wIgnoreRecordLength = GUI.button.checkbox((Composite)recordsGroup, (String)Messages.__IGNORE_RECORD_LENGTH_MISMATCHES, (Object)GUI.grid.d.fillH((int)2));
        new FMWizardPage.ManagedWidget(this, this.wIgnoreRecordLength, this.params.getSystem());
        this.wKsdsUpdate = GUI.button.checkbox((Composite)recordsGroup, (String)Messages._KSDS_UPDATE, (Object)GUI.grid.d.fillH((int)3));
        this.wKsdsUpdate.setToolTipText(Messages.ToolTip_KSDS_UPDATE);
        this.wKsdsUpdate.setSelection(false);
        new FMWizardPage.ManagedWidget(this, this.wKsdsUpdate, this.params.getSystem());
        Group pdsGroup = GUI.group((Composite)parent, (String)Messages.Title_COPY_WIZARD_MEMBER_COPY_OPTIONS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        this.wReplaceMembers = GUI.button.checkbox((Composite)pdsGroup, (String)Messages._COPY_WIZARD_REPLACE_EXISTING_MEMBERS, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wReplaceMembers, this.params.getSystem());
        this.wUpdateStatistics[0] = GUI.button.radio((Composite)pdsGroup, (String)Messages._COPY_WIZARD_DO_NOT_UPDATE_ISPF_STATISTICS, (Object)GUI.grid.d.fillH((int)1));
        this.wUpdateStatistics[1] = GUI.button.radio((Composite)pdsGroup, (String)Messages._COPY_WIZARD_ONLY_UPDATE_EXISTING_ISPF_STATISTICS, (Object)GUI.grid.d.fillH((int)1));
        this.wUpdateStatistics[2] = GUI.button.radio((Composite)pdsGroup, (String)Messages._COPY_WIZARD_FORCE_UPDATING_ALL_ISPF_STATISTICS, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wUpdateStatistics, this.params.getSystem());
        this.updateControlValues();
        this.setControl((Control)parent);
    }

    @Override
    protected void updateControlValues() {
        CopyModel tempParams = this.params.clone();
        this.unselect((Control[])this.wUpdateStatistics);
        switch (tempParams.getUpdateStatistics()) {
            case OFF: {
                this.select((Control)this.wUpdateStatistics[0]);
                break;
            }
            case ON: {
                this.select((Control)this.wUpdateStatistics[1]);
                break;
            }
            case FORCE: {
                this.select((Control)this.wUpdateStatistics[2]);
                break;
            }
            default: {
                this.select((Control)this.wUpdateStatistics[1]);
            }
        }
        if (tempParams.isOverwriteExistingRecords()) {
            this.wOverwriteExistingRecords.setSelection(tempParams.isOverwriteExistingRecords());
        }
        if (tempParams.isKsdsUpdate()) {
            this.wKsdsUpdate.setSelection(tempParams.isKsdsUpdate());
        }
        this.wSkipRecords.setText(tempParams.getSkipRecords());
        this.wVsamKey.setText(tempParams.getVsamKey());
        this.wNumberRecords.setText(tempParams.getNumberRecords());
        this.wReplaceMembers.setSelection(tempParams.isReplaceMembers());
        this.wIgnoreRecordLength.setSelection(tempParams.isIgnoreRecordLength());
        this.wPack.select(ArrayUtils.findIndexOf((Object)tempParams.getPacking(), (Object[])DSC.DscPack.values(), (int)0));
    }
}

