/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.ui.dialog.MemberLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.MemberSelectionCriteriaComposite;
import com.ibm.etools.fm.ui.widget.MemberSelectionCriteriaModel;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CopyWizardPageMembers
extends FMWizardPage {
    private static final String COMMA = ",";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final CopyModel params;
    private Combo wMembersList;
    private Button wMembersListLookup;
    private MemberSelectionCriteriaComposite wMemberSelection;
    private Combo wMembersRenameList;
    private Button wMembersRenameListPreview;
    private Combo wMembersRenameMask;

    public CopyWizardPageMembers(CopyModel params) {
        super(Messages.Title_COPY_WIZARD_PAGE_MEMBERS);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_COPY_WIZARD_PAGE_MEMBERS_SPECIFY_CRITERIA);
    }

    public void setPageComplete(boolean complete) {
        boolean bl = complete = complete && this.wMemberSelection.getValidationErrorMessage() == null;
        if (complete) {
            String text2;
            if (this.wMembersList != null) {
                this.params.setMembersList(this.wMembersList.getText());
            }
            if (this.wMembersRenameList != null) {
                this.params.getMembersRenameList().clear();
                text2 = this.wMembersRenameList.getText();
                if (text2.length() > 0 && this.params.isDestDataSetWithMembers()) {
                    String[] members;
                    String[] stringArray = members = text2.split(COMMA);
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String member = stringArray[n2];
                        if (!member.isEmpty()) {
                            this.params.getMembersRenameList().add(member);
                        } else {
                            this.params.getMembersRenameList().add(null);
                        }
                        ++n2;
                    }
                }
            }
            if (this.wMembersRenameMask != null && !(text2 = this.wMembersRenameMask.getText().trim()).isEmpty()) {
                this.params.setMembersRenameMask(text2);
            }
        }
        this.setEnabledIf((Control)this.wMembersList, this.params.isSourceDataSetWithMembers());
        this.setEnabledIf((Control)this.wMembersListLookup, this.params.isSourceDataSetWithMembers());
        this.setEnabledIf((Control)this.wMembersRenameList, this.wMembersRenameMask.getText().isEmpty() && this.wMembersList.getText().length() > 0 && UIValidator.isValidMemberList(this.wMembersList.getText(), false, this.params.getSystem().getCodePage()) && !this.wMemberSelection.isMembersSelected());
        this.setEnabledIf((Control)this.wMembersRenameListPreview, complete && UIValidator.isValidMemberList(this.wMembersList.getText(), false, this.params.getSystem().getCodePage()) && this.wMembersRenameList.getText().length() > 0 && this.isWidgetValid(this.wMembersRenameList));
        this.setEnabledIf((Control)this.wMembersRenameMask, this.wMembersRenameList.getText().isEmpty() && (this.wMemberSelection.isMembersSelected() || !this.isEmpty(this.wMembersList)));
        super.setPageComplete(complete && this.memberSelectionOkay() == null);
    }

    public void setErrorMessage(String newMessage) {
        if (newMessage == null) {
            newMessage = this.wMemberSelection.getValidationErrorMessage();
        }
        if (newMessage == null) {
            newMessage = this.memberSelectionOkay();
        }
        super.setErrorMessage(newMessage);
    }

    private String memberSelectionOkay() {
        if (!(this.params.isSourceDataSetWithMembers() || this.wMembersList.getText().length() <= 0 && this.wMembersRenameList.getText().length() <= 0 && this.wMembersRenameMask.getText().length() <= 0 && this.params.getMemberSelection().isNoMemberSelected())) {
            return "No member selection allowed for specified source resource";
        }
        return null;
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 5;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)5, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)parent, (String)Messages.Label__MEMBER_LIST, (Object)GUI.grid.d.left1());
        this.wMembersList = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)3));
        new ComboValueSaver(this.wMembersList, ((Object)((Object)this)).getClass().getCanonicalName() + "MembersList");
        new FMWizardPage.ManagedWidget(this, this.wMembersList, Messages.Msg_COPY_WIZARD_PAGE_MEMBERS_MEMBER_LIST_FORMAT, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                return UIValidator.isValidMemberList(CopyWizardPageMembers.this.wMembersList.getText(), false, CopyWizardPageMembers.this.params.getSystem().getCodePage()) || UIValidator.isValidWildcardableMember(CopyWizardPageMembers.this.wMembersList.getText(), CopyWizardPageMembers.this.params.getSystem().getCodePage());
            }

            @Override
            public void onChange(Event event) {
                if (CopyWizardPageMembers.this.wMembersList.getText().isEmpty()) {
                    CopyWizardPageMembers.this.wMembersRenameList.setText("");
                    CopyWizardPageMembers.this.wMembersRenameMask.setText("");
                }
            }
        };
        this.wMembersListLookup = LookupButton.createLookupButtonLeft1(parent);
        Group memberAdvanced = GUI.group((Composite)parent, (String)Messages.Title__ADVANCED_MEMBER_SELECTION, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)5));
        this.wMemberSelection = new MemberSelectionCriteriaComposite((Composite)memberAdvanced, 0, this.params.getMemberSelection()){

            @Override
            protected void onViewUpdated() {
                CopyWizardPageMembers.this.safeValidateManagedWidgets();
            }
        };
        MemberSelectionCriteriaModel memberSelection = this.params.getMemberSelection();
        this.wMemberSelection.setLayoutData(GUI.grid.d.fillH((int)1));
        final Combo getwExcludeMembers = this.wMemberSelection.getwExcludeMembers();
        getwExcludeMembers.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (!getwExcludeMembers.getText().equals("")) {
                    CopyWizardPageMembers.this.filterMamberList(getwExcludeMembers);
                }
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.wMembersList.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (!getwExcludeMembers.getText().equals("")) {
                    CopyWizardPageMembers.this.filterMamberList(getwExcludeMembers);
                }
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.wMembersListLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MemberLookupDialog dlg = new MemberLookupDialog((DataSet)CopyWizardPageMembers.this.params.getSourceResourceZRL(), getwExcludeMembers.getText());
                if (dlg.open() == 0) {
                    CopyWizardPageMembers.this.wMembersListLookup.setFocus();
                    for (Member member : dlg.getSelectedMembers()) {
                        ArrayList<String> membersList = new ArrayList<String>(CopyWizardPageMembers.this.params.getListOfMembersToCopy());
                        if (membersList.contains(member.getName())) continue;
                        membersList.add(member.getName());
                        Collections.sort(membersList);
                        Object text2 = "";
                        for (String mem : membersList) {
                            text2 = !((String)text2).isEmpty() ? (String)text2 + CopyWizardPageMembers.COMMA + mem : mem;
                        }
                        CopyWizardPageMembers.this.wMembersList.setText((String)text2);
                    }
                }
            }
        });
        Group memberRenaming = GUI.group((Composite)parent, (String)Messages.Title__COPY_MEMBER_RENAMING, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)5));
        GUI.label.left((Composite)memberRenaming, (String)Messages.Label__BY_LIST, (Object)GUI.grid.d.left1());
        this.wMembersRenameList = GUI.combo.editable((Composite)memberRenaming, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMembersRenameList, ((Object)((Object)this)).getClass().getCanonicalName() + "MembersRenameList");
        new FMWizardPage.ManagedWidget(this, this.wMembersRenameList, Messages.Msg_COPY_WIZARD_PAGE_MEMBERS_MEMBER_RENAME_LIST_FORMAT, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                String toMembers = CopyWizardPageMembers.this.wMembersRenameList.getText();
                if (UIValidator.isValidMemberList(toMembers, true, CopyWizardPageMembers.this.params.getSystem().getCodePage())) {
                    return StringUtils.count((String)CopyWizardPageMembers.this.params.getMembersList(), (String)CopyWizardPageMembers.COMMA) >= StringUtils.count((String)toMembers, (String)CopyWizardPageMembers.COMMA);
                }
                return false;
            }

            @Override
            public void onChange(Event event) {
                if (!CopyWizardPageMembers.this.wMembersRenameList.getText().isEmpty()) {
                    CopyWizardPageMembers.this.wMembersRenameMask.setText("");
                }
            }
        };
        this.wMembersRenameListPreview = GUI.button.push((Composite)memberRenaming, (String)Messages.__PREVIEW, (Object)GUI.grid.d.left1());
        this.wMembersRenameListPreview.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                StringBuilder comparisonSb = new StringBuilder();
                String arrow = " -> ";
                String newline = "\n";
                ArrayList<String> membersList = CopyWizardPageMembers.this.params.getListOfMembersToCopy();
                int i = 0;
                while (i < membersList.size()) {
                    String member = membersList.get(i);
                    if (i >= CopyWizardPageMembers.this.params.getMembersRenameList().size()) {
                        comparisonSb.append(member).append(" -> ").append(member).append("\n");
                    } else {
                        String newMemberName = CopyWizardPageMembers.this.params.getMembersRenameList().get(i);
                        comparisonSb.append(member).append(" -> ").append(newMemberName == null ? member : newMemberName).append("\n");
                    }
                    ++i;
                }
                PDDialogs.openInfoThreadSafe((String)Messages.Title__MEMBER_RENAME_PREVIEW, (String)comparisonSb.toString());
            }
        });
        GUI.label.left((Composite)memberRenaming, (String)Messages.Label__BY_MASK, (Object)GUI.grid.d.left1());
        this.wMembersRenameMask = GUI.combo.editable((Composite)memberRenaming, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMembersRenameMask, ((Object)((Object)this)).getClass().getCanonicalName() + "MembersRenameMask");
        new FMWizardPage.ManagedWidget(this, this.wMembersRenameMask, Messages.Msg_COPY_WIZARD_PAGE_MEMBERS_MEMBER_RENAME_MASK, this.params.getSystem()){

            @Override
            protected boolean isValid() {
                if (CopyWizardPageMembers.this.wMembersList.getText().isEmpty()) {
                    return true;
                }
                String renameMask = CopyWizardPageMembers.this.wMembersRenameMask.getText();
                return !(CopyWizardPageMembers.this.wMembersRenameList.getText().length() > 0 && renameMask.length() > 0 || !UIValidator.isValidWildcardableMember(renameMask, CopyWizardPageMembers.this.params.getSystem().getCodePage()) && !renameMask.isEmpty());
            }

            @Override
            public void onChange(Event event) {
                if (!CopyWizardPageMembers.this.wMembersRenameMask.getText().isEmpty()) {
                    CopyWizardPageMembers.this.wMembersRenameList.setText("");
                }
            }
        };
        this.updateControlValues();
        this.setControl((Control)parent);
    }

    @Override
    protected void updateControlValues() {
        CopyModel tempParams = this.params.clone();
        this.wMembersList.setText(tempParams.getMembersList());
        this.wMemberSelection.getConnector().doManualViewUpdate();
        if (tempParams.getSourceResourceZRL() instanceof DataSet) {
            this.wMemberSelection.setResource(tempParams.getSourceResourceZRL());
        }
        StringBuilder renameText = new StringBuilder();
        boolean first = true;
        for (String newName : tempParams.getMembersRenameList()) {
            if (!first) {
                renameText.append(COMMA);
            }
            first = false;
            if (newName == null) continue;
            renameText.append(newName);
        }
        this.wMembersRenameList.setText(renameText.toString());
        this.wMembersRenameMask.setText(tempParams.getMembersRenameMask());
    }

    private void filterMamberList(Combo getwExcludeMembers) {
        List<String> memberList = new ArrayList<String>(Arrays.asList(this.wMembersList.getText().split(COMMA)));
        ArrayList<String> excludeList = new ArrayList<String>(Arrays.asList(getwExcludeMembers.getText().split(COMMA)));
        for (String exclude : excludeList) {
            memberList = memberList.stream().filter(s -> !s.matches(exclude.replaceAll("\\*", "\\\\w*"))).collect(Collectors.toList());
        }
        this.wMembersList.setText(String.join((CharSequence)COMMA, memberList));
    }
}

