/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.dialog.lookup.filter.DefaultLookupFilter;
import com.ibm.etools.fm.ui.dialog.lookup.filter.ILookupFilterProvider;
import com.ibm.etools.fm.ui.widget.SystemSelectionCombo;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CopyWizardPageFirst
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(CopyWizardPageFirst.class);
    private final CopyModel model;
    private CopyWizardPageFirstConnector connector = new CopyWizardPageFirstConnector();
    private Set<IPDHost> possibleHosts = new HashSet<IPDHost>();
    private ComboViewer wSourceSystemViewer;
    private Combo wSourceResource;
    private Combo wSourceResourceVolser;
    private ComboViewer wDestSystemViewer;
    private Combo wDestResource;
    private Combo wDestResourceVolser;
    private Button wAdvancedAllocation;

    public CopyWizardPageFirst(CopyModel params) {
        super(Messages.Title_COPY_WIZARD_PAGE_FIRST);
        this.model = Objects.requireNonNull(params, "Must provide a non-null params");
        this.possibleHosts = new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all());
        this.setTitle(Messages.Title_COPY_WIZARD_PAGE_FIRST);
        this.setMessage(Messages.Msg_COPY_WIZARD_PAGE_FIRST_ENTER_RESOURCE);
    }

    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group fromGroup = GUI.group((Composite)parent, (String)Messages.Title__COPY_SOURCE, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wSourceSystemViewer = SystemSelectionCombo.createSystemLabelAndComboViewer((Composite)fromGroup, this.possibleHosts, this.model.getSystem());
        GUI.label.left((Composite)fromGroup, (String)"", (Object)GUI.grid.d.left1());
        this.wSourceSystemViewer.getCombo().setEnabled(false);
        GUI.label.left((Composite)fromGroup, (String)Messages.Label__RESOURCE, (Object)GUI.grid.d.left1());
        this.wSourceResource = GUI.combo.editable((Composite)fromGroup, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)fromGroup), this.wSourceResource, (IHostProvider)this.model).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                return DefaultLookupFilter.getDatasetNameOrFallbackToZrlThenString(CopyWizardPageFirst.this.model.getSourceResourceZRL(), CopyWizardPageFirst.this.wSourceResource.getText());
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                CopyWizardPageFirst.this.model.setSourceResource(zrl);
                CopyWizardPageFirst.this.model.setHostProvider(selectedHost);
                CopyWizardPageFirst.this.model.fireModelChangeEvent();
            }
        }).types(ZRLs.getAllResourceTypesForZos()).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "SourceResource").create();
        GUI.label.left((Composite)fromGroup, (String)Messages.Label__VOLUME, (Object)GUI.grid.d.left1());
        this.wSourceResourceVolser = GUI.combo.editable((Composite)fromGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wSourceResourceVolser, ((Object)((Object)this)).getClass().getCanonicalName() + "SourceVolume");
        GUI.grid.padding((Composite)fromGroup, (int)1);
        Group toGroup = GUI.group((Composite)parent, (String)Messages.Title__COPY_DESTINATION, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wDestSystemViewer = SystemSelectionCombo.createSystemLabelAndComboViewer((Composite)toGroup, this.possibleHosts, this.model.getDestSystem());
        GUI.label.left((Composite)toGroup, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)toGroup, (String)Messages.Label__RESOURCE, (Object)GUI.grid.d.left1());
        this.wDestResource = GUI.combo.editable((Composite)toGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wDestResource.setToolTipText(Messages.CopyWizardPageFirst_DEST_TOOLTIP);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)toGroup), this.wDestResource, new IHostProvider(){

            public IPDHost getSystem() {
                return CopyWizardPageFirst.this.model.getDestSystem();
            }
        }).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                return DefaultLookupFilter.getDatasetNameOrFallbackToZrlThenString(CopyWizardPageFirst.this.model.getDestResourceZRL(), CopyWizardPageFirst.this.wDestResource.getText());
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                CopyWizardPageFirst.this.model.setDestSystem(selectedHost);
                CopyWizardPageFirst.this.model.setDestResource(zrl.getFormattedName());
                CopyWizardPageFirst.this.model.setDestResourceVolume("");
                CopyWizardPageFirst.this.model.fireModelChangeEvent();
            }
        }).allowMultiple().types(ZRLs.getAllResourceTypesForZos()).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "DestResource").create();
        GUI.label.left((Composite)toGroup, (String)Messages.Label__VOLUME, (Object)GUI.grid.d.left1());
        this.wDestResourceVolser = GUI.combo.editable((Composite)toGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wDestResourceVolser, ((Object)((Object)this)).getClass().getCanonicalName() + "DestVolume");
        GUI.grid.padding((Composite)toGroup, (int)1);
        this.wAdvancedAllocation = GUI.button.checkbox((Composite)toGroup, (String)Messages.CopyWizardPageFirst_0, (Object)GridDataFactory.swtDefaults().span(2, 1).create());
        this.wAdvancedAllocation.setToolTipText(Messages.CopyWizardPageFirst_1);
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wSourceSystemViewer.getCombo());
        this.connector.listenTo((Control)this.wSourceResource);
        this.connector.listenTo((Control)this.wSourceResourceVolser);
        this.connector.listenTo((Control)this.wDestSystemViewer.getCombo());
        this.connector.listenTo((Control)this.wDestResource);
        this.connector.listenTo((Control)this.wDestResourceVolser);
        this.connector.listenTo((Control)this.wAdvancedAllocation);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
            if (this.model.getSourceResourceZRL() == null) {
                this.wSourceResource.setFocus();
            } else if (this.model.getSourceResourceZRL() == null) {
                this.wDestResource.setFocus();
            }
        }
        super.setVisible(visible);
        if (!visible) {
            try {
                DataSet oldDataSet;
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        String validationResult = CopyWizardPageFirst.this.model.validateResourceTypes(howIsGoing);
                        if (validationResult != null) {
                            throw new IllegalArgumentException(validationResult);
                        }
                        if (CopyWizardPageFirst.this.model.getUseAdvancedAllocation()) {
                            CopyWizardPageFirst.this.model.promptToAllocate(howIsGoing);
                        }
                    }
                });
                boolean skipNextPage = true;
                if (this.model.getSourceResourceZRL() instanceof DataSet && (oldDataSet = (DataSet)this.model.getSourceResourceZRL()).getHasMembers()) {
                    skipNextPage = false;
                }
                if (skipNextPage) {
                    this.skipNextPage();
                }
                this.getContainer().getCurrentPage().setVisible(true);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                if (t instanceof IllegalArgumentException) {
                    PDDialogs.openErrorThreadSafe((String)Messages.Cannot_PROGRESS_SEE_ERROR_BELOW, (String)t.getMessage(), (Throwable)t);
                } else {
                    logger.error(t);
                }
                IWizardPage newPage = this.getWizard().getStartingPage();
                this.getContainer().showPage(newPage);
                newPage.setPreviousPage(null);
            }
        }
    }

    private void skipNextPage() {
        IWizardPage nextPage = this.getContainer().getCurrentPage();
        nextPage.setVisible(true);
        IWizardPage pageAfterNextPage = nextPage.getNextPage();
        this.getContainer().showPage(pageAfterNextPage);
        pageAfterNextPage.setPreviousPage((IWizardPage)this);
    }

    public String getValidationErrorMessage() {
        int memStart;
        if (this.model.getSystem() == null) {
            return Messages.CopyWizardPageFirst_INVALID_SYSTEM;
        }
        String sourceResource = this.model.getSourceResource();
        if (this.model.isMultipleSourceMembersSelected() && (memStart = sourceResource.indexOf("(")) >= 0) {
            sourceResource = sourceResource.substring(0, memStart);
        }
        if (!ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)sourceResource)) {
            return Messages.Msg_COPY_WIZARD_PAGE_FIRST_VALID_SOURCE_RESOURCE;
        }
        if (!ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)this.model.getDestResource())) {
            return Messages.Msg_COPY_WIZARD_PAGE_FIRST_VALID_DEST_RESOURCE;
        }
        if (this.model.getSourceResourceVolumeSet().length() > 0 && !Volume.isValid((String)this.model.getSourceResourceVolumeSet(), (String)this.model.getSystem().getCodePage())) {
            return Messages.CopyWizardPageFirst_INVALID_SOURCE_RESOURCE_VOLUME;
        }
        if (this.model.getDestResourceVolumeSet().length() > 0 && !Volume.isValid((String)this.model.getDestResourceVolumeSet(), (String)this.model.getSystem().getCodePage())) {
            return Messages.CopyWizardPageFirst_INVALID_DEST_RESOURCE_VOLUME;
        }
        if (this.model.isSourceResourceLoaded() && !this.model.isSourceDataSetWithMembers() && (this.model.getSingleSourceMemberSelected() != null || this.model.isMultipleSourceMembersSelected())) {
            return Messages.CopyWizardPageFirst_SOURCE_RESOURCE_INVALID_TYPE;
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    private class CopyWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private CopyWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (CopyWizardPageFirst.this.model.getSystem() != null) {
                IStructuredSelection selectedDestSystem;
                IStructuredSelection selectedSourceSystem;
                if (CopyWizardPageFirstConnector.focussed((Control)CopyWizardPageFirst.this.wSourceSystemViewer.getCombo()) && (selectedSourceSystem = (IStructuredSelection)CopyWizardPageFirst.this.wSourceSystemViewer.getSelection()).getFirstElement() != null) {
                    CopyWizardPageFirst.this.model.setHostProvider((IPDHost)selectedSourceSystem.getFirstElement());
                }
                if (CopyWizardPageFirstConnector.focussed((Control)CopyWizardPageFirst.this.wSourceResource)) {
                    CopyWizardPageFirst.this.model.setSourceResource(CopyWizardPageFirst.this.wSourceResource.getText());
                }
                if (CopyWizardPageFirstConnector.focussed((Control)CopyWizardPageFirst.this.wSourceResourceVolser)) {
                    CopyWizardPageFirst.this.model.setSourceResourceVolume(CopyWizardPageFirst.this.wSourceResourceVolser.getText());
                }
                if ((selectedDestSystem = (IStructuredSelection)CopyWizardPageFirst.this.wDestSystemViewer.getSelection()).getFirstElement() != null) {
                    CopyWizardPageFirst.this.model.setDestSystem((IPDHost)selectedDestSystem.getFirstElement());
                }
                if (CopyWizardPageFirstConnector.focussed((Control)CopyWizardPageFirst.this.wDestResource)) {
                    CopyWizardPageFirst.this.model.setDestResource(CopyWizardPageFirst.this.wDestResource.getText());
                }
                if (CopyWizardPageFirstConnector.focussed((Control)CopyWizardPageFirst.this.wDestResourceVolser)) {
                    CopyWizardPageFirst.this.model.setDestResourceVolume(CopyWizardPageFirst.this.wDestResourceVolser.getText());
                }
                CopyWizardPageFirst.this.model.setUseAdvancedAllocationAttributes(CopyWizardPageFirst.this.wAdvancedAllocation.getSelection());
            }
            CopyWizardPageFirst.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            CopyWizardPageFirst.this.wSourceSystemViewer.setSelection((ISelection)new StructuredSelection((Object)CopyWizardPageFirst.this.model.getSystem()));
            this.updateComboFromModelIfNeeded(CopyWizardPageFirst.this.wSourceResource, this.getSourceResourceRep());
            this.updateComboFromModelIfNeeded(CopyWizardPageFirst.this.wSourceResourceVolser, CopyWizardPageFirst.this.model.getSourceResourceVolumeSet());
            if (CopyWizardPageFirst.this.model.getDestSystem() != null) {
                CopyWizardPageFirst.this.wDestSystemViewer.setSelection((ISelection)new StructuredSelection((Object)CopyWizardPageFirst.this.model.getDestSystem()));
            }
            this.updateComboFromModelIfNeeded(CopyWizardPageFirst.this.wDestResource, CopyWizardPageFirst.this.model.getDestResource());
            this.updateComboFromModelIfNeeded(CopyWizardPageFirst.this.wDestResourceVolser, CopyWizardPageFirst.this.model.getDestResourceVolumeSet());
            this.updateButtonSelectionFromModelIfNeeded(CopyWizardPageFirst.this.wAdvancedAllocation, CopyWizardPageFirst.this.model.getUseAdvancedAllocation());
            String validationErrorMessage = CopyWizardPageFirst.this.getValidationErrorMessage();
            CopyWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            CopyWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }

        public String getSourceResourceRep() {
            Object oldResourceText = CopyWizardPageFirst.this.model.getSourceResource();
            if (CopyWizardPageFirst.this.model.getSingleSourceMemberSelected() != null) {
                oldResourceText = (String)oldResourceText + "(" + CopyWizardPageFirst.this.model.getSingleSourceMemberSelected() + ")";
            } else if (CopyWizardPageFirst.this.model.isMultipleSourceMembersSelected()) {
                oldResourceText = (String)oldResourceText + "(...)";
            }
            return oldResourceText;
        }
    }
}

