/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import java.text.MessageFormat;
import java.util.Objects;

public class CopyRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final CopyModel model;

    public CopyRunnable(CopyModel model) {
        this.model = model;
    }

    @Override
    protected String getName() {
        return Messages.CopyRunnable_TASK_NAME;
    }

    @Override
    protected boolean preWizardClose(IHowIsGoing monitor) {
        block11: {
            block10: {
                block9: {
                    if (this.model.getUseAdvancedAllocation()) {
                        try {
                            this.model.promptToAllocate(monitor);
                            return true;
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                    FMHost.loadHostVersion((IPDHost)this.model.getHostProvider(), (IHowIsGoing)monitor);
                    FMHost.loadHostVersion((IPDHost)this.model.getDestSystem(), (IHowIsGoing)monitor);
                    FMHost.loadHostVersion((IPDHost)this.model.getSourceTemplate().getHostProvider(), (IHowIsGoing)monitor);
                    FMHost.loadHostVersion((IPDHost)this.model.getDestTemplate().getHostProvider(), (IHowIsGoing)monitor);
                    if (!this.model.getHostProvider().equals(this.model.getDestSystem()) || !this.model.getHostProvider().equals(this.model.getSourceTemplate().getHostProvider()) || !this.model.getHostProvider().equals(this.model.getDestTemplate().getHostProvider())) break block9;
                    return true;
                }
                if (this.model.getHostProvider().isSameSystem(this.model.getDestSystem()) || this.model.getHostProvider().isSameSecurity(this.model.getDestSystem())) break block10;
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CopyRunnable_INVALID_SSL_CONFIG, this.model.getDestSystem().toString(), this.model.getHostProvider().toString()));
                return false;
            }
            if (this.model.getHostProvider().isSameSystem(this.model.getSourceTemplate().getHostProvider()) || this.model.getHostProvider().isSameSecurity(this.model.getSourceTemplate().getHostProvider())) break block11;
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CopyRunnable_INVALID_SSL_CONFIG, this.model.getSourceTemplate().getHostProvider().toString(), this.model.getHostProvider().toString()));
            return false;
        }
        try {
            if (!this.model.getHostProvider().isSameSystem(this.model.getDestTemplate().getHostProvider()) && !this.model.getHostProvider().isSameSecurity(this.model.getDestTemplate().getHostProvider())) {
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CopyRunnable_INVALID_SSL_CONFIG, this.model.getDestTemplate().getHostProvider().toString()));
                return false;
            }
        }
        catch (CommunicationException | InterruptedException e) {
            logger.error(e);
            FMDialogWithText.showResultDump((Result<StringBuffer>)new Result(e), true, 0);
            return false;
        }
        return true;
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result<StringBuffer> result;
        monitor.beginTask(this.getName(), 3);
        monitor.worked(1);
        try {
            result = this.model.execute(monitor);
        }
        catch (InterruptedException e) {
            result = null;
        }
        monitor.worked(1);
        if (result != null && result.getRC() <= 4) {
            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)this.model.getDestResourceZRL());
        }
        monitor.done();
        return result;
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().getRC() <= 4;
    }

    @Override
    public void showResult() {
        Result<StringBuffer> result = this.getResult();
        if (!this.model.getHostProvider().equals(this.model.getDestSystem())) {
            result = CopyRunnable.prependUsersAndSystemNamesToMessages(this.model.getHostProvider(), this.model.getDestSystem(), result, Messages.CopyRunnable_1);
        }
        FMDialogWithText.showResultDump(result, false, 0);
    }

    public static Result<StringBuffer> prependUsersAndSystemNamesToMessages(IPDHost src, IPDHost dest, Result<?> result, String operation) {
        Objects.requireNonNull(operation);
        Result temp = new Result();
        try {
            temp.add(operation + MessageFormat.format("{0}@{1} to {2}@{3}", src.getLogin(false).getUsername(), src, dest.getLogin(false).getUsername(), dest));
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
        }
        temp.addSubResult(result);
        return temp;
    }
}

