/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.data.UssFileProperties;
import com.ibm.etools.fm.core.socket.func.DSC;
import com.ibm.etools.fm.core.socket.func.DSP;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.SET;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.io.RemoteServicesCall;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.views.systems.FMSystemsTreeUpdater;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.widget.MemberSelectionCriteriaModel;
import com.ibm.etools.fm.ui.widget.TemplateWithOffsetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetActionItem;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizard;
import com.ibm.etools.fm.ui.wizards.AllocateHFSModel;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.core.model.IRefreshable;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public class CopyModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MULTI_MEMBER_PLACEHOLDER = "...";
    private String sourceResource = "";
    private IRefreshable sourceResourceLoaded = null;
    private String sourceResourceVolume = "";
    private IPDHost destSystem = null;
    private String destResource = "";
    private IRefreshable destResourceLoaded = null;
    private String destResourceVolume = "";
    private boolean useAdvancedAllocation = false;
    private String membersList = "";
    private MemberSelectionCriteriaModel memberSelection = new MemberSelectionCriteriaModel(this.getSystem());
    private List<String> membersRenameList = new ArrayList<String>();
    private String membersRenameMask = "";
    private TemplateWithOffsetModel sourceTemplate = new TemplateWithOffsetModel(this.getSystem());
    private TemplateWithOffsetModel destTemplate = new TemplateWithOffsetModel(this.getSystem());
    private boolean useDefaultMappingCopyCorresponding = false;
    private String skipRecords = "";
    private String vsamKey = "";
    private String numberRecords = "";
    private DSC.DscPack packing = DSC.DscPack.ASIS;
    private boolean overwriteExistingRecords = false;
    private boolean ksdsUpdate = false;
    private boolean ignoreRecordLength = false;
    private DSC.DscStats updateStatistics = DSC.DscStats.ON;
    private boolean replaceMembers = false;
    private String sourceBinaryRecordLength = "";
    private boolean sourceAdjustStart = false;
    private boolean sourceIOExitSpecified = false;
    private String sourceIOExit = "";
    private String destBinaryRecordLength = "";
    private boolean destAdjustStart = false;
    private boolean destIOExitSpecified = false;
    private String destIOExit = "";
    private String sampleSkip = "";
    private String sampleInclude = "";
    private boolean formatInXml = false;
    private DSC.DscNprtChar nonPrintableChar = DSC.DscNprtChar.DOT;
    private String nonPrintableCharReplacementChar = "";
    private DSC.DscSpecChar specialChar = DSC.DscSpecChar.UNDERSCORE;
    private String specialCharReplacementChar = "";
    private DSC.DscInvData invalidData = DSC.DscInvData.ASTERISK;
    private String invalidDataReplacementChar = "";
    private String indent = (String)DSC.INDENT.getDefaultValue();
    private boolean fillers = false;
    private boolean redefines = false;
    private boolean unicode = false;
    private boolean linesplit = false;
    private boolean includeMd = false;
    private boolean mqReadDestructive = false;
    private boolean importFile = false;
    private String resource;
    private String template;
    private boolean includeHeader;
    private boolean specifyDoubleBytes;
    private boolean singleQuotes;

    public CopyModel(IPDHost host) {
        super(host);
        this.destSystem = host;
    }

    public DSC toUtilityFunction() {
        DSC dsc = new DSC();
        if (this.importFile) {
            this.buildDSCForFileImport(dsc);
        } else {
            IZRL sourceResource = this.getSourceResourceZRL();
            if (sourceResource != null) {
                Volume volume;
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.DSNIN, (Object)sourceResource.getFormattedName(), this.getSystem());
                if (sourceResource instanceof DataSet && (volume = ((DataSet)sourceResource).getVolume()) != null) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.VOLSERIN, (Object)volume.getVolserID(), this.getSystem());
                }
            }
            MemberSelectionCriteriaModel mscm = this.getMemberSelection();
            IZRL destResource = this.getDestResourceZRL();
            if (destResource != null) {
                Volume volume;
                if (destResource instanceof DataSet && (volume = ((DataSet)destResource).getVolume()) != null) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.VOLSEROUT, (Object)volume.getVolserID(), this.getSystem());
                }
                if (!this.getMembersList().isEmpty()) {
                    ArrayList<String> listOfSrcMembers = this.getListOfMembersToCopy();
                    if (listOfSrcMembers.size() > 0 || this.getMembersRenameList().size() > 0) {
                        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CPYMBR, (Object)CopyModel.buildCpyMbr(this.getListOfMembersToCopy(), mscm.isRangesInUse() ? Collections.emptyList() : this.getMembersRenameList()), this.getSystem());
                    }
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.DSNOUT, (Object)destResource.getFormattedName(), this.getSystem());
                } else if (this.getMembersRenameList().size() == 1) {
                    String memberName = this.getMembersRenameList().get(0);
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.DSNOUT, (Object)(String.valueOf(destResource) + "(" + memberName + ")"), this.getSystem());
                } else {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.DSNOUT, (Object)destResource.getFormattedName(), this.getSystem());
                }
            }
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.MEMOUT, (Object)this.getMembersRenameMask().toUpperCase(), this.getSystem());
            if (mscm.isUsingRange()) {
                if (mscm.getMembersRangeStart().equals(mscm.getMembersRangeEnd())) {
                    if (!mscm.getMembersRangeStart().isEmpty()) {
                        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CPYMBR, (Object)mscm.getMembersRangeStart(), this.getSystem());
                    }
                } else {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.MEMSTART, (Object)mscm.getMembersRangeStart(), this.getSystem());
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.MEMEND, (Object)mscm.getMembersRangeEnd(), this.getSystem());
                }
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            if (mscm.isUsingCreated()) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CRESTART, (Object)dateFormat.format(mscm.getMembersCreatedStart().getTime()), this.getSystem());
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CREEND, (Object)dateFormat.format(mscm.getMembersCreatedEnd().getTime()), this.getSystem());
            }
            if (mscm.isUsingChanged()) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CHGSTART, (Object)dateFormat.format(mscm.getMembersChangedStart().getTime()), this.getSystem());
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CHGEND, (Object)dateFormat.format(mscm.getMembersChangedEnd().getTime()), this.getSystem());
            }
            if (mscm.isUsingUserID()) {
                if (mscm.getMembersUserIDStart().equals(mscm.getMembersUserIDEnd())) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.USERID, (Object)mscm.getMembersUserIDStart(), this.getSystem());
                } else {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.UIDSTART, (Object)mscm.getMembersUserIDStart(), this.getSystem());
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.UIDEND, (Object)mscm.getMembersUserIDEnd(), this.getSystem());
                }
            }
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.DIRINTEGR, (Object)true, this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.BINRECIN, (Object)this.getSourceBinaryRecordLength(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.INRDW, (Object)this.isSourceAdjustStart(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.USEIOXIN, (Object)this.isSourceIOExitSpecified(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.IOXIN, (Object)this.getSourceIOExit(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.BINRECOUT, (Object)this.getDestBinaryRecordLength(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.OUTRDW, (Object)this.isDestAdjustStart(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.STATS, (Object)this.getUpdateStatistics(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.DISP, (Object)(this.isOverwriteExistingRecords() ? DSC.DscDisp.OLD : DSC.DscDisp.MOD), this.getSystem());
            if (!this.getSkipRecords().isEmpty()) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.POSITION, (Object)this.getSkipRecords(), this.getSystem());
            } else {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.KEY, (Object)this.getVsamKey(), this.getSystem());
            }
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.SMPLINCL, (Object)this.getSampleInclude(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.SMPLSKIP, (Object)this.getSampleSkip(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.NLRECS, (Object)this.getNumberRecords(), this.getSystem());
            if (this.getSourceTemplate().getTemplate() != null && this.getDestTemplate().getTemplate() != null) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CORRESP, (Object)this.isUseDefaultMappingCopyCorresponding(), this.getSystem());
            }
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.REPLACE, (Object)this.isReplaceMembers(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.IGNLEN, (Object)this.isIgnoreRecordLength(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.PACK, (Object)this.getPacking(), this.getSystem());
            if (this.getSourceTemplate().getTemplate() != null) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.TCIN, (Object)this.getSourceTemplate().getTemplate().getFormattedName(), this.getSystem());
            }
            if (!this.getSourceTemplate().getOffsets().isEmpty()) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.OFFSETIN, (Object)this.getSourceTemplate().getOffsetsForHost(), this.getSystem());
            }
            if (this.getDestTemplate().getTemplate() != null) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.TCOUT, (Object)this.getDestTemplate().getTemplate().getFormattedName(), this.getSystem());
            }
            if (!this.getDestTemplate().getOffsets().isEmpty()) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.OFFSETOUT, (Object)this.getDestTemplate().getOffsetsForHost(), this.getSystem());
            }
            if (this.isFormatInXml()) {
                if (this.isFormatInXml()) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.FORMAT, (Object)"XML", this.getSystem());
                }
                if (this.getNonPrintableChar() == DSC.DscNprtChar.REPLACING_CHARACTER) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.NPRTCHAR, (Object)this.getNonPrintableCharReplacementChar(), this.getSystem());
                } else if (this.getNonPrintableChar() == DSC.DscNprtChar.DOT) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.NPRTCHAR, (Object)".", this.getSystem());
                } else {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.NPRTCHAR, (Object)this.getNonPrintableChar().name(), this.getSystem());
                }
                if (this.getSpecialChar() == DSC.DscSpecChar.REPLACING_CHARACTER) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.SPECCHAR, (Object)this.getSpecialCharReplacementChar(), this.getSystem());
                } else if (this.getSpecialChar() == DSC.DscSpecChar.UNDERSCORE) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.SPECCHAR, (Object)"_", this.getSystem());
                } else {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.SPECCHAR, (Object)this.getSpecialChar().name(), this.getSystem());
                }
                if (this.getInvalidData() == DSC.DscInvData.REPLACING_CHARACTER) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.INVDATA, (Object)this.getInvalidDataReplacementChar(), this.getSystem());
                } else if (this.getInvalidData() == DSC.DscInvData.ASTERISK) {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.INVDATA, (Object)"*", this.getSystem());
                } else {
                    dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.INVDATA, (Object)this.getInvalidData().name(), this.getSystem());
                }
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.INDENT, (Object)this.getIndent(), this.getSystem());
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.FILLERS, (Object)this.isFillers(), this.getSystem());
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.REDEFINES, (Object)this.isRedefines(), this.getSystem());
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.UNICODE, (Object)this.isUnicode(), this.getSystem());
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.LINESPLIT, (Object)this.isLinesplit(), this.getSystem());
            }
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.INCLUDEMD, (Object)this.isIncludeMd(), this.getSystem());
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.MQDESTRUCTIVEREAD, (Object)this.getMqDestructiveRead(), this.getSystem());
            if (this.isKsdsUpdate()) {
                dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.KSDSUPD, (Object)true, this.getSystem());
            }
        }
        return dsc;
    }

    private void buildDSCForFileImport(DSC dsc) {
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.FMIBUF, (Object)true, this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CSVIMP, (Object)true, this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CSVIHDR, (Object)this.includeHeader, this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.REPLACE, (Object)this.isReplaceMembers(), this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.DISP, (Object)(this.isOverwriteExistingRecords() ? DSC.DscDisp.OLD : DSC.DscDisp.MOD), this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.TCIN, (Object)this.template, this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.DSNOUT, (Object)this.resource, this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CSVIFILL, (Object)this.fillers, this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CSVISNGL, (Object)this.singleQuotes, this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CSVIRDF, (Object)this.redefines, this.getSystem());
        dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.CSVIDBCS, (Object)this.specifyDoubleBytes, this.getSystem());
        if (this.destResourceVolume != null && !this.destResourceVolume.isEmpty()) {
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.VOLSEROUT, (Object)this.destResourceVolume, this.getSystem());
        }
    }

    public void fromUtilityFunction(DSC dsc) {
        this.setSourceResource((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.DSNIN, this.getSystem()));
        this.setSourceResourceVolume((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.VOLSERIN, this.getSystem()));
        MemberSelectionCriteriaModel mscm = this.getMemberSelection();
        String cpyMbr = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.CPYMBR, this.getSystem());
        ArrayList<String> parsedSrcMemberNames = new ArrayList<String>();
        ArrayList<String> parsedDestMemberNames = new ArrayList<String>();
        CopyModel.parseCpyMbr(cpyMbr, parsedSrcMemberNames, parsedDestMemberNames);
        StringBuilder memList = new StringBuilder();
        for (String parsedSrcMemberName : parsedSrcMemberNames) {
            memList.append(",");
            if (parsedSrcMemberName == null) continue;
            memList.append(parsedSrcMemberName);
        }
        this.setMembersList(memList.toString());
        this.setMembersRenameList(parsedDestMemberNames);
        if (parsedSrcMemberNames.size() == 1) {
            mscm.setUsingRange(true);
        }
        String dsnOut = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.DSNOUT, this.getSystem());
        IZRL parsedDsnOut = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)dsnOut);
        if (parsedDsnOut instanceof Member) {
            this.setDestResource(((Member)parsedDsnOut).asDataSet().getFormattedName());
            String memName = parsedDsnOut.getName();
            if (!this.getMembersRenameList().contains(memName)) {
                this.getMembersRenameList().add(memName);
            }
        } else {
            this.setDestResource(parsedDsnOut.getFormattedName());
        }
        this.setMembersRenameMask((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.MEMOUT, this.getSystem()));
        this.setDestResourceVolume((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.VOLSEROUT, this.getSystem()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String memStart = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.MEMSTART, this.getSystem());
        String memEnd = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.MEMEND, this.getSystem());
        mscm.setUsingRange(memStart.length() > 0 && memEnd.length() > 0);
        mscm.setMembersRangeStart(memStart);
        mscm.setMembersRangeEnd(memEnd);
        String creStart = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CRESTART, this.getSystem());
        String creEnd = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CREEND, this.getSystem());
        mscm.setUsingCreated(creStart.length() > 0 && creEnd.length() > 0);
        mscm.setMembersCreatedStart(creStart, dateFormat);
        mscm.setMembersCreatedEnd(creEnd, dateFormat);
        String chgStart = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CHGSTART, this.getSystem());
        String chgEnd = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.CHGEND, this.getSystem());
        mscm.setUsingChanged(chgStart.length() > 0 && chgEnd.length() > 0);
        mscm.setMembersChangedStart(chgStart, dateFormat);
        mscm.setMembersChangedEnd(chgEnd, dateFormat);
        String userId = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.USERID, this.getSystem());
        String uidStart = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.UIDSTART, this.getSystem());
        String uidEnd = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSP.UIDEND, this.getSystem());
        if (!userId.isEmpty()) {
            mscm.setUsingUserID(true);
            mscm.setMembersUserIDStart(userId);
            mscm.setMembersUserIDEnd(userId);
        } else {
            mscm.setUsingUserID(uidStart.length() > 0 && uidEnd.length() > 0);
            mscm.setMembersUserIDStart(uidStart);
            mscm.setMembersUserIDEnd(uidEnd);
        }
        this.setSourceBinaryRecordLength((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.BINRECIN, this.getSystem()));
        this.setSourceAdjustStart((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.INRDW, this.getSystem()));
        this.setSourceIOExitSpecified((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.USEIOXIN, this.getSystem()));
        this.setSourceIOExit((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.IOXIN, this.getSystem()));
        this.setDestBinaryRecordLength((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.BINRECOUT, this.getSystem()));
        this.setDestAdjustStart((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.OUTRDW, this.getSystem()));
        this.setUpdateStatistics((DSC.DscStats)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.STATS, this.getSystem()));
        this.setOverwriteExistingRecords(dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.DISP, this.getSystem()) == DSC.DscDisp.OLD);
        if (this.isKsdsUpdate()) {
            dsc.setValue((NewUtilityFunction.IUtilFuncParam)DSC.KSDSUPD, (Object)true, this.getSystem());
        }
        this.setSkipRecords((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.POSITION, this.getSystem()));
        this.setVsamKey((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.KEY, this.getSystem()));
        this.setSampleInclude((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.SMPLINCL, this.getSystem()));
        this.setSampleSkip((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.SMPLSKIP, this.getSystem()));
        this.setNumberRecords((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.NLRECS, this.getSystem()));
        this.setUseDefaultMappingCopyCorresponding((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.CORRESP, this.getSystem()));
        this.setReplaceMembers((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.REPLACE, this.getSystem()));
        this.setIgnoreRecordLength((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.IGNLEN, this.getSystem()));
        this.setPacking((DSC.DscPack)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.PACK, this.getSystem()));
        this.getSourceTemplate().setTemplate((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.TCIN, this.getSystem()));
        this.getSourceTemplate().setOffset((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.OFFSETIN, this.getSystem()));
        this.getDestTemplate().setTemplate((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.TCOUT, this.getSystem()));
        this.getDestTemplate().setOffset((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.OFFSETOUT, this.getSystem()));
        this.setFormatInXml("XML".equals(dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.FORMAT, this.getSystem())));
        String nprtChar = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.NPRTCHAR, this.getSystem());
        try {
            this.setNonPrintableChar(DSC.DscNprtChar.valueOf((String)nprtChar));
        }
        catch (IllegalArgumentException e) {
            this.setNonPrintableChar(DSC.DscNprtChar.REPLACING_CHARACTER);
            this.setNonPrintableCharReplacementChar(nprtChar);
        }
        String specChar = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.SPECCHAR, this.getSystem());
        try {
            this.setSpecialChar(DSC.DscSpecChar.valueOf((String)specChar));
        }
        catch (IllegalArgumentException e) {
            this.setSpecialChar(DSC.DscSpecChar.REPLACING_CHARACTER);
            this.setSpecialCharReplacementChar(specChar);
        }
        String invData = (String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.INVDATA, this.getSystem());
        try {
            this.setInvalidData(DSC.DscInvData.valueOf((String)invData));
        }
        catch (IllegalArgumentException e) {
            this.setInvalidData(DSC.DscInvData.REPLACING_CHARACTER);
            this.setInvalidDataReplacementChar(invData);
        }
        this.setIndent((String)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.INDENT, this.getSystem()));
        this.setFillers((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.FILLERS, this.getSystem()));
        this.setRedefines((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.REDEFINES, this.getSystem()));
        this.setUnicode((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.UNICODE, this.getSystem()));
        this.setLinesplit((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.LINESPLIT, this.getSystem()));
        this.setIncludeMd((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.INCLUDEMD, this.getSystem()));
        this.setMqDestructiveRead((Boolean)dsc.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSC.MQDESTRUCTIVEREAD, this.getSystem()));
    }

    public static String buildCpyMbr(List<String> srcMemberNames, List<String> destMemberNames) {
        Objects.requireNonNull(srcMemberNames, "Must provide a non-null srcMemberNames.");
        StringBuilder cpyMbr = new StringBuilder();
        int i = 0;
        while (i < srcMemberNames.size()) {
            String newMemberName;
            if (i > 0) {
                cpyMbr.append(",");
            }
            cpyMbr.append(srcMemberNames.get(i));
            if (i < destMemberNames.size() && (newMemberName = destMemberNames.get(i)) != null) {
                cpyMbr.append("(").append(newMemberName).append(")");
            }
            ++i;
        }
        return cpyMbr.toString().toUpperCase();
    }

    public static void parseCpyMbr(String cpyMbr, List<String> srcMemberNamesOut, List<String> destMemberNamesOut) {
        if (!cpyMbr.isEmpty()) {
            String[] cpyMbrEntries;
            String[] stringArray = cpyMbrEntries = cpyMbr.split(",");
            int n = cpyMbrEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String cpyMbrEntry = stringArray[n2];
                String newName = null;
                String name = null;
                int newNameStart = cpyMbrEntry.indexOf("(");
                int newNameEnd = cpyMbrEntry.indexOf(")");
                if (newNameEnd < newNameStart) {
                    throw new IllegalArgumentException(cpyMbr);
                }
                if (newNameStart >= 0 && newNameStart < newNameEnd) {
                    name = cpyMbrEntry.substring(0, newNameStart);
                    newName = cpyMbrEntry.substring(newNameStart + 1, newNameEnd);
                } else {
                    name = cpyMbrEntry;
                }
                srcMemberNamesOut.add(name);
                destMemberNamesOut.add(newName);
                ++n2;
            }
        }
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        IZRL dest = this.getDestResourceZRL();
        if (dest instanceof UssFile) {
            UssFile destFile;
            Result result;
            String permissions = "600";
            IZRL source = this.getSourceResourceZRL();
            if (source instanceof UssFile) {
                UssFile srcFile = (UssFile)source;
                result = srcFile.refreshSelf(monitor);
                if (result.hasError()) {
                    return new Result(result);
                }
                UssFileProperties props = srcFile.getProperties();
                if (props != null) {
                    permissions = props.getPropertyValue("Access");
                }
            }
            if ((result = (destFile = (UssFile)dest).refreshExistence(monitor)).hasError()) {
                return new Result(result);
            }
            if (!destFile.getConfirmedExists()) {
                AllocateHFSModel ufal = new AllocateHFSModel(destFile.getSystem(), dest.getFormattedName(), permissions);
                Result<StringBuffer> allocateHfsFileResult = ufal.execute(monitor);
                if (allocateHfsFileResult.hasError()) {
                    return allocateHfsFileResult;
                }
                FMSystemsTreeUpdater.refreshFilesRelatedTo(destFile);
            }
        }
        DSC dsc = this.toUtilityFunction();
        this.applySystemOptions(monitor);
        this.applyPrintOptions(monitor);
        RemoteServicesCall remoteCall = new RemoteServicesCall((NewUtilityFunction)dsc, this.getHostProvider(), this.getDestSystem(), (NewUtilityFunction.AbstractUtilFuncParam)DSC.DSNOUT);
        if (this.sourceTemplate.getTemplate() != null) {
            remoteCall.addParameterMapping(this.sourceTemplate.getHostProvider(), (NewUtilityFunction.AbstractUtilFuncParam)DSC.TCIN);
        }
        if (this.destTemplate.getTemplate() != null) {
            remoteCall.addParameterMapping(this.destTemplate.getHostProvider(), (NewUtilityFunction.AbstractUtilFuncParam)DSC.TCOUT);
        }
        return remoteCall.run(monitor);
    }

    private void applyPrintOptions(IHowIsGoing monitor) {
        try {
            IEclipsePreferences systemOptsPrefs = InstanceScope.INSTANCE.getNode("com.ibm.etools.fm.ui.prefs.prtopts");
            Preferences node = systemOptsPrefs.node(this.getHostProvider().getDescription());
            String pageSkipVal = node.get("pageskip", "YES");
            String dumpVal = node.get("dump", "UPDOWN");
            String dataHdrVal = node.get("datahdr", "YES");
            String recLimitVal = node.get("reclimit", "(1,*)");
            String printLenVal = node.get("reclength", "80");
            String printTransVal = node.get("pagetrans", "ON");
            String headerPagVal = node.get("headerpage", "YES");
            SET set = new SET();
            set.setPageSkip(pageSkipVal);
            set.setPrintLen(Integer.parseInt(printLenVal));
            set.setDumpVal(dumpVal);
            set.setDataHdr(dataHdrVal);
            set.setRecLimit(recLimitVal);
            set.setPrintTrans(printTransVal);
            set.setHeaderPage(headerPagVal);
            Result result = UtilityFunctionRunner.execute((IPDHost)this.getHostProvider(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getHostProvider()), (UtilityFunction)set, (IHowIsGoing)monitor);
            if (result.getRC() != 0) {
                System.out.println(result.getDisplayMessage());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void applySystemOptions(IHowIsGoing monitor) {
        try {
            IEclipsePreferences systemOptsPrefs = InstanceScope.INSTANCE.getNode("com.ibm.etools.fm.ui.prefs.sysopts");
            Preferences node = systemOptsPrefs.node(this.getHostProvider().getDescription());
            String pad = node.get("pad", "ON");
            String notrunc = node.get("notrunc", "YES");
            SET set = new SET();
            set.setPAD(pad);
            set.setNotTrunc(notrunc);
            Result result = UtilityFunctionRunner.execute((IPDHost)this.getHostProvider(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getHostProvider()), (UtilityFunction)set, (IHowIsGoing)monitor);
            if (result.getRC() != 0) {
                System.out.println(result.getDisplayMessage());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void promptToAllocate(IHowIsGoing howIsGoing) throws InterruptedException {
        DataSetOrMember dsom;
        Result r;
        if (this.getUseAdvancedAllocation() && this.getDestResourceZRL() != null && this.getDestResourceZRL() instanceof DataSetOrMember && (r = (dsom = (DataSetOrMember)this.getDestResourceZRL()).refreshSelf(howIsGoing)).isSuccessfulWithoutWarnings() && !dsom.getConfirmedExists()) {
            final AtomicInteger result = new AtomicInteger();
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AllocateDataSetModel allocateParams = new AllocateDataSetModel();
                    if (CopyModel.this.getSourceResourceZRL() instanceof DataSetOrMember) {
                        DataSet dataSet = ((DataSetOrMember)CopyModel.this.getSourceResourceZRL()).asDataSet();
                        if (dataSet.getProperties() == null || dataSet.getProperties().getPropertyCount() == 0) {
                            try {
                                ZrlLoaderDialogUtils.refreshDataSetProperties((DataSetOrMember)dataSet);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        allocateParams.setAllocateLike(dataSet);
                        allocateParams.setAllocateLikeSystem(dataSet.getSystem());
                        allocateParams.setDataSetName(CopyModel.this.getDestResource());
                    }
                    allocateParams.setHost(CopyModel.this.getDestSystem());
                    AllocateDataSetWizard wizard = AllocateDataSetWizard.create(allocateParams);
                    final AllocateDataSetActionItem action = new AllocateDataSetActionItem(allocateParams, CopyModel.this.getDestSystem());
                    wizard.getRunnable().addCallback(new Runnable(){

                        @Override
                        public void run() {
                            FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
                        }
                    });
                    wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
                    result.set(PDScrollableWizardDialog.openWizard((IWizard)wizard));
                }
            });
            if (result.get() == 1) {
                throw new InterruptedException();
            }
        }
    }

    public void setHostProvider(IPDHost newProvider) {
        this.sourceResourceLoaded = null;
        this.destResourceLoaded = null;
        super.setHostProvider(newProvider);
    }

    public String validateResourceTypes(IHowIsGoing monitor) throws InterruptedException {
        IZRL destResource;
        IZRL sourceResource = this.getSourceResourceZRL();
        if (sourceResource instanceof DataSetOrMember) {
            DataSet sourceDataSet = ((DataSetOrMember)sourceResource).asDataSet();
            if (!(this.sourceResourceLoaded instanceof DataSet && sourceResource.equals(this.sourceResourceLoaded) && sourceDataSet.getAllVolumes().equals(((DataSet)this.sourceResourceLoaded).getAllVolumes()) && sourceDataSet.getConfirmedExists())) {
                sourceDataSet.refreshExistence(monitor);
                this.sourceResourceLoaded = sourceDataSet;
            }
            if (!sourceDataSet.getConfirmedExists()) {
                return Messages.CopyWizardPageFirst_SOURCE_RESOURCE_NOT_FOUND;
            }
            if (!sourceDataSet.getHasMembers()) {
                this.getMemberSelection().clear();
                this.setMembersList("");
            }
        } else if (sourceResource instanceof CicsFile) {
            CicsFile sourceCicsFile = (CicsFile)sourceResource;
            if (!(this.sourceResourceLoaded instanceof CicsFile) || !sourceCicsFile.equals((Object)this.sourceResourceLoaded)) {
                sourceCicsFile.refreshSelf(monitor);
                this.sourceResourceLoaded = sourceCicsFile;
            }
            if (!sourceCicsFile.getConfirmedExists()) {
                return Messages.CopyWizardPageFirst_SOURCE_RESOURCE_NOT_FOUND;
            }
            if (!sourceCicsFile.isOpen()) {
                return Messages.DSCCommand_SOURCE_IS_CLOSED_CICS_FILE;
            }
        }
        if ((destResource = this.getDestResourceZRL()) instanceof DataSetOrMember) {
            DataSet destDataSet = ((DataSetOrMember)destResource).asDataSet();
            if (!(this.destResourceLoaded instanceof DataSet && destResource.equals(this.destResourceLoaded) && destDataSet.getAllVolumes().equals(((DataSet)this.destResourceLoaded).getAllVolumes()) && destDataSet.getConfirmedExists())) {
                destDataSet.refreshExistence(monitor);
                this.destResourceLoaded = destDataSet;
            }
        } else if (destResource instanceof CicsFile) {
            CicsFile destCicsFile = (CicsFile)destResource;
            if (!(this.destResourceLoaded instanceof CicsFile) || !destCicsFile.equals((Object)this.destResourceLoaded)) {
                destCicsFile.refreshSelf(monitor);
                this.destResourceLoaded = destCicsFile;
            }
            if (!destCicsFile.getConfirmedExists()) {
                return Messages.DSCCommand_DEST_DOES_NOT_EXIST;
            }
            if (!destCicsFile.isOpen()) {
                return Messages.DSCCommand_DEST_IS_CLOSED_CICS_FILE;
            }
        }
        return null;
    }

    public ArrayList<String> getListOfMembersToCopy() {
        ArrayList<String> listOfMembers = new ArrayList<String>(Arrays.asList(this.getMembersList().split(",")));
        return listOfMembers;
    }

    public boolean isSourceDataSetWithMembers() {
        IZRL src = this.getSourceResourceZRL();
        if (src instanceof DataSet) {
            return ((DataSet)src).getHasMembers();
        }
        return false;
    }

    private IZRL getSourceResourceParsed() {
        IZRL parsedResource = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.sourceResource);
        if (parsedResource instanceof DataSet && Volume.isValid((String)this.sourceResourceVolume, (String)this.getSystem().getCodePage())) {
            ((DataSet)parsedResource).setVolume(Volume.create((IPDHost)this.getSystem(), (String)this.sourceResourceVolume));
        }
        return parsedResource;
    }

    public boolean isSourceResourceLoaded() {
        boolean useLoadedResource = false;
        if (this.sourceResourceLoaded instanceof DataSet && ((DataSet)this.sourceResourceLoaded).equalsWithVolumes((Object)this.getSourceResourceParsed())) {
            useLoadedResource = true;
        } else if (this.sourceResourceLoaded instanceof CicsFile && this.sourceResourceLoaded.equals(this.getSourceResourceParsed())) {
            useLoadedResource = true;
        }
        return useLoadedResource;
    }

    public String getSourceResource() {
        return this.sourceResource;
    }

    public IZRL getSourceResourceZRL() {
        if (this.getSystem() != null && ZRLs.isParseable((IPDHost)this.getSystem(), (String)this.sourceResource)) {
            if (this.isSourceResourceLoaded()) {
                return this.sourceResourceLoaded;
            }
            return this.getSourceResourceParsed();
        }
        return null;
    }

    public void setSourceResource(IZRL sourceZrl) {
        DataSet sourceDataSet;
        this.setMembersList("");
        this.getMemberSelection().clear();
        this.sourceResource = sourceZrl.getFormattedName();
        if (sourceZrl instanceof IRefreshable && ((IRefreshable)sourceZrl).getConfirmedExists()) {
            this.sourceResourceLoaded = (IRefreshable)sourceZrl;
        }
        DataSet dataSet = sourceDataSet = sourceZrl instanceof DataSet ? (DataSet)sourceZrl : null;
        if (sourceZrl instanceof Member) {
            Member member = (Member)sourceZrl;
            sourceDataSet = member.asDataSet();
            this.sourceResource = sourceDataSet.getFormattedName();
            this.sourceResourceLoaded = sourceDataSet;
            this.setMembersList(member.getName());
        }
        if (sourceDataSet != null) {
            this.sourceResourceVolume = sourceDataSet.getVolume() != null ? sourceDataSet.getVolume().getVolserID() : "";
        }
    }

    public void setSourceResource(String sourceResource) {
        int memStart = ((String)sourceResource).indexOf("(");
        int memEnd = ((String)sourceResource).indexOf(")");
        if (memStart >= 0 && memStart < memEnd) {
            String mem = ((String)sourceResource).substring(memStart + 1, memEnd);
            sourceResource = ((String)sourceResource).substring(0, memStart);
            if (!MULTI_MEMBER_PLACEHOLDER.equals(mem)) {
                if (UIValidator.isValidWildcardableMember(mem, this.getSystem().getCodePage()) || UIValidator.isValidMemberList(mem, false, this.getSystem().getCodePage())) {
                    this.setMembersList(mem);
                    this.getMemberSelection().clear();
                } else {
                    sourceResource = (String)sourceResource + "()";
                    this.setMembersList("");
                    this.getMemberSelection().clear();
                }
            }
        } else {
            this.setMembersList("");
            this.getMemberSelection().clear();
        }
        this.sourceResource = sourceResource;
    }

    public String getSourceResourceVolumeSet() {
        return this.sourceResourceVolume;
    }

    public String getSourceResourceVolume() {
        if (Volume.isValid((String)this.sourceResourceVolume, (String)this.getSystem().getCodePage())) {
            return this.sourceResourceVolume;
        }
        return "";
    }

    public void setSourceResourceVolume(String sourceResourceVolume) {
        this.sourceResourceVolume = sourceResourceVolume;
    }

    public boolean isDestDataSetWithMembers() {
        IZRL dest = this.getDestResourceZRL();
        if (dest instanceof DataSet) {
            return ((DataSet)dest).getHasMembers();
        }
        return false;
    }

    public String getDestResource() {
        return this.destResource;
    }

    public IZRL getDestResourceZRL() {
        if (this.getSystem() != null && ZRLs.isParseable((IPDHost)this.getDestSystem(), (String)this.destResource)) {
            IZRL parsedDestResource = ZRLs.parseZRL((IPDHost)this.getDestSystem(), (String)this.destResource);
            if (parsedDestResource instanceof DataSet && Volume.isValid((String)this.destResourceVolume, (String)this.getDestSystem().getCodePage())) {
                ((DataSet)parsedDestResource).setVolume(Volume.create((IPDHost)this.getDestSystem(), (String)this.destResourceVolume));
            }
            if (this.destResourceLoaded != null && this.destResourceLoaded.equals(parsedDestResource)) {
                boolean useLoadedResource = true;
                if (this.destResourceLoaded instanceof DataSet && !((DataSet)this.destResourceLoaded).equalsWithVolumes((Object)parsedDestResource)) {
                    useLoadedResource = false;
                }
                if (useLoadedResource) {
                    return this.destResourceLoaded;
                }
            }
            return parsedDestResource;
        }
        return null;
    }

    public void setDestSystem(IPDHost destSystem) {
        this.destSystem = destSystem;
    }

    public IPDHost getDestSystem() {
        return this.destSystem;
    }

    public void setDestResource(String destResource) {
        this.destResource = destResource;
    }

    public String getDestResourceVolumeSet() {
        return this.destResourceVolume;
    }

    public String getDestResourceVolume() {
        if (Volume.isValid((String)this.destResourceVolume, (String)this.getSystem().getCodePage())) {
            return this.destResourceVolume;
        }
        return "";
    }

    public void setDestResourceVolume(String destResourceVolume) {
        this.destResourceVolume = destResourceVolume;
    }

    public String getSingleSourceMemberSelected() {
        if (this.getSourceResourceZRL() instanceof DataSet) {
            if (this.getMemberSelection().isNoMemberSelected() && this.getMembersList().indexOf(",") == -1 && !this.getMembersList().isEmpty()) {
                return this.getMembersList();
            }
            if (this.getMemberSelection().isSingleMemberSelected() && this.getMembersList().isEmpty()) {
                return this.getMemberSelection().getMembersRangeStart();
            }
        }
        return null;
    }

    public boolean isMultipleSourceMembersSelected() {
        boolean multipleSrcMembers = false;
        if (this.getSourceResourceZRL() instanceof DataSet) {
            multipleSrcMembers = this.getMembersList().indexOf(",") >= 0;
            multipleSrcMembers = multipleSrcMembers || this.getMemberSelection().isUsingRange() && !this.getMemberSelection().getMembersRangeStart().equals(this.getMembersList());
            multipleSrcMembers = multipleSrcMembers || this.getMemberSelection().isMultipleMembersSelected(false);
        }
        return multipleSrcMembers;
    }

    public CopyModel clone() {
        CopyModel newParams = new CopyModel(this.getHostProvider());
        newParams.sourceResource = this.sourceResource;
        newParams.sourceResourceLoaded = (IRefreshable)this.getCloneOf(this.sourceResourceLoaded);
        newParams.sourceResourceVolume = this.sourceResourceVolume;
        newParams.destSystem = this.destSystem;
        newParams.destResource = this.destResource;
        newParams.destResourceLoaded = (IRefreshable)this.getCloneOf(this.destResourceLoaded);
        newParams.destResourceVolume = this.destResourceVolume;
        newParams.setMembersList(this.membersList);
        newParams.setMemberSelection((MemberSelectionCriteriaModel)((Object)this.getCloneOf((Object)this.getMemberSelection())));
        newParams.setMembersRenameList((List)this.getCloneOf(this.getMembersRenameList()));
        newParams.setMembersRenameMask(this.getMembersRenameMask());
        newParams.setSourceTemplate((TemplateWithOffsetModel)((Object)this.getCloneOf((Object)this.getSourceTemplate())));
        newParams.setDestTemplate((TemplateWithOffsetModel)((Object)this.getCloneOf((Object)this.getDestTemplate())));
        newParams.setUseDefaultMappingCopyCorresponding(this.isUseDefaultMappingCopyCorresponding());
        newParams.setSkipRecords(this.getSkipRecords());
        newParams.setVsamKey(this.getVsamKey());
        newParams.setNumberRecords(this.getNumberRecords());
        newParams.setPacking(this.getPacking());
        newParams.setOverwriteExistingRecords(this.isOverwriteExistingRecords());
        newParams.setKsdsUpdate(this.isKsdsUpdate());
        newParams.setIgnoreRecordLength(this.isIgnoreRecordLength());
        newParams.setUpdateStatistics(this.getUpdateStatistics());
        newParams.setReplaceMembers(this.isReplaceMembers());
        newParams.setSourceBinaryRecordLength(this.getSourceBinaryRecordLength());
        newParams.setSourceAdjustStart(this.isSourceAdjustStart());
        newParams.setSourceIOExitSpecified(this.isSourceIOExitSpecified());
        newParams.setSourceIOExit(this.getSourceIOExit());
        newParams.setDestBinaryRecordLength(this.getDestBinaryRecordLength());
        newParams.setDestAdjustStart(this.isDestAdjustStart());
        newParams.setDestIOExitSpecified(this.isDestIOExitSpecified());
        newParams.setDestIOExit(this.getDestIOExit());
        newParams.setSampleSkip(this.getSampleSkip());
        newParams.setSampleInclude(this.getSampleInclude());
        newParams.formatInXml = this.formatInXml;
        newParams.nonPrintableChar = this.nonPrintableChar;
        newParams.nonPrintableCharReplacementChar = this.nonPrintableCharReplacementChar;
        newParams.specialChar = this.specialChar;
        newParams.specialCharReplacementChar = this.specialCharReplacementChar;
        newParams.invalidData = this.invalidData;
        newParams.invalidDataReplacementChar = this.invalidDataReplacementChar;
        newParams.indent = this.indent;
        newParams.fillers = this.fillers;
        newParams.redefines = this.redefines;
        newParams.unicode = this.unicode;
        newParams.linesplit = this.linesplit;
        newParams.includeMd = this.includeMd;
        newParams.mqReadDestructive = this.mqReadDestructive;
        return newParams;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CopyModel) {
            CopyModel other = (CopyModel)((Object)obj);
            return this.getSystem().equals(other.getSystem()) && this.toUtilityFunction().equals((Object)other.toUtilityFunction());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.toUtilityFunction().hashCode();
    }

    public boolean isFormatInXml() {
        return this.formatInXml && this.getSourceTemplate().getTemplate() != null;
    }

    public boolean isFormatInXmlSet() {
        return this.formatInXml;
    }

    public void setFormatInXml(boolean formatInXml) {
        this.formatInXml = formatInXml;
    }

    public DSC.DscNprtChar getNonPrintableChar() {
        return this.nonPrintableChar;
    }

    public void setNonPrintableChar(DSC.DscNprtChar nonPrintableChar) {
        this.nonPrintableChar = nonPrintableChar;
    }

    public String getNonPrintableCharReplacementChar() {
        return this.nonPrintableCharReplacementChar;
    }

    public void setNonPrintableCharReplacementChar(String nonPrintableCharReplacementChar) {
        this.nonPrintableCharReplacementChar = nonPrintableCharReplacementChar;
    }

    public DSC.DscSpecChar getSpecialChar() {
        return this.specialChar;
    }

    public void setSpecialChar(DSC.DscSpecChar specialChar) {
        this.specialChar = specialChar;
    }

    public String getSpecialCharReplacementChar() {
        return this.specialCharReplacementChar;
    }

    public void setSpecialCharReplacementChar(String specialCharReplacementChar) {
        this.specialCharReplacementChar = specialCharReplacementChar;
    }

    public DSC.DscInvData getInvalidData() {
        return this.invalidData;
    }

    public void setInvalidData(DSC.DscInvData invalidData) {
        this.invalidData = invalidData;
    }

    public String getInvalidDataReplacementChar() {
        return this.invalidDataReplacementChar;
    }

    public void setInvalidDataReplacementChar(String invalidDataReplacementChar) {
        this.invalidDataReplacementChar = invalidDataReplacementChar;
    }

    public String getIndent() {
        return this.indent.length() > 0 ? this.indent : (String)DSC.INDENT.getDefaultValue();
    }

    public String getIndentSet() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public boolean isFillers() {
        return this.fillers;
    }

    public void setFillers(boolean fillers) {
        this.fillers = fillers;
    }

    public boolean isRedefines() {
        return this.redefines;
    }

    public void setRedefines(boolean redefines) {
        this.redefines = redefines;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }

    public boolean isLinesplit() {
        return this.linesplit;
    }

    public void setLinesplit(boolean linesplit) {
        this.linesplit = linesplit;
    }

    public boolean isIncludeMd() {
        return this.includeMd;
    }

    public void setIncludeMd(boolean includeMd) {
        this.includeMd = includeMd;
    }

    public boolean getMqDestructiveRead() {
        return this.mqReadDestructive;
    }

    public void setMqDestructiveRead(boolean mqOpen) {
        this.mqReadDestructive = mqOpen;
    }

    public String getMembersList() {
        return this.membersList;
    }

    public void setMembersList(String membersList) {
        this.membersList = membersList;
    }

    public MemberSelectionCriteriaModel getMemberSelection() {
        return this.memberSelection;
    }

    public void setMemberSelection(MemberSelectionCriteriaModel memberSelection) {
        this.memberSelection = memberSelection;
    }

    public List<String> getMembersRenameList() {
        return this.membersRenameList;
    }

    public void setMembersRenameList(List<String> membersRenameList) {
        this.membersRenameList = membersRenameList;
    }

    public String getMembersRenameMask() {
        return this.membersRenameMask;
    }

    public void setMembersRenameMask(String membersRenameMask) {
        this.membersRenameMask = membersRenameMask;
    }

    public TemplateWithOffsetModel getSourceTemplate() {
        return this.sourceTemplate;
    }

    public void setSourceTemplate(TemplateWithOffsetModel sourceTemplate) {
        this.sourceTemplate = sourceTemplate;
    }

    public TemplateWithOffsetModel getDestTemplate() {
        return this.destTemplate;
    }

    public void setDestTemplate(TemplateWithOffsetModel destTemplate) {
        this.destTemplate = destTemplate;
    }

    public boolean isUseDefaultMappingCopyCorresponding() {
        return this.useDefaultMappingCopyCorresponding;
    }

    public void setUseDefaultMappingCopyCorresponding(boolean useDefaultMappingCopyCorresponding) {
        this.useDefaultMappingCopyCorresponding = useDefaultMappingCopyCorresponding;
    }

    public String getSkipRecords() {
        return this.skipRecords;
    }

    public void setSkipRecords(String skipRecords) {
        this.skipRecords = skipRecords;
    }

    public String getVsamKey() {
        return this.vsamKey;
    }

    public void setVsamKey(String vsamKey) {
        this.vsamKey = vsamKey;
    }

    public String getNumberRecords() {
        return this.numberRecords;
    }

    public void setNumberRecords(String numberRecords) {
        this.numberRecords = numberRecords;
    }

    public DSC.DscPack getPacking() {
        return this.packing;
    }

    public void setPacking(DSC.DscPack packing) {
        this.packing = packing;
    }

    public boolean isOverwriteExistingRecords() {
        return this.overwriteExistingRecords;
    }

    public void setOverwriteExistingRecords(boolean overwriteExistingRecords) {
        this.overwriteExistingRecords = overwriteExistingRecords;
    }

    public boolean isKsdsUpdate() {
        return this.ksdsUpdate;
    }

    public void setKsdsUpdate(boolean ksdsUpdate) {
        this.ksdsUpdate = ksdsUpdate;
    }

    public boolean isIgnoreRecordLength() {
        return this.ignoreRecordLength;
    }

    public void setIgnoreRecordLength(boolean ignoreRecordLength) {
        this.ignoreRecordLength = ignoreRecordLength;
    }

    public DSC.DscStats getUpdateStatistics() {
        return this.updateStatistics;
    }

    public void setUpdateStatistics(DSC.DscStats updateStatistics) {
        this.updateStatistics = updateStatistics;
    }

    public boolean isReplaceMembers() {
        return this.replaceMembers;
    }

    public void setReplaceMembers(boolean replaceMembers) {
        this.replaceMembers = replaceMembers;
    }

    public String getSourceBinaryRecordLength() {
        return this.sourceBinaryRecordLength;
    }

    public void setSourceBinaryRecordLength(String sourceBinaryRecordLength) {
        this.sourceBinaryRecordLength = sourceBinaryRecordLength;
    }

    public boolean isSourceAdjustStart() {
        return this.sourceAdjustStart;
    }

    public void setSourceAdjustStart(boolean sourceAdjustStart) {
        this.sourceAdjustStart = sourceAdjustStart;
    }

    public boolean isSourceIOExitSpecified() {
        return this.sourceIOExitSpecified;
    }

    public void setSourceIOExitSpecified(boolean sourceIOExitSpecified) {
        this.sourceIOExitSpecified = sourceIOExitSpecified;
    }

    public String getSourceIOExit() {
        return this.sourceIOExit;
    }

    public void setSourceIOExit(String sourceIOExit) {
        this.sourceIOExit = sourceIOExit;
    }

    public String getDestBinaryRecordLength() {
        return this.destBinaryRecordLength;
    }

    public void setDestBinaryRecordLength(String destBinaryRecordLength) {
        this.destBinaryRecordLength = destBinaryRecordLength;
    }

    public boolean isDestAdjustStart() {
        return this.destAdjustStart;
    }

    public void setDestAdjustStart(boolean destAdjustStart) {
        this.destAdjustStart = destAdjustStart;
    }

    public boolean isDestIOExitSpecified() {
        return this.destIOExitSpecified;
    }

    public void setDestIOExitSpecified(boolean destIOExitSpecified) {
        this.destIOExitSpecified = destIOExitSpecified;
    }

    public String getDestIOExit() {
        return this.destIOExit;
    }

    public void setDestIOExit(String destIOExit) {
        this.destIOExit = destIOExit;
    }

    public String getSampleSkip() {
        return this.sampleSkip;
    }

    public void setSampleSkip(String sampleSkip) {
        this.sampleSkip = sampleSkip;
    }

    public String getSampleInclude() {
        return this.sampleInclude;
    }

    public void setSampleInclude(String sampleInclude) {
        this.sampleInclude = sampleInclude;
    }

    public void setUseAdvancedAllocationAttributes(boolean selection) {
        this.useAdvancedAllocation = selection;
    }

    public boolean getUseAdvancedAllocation() {
        return this.useAdvancedAllocation;
    }

    public void setImportFromDesktop(boolean importFromDesktop) {
        this.importFile = importFromDesktop;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    public void setSpecifyDoubleBytes(boolean specifyDoubleBytes) {
        this.specifyDoubleBytes = specifyDoubleBytes;
    }

    public void setSingleQuotes(boolean singleQuotes) {
        this.singleQuotes = singleQuotes;
    }
}

