/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.socket.func.DSC;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.etools.fm.ui.wizards.CopyRunnable;
import com.ibm.etools.fm.ui.wizards.CopyWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CopyActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private CopyModel model;
    private static DSCActionItemPropertySource propSource = null;

    public CopyActionItem(CopyModel model) {
        super(ActionType.DSC, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.DSCActionItem_COPY_LABEL, this.getFullResourceName(false), this.model.getDestResourceZRL().getFormattedName());
    }

    private String getFullResourceName(boolean listAllMembers) {
        if (this.model.isMultipleSourceMembersSelected()) {
            String members = this.model.getListOfMembersToCopy().toString();
            if (members.length() > 1) {
                members = members.substring(1, members.length() - 1);
            }
            return this.model.getSourceResourceZRL().getFormattedName() + "(" + (listAllMembers && members != null ? members : "...") + ")";
        }
        if (this.model.getSingleSourceMemberSelected() != null) {
            return this.model.getSourceResourceZRL().getFormattedName() + "(" + this.model.getSingleSourceMemberSelected() + ")";
        }
        return this.model.getSourceResourceZRL().getFormattedName();
    }

    @Override
    public String getToolTipText() {
        IPDHost destSystem = this.model.getDestSystem();
        return MessageFormat.format(Messages.DSCActionItem_COPY_TOOLTIP, this.getFullResourceName(true), destSystem != null ? destSystem.getConnectionName() + ":" : this.model.getDestResourceZRL().getName());
    }

    @Override
    public void saveTo(IMemento memento) {
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
        IActionItemSaver.saveDestinationSystem(memento, this.model.getDestSystem());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        DSC function = new DSC();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        CopyModel model = new CopyModel(system);
        model.fromUtilityFunction(function);
        IPDHost dest = IActionItemSaver.loadDestinationSystem(memento);
        if (dest != null) {
            model.setDestSystem(dest);
        }
        return new CopyActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        CopyRunnable runnable = new CopyRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void execute(List<SystemsTreeNode> draggedObjects) {
    }

    @Override
    public void modify() {
        this.beginExecution();
        final CopyModel clone = this.model.clone();
        CopyWizard wizard = new CopyWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                CopyActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public CopyActionItem clone() {
        CopyActionItem clone = new CopyActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CopyActionItem) {
            CopyActionItem other = (CopyActionItem)obj;
            return this.getSystem().equals(other.getSystem()) && this.model.toUtilityFunction().equals((Object)other.model.toUtilityFunction());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 37;
        r = 37 * r + this.getSystem().hashCode();
        r = 37 * r + this.model.toUtilityFunction().hashCode();
        return r;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new DSCActionItemPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    private static class DSCActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private CopyModel model;
        private IPropertyDescriptor[] propertyDescriptors;
        private String sourceResource = "sourceResource";
        private String sourceResourceVolume = "sourceResourceVolume";
        private String destSystem = "destSystem";
        private String destResource = "destResource";
        private String destResourceVolume = "destResourceVolume";
        private String membersList = "membersList";
        private String membersRangeStart = "membersRangeStart";
        private String membersRangeEnd = "membersRangeEnd";
        private String membersCreatedStart = "membersCreatedStart";
        private String membersCreatedEnd = "membersCreatedEnd";
        private String membersChangedStart = "membersChangedStart";
        private String membersChangedEnd = "membersChangedEnd";
        private String membersUserIDStart = "membersUserIDStart";
        private String membersUserIDEnd = "membersUserIDEnd";
        private String membersRenameMask = "membersRenameMask";
        private String sourceTemplate = "sourceTemplate";
        private String sourceOffset = "sourceOffset";
        private String destTemplate = "destTemplate";
        private String destOffset = "destOffset";
        public String skipRecords = "skipRecords";
        public String vsamKey = "vsamKey";
        public String numberRecords = "numberRecords";
        public String packing = "packing";
        public String overwriteExistingRecords = "overwriteExistingRecords";
        public String ignoreRecordLength = "ignoreRecordLength";
        public String updateStatistics = "updateStatistics";
        public String replaceMembers = "replaceMembers";
        public String sourceBinaryRecordLength = "sourceBinaryRecordLength";
        public String sourceAdjustStart = "sourceAdjustStart";
        public String sourceIOExit = "sourceIOExit";
        public String destBinaryRecordLength = "destBinaryRecordLength";
        public String destAdjustStart = "destAdjustStart";
        public String destIOExit = "destIOExit";
        public String sampleSkip = "sampleSkip";
        public String sampleInclude = "sampleInclude";
        public Object xmlFormat = new Object();
        public Object nonPrintableChar = new Object();
        public Object nonPrintableCharReplacementChar = new Object();
        public Object specialChar = new Object();
        public Object specialCharReplacementChar = new Object();
        public Object invData = new Object();
        public Object invDataReplacementChar = new Object();
        public Object indent = new Object();
        public Object fillers = new Object();
        public Object redefines = new Object();
        public Object unicode = new Object();
        public Object linesplit = new Object();
        public Object includeMQ = new Object();
        public Object mqDestructiveRead = new Object();

        public DSCActionItemPropertySource(CopyModel model) {
            this.model = model;
            this.init();
        }

        public void setModel(CopyModel model) {
            this.model = model;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.sourceResource, Messages.DSCActionItem_SOURCE_RESOURCE));
            temp.add(new PropertyDescriptor((Object)this.sourceResourceVolume, Messages.DSCActionItem_SOURCE_VOLUME));
            temp.add(new PropertyDescriptor((Object)this.destSystem, Messages.CopyActionItem_0));
            temp.add(new PropertyDescriptor((Object)this.destResource, Messages.DSCActionItem_DESTINATION_RESOURCE));
            temp.add(new PropertyDescriptor((Object)this.destResourceVolume, Messages.DSCActionItem_DESTINATION_VOLUME));
            temp.add(new PropertyDescriptor((Object)this.membersList, Messages.Label__MEMBER_LIST));
            temp.add(new PropertyDescriptor((Object)this.membersRangeStart, Messages.DSCActionItem_MEMBER_RANGE_START));
            temp.add(new PropertyDescriptor((Object)this.membersRangeEnd, Messages.DSCActionItem_MEMBER_RANGE_END));
            temp.add(new PropertyDescriptor((Object)this.membersCreatedStart, Messages.DSCActionItem_CREATED_START));
            temp.add(new PropertyDescriptor((Object)this.membersCreatedEnd, Messages.DSCActionItem_CREATED_END));
            temp.add(new PropertyDescriptor((Object)this.membersChangedStart, Messages.DSCActionItem_CHANGE_START));
            temp.add(new PropertyDescriptor((Object)this.membersChangedEnd, Messages.DSCActionItem_CHANGE_END));
            temp.add(new PropertyDescriptor((Object)this.membersUserIDStart, Messages.DSCActionItem_USER_ID_START));
            temp.add(new PropertyDescriptor((Object)this.membersUserIDEnd, Messages.DSCActionItem_USER_ID_END));
            temp.add(new PropertyDescriptor((Object)this.membersRenameMask, Messages.DSCActionItem_MEMBER_RENAME_MASK));
            temp.add(new PropertyDescriptor((Object)this.sourceTemplate, Messages.DSCActionItem_SOURCE_TEMPLATE));
            temp.add(new PropertyDescriptor((Object)this.sourceOffset, Messages.DSCActionItem_SOURCE_TEMPLATE_OFFSET));
            temp.add(new PropertyDescriptor((Object)this.destTemplate, Messages.DSCActionItem_DESTINATION_TEMPLATE));
            temp.add(new PropertyDescriptor((Object)this.destOffset, Messages.DSCActionItem_DESTINATION_TEMPLATE_OFFSET));
            temp.add(new PropertyDescriptor((Object)this.skipRecords, Messages.Label__SKIP_RECORDS));
            temp.add(new PropertyDescriptor((Object)this.vsamKey, Messages.Label__VSAM_KEY));
            temp.add(new PropertyDescriptor((Object)this.numberRecords, Messages.Label__RECORDS_TO_COPY));
            temp.add(new PropertyDescriptor((Object)this.packing, Messages.Label__PACKING_POLICY));
            temp.add(new PropertyDescriptor((Object)this.overwriteExistingRecords, Messages.__OVERWRITE_EXISTING_RECORDS));
            temp.add(new PropertyDescriptor((Object)this.ignoreRecordLength, Messages.__IGNORE_RECORD_LENGTH_MISMATCHES));
            temp.add(new PropertyDescriptor((Object)this.updateStatistics, Messages.DSCActionItem_UPDATE_STATISTICS));
            temp.add(new PropertyDescriptor((Object)this.replaceMembers, Messages._COPY_WIZARD_REPLACE_EXISTING_MEMBERS));
            temp.add(new PropertyDescriptor((Object)this.sourceBinaryRecordLength, Messages.DSCActionItem_SOURCE_BINARY_RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.sourceAdjustStart, Messages.DSCActionItem_SOURCE_ADJUST_START));
            temp.add(new PropertyDescriptor((Object)this.sourceIOExit, Messages.DSCActionItem_SOURCE_IO_EXIT));
            temp.add(new PropertyDescriptor((Object)this.destBinaryRecordLength, Messages.DSCActionItem_DESTINATION_BINARY_RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.destAdjustStart, Messages.DSCActionItem_DESTINATION_ADJUST_START));
            temp.add(new PropertyDescriptor((Object)this.destIOExit, Messages.DSCActionItem_DESTINATION_IO_EXIT));
            temp.add(new PropertyDescriptor((Object)this.sampleSkip, Messages.Label__SKIP));
            temp.add(new PropertyDescriptor((Object)this.sampleInclude, Messages.Label__INCLUDE));
            temp.add(new PropertyDescriptor(this.xmlFormat, Messages.CopyActionItem_XML_FORMAT));
            temp.add(new PropertyDescriptor(this.nonPrintableChar, Messages.CopyActionItem_NON_PRINTABLE_CHARACTER));
            temp.add(new PropertyDescriptor(this.nonPrintableCharReplacementChar, Messages.CopyActionItem_NON_PRINTABLE_REPLACEMENT));
            temp.add(new PropertyDescriptor(this.specialChar, Messages.CopyActionItem_SPECIAL_CHAR));
            temp.add(new PropertyDescriptor(this.specialCharReplacementChar, Messages.CopyActionItem_SPECIAL_REPLACEMENT));
            temp.add(new PropertyDescriptor(this.invData, Messages.CopyActionItem_INVALID_CHAR));
            temp.add(new PropertyDescriptor(this.invDataReplacementChar, Messages.CopyActionItem_INVALID_REPLACEMENT));
            temp.add(new PropertyDescriptor(this.indent, Messages.CopyActionItem_INDENT));
            temp.add(new PropertyDescriptor(this.fillers, Messages.CopyActionItem_FILLERS));
            temp.add(new PropertyDescriptor(this.redefines, Messages.CopyActionItem_REDEFINES));
            temp.add(new PropertyDescriptor(this.unicode, Messages.CopyActionItem_UNICODE));
            temp.add(new PropertyDescriptor(this.linesplit, Messages.CopyActionItem_LINESPLIT));
            temp.add(new PropertyDescriptor(this.includeMQ, Messages.CopyActionItem_1));
            temp.add(new PropertyDescriptor(this.mqDestructiveRead, Messages.CopyActionItem_2));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object id) {
            if (id.equals(this.sourceResource)) {
                return this.model.getSourceResource();
            }
            if (id.equals(this.sourceResourceVolume)) {
                return this.model.getSourceResourceVolume();
            }
            if (id.equals(this.destResource)) {
                return this.model.getDestResource();
            }
            if (id.equals(this.destSystem)) {
                return this.model.getDestSystem();
            }
            if (id.equals(this.destResourceVolume)) {
                return this.model.getDestResourceVolume();
            }
            if (id.equals(this.membersList)) {
                return this.model.getMembersList();
            }
            if (id.equals(this.membersRangeStart)) {
                if (!this.model.getMemberSelection().isUsingRange()) {
                    return "";
                }
                return this.model.getMemberSelection().getMembersRangeStart();
            }
            if (id.equals(this.membersRangeEnd)) {
                if (!this.model.getMemberSelection().isUsingRange()) {
                    return "";
                }
                return this.model.getMemberSelection().getMembersRangeEnd();
            }
            if (id.equals(this.membersCreatedStart)) {
                if (!this.model.getMemberSelection().isUsingCreated()) {
                    return "";
                }
                return this.model.getMemberSelection().getMembersCreatedStartFormatted();
            }
            if (id.equals(this.membersCreatedEnd)) {
                if (!this.model.getMemberSelection().isUsingCreated()) {
                    return "";
                }
                return this.model.getMemberSelection().getMembersCreatedEndFormatted();
            }
            if (id.equals(this.membersChangedStart)) {
                if (!this.model.getMemberSelection().isUsingChanged()) {
                    return "";
                }
                return this.model.getMemberSelection().getMembersChangedStartFormatted();
            }
            if (id.equals(this.membersChangedEnd)) {
                if (!this.model.getMemberSelection().isUsingChanged()) {
                    return "";
                }
                return this.model.getMemberSelection().getMembersChangedEndFormatted();
            }
            if (id.equals(this.membersUserIDStart)) {
                if (!this.model.getMemberSelection().isUsingUserID()) {
                    return "";
                }
                return this.model.getMemberSelection().getMembersUserIDStart();
            }
            if (id.equals(this.membersUserIDEnd)) {
                if (!this.model.getMemberSelection().isUsingUserID()) {
                    return "";
                }
                return this.model.getMemberSelection().getMembersUserIDEnd();
            }
            if (id.equals(this.membersRenameMask)) {
                return this.model.getMembersRenameMask();
            }
            if (id.equals(this.sourceTemplate)) {
                return this.model.getSourceTemplate().getTemplateSet();
            }
            if (id.equals(this.sourceOffset)) {
                return this.model.getSourceTemplate().getOffsets();
            }
            if (id.equals(this.destTemplate)) {
                return this.model.getDestTemplate().getTemplateSet();
            }
            if (id.equals(this.destOffset)) {
                return this.model.getDestTemplate().getOffsets();
            }
            if (id.equals(this.skipRecords)) {
                return this.model.getSkipRecords();
            }
            if (id.equals(this.vsamKey)) {
                return this.model.getVsamKey();
            }
            if (id.equals(this.numberRecords)) {
                return this.model.getNumberRecords();
            }
            if (id.equals(this.packing)) {
                return this.model.getPacking();
            }
            if (id.equals(this.overwriteExistingRecords)) {
                return this.model.isOverwriteExistingRecords();
            }
            if (id.equals(this.ignoreRecordLength)) {
                return this.model.isIgnoreRecordLength();
            }
            if (id.equals(this.updateStatistics)) {
                return this.model.getUpdateStatistics();
            }
            if (id.equals(this.replaceMembers)) {
                return this.model.isReplaceMembers();
            }
            if (id.equals(this.sourceBinaryRecordLength)) {
                return this.model.getSourceBinaryRecordLength();
            }
            if (id.equals(this.sourceAdjustStart)) {
                return this.model.isSourceAdjustStart();
            }
            if (id.equals(this.sourceIOExit)) {
                if (!this.model.isSourceIOExitSpecified()) {
                    return "";
                }
                return this.model.getSourceIOExit();
            }
            if (id.equals(this.destBinaryRecordLength)) {
                return this.model.getDestBinaryRecordLength();
            }
            if (id.equals(this.destAdjustStart)) {
                return this.model.isDestAdjustStart();
            }
            if (id.equals(this.destIOExit)) {
                if (!this.model.isDestIOExitSpecified()) {
                    return "";
                }
                return this.model.isDestIOExitSpecified();
            }
            if (id.equals(this.sampleSkip)) {
                return this.model.getSampleSkip();
            }
            if (id.equals(this.sampleInclude)) {
                return this.model.getSampleInclude();
            }
            if (id.equals(this.xmlFormat)) {
                return this.model.isFormatInXml();
            }
            if (id.equals(this.nonPrintableChar)) {
                return this.model.getNonPrintableChar();
            }
            if (id.equals(this.nonPrintableCharReplacementChar)) {
                return this.model.getNonPrintableCharReplacementChar();
            }
            if (id.equals(this.specialChar)) {
                return this.model.getSpecialChar();
            }
            if (id.equals(this.specialCharReplacementChar)) {
                return this.model.getSpecialCharReplacementChar();
            }
            if (id.equals(this.invData)) {
                return this.model.getInvalidData();
            }
            if (id.equals(this.invDataReplacementChar)) {
                return this.model.getInvalidDataReplacementChar();
            }
            if (id.equals(this.indent)) {
                return this.model.getIndent();
            }
            if (id.equals(this.fillers)) {
                return this.model.isFillers();
            }
            if (id.equals(this.redefines)) {
                return this.model.isRedefines();
            }
            if (id.equals(this.unicode)) {
                return this.model.isUnicode();
            }
            if (id.equals(this.linesplit)) {
                return this.model.isLinesplit();
            }
            if (id.equals(this.includeMQ)) {
                return this.model.isIncludeMd();
            }
            if (id.equals(this.mqDestructiveRead)) {
                return this.model.getMqDestructiveRead();
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

