/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.socket.func.DSM;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.CompareModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CompareWizardPageSynchronization
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(CompareWizardPageSynchronization.class);
    private final CompareModel command;
    private CompareWizardPageSynchronizationConnector connector = new CompareWizardPageSynchronizationConnector();
    private Combo wReadAheadLimit;
    private Combo wReadAheadLength;
    private Button wAllKeysMatch;
    private Button wKeyDupOk;
    private Button wUsingOldTemplateKey;
    private Combo wOldTemplateKeyFields;
    private Combo wOldKeyLocations;
    private Button wUsingNewTemplateKey;
    private Combo wNewTemplateKeyFields;
    private Combo wNewKeyLocations;
    private Combo wKeyLengths;
    private Combo wKeyTypes;
    private Combo wNewKeyLengths;
    private Combo wNewKeyTypes;
    private Combo wKeyOrder;

    protected CompareWizardPageSynchronization(CompareModel command) {
        super(Messages.CompareWizardPageSynchronization_SYNCH_SETTINGS);
        this.setTitle(Messages.CompareWizardPageSynchronization_SYNCH_SETTINGS);
        this.setMessage(Messages.CompareWizardPageSynchronization_SPECIFY_ADVANCED_SYNCH_SETTINGS);
        this.command = command;
    }

    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group wReadAheadGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageSynchronization_READ_AHEAD_OPTIONS, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        GUI.label.left((Composite)wReadAheadGroup, (String)Messages.CompareWizardPageSynchronization_LIMIT, (Object)GUI.grid.d.left1());
        this.wReadAheadLimit = GUI.combo.editable((Composite)wReadAheadGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wReadAheadLimit, ((Object)((Object)this)).getClass().getCanonicalName() + "ReadAheadLimit");
        this.wReadAheadLimit.setToolTipText(Messages.CompareWizardPageSynchronization_LIMIT_TOOLTIP);
        GUI.label.left((Composite)wReadAheadGroup, (String)Messages.CompareWizardPageSynchronization_LENGTH, (Object)GUI.grid.d.left1());
        this.wReadAheadLength = GUI.combo.editable((Composite)wReadAheadGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wReadAheadLength, ((Object)((Object)this)).getClass().getCanonicalName() + "ReadAheadLength");
        this.wReadAheadLength.setToolTipText(Messages.CompareWizardPageSynchronization_LENGTH_TOOLTIP);
        Group wKeyedGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageSynchronization_KEYED_OPTIONS, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wAllKeysMatch = GUI.button.checkbox((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_MATCH_ON_ALL_KEYS, (Object)GUI.grid.d.fillH((int)2));
        this.wAllKeysMatch.setToolTipText(Messages.CompareWizardPageSynchronization_MATCH_ON_ALL_KEYS_TOOLTIP);
        this.wKeyDupOk = GUI.button.checkbox((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_SUPPRESS_DUPLICATE_ERRORS, (Object)GUI.grid.d.fillH((int)2));
        this.wKeyDupOk.setToolTipText(Messages.CompareWizardPageSynchronization_SUPPRESS_DUPLICATE_ERRORS_TOOLTIP);
        this.wUsingOldTemplateKey = GUI.button.checkbox((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_USE_OLD_TEMPLATE_KEYS, (Object)GUI.grid.d.fillH((int)2));
        this.wUsingOldTemplateKey.setToolTipText(Messages.CompareWizardPageSynchronization_USE_OLD_TEMPLATE_KEYS_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_OLD_TEMPLATE_KEYS, (Object)GUI.grid.d.left1());
        this.wOldTemplateKeyFields = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wOldTemplateKeyFields, ((Object)((Object)this)).getClass().getCanonicalName() + "OldTemplKeyFlds");
        this.wOldTemplateKeyFields.setToolTipText(Messages.CompareWizardPageSynchronization_OLD_TEMPLATE_KEYS_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_OLD_KEY_LOCATIONS, (Object)GUI.grid.d.left1());
        this.wOldKeyLocations = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wOldKeyLocations, ((Object)((Object)this)).getClass().getCanonicalName() + "OldKeyLocs");
        this.wOldKeyLocations.setToolTipText(Messages.CompareWizardPageSynchronization_OLD_KEY_LOCATIONS_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_KEY_LENGTHS, (Object)GUI.grid.d.left1());
        this.wKeyLengths = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wKeyLengths, ((Object)((Object)this)).getClass().getCanonicalName() + "KeyLengths");
        this.wKeyLengths.setToolTipText(Messages.CompareWizardPageSynchronization_KEY_LENGTHS_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_KEY_TYPES, (Object)GUI.grid.d.left1());
        this.wKeyTypes = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wKeyTypes, ((Object)((Object)this)).getClass().getCanonicalName() + "KeyTypes");
        this.wKeyTypes.setToolTipText(Messages.CompareWizardPageSynchronization_KEY_TYPES_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_KEY_ORDERS, (Object)GUI.grid.d.left1());
        this.wKeyOrder = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wKeyOrder, ((Object)((Object)this)).getClass().getCanonicalName() + "KeyOrder");
        this.wKeyOrder.setToolTipText(Messages.CompareWizardPageSynchronization_KEY_ORDERS_TOOLTIP);
        this.wUsingNewTemplateKey = GUI.button.checkbox((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_USE_NEW_TEMPLATE_KEYS, (Object)GUI.grid.d.fillH((int)2));
        this.wUsingNewTemplateKey.setToolTipText(Messages.CompareWizardPageSynchronization_USE_NEW_TEMPLATE_KEYS_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_NEW_TEMPLATE_KEYS, (Object)GUI.grid.d.left1());
        this.wNewTemplateKeyFields = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wNewTemplateKeyFields, ((Object)((Object)this)).getClass().getCanonicalName() + "NewTemplKeyFlds");
        this.wNewTemplateKeyFields.setToolTipText(Messages.CompareWizardPageSynchronization_OLD_TEMPLATE_KEYS_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_NEW_KEY_LOCATIONS, (Object)GUI.grid.d.left1());
        this.wNewKeyLocations = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wNewKeyLocations, ((Object)((Object)this)).getClass().getCanonicalName() + "NewKeyLocs");
        this.wNewKeyLocations.setToolTipText(Messages.CompareWizardPageSynchronization_OLD_KEY_LOCATIONS_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_NEW_KEY_LENGTHS, (Object)GUI.grid.d.left1());
        this.wNewKeyLengths = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wNewKeyLengths, ((Object)((Object)this)).getClass().getCanonicalName() + "NewKeyLengths");
        this.wNewKeyLengths.setToolTipText(Messages.CompareWizardPageSynchronization_KEY_LENGTHS_TOOLTIP);
        GUI.label.left((Composite)wKeyedGroup, (String)Messages.CompareWizardPageSynchronization_NEW_KEY_TYPES, (Object)GUI.grid.d.left1());
        this.wNewKeyTypes = GUI.combo.editable((Composite)wKeyedGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wNewKeyTypes, ((Object)((Object)this)).getClass().getCanonicalName() + "NewKeyTypes");
        this.wNewKeyTypes.setToolTipText(Messages.CompareWizardPageSynchronization_KEY_TYPES_TOOLTIP);
        this.connector.listenTo(this.command);
        this.connector.listenTo((Control)this.wReadAheadLimit);
        this.connector.listenTo((Control)this.wReadAheadLength);
        this.connector.listenTo((Control)this.wAllKeysMatch);
        this.connector.listenTo((Control)this.wKeyDupOk);
        this.connector.listenTo((Control)this.wUsingOldTemplateKey);
        this.connector.listenTo((Control)this.wOldTemplateKeyFields);
        this.connector.listenTo((Control)this.wOldKeyLocations);
        this.connector.listenTo((Control)this.wUsingNewTemplateKey);
        this.connector.listenTo((Control)this.wNewTemplateKeyFields);
        this.connector.listenTo((Control)this.wNewKeyLocations);
        this.connector.listenTo((Control)this.wKeyLengths);
        this.connector.listenTo((Control)this.wKeyTypes);
        this.connector.listenTo((Control)this.wNewKeyLengths);
        this.connector.listenTo((Control)this.wNewKeyTypes);
        this.connector.listenTo((Control)this.wKeyOrder);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        if ((this.command.getSynch() == DSM.DsmSynch.READAHEAD || this.command.getSynch() == DSM.DsmSynch.RAKEY) && this.command.getLimit().isEmpty()) {
            return Messages.CompareWizardPageSynchronization_INVALID_RECORD_LIMIT;
        }
        if ((this.command.getSynch() == DSM.DsmSynch.READAHEAD || this.command.getSynch() == DSM.DsmSynch.RAKEY) && this.command.getLength().isEmpty()) {
            return Messages.CompareWizardPageSynchronization_INVALID_MATCHING_LENGTH;
        }
        if (!UIValidator.isValidIntegerList(this.command.getKeyLengthsSet(), true)) {
            return Messages.CompareWizardPageSynchronization_KEY_LENGTHS_INVALID;
        }
        if (!UIValidator.isValidStringList(this.command.getKeyTypesSet(), CompareModel.getKeyTypeListValues(), true)) {
            return Messages.CompareWizardPageSynchronization_KEY_TYPES_INVALID;
        }
        if (!UIValidator.isValidIntegerList(this.command.getNewKeyLengthsSet(), true)) {
            return Messages.CompareWizardPageSynchronization_KEY_LENGTHS_INVALID;
        }
        if (!UIValidator.isValidStringList(this.command.getNewKeyTypesSet(), CompareModel.getKeyTypeListValues(), true)) {
            return Messages.CompareWizardPageSynchronization_KEY_TYPES_INVALID;
        }
        if (!UIValidator.isValidStringList(this.command.getKeyOrdersSet(), CompareModel.getKeyOrdersListValues(), true)) {
            return Messages.CompareWizardPageSynchronization_KEY_ORDERS_INVALID;
        }
        return null;
    }

    public IWizardPage getNextPage() {
        if (this.command.isResultDatasets()) {
            IWizardPage[] pages = this.getWizard().getPages();
            return pages[pages.length - 1];
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    private class CompareWizardPageSynchronizationConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private CompareWizardPageSynchronizationConnector() {
        }

        protected void updateModelFromViewImpl() {
            CompareWizardPageSynchronization.this.command.setLimit(CompareWizardPageSynchronization.this.wReadAheadLimit.getText());
            CompareWizardPageSynchronization.this.command.setLength(CompareWizardPageSynchronization.this.wReadAheadLength.getText());
            CompareWizardPageSynchronization.this.command.setAllKeysMatch(CompareWizardPageSynchronization.this.wAllKeysMatch.getSelection());
            CompareWizardPageSynchronization.this.command.setKeyDupOk(CompareWizardPageSynchronization.this.wKeyDupOk.getSelection());
            CompareWizardPageSynchronization.this.command.setUsingKeyFromOldTemplate(CompareWizardPageSynchronization.this.wUsingOldTemplateKey.getSelection());
            CompareWizardPageSynchronization.this.command.setOldTemplateKeyFields(CompareWizardPageSynchronization.this.wOldTemplateKeyFields.getText());
            CompareWizardPageSynchronization.this.command.setOldKeyLocations(CompareWizardPageSynchronization.this.wOldKeyLocations.getText());
            CompareWizardPageSynchronization.this.command.setUsingKeyFromNewTemplate(CompareWizardPageSynchronization.this.wUsingNewTemplateKey.getSelection());
            CompareWizardPageSynchronization.this.command.setNewTemplateKeyFields(CompareWizardPageSynchronization.this.wNewTemplateKeyFields.getText());
            CompareWizardPageSynchronization.this.command.setNewKeyLocations(CompareWizardPageSynchronization.this.wNewKeyLocations.getText());
            CompareWizardPageSynchronization.this.command.setKeyLengths(CompareWizardPageSynchronization.this.wKeyLengths.getText());
            CompareWizardPageSynchronization.this.command.setKeyTypes(CompareWizardPageSynchronization.this.wKeyTypes.getText());
            CompareWizardPageSynchronization.this.command.setNewKeyLengths(CompareWizardPageSynchronization.this.wNewKeyLengths.getText());
            CompareWizardPageSynchronization.this.command.setNewKeyTypes(CompareWizardPageSynchronization.this.wNewKeyTypes.getText());
            CompareWizardPageSynchronization.this.command.setKeyOrders(CompareWizardPageSynchronization.this.wKeyOrder.getText());
            CompareWizardPageSynchronization.this.command.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wReadAheadLimit, CompareWizardPageSynchronization.this.command.getLimit());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wReadAheadLength, CompareWizardPageSynchronization.this.command.getLength());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageSynchronization.this.wAllKeysMatch, CompareWizardPageSynchronization.this.command.isAllKeysMatch());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageSynchronization.this.wKeyDupOk, CompareWizardPageSynchronization.this.command.isKeyDupOk());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageSynchronization.this.wUsingOldTemplateKey, CompareWizardPageSynchronization.this.command.isUsingKeyFromOldTemplate());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wOldTemplateKeyFields, CompareWizardPageSynchronization.this.command.getOldTemplateKeyFields());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wOldKeyLocations, CompareWizardPageSynchronization.this.command.getOldKeyLocations());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageSynchronization.this.wUsingNewTemplateKey, CompareWizardPageSynchronization.this.command.isUsingKeyFromNewTemplate());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wNewTemplateKeyFields, CompareWizardPageSynchronization.this.command.getNewTemplateKeyFields());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wNewKeyLocations, CompareWizardPageSynchronization.this.command.getNewKeyLocations());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wKeyLengths, CompareWizardPageSynchronization.this.command.getKeyLengths());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wKeyTypes, CompareWizardPageSynchronization.this.command.getKeyTypes());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wNewKeyLengths, CompareWizardPageSynchronization.this.command.getNewKeyLengths());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wNewKeyTypes, CompareWizardPageSynchronization.this.command.getNewKeyTypes());
            this.updateComboFromModelIfNeeded(CompareWizardPageSynchronization.this.wKeyOrder, CompareWizardPageSynchronization.this.command.getKeyOrders());
            boolean isUsingReadAhead = CompareWizardPageSynchronization.this.command.getSynch() == DSM.DsmSynch.READAHEAD || CompareWizardPageSynchronization.this.command.getSynch() == DSM.DsmSynch.RAKEY;
            CompareWizardPageSynchronization.this.wReadAheadLimit.setEnabled(isUsingReadAhead);
            CompareWizardPageSynchronization.this.wReadAheadLength.setEnabled(isUsingReadAhead);
            boolean isUsingKeyed = CompareWizardPageSynchronization.this.command.getSynch() == DSM.DsmSynch.KEYED || CompareWizardPageSynchronization.this.command.getSynch() == DSM.DsmSynch.RAKEY;
            CompareWizardPageSynchronization.this.wAllKeysMatch.setEnabled(isUsingKeyed);
            CompareWizardPageSynchronization.this.wKeyDupOk.setEnabled(isUsingKeyed);
            CompareWizardPageSynchronization.this.wUsingOldTemplateKey.setEnabled(isUsingKeyed && CompareWizardPageSynchronization.this.command.usingOldTemplate());
            CompareWizardPageSynchronization.this.wOldTemplateKeyFields.setEnabled(isUsingKeyed && CompareWizardPageSynchronization.this.command.usingOldTemplate() && !CompareWizardPageSynchronization.this.command.isUsingKeyFromOldTemplate());
            CompareWizardPageSynchronization.this.wOldKeyLocations.setEnabled(isUsingKeyed && !CompareWizardPageSynchronization.this.command.isUsingKeyFromOldTemplate());
            CompareWizardPageSynchronization.this.wUsingNewTemplateKey.setEnabled(isUsingKeyed && CompareWizardPageSynchronization.this.command.usingNewTemplate());
            CompareWizardPageSynchronization.this.wNewTemplateKeyFields.setEnabled(isUsingKeyed && CompareWizardPageSynchronization.this.command.usingNewTemplate() && !CompareWizardPageSynchronization.this.command.isUsingKeyFromNewTemplate());
            CompareWizardPageSynchronization.this.wNewKeyLocations.setEnabled(isUsingKeyed && !CompareWizardPageSynchronization.this.command.isUsingKeyFromNewTemplate());
            CompareWizardPageSynchronization.this.wKeyLengths.setEnabled(isUsingKeyed && !CompareWizardPageSynchronization.this.command.isUsingKeyFromOldTemplate());
            CompareWizardPageSynchronization.this.wKeyTypes.setEnabled(isUsingKeyed && !CompareWizardPageSynchronization.this.command.isUsingKeyFromOldTemplate());
            CompareWizardPageSynchronization.this.wNewKeyLengths.setEnabled(isUsingKeyed && !CompareWizardPageSynchronization.this.command.isUsingKeyFromNewTemplate());
            CompareWizardPageSynchronization.this.wNewKeyTypes.setEnabled(isUsingKeyed && !CompareWizardPageSynchronization.this.command.isUsingKeyFromNewTemplate());
            CompareWizardPageSynchronization.this.wKeyOrder.setEnabled(CompareWizardPageSynchronization.this.command.getSynch() == DSM.DsmSynch.KEYED && !CompareWizardPageSynchronization.this.command.isUsingKeyFromOldTemplate());
            String validationErrorMessage = CompareWizardPageSynchronization.this.getValidationErrorMessage();
            CompareWizardPageSynchronization.this.setPageComplete(validationErrorMessage == null);
            CompareWizardPageSynchronization.this.setErrorMessage(validationErrorMessage);
        }
    }
}

