/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.socket.func.DSM;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.dialog.lookup.filter.ILookupFilterProvider;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetActionItem;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizard;
import com.ibm.etools.fm.ui.wizards.AllocateHFSActionItem;
import com.ibm.etools.fm.ui.wizards.AllocateHFSModel;
import com.ibm.etools.fm.ui.wizards.AllocateHFSWizard;
import com.ibm.etools.fm.ui.wizards.CompareModel;
import com.ibm.etools.fm.ui.wizards.FMBaseWizard;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class CompareWizardPageResultDatasets
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2020. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(CompareWizardPageResultDatasets.class);
    private static final Class<?>[] VALID_RESULT_TYPES = new Class[]{DataSet.class, Member.class, UssFile.class};
    private final CompareModel model;
    private CompareWizardPageResultDatasetsConnector connector = new CompareWizardPageResultDatasetsConnector();
    private Combo wInsertsDataset;
    private Button wInsertsAllocate;
    private Button wInsertsDispOld;
    private Button wInsertsDispMod;
    private Combo wInsertsReclen;
    private Combo wDeletesDataset;
    private Button wDeletesAllocate;
    private Button wDeletesDispOld;
    private Button wDeletesDispMod;
    private Combo wDeletesReclen;
    private Combo wNChangesDataset;
    private Button wNChangesAllocate;
    private Button wNChangesDispOld;
    private Button wNChangesDispMod;
    private Combo wNChangesReclen;
    private Combo wOChangesDataset;
    private Button wOChangesAllocate;
    private Button wOChangesDispOld;
    private Button wOChangesDispMod;
    private Combo wOChangesReclen;
    private Combo wNMatchesDataset;
    private Button wNMatchesAllocate;
    private Button wNMatchesDispOld;
    private Button wNMatchesDispMod;
    private Combo wNMatchesReclen;
    private Combo wOMatchesDataset;
    private Button wOMatchesAllocate;
    private Button wOMatchesDispOld;
    private Button wOMatchesDispMod;
    private Combo wOMatchesReclen;

    protected CompareWizardPageResultDatasets(CompareModel command) {
        super(Messages.CompareWizardPageResultDatasets_TITLE);
        this.setTitle(Messages.CompareWizardPageResultDatasets_TITLE);
        this.setMessage(Messages.CompareWizardPageResultDatasets_SPECIFY_OPTIONS);
        this.model = command;
    }

    public void createControl(Composite parent) {
        boolean compWidth = true;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group insertsGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageResultDatasets_INSERTED_RECORDS, (Layout)GUI.grid.l.margins((int)15, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)insertsGroup, (String)Messages.CompareWizardPageResultDatasets_DATA_SET_NAME, (Object)GUI.grid.d.left1());
        this.wInsertsDataset = GUI.combo.editable((Composite)insertsGroup, (Object)GUI.grid.d.fillH((int)12));
        this.wInsertsAllocate = GUI.button.push((Composite)insertsGroup, (String)Messages.CompareWizardPageResultDatasets_ALLOCATE, (Object)GUI.grid.d.left1());
        this.wInsertsAllocate.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String dsn = CompareWizardPageResultDatasets.this.wInsertsDataset.getText();
                IZRL aZrl = ZRLs.parseZRL((IPDHost)CompareWizardPageResultDatasets.this.model.getSystem(), (String)dsn);
                if (aZrl instanceof DataSetOrMember || aZrl instanceof UssFile) {
                    CompareWizardPageResultDatasets.this.allocateResultDataset(aZrl, dsn, CompareWizardPageResultDatasets.this.model.getNewResource().getName());
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)insertsGroup), this.wInsertsDataset, (IHostProvider)this.model.getSystem()).types(VALID_RESULT_TYPES).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                String query = null;
                try {
                    query = CompareWizardPageResultDatasets.this.model.getSystem().getLogin(false).getUsername();
                }
                catch (InterruptedException e) {
                    logger.error((Object)(Messages.CompareWizardPageResultDatasets_USERID_FAILED + e.getMessage()));
                }
                return query + ".**";
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl != null) {
                    CompareWizardPageResultDatasets.this.model.setInsertsDataset(zrl.getFormattedName());
                }
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        this.wInsertsDataset.setText(this.model.getInsertsDataset());
        this.wInsertsDataset.setFocus();
        GUI.label.left((Composite)insertsGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION, (Object)GUI.grid.d.left1());
        this.wInsertsDispMod = GUI.button.radio((Composite)insertsGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND, (Object)GUI.grid.d.fillH((int)1));
        this.wInsertsDispMod.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND_TOOLTIP);
        this.wInsertsDispMod.setEnabled(true);
        this.wInsertsDispOld = GUI.button.radio((Composite)insertsGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE, (Object)GUI.grid.d.fillH((int)1));
        this.wInsertsDispOld.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE_TOOLTIP);
        this.wInsertsDispOld.setEnabled(true);
        GUI.grid.padding((Composite)insertsGroup, (int)8);
        GUI.label.left((Composite)insertsGroup, (String)Messages.CompareWizardPageResultDatasets_RECLEN, (Object)GUI.grid.d.left1());
        this.wInsertsReclen = GUI.combo.editable((Composite)insertsGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wInsertsReclen, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        this.wInsertsReclen.setToolTipText(Messages.CompareWizardPageOld_BINARY_RECORD_LENGTH_TOOLTIP);
        Group deletesGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageResultDatasets_DELETED_RECORDS, (Layout)GUI.grid.l.margins((int)15, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)deletesGroup, (String)Messages.CompareWizardPageResultDatasets_DATA_SET_NAME, (Object)GUI.grid.d.left1());
        this.wDeletesDataset = GUI.combo.editable((Composite)deletesGroup, (Object)GUI.grid.d.fillH((int)12));
        this.wDeletesAllocate = GUI.button.push((Composite)deletesGroup, (String)Messages.CompareWizardPageResultDatasets_ALLOCATE, (Object)GUI.grid.d.left1());
        this.wDeletesAllocate.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String dsn = CompareWizardPageResultDatasets.this.wDeletesDataset.getText();
                IZRL aZrl = ZRLs.parseZRL((IPDHost)CompareWizardPageResultDatasets.this.model.getSystem(), (String)dsn);
                if (aZrl instanceof DataSetOrMember || aZrl instanceof UssFile) {
                    CompareWizardPageResultDatasets.this.allocateResultDataset(aZrl, dsn, CompareWizardPageResultDatasets.this.model.getOldResource().getName());
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)deletesGroup), this.wDeletesDataset, (IHostProvider)this.model.getSystem()).types(VALID_RESULT_TYPES).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                String query = null;
                try {
                    query = CompareWizardPageResultDatasets.this.model.getSystem().getLogin(false).getUsername();
                }
                catch (InterruptedException e) {
                    logger.error((Object)(Messages.CompareWizardPageResultDatasets_USERID_FAILED + e.getMessage()));
                }
                return query + ".**";
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl != null) {
                    CompareWizardPageResultDatasets.this.model.setDeletesDataset(zrl.getFormattedName());
                }
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        this.wDeletesDataset.setText(this.model.getDeletesDataset());
        this.wDeletesDataset.setFocus();
        GUI.label.left((Composite)deletesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION, (Object)GUI.grid.d.left1());
        this.wDeletesDispMod = GUI.button.radio((Composite)deletesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND, (Object)GUI.grid.d.fillH((int)1));
        this.wDeletesDispMod.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND_TOOLTIP);
        this.wDeletesDispMod.setEnabled(true);
        this.wDeletesDispOld = GUI.button.radio((Composite)deletesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE, (Object)GUI.grid.d.fillH((int)1));
        this.wDeletesDispOld.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE_TOOLTIP);
        this.wDeletesDispOld.setEnabled(true);
        GUI.grid.padding((Composite)deletesGroup, (int)8);
        GUI.label.left((Composite)deletesGroup, (String)Messages.CompareWizardPageResultDatasets_RECLEN, (Object)GUI.grid.d.left1());
        this.wDeletesReclen = GUI.combo.editable((Composite)deletesGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wDeletesReclen, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        this.wDeletesReclen.setToolTipText(Messages.CompareWizardPageOld_BINARY_RECORD_LENGTH_TOOLTIP);
        Group nchangesGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageResultDatasets_NCHANGED_RECORDS, (Layout)GUI.grid.l.margins((int)15, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)nchangesGroup, (String)Messages.CompareWizardPageResultDatasets_DATA_SET_NAME, (Object)GUI.grid.d.left1());
        this.wNChangesDataset = GUI.combo.editable((Composite)nchangesGroup, (Object)GUI.grid.d.fillH((int)12));
        this.wNChangesAllocate = GUI.button.push((Composite)nchangesGroup, (String)Messages.CompareWizardPageResultDatasets_ALLOCATE, (Object)GUI.grid.d.left1());
        this.wNChangesAllocate.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String dsn = CompareWizardPageResultDatasets.this.wNChangesDataset.getText();
                IZRL aZrl = ZRLs.parseZRL((IPDHost)CompareWizardPageResultDatasets.this.model.getSystem(), (String)dsn);
                if (aZrl instanceof DataSetOrMember || aZrl instanceof UssFile) {
                    CompareWizardPageResultDatasets.this.allocateResultDataset(aZrl, dsn, CompareWizardPageResultDatasets.this.model.getNewResource().getName());
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)nchangesGroup), this.wNChangesDataset, (IHostProvider)this.model.getSystem()).types(VALID_RESULT_TYPES).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                String query = null;
                try {
                    query = CompareWizardPageResultDatasets.this.model.getSystem().getLogin(false).getUsername();
                }
                catch (InterruptedException e) {
                    logger.error((Object)(Messages.CompareWizardPageResultDatasets_USERID_FAILED + e.getMessage()));
                }
                return query + ".**";
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl != null) {
                    CompareWizardPageResultDatasets.this.model.setNChangesDataset(zrl.getFormattedName());
                }
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        this.wNChangesDataset.setText(this.model.getNChangesDataset());
        this.wNChangesDataset.setFocus();
        GUI.label.left((Composite)nchangesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION, (Object)GUI.grid.d.left1());
        this.wNChangesDispMod = GUI.button.radio((Composite)nchangesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND, (Object)GUI.grid.d.fillH((int)1));
        this.wNChangesDispMod.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND_TOOLTIP);
        this.wNChangesDispMod.setEnabled(true);
        this.wNChangesDispOld = GUI.button.radio((Composite)nchangesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE, (Object)GUI.grid.d.fillH((int)1));
        this.wNChangesDispOld.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE_TOOLTIP);
        this.wNChangesDispOld.setEnabled(true);
        GUI.grid.padding((Composite)nchangesGroup, (int)8);
        GUI.label.left((Composite)nchangesGroup, (String)Messages.CompareWizardPageResultDatasets_RECLEN, (Object)GUI.grid.d.left1());
        this.wNChangesReclen = GUI.combo.editable((Composite)nchangesGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wNChangesReclen, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        this.wNChangesReclen.setToolTipText(Messages.CompareWizardPageOld_BINARY_RECORD_LENGTH_TOOLTIP);
        Group ochangesGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageResultDatasets_OCHANGED_RECORDS, (Layout)GUI.grid.l.margins((int)15, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)ochangesGroup, (String)Messages.CompareWizardPageResultDatasets_DATA_SET_NAME, (Object)GUI.grid.d.left1());
        this.wOChangesDataset = GUI.combo.editable((Composite)ochangesGroup, (Object)GUI.grid.d.fillH((int)12));
        this.wOChangesAllocate = GUI.button.push((Composite)ochangesGroup, (String)Messages.CompareWizardPageResultDatasets_ALLOCATE, (Object)GUI.grid.d.left1());
        this.wOChangesAllocate.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String dsn = CompareWizardPageResultDatasets.this.wOChangesDataset.getText();
                IZRL aZrl = ZRLs.parseZRL((IPDHost)CompareWizardPageResultDatasets.this.model.getSystem(), (String)dsn);
                if (aZrl instanceof DataSetOrMember || aZrl instanceof UssFile) {
                    CompareWizardPageResultDatasets.this.allocateResultDataset(aZrl, dsn, CompareWizardPageResultDatasets.this.model.getOldResource().getName());
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)ochangesGroup), this.wOChangesDataset, (IHostProvider)this.model.getSystem()).types(VALID_RESULT_TYPES).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                String query = null;
                try {
                    query = CompareWizardPageResultDatasets.this.model.getSystem().getLogin(false).getUsername();
                }
                catch (InterruptedException e) {
                    logger.error((Object)(Messages.CompareWizardPageResultDatasets_USERID_FAILED + e.getMessage()));
                }
                return query + ".**";
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl != null) {
                    CompareWizardPageResultDatasets.this.model.setOChangesDataset(zrl.getFormattedName());
                }
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        this.wOChangesDataset.setText(this.model.getOChangesDataset());
        this.wOChangesDataset.setFocus();
        GUI.label.left((Composite)ochangesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION, (Object)GUI.grid.d.left1());
        this.wOChangesDispMod = GUI.button.radio((Composite)ochangesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND, (Object)GUI.grid.d.fillH((int)1));
        this.wOChangesDispMod.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND_TOOLTIP);
        this.wOChangesDispMod.setEnabled(true);
        this.wOChangesDispOld = GUI.button.radio((Composite)ochangesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE, (Object)GUI.grid.d.fillH((int)1));
        this.wOChangesDispOld.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE_TOOLTIP);
        this.wOChangesDispOld.setEnabled(true);
        GUI.grid.padding((Composite)ochangesGroup, (int)8);
        GUI.label.left((Composite)ochangesGroup, (String)Messages.CompareWizardPageResultDatasets_RECLEN, (Object)GUI.grid.d.left1());
        this.wOChangesReclen = GUI.combo.editable((Composite)ochangesGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wOChangesReclen, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        this.wOChangesReclen.setToolTipText(Messages.CompareWizardPageOld_BINARY_RECORD_LENGTH_TOOLTIP);
        Group nmatchesGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageResultDatasets_NMATCHED_RECORDS, (Layout)GUI.grid.l.margins((int)15, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)nmatchesGroup, (String)Messages.CompareWizardPageResultDatasets_DATA_SET_NAME, (Object)GUI.grid.d.left1());
        this.wNMatchesDataset = GUI.combo.editable((Composite)nmatchesGroup, (Object)GUI.grid.d.fillH((int)12));
        this.wNMatchesAllocate = GUI.button.push((Composite)nmatchesGroup, (String)Messages.CompareWizardPageResultDatasets_ALLOCATE, (Object)GUI.grid.d.left1());
        this.wNMatchesAllocate.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String dsn = CompareWizardPageResultDatasets.this.wNMatchesDataset.getText();
                IZRL aZrl = ZRLs.parseZRL((IPDHost)CompareWizardPageResultDatasets.this.model.getSystem(), (String)dsn);
                if (aZrl instanceof DataSetOrMember || aZrl instanceof UssFile) {
                    CompareWizardPageResultDatasets.this.allocateResultDataset(aZrl, dsn, CompareWizardPageResultDatasets.this.model.getNewResource().getName());
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)nmatchesGroup), this.wNMatchesDataset, (IHostProvider)this.model.getSystem()).types(VALID_RESULT_TYPES).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                String query = null;
                try {
                    query = CompareWizardPageResultDatasets.this.model.getSystem().getLogin(false).getUsername();
                }
                catch (InterruptedException e) {
                    logger.error((Object)(Messages.CompareWizardPageResultDatasets_USERID_FAILED + e.getMessage()));
                }
                return query + ".**";
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl != null) {
                    CompareWizardPageResultDatasets.this.model.setNMatchesDataset(zrl.getFormattedName());
                }
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        this.wNMatchesDataset.setText(this.model.getNMatchesDataset());
        this.wNMatchesDataset.setFocus();
        GUI.label.left((Composite)nmatchesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION, (Object)GUI.grid.d.left1());
        this.wNMatchesDispMod = GUI.button.radio((Composite)nmatchesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND, (Object)GUI.grid.d.fillH((int)1));
        this.wNMatchesDispMod.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND_TOOLTIP);
        this.wNMatchesDispMod.setEnabled(true);
        this.wNMatchesDispOld = GUI.button.radio((Composite)nmatchesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE, (Object)GUI.grid.d.fillH((int)1));
        this.wNMatchesDispOld.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE_TOOLTIP);
        this.wNMatchesDispOld.setEnabled(true);
        GUI.grid.padding((Composite)nmatchesGroup, (int)8);
        GUI.label.left((Composite)nmatchesGroup, (String)Messages.CompareWizardPageResultDatasets_RECLEN, (Object)GUI.grid.d.left1());
        this.wNMatchesReclen = GUI.combo.editable((Composite)nmatchesGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wNMatchesReclen, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        this.wNMatchesReclen.setToolTipText(Messages.CompareWizardPageOld_BINARY_RECORD_LENGTH_TOOLTIP);
        Group omatchesGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageResultDatasets_OMATCHED_RECORDS, (Layout)GUI.grid.l.margins((int)15, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)omatchesGroup, (String)Messages.CompareWizardPageResultDatasets_DATA_SET_NAME, (Object)GUI.grid.d.left1());
        this.wOMatchesDataset = GUI.combo.editable((Composite)omatchesGroup, (Object)GUI.grid.d.fillH((int)12));
        this.wOMatchesAllocate = GUI.button.push((Composite)omatchesGroup, (String)Messages.CompareWizardPageResultDatasets_ALLOCATE, (Object)GUI.grid.d.left1());
        this.wOMatchesAllocate.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String dsn = CompareWizardPageResultDatasets.this.wOMatchesDataset.getText();
                IZRL aZrl = ZRLs.parseZRL((IPDHost)CompareWizardPageResultDatasets.this.model.getSystem(), (String)dsn);
                if (aZrl instanceof DataSetOrMember || aZrl instanceof UssFile) {
                    CompareWizardPageResultDatasets.this.allocateResultDataset(aZrl, dsn, CompareWizardPageResultDatasets.this.model.getOldResource().getName());
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)omatchesGroup), this.wOMatchesDataset, (IHostProvider)this.model.getSystem()).types(VALID_RESULT_TYPES).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                String query = null;
                try {
                    query = CompareWizardPageResultDatasets.this.model.getSystem().getLogin(false).getUsername();
                }
                catch (InterruptedException e) {
                    logger.error((Object)(Messages.CompareWizardPageResultDatasets_USERID_FAILED + e.getMessage()));
                }
                return query + ".**";
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl != null) {
                    CompareWizardPageResultDatasets.this.model.setOMatchesDataset(zrl.getFormattedName());
                }
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        this.wOMatchesDataset.setText(this.model.getOMatchesDataset());
        this.wOMatchesDataset.setFocus();
        GUI.label.left((Composite)omatchesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION, (Object)GUI.grid.d.left1());
        this.wOMatchesDispMod = GUI.button.radio((Composite)omatchesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND, (Object)GUI.grid.d.fillH((int)1));
        this.wOMatchesDispMod.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND_TOOLTIP);
        this.wOMatchesDispMod.setEnabled(true);
        this.wOMatchesDispOld = GUI.button.radio((Composite)omatchesGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE, (Object)GUI.grid.d.fillH((int)1));
        this.wOMatchesDispOld.setToolTipText(Messages.CompareWizardPageResultDatasets_DISPOSITION_REPLACE_TOOLTIP);
        this.wOMatchesDispOld.setEnabled(true);
        GUI.grid.padding((Composite)omatchesGroup, (int)8);
        GUI.label.left((Composite)omatchesGroup, (String)Messages.CompareWizardPageResultDatasets_RECLEN, (Object)GUI.grid.d.left1());
        this.wOMatchesReclen = GUI.combo.editable((Composite)omatchesGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wOMatchesReclen, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        this.wOMatchesReclen.setToolTipText(Messages.CompareWizardPageOld_BINARY_RECORD_LENGTH_TOOLTIP);
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wInsertsDataset);
        this.connector.listenTo((Control)this.wInsertsDispMod);
        this.connector.listenTo((Control)this.wInsertsDispOld);
        this.connector.listenTo((Control)this.wInsertsReclen);
        this.connector.listenTo((Control)this.wDeletesDataset);
        this.connector.listenTo((Control)this.wDeletesDispMod);
        this.connector.listenTo((Control)this.wDeletesDispOld);
        this.connector.listenTo((Control)this.wDeletesReclen);
        this.connector.listenTo((Control)this.wNChangesDataset);
        this.connector.listenTo((Control)this.wNChangesDispMod);
        this.connector.listenTo((Control)this.wNChangesDispOld);
        this.connector.listenTo((Control)this.wNChangesReclen);
        this.connector.listenTo((Control)this.wOChangesDataset);
        this.connector.listenTo((Control)this.wOChangesDispMod);
        this.connector.listenTo((Control)this.wOChangesDispOld);
        this.connector.listenTo((Control)this.wOChangesReclen);
        this.connector.listenTo((Control)this.wNMatchesDataset);
        this.connector.listenTo((Control)this.wNMatchesDispMod);
        this.connector.listenTo((Control)this.wNMatchesDispOld);
        this.connector.listenTo((Control)this.wNMatchesReclen);
        this.connector.listenTo((Control)this.wOMatchesDataset);
        this.connector.listenTo((Control)this.wOMatchesDispMod);
        this.connector.listenTo((Control)this.wOMatchesDispOld);
        this.connector.listenTo((Control)this.wOMatchesReclen);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        IZRL aZrl;
        String dsn = this.wInsertsDataset.getText();
        if (!dsn.isEmpty() && !ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)dsn)) {
            this.wInsertsAllocate.setEnabled(false);
            return Messages.CompareWizardPageResultDatasets_INVALID_DATASET_NAME;
        }
        if (dsn.isEmpty()) {
            this.wInsertsAllocate.setEnabled(false);
            this.wInsertsDispMod.setEnabled(true);
        } else {
            aZrl = ZRLs.parseZRL((IPDHost)this.model.getSystem(), (String)dsn);
            if (aZrl instanceof DataSetOrMember) {
                this.wInsertsAllocate.setEnabled(true);
                if (aZrl instanceof Member) {
                    this.wInsertsDispMod.setSelection(false);
                    this.wInsertsDispOld.setSelection(true);
                    this.wInsertsDispMod.setEnabled(false);
                } else {
                    this.wInsertsDispMod.setEnabled(true);
                }
            } else if (aZrl instanceof UssFile) {
                this.wInsertsAllocate.setEnabled(true);
                this.wInsertsDispMod.setEnabled(true);
            } else {
                this.wInsertsDispMod.setEnabled(true);
            }
        }
        dsn = this.wDeletesDataset.getText();
        if (!dsn.isEmpty() && !ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)dsn)) {
            this.wDeletesAllocate.setEnabled(false);
            return Messages.CompareWizardPageResultDatasets_INVALID_DATASET_NAME;
        }
        if (dsn.isEmpty()) {
            this.wDeletesAllocate.setEnabled(false);
            this.wDeletesDispMod.setEnabled(true);
        } else {
            aZrl = ZRLs.parseZRL((IPDHost)this.model.getSystem(), (String)dsn);
            if (aZrl instanceof DataSetOrMember) {
                this.wDeletesAllocate.setEnabled(true);
                if (aZrl instanceof Member) {
                    this.wDeletesDispMod.setSelection(false);
                    this.wDeletesDispOld.setSelection(true);
                    this.wDeletesDispMod.setEnabled(false);
                } else {
                    this.wDeletesDispMod.setEnabled(true);
                }
            } else if (aZrl instanceof UssFile) {
                this.wDeletesAllocate.setEnabled(true);
                this.wDeletesDispMod.setEnabled(true);
            } else {
                this.wDeletesDispMod.setEnabled(true);
            }
        }
        dsn = this.wNChangesDataset.getText();
        if (!dsn.isEmpty() && !ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)dsn)) {
            this.wNChangesAllocate.setEnabled(false);
            return Messages.CompareWizardPageResultDatasets_INVALID_DATASET_NAME;
        }
        if (dsn.isEmpty()) {
            this.wNChangesAllocate.setEnabled(false);
            this.wNChangesDispMod.setEnabled(true);
        } else {
            aZrl = ZRLs.parseZRL((IPDHost)this.model.getSystem(), (String)dsn);
            if (aZrl instanceof DataSetOrMember) {
                this.wNChangesAllocate.setEnabled(true);
                if (aZrl instanceof Member) {
                    this.wNChangesDispMod.setSelection(false);
                    this.wNChangesDispOld.setSelection(true);
                    this.wNChangesDispMod.setEnabled(false);
                } else {
                    this.wNChangesDispMod.setEnabled(true);
                }
            } else if (aZrl instanceof UssFile) {
                this.wNChangesAllocate.setEnabled(true);
                this.wNChangesDispMod.setEnabled(true);
            } else {
                this.wNChangesDispMod.setEnabled(true);
            }
        }
        dsn = this.wOChangesDataset.getText();
        if (!dsn.isEmpty() && !ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)dsn)) {
            this.wOChangesAllocate.setEnabled(false);
            return Messages.CompareWizardPageResultDatasets_INVALID_DATASET_NAME;
        }
        if (dsn.isEmpty()) {
            this.wOChangesAllocate.setEnabled(false);
            this.wOChangesDispMod.setEnabled(true);
        } else {
            aZrl = ZRLs.parseZRL((IPDHost)this.model.getSystem(), (String)dsn);
            if (aZrl instanceof DataSetOrMember) {
                this.wOChangesAllocate.setEnabled(true);
                if (aZrl instanceof Member) {
                    this.wOChangesDispMod.setSelection(false);
                    this.wOChangesDispOld.setSelection(true);
                    this.wOChangesDispMod.setEnabled(false);
                } else {
                    this.wOChangesDispMod.setEnabled(true);
                }
            } else if (aZrl instanceof UssFile) {
                this.wOChangesAllocate.setEnabled(true);
                this.wOChangesDispMod.setEnabled(true);
            } else {
                this.wOChangesDispMod.setEnabled(true);
            }
        }
        dsn = this.wNMatchesDataset.getText();
        if (!dsn.isEmpty() && !ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)dsn)) {
            this.wNMatchesAllocate.setEnabled(false);
            return Messages.CompareWizardPageResultDatasets_INVALID_DATASET_NAME;
        }
        if (dsn.isEmpty()) {
            this.wNMatchesAllocate.setEnabled(false);
            this.wNMatchesDispMod.setEnabled(true);
        } else {
            aZrl = ZRLs.parseZRL((IPDHost)this.model.getSystem(), (String)dsn);
            if (aZrl instanceof DataSetOrMember) {
                this.wNMatchesAllocate.setEnabled(true);
                if (aZrl instanceof Member) {
                    this.wNMatchesDispMod.setSelection(false);
                    this.wNMatchesDispOld.setSelection(true);
                    this.wNMatchesDispMod.setEnabled(false);
                } else {
                    this.wNMatchesDispMod.setEnabled(true);
                }
            } else if (aZrl instanceof UssFile) {
                this.wNMatchesAllocate.setEnabled(true);
                this.wNMatchesDispMod.setEnabled(true);
            } else {
                this.wNMatchesDispMod.setEnabled(true);
            }
        }
        dsn = this.wOMatchesDataset.getText();
        if (!dsn.isEmpty() && !ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)dsn)) {
            this.wOMatchesAllocate.setEnabled(false);
            return Messages.CompareWizardPageResultDatasets_INVALID_DATASET_NAME;
        }
        if (dsn.isEmpty()) {
            this.wOMatchesAllocate.setEnabled(false);
            this.wOMatchesDispMod.setEnabled(true);
        } else {
            aZrl = ZRLs.parseZRL((IPDHost)this.model.getSystem(), (String)dsn);
            if (aZrl instanceof DataSetOrMember) {
                this.wOMatchesAllocate.setEnabled(true);
                if (aZrl instanceof Member) {
                    this.wOMatchesDispMod.setSelection(false);
                    this.wOMatchesDispOld.setSelection(true);
                    this.wOMatchesDispMod.setEnabled(false);
                } else {
                    this.wOMatchesDispMod.setEnabled(true);
                }
            } else if (aZrl instanceof UssFile) {
                this.wOMatchesAllocate.setEnabled(true);
                this.wOMatchesDispMod.setEnabled(true);
            } else {
                this.wOMatchesDispMod.setEnabled(true);
            }
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    public void disableFinish() {
        this.setPageComplete(false);
    }

    public void enableFinish() {
        this.setPageComplete(true);
    }

    private void allocateResultDataset(final IZRL aZrl, final String dsn, final String likeDataset) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    howIsGoing.beginTask(Messages.AllocateDataSetRunnable_TASK_NAME, 6);
                    howIsGoing.worked(1);
                    String validationResult = CompareWizardPageResultDatasets.this.allocateValidation(howIsGoing, aZrl, dsn);
                    howIsGoing.worked(1);
                    if (validationResult == null) {
                        CompareWizardPageResultDatasets.this.allocatePrompt(aZrl, dsn, likeDataset);
                    } else {
                        PDDialogs.openInfoThreadSafe((String)Messages.ActionHistoryFactory_ALLOCATE_DATA_SET, (String)validationResult);
                    }
                    howIsGoing.done();
                }
            });
            this.getContainer().getCurrentPage().setVisible(true);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if (t instanceof IllegalArgumentException) {
                PDDialogs.openErrorThreadSafe((String)Messages.CompareWizardPageResultDatasets_ALLOCATE_FAILED, (String)t.getMessage(), (Throwable)t);
            }
            logger.error(t);
        }
    }

    private String allocateValidation(IHowIsGoing howIsGoing, IZRL aZrl, String dsn) {
        block8: {
            block9: {
                block7: {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CompareWizardPageResultDatasets.this.disableFinish();
                        }
                    });
                    if (!(aZrl instanceof DataSetOrMember)) break block7;
                    DataSet newDataset = ((DataSetOrMember)aZrl).asDataSet();
                    Result refreshExistence = newDataset.refreshExistence(howIsGoing);
                    if (refreshExistence.isSuccessfulWithoutWarnings()) {
                        if (newDataset.getConfirmedExists()) {
                            return Messages.CompareWizardPageResultDatasets_DATA_SET_EXISTS;
                        }
                        return null;
                    }
                }
                if (!(aZrl instanceof UssFile)) break block8;
                UssFile newFile = UssFile.parse((IPDHost)this.model.getSystem(), (String)dsn);
                Result refreshExistence = newFile.doRefresh(howIsGoing, false);
                if (refreshExistence.getRC() != 0) break block9;
                if (newFile.getConfirmedExists()) {
                    return Messages.CompareWizardPageResultDatasets_DATA_SET_EXISTS;
                }
                return null;
            }
            try {
                return Messages.CompareWizardPageResultDatasets_ALLOCATE_ZFS_FAILED;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return Messages.CompareWizardPageResultDatasets_VERIFY_FAILED;
    }

    private void allocatePrompt(final IZRL aZrl, final String dsn, final String likeDataset) throws InterruptedException {
        final AtomicInteger result = new AtomicInteger();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                FMBaseWizard wizard = null;
                ActionItem action = null;
                if (aZrl instanceof DataSetOrMember) {
                    AllocateDataSetModel allocateParams = new AllocateDataSetModel();
                    DataSet newDataset = ((DataSetOrMember)aZrl).asDataSet();
                    allocateParams.setDataSetName(newDataset.getName());
                    allocateParams.setHost(CompareWizardPageResultDatasets.this.model.getSystem());
                    IZRL aZrl2 = ZRLs.parseZRL((IPDHost)CompareWizardPageResultDatasets.this.model.getSystem(), (String)likeDataset);
                    if (aZrl2 instanceof DataSetOrMember) {
                        DataSet allocateLike = ((DataSetOrMember)aZrl2).asDataSet();
                        allocateParams.setAllocateLike(allocateLike);
                    }
                    wizard = AllocateDataSetWizard.create(allocateParams);
                    action = new AllocateDataSetActionItem(allocateParams, CompareWizardPageResultDatasets.this.model.getSystem());
                } else if (aZrl instanceof UssFile) {
                    AllocateHFSModel allocateParms = new AllocateHFSModel(CompareWizardPageResultDatasets.this.model.getSystem());
                    allocateParms.setResource(dsn);
                    wizard = new AllocateHFSWizard(allocateParms);
                    action = new AllocateHFSActionItem(allocateParms);
                }
                try {
                    final ActionItem finalAction = action;
                    if (wizard != null && action != null) {
                        wizard.getRunnable().addCallback(new Runnable(){

                            @Override
                            public void run() {
                                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)finalAction);
                                CompareWizardPageResultDatasets.this.enableFinish();
                            }
                        });
                        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
                        result.set(PDScrollableWizardDialog.openWizard((IWizard)wizard));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)(Messages.CompareWizardPageResultDatasets_ALLOCATE_FAILED + ": " + e.getMessage()));
                }
            }
        });
        if (result.get() == 1) {
            throw new InterruptedException();
        }
    }

    private class CompareWizardPageResultDatasetsConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2020. All rights reserved.";

        private CompareWizardPageResultDatasetsConnector() {
        }

        protected void updateModelFromViewImpl() {
            CompareWizardPageResultDatasets.this.model.setInsertsDataset(CompareWizardPageResultDatasets.this.wInsertsDataset.getText());
            if (CompareWizardPageResultDatasets.this.wInsertsDispMod.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setInsertsDisposition(DSM.DsmDisp.MOD);
            } else if (CompareWizardPageResultDatasets.this.wInsertsDispOld.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setInsertsDisposition(DSM.DsmDisp.OLD);
            }
            CompareWizardPageResultDatasets.this.model.setInsertsReclen(CompareWizardPageResultDatasets.this.wInsertsReclen.getText());
            CompareWizardPageResultDatasets.this.model.setDeletesDataset(CompareWizardPageResultDatasets.this.wDeletesDataset.getText());
            if (CompareWizardPageResultDatasets.this.wDeletesDispMod.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setDeletesDisposition(DSM.DsmDisp.MOD);
            } else if (CompareWizardPageResultDatasets.this.wDeletesDispOld.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setDeletesDisposition(DSM.DsmDisp.OLD);
            }
            CompareWizardPageResultDatasets.this.model.setDeletesReclen(CompareWizardPageResultDatasets.this.wDeletesReclen.getText());
            CompareWizardPageResultDatasets.this.model.setNChangesDataset(CompareWizardPageResultDatasets.this.wNChangesDataset.getText());
            if (CompareWizardPageResultDatasets.this.wNChangesDispMod.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setNChangesDisposition(DSM.DsmDisp.MOD);
            } else if (CompareWizardPageResultDatasets.this.wNChangesDispOld.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setNChangesDisposition(DSM.DsmDisp.OLD);
            }
            CompareWizardPageResultDatasets.this.model.setNChangesReclen(CompareWizardPageResultDatasets.this.wNChangesReclen.getText());
            CompareWizardPageResultDatasets.this.model.setOChangesDataset(CompareWizardPageResultDatasets.this.wOChangesDataset.getText());
            if (CompareWizardPageResultDatasets.this.wOChangesDispMod.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setOChangesDisposition(DSM.DsmDisp.MOD);
            } else if (CompareWizardPageResultDatasets.this.wOChangesDispOld.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setOChangesDisposition(DSM.DsmDisp.OLD);
            }
            CompareWizardPageResultDatasets.this.model.setOChangesReclen(CompareWizardPageResultDatasets.this.wOChangesReclen.getText());
            CompareWizardPageResultDatasets.this.model.setNMatchesDataset(CompareWizardPageResultDatasets.this.wNMatchesDataset.getText());
            if (CompareWizardPageResultDatasets.this.wNMatchesDispMod.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setNMatchesDisposition(DSM.DsmDisp.MOD);
            } else if (CompareWizardPageResultDatasets.this.wNMatchesDispOld.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setNMatchesDisposition(DSM.DsmDisp.OLD);
            }
            CompareWizardPageResultDatasets.this.model.setNMatchesReclen(CompareWizardPageResultDatasets.this.wNMatchesReclen.getText());
            CompareWizardPageResultDatasets.this.model.setOMatchesDataset(CompareWizardPageResultDatasets.this.wOMatchesDataset.getText());
            if (CompareWizardPageResultDatasets.this.wOMatchesDispMod.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setOMatchesDisposition(DSM.DsmDisp.MOD);
            } else if (CompareWizardPageResultDatasets.this.wOMatchesDispOld.getSelection()) {
                CompareWizardPageResultDatasets.this.model.setOMatchesDisposition(DSM.DsmDisp.OLD);
            }
            CompareWizardPageResultDatasets.this.model.setOMatchesReclen(CompareWizardPageResultDatasets.this.wOMatchesReclen.getText());
            CompareWizardPageResultDatasets.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wInsertsDataset, CompareWizardPageResultDatasets.this.model.getInsertsDataset());
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wInsertsReclen, CompareWizardPageResultDatasets.this.model.getInsertsReclen());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wInsertsDispMod, CompareWizardPageResultDatasets.this.model.getInsertsDisposition() == DSM.DsmDisp.MOD);
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wInsertsDispOld, CompareWizardPageResultDatasets.this.model.getInsertsDisposition() == DSM.DsmDisp.OLD);
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wDeletesDataset, CompareWizardPageResultDatasets.this.model.getDeletesDataset());
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wDeletesReclen, CompareWizardPageResultDatasets.this.model.getDeletesReclen());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wDeletesDispMod, CompareWizardPageResultDatasets.this.model.getDeletesDisposition() == DSM.DsmDisp.MOD);
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wDeletesDispOld, CompareWizardPageResultDatasets.this.model.getDeletesDisposition() == DSM.DsmDisp.OLD);
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wNChangesDataset, CompareWizardPageResultDatasets.this.model.getNChangesDataset());
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wNChangesReclen, CompareWizardPageResultDatasets.this.model.getNChangesReclen());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wNChangesDispMod, CompareWizardPageResultDatasets.this.model.getNChangesDisposition() == DSM.DsmDisp.MOD);
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wNChangesDispOld, CompareWizardPageResultDatasets.this.model.getNChangesDisposition() == DSM.DsmDisp.OLD);
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wOChangesDataset, CompareWizardPageResultDatasets.this.model.getOChangesDataset());
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wOChangesReclen, CompareWizardPageResultDatasets.this.model.getOChangesReclen());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wOChangesDispMod, CompareWizardPageResultDatasets.this.model.getOChangesDisposition() == DSM.DsmDisp.MOD);
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wOChangesDispOld, CompareWizardPageResultDatasets.this.model.getOChangesDisposition() == DSM.DsmDisp.OLD);
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wNMatchesDataset, CompareWizardPageResultDatasets.this.model.getNMatchesDataset());
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wNMatchesReclen, CompareWizardPageResultDatasets.this.model.getNMatchesReclen());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wNMatchesDispMod, CompareWizardPageResultDatasets.this.model.getNMatchesDisposition() == DSM.DsmDisp.MOD);
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wNMatchesDispOld, CompareWizardPageResultDatasets.this.model.getNMatchesDisposition() == DSM.DsmDisp.OLD);
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wOMatchesDataset, CompareWizardPageResultDatasets.this.model.getOMatchesDataset());
            this.updateComboFromModelIfNeeded(CompareWizardPageResultDatasets.this.wOMatchesReclen, CompareWizardPageResultDatasets.this.model.getOMatchesReclen());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wOMatchesDispMod, CompareWizardPageResultDatasets.this.model.getOMatchesDisposition() == DSM.DsmDisp.MOD);
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageResultDatasets.this.wOMatchesDispOld, CompareWizardPageResultDatasets.this.model.getOMatchesDisposition() == DSM.DsmDisp.OLD);
            String validationErrorMessage = CompareWizardPageResultDatasets.this.getValidationErrorMessage();
            CompareWizardPageResultDatasets.this.setPageComplete(validationErrorMessage == null);
            CompareWizardPageResultDatasets.this.setErrorMessage(validationErrorMessage);
        }
    }
}

