/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.socket.func.DSM;
import com.ibm.etools.fm.ui.dialog.MemberLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.MemberSelectionCriteriaComposite;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.CompareModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.ByteStringComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CompareWizardPageOld
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(CompareWizardPageOld.class);
    private static final String COMMA = ",";
    private final CompareModel command;
    private CompareWizardPageOldConnector connector = new CompareWizardPageOldConnector();
    private Combo wMemberList;
    private Button wMemberListLookup;
    private MemberSelectionCriteriaComposite wMemberSelection;
    private Button wIoExit;
    private Combo wIoExitCustom;
    private Combo wBinaryRecordLength;
    private Combo wKey;
    private Combo wSkip;
    private Combo wCompare;

    protected CompareWizardPageOld(CompareModel command) {
        super(Messages.CompareWizardPageOld_OLD_RESOURCE_SETTINGS);
        this.setTitle(Messages.CompareWizardPageOld_OLD_RESOURCE_SETTINGS);
        this.setMessage(Messages.CompareWizardPageOld_SPECIFY_OLD_SETTINGS);
        this.command = command;
    }

    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group memberGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageOld_MEMBER_SPECIFICATION, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        GUI.label.left((Composite)memberGroup, (String)Messages.CompareWizardPageOld_MEMBERS, (Object)GUI.grid.d.left1());
        this.wMemberList = GUI.combo.editable((Composite)memberGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMemberList, ((Object)((Object)this)).getClass().getCanonicalName() + "Members");
        this.wMemberList.setToolTipText(Messages.CompareWizardPageOld_MEMBERS_TOOLTIP);
        this.wMemberListLookup = LookupButton.createLookupButtonLeft1((Composite)memberGroup);
        this.wMemberSelection = new MemberSelectionCriteriaComposite((Composite)memberGroup, 0, this.command.getOldMemberSelectionCriteria());
        this.wMemberSelection.setLayoutData(GUI.grid.d.fillH((int)3));
        final Combo getwExcludeMembers = this.wMemberSelection.getwExcludeMembers();
        getwExcludeMembers.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (!getwExcludeMembers.getText().equals("")) {
                    CompareWizardPageOld.this.filterMamberList(getwExcludeMembers);
                }
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.wMemberList.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (!getwExcludeMembers.getText().equals("")) {
                    CompareWizardPageOld.this.filterMamberList(getwExcludeMembers);
                }
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.wMemberListLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MemberLookupDialog dlg = new MemberLookupDialog((DataSet)CompareWizardPageOld.this.command.getOldResource(), getwExcludeMembers.getText());
                if (dlg.open() == 0) {
                    CompareWizardPageOld.this.wMemberListLookup.setFocus();
                    for (Member member : dlg.getSelectedMembers()) {
                        ArrayList<String> membersList = new ArrayList<String>(CompareWizardPageOld.this.command.getOldMemberListAsList());
                        if (membersList.contains(member.getName())) continue;
                        membersList.add(member.getName());
                        Collections.sort(membersList, new ByteStringComparator(CompareWizardPageOld.this.command.getSystem().getHostType()));
                        Object text2 = "";
                        for (String mem : membersList) {
                            text2 = !((String)text2).isEmpty() ? (String)text2 + CompareWizardPageOld.COMMA + mem : mem;
                        }
                        CompareWizardPageOld.this.wMemberList.setText((String)text2);
                    }
                }
            }
        });
        Group miscGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageOld_MISC_SETTINGS, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wIoExit = GUI.button.checkbox((Composite)miscGroup, (String)Messages.Label__IO_EXIT, (Object)GUI.grid.d.left1());
        this.wIoExitCustom = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wIoExitCustom, ((Object)((Object)this)).getClass().getCanonicalName() + "CustomIOExit");
        GUI.label.left((Composite)miscGroup, (String)Messages.Label__BINARY_RECORD_LENGTH, (Object)GUI.grid.d.left1());
        this.wBinaryRecordLength = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)2));
        NumberForcer.addTo(this.wBinaryRecordLength, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        this.wBinaryRecordLength.setToolTipText(Messages.CompareWizardPageOld_BINARY_RECORD_LENGTH_TOOLTIP);
        GUI.label.left((Composite)miscGroup, (String)Messages.CompareWizardPageOld_KSDS_KEY_RRDS_SLOT, (Object)GUI.grid.d.left1());
        this.wKey = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wKey, ((Object)((Object)this)).getClass().getCanonicalName() + "Key");
        this.wKey.setToolTipText(Messages.CompareWizardPageOld_KSDS_KEY_RRDS_SLOT_TOOLTIP);
        GUI.label.left((Composite)miscGroup, (String)Messages.CompareWizardPageOld_SKIP, (Object)GUI.grid.d.left1());
        this.wSkip = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)2));
        NumberForcer.addTo(this.wSkip, ((Object)((Object)this)).getClass().getCanonicalName() + "Skip");
        this.wSkip.setToolTipText(Messages.CompareWizardPageOld_SKIP_TOOLTIP);
        GUI.label.left((Composite)miscGroup, (String)Messages.CompareWizardPageOld_COMPARE, (Object)GUI.grid.d.left1());
        this.wCompare = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wCompare, ((Object)((Object)this)).getClass().getCanonicalName() + "Compare");
        this.wCompare.setToolTipText(Messages.CompareWizardPageOld_COMPARE_TOOLTIP);
        this.connector.listenTo(this.command);
        this.connector.listenTo((Control)this.wMemberList);
        this.connector.listenTo((Control)this.wIoExit);
        this.connector.listenTo((Control)this.wIoExitCustom);
        this.connector.listenTo((Control)this.wBinaryRecordLength);
        this.connector.listenTo((Control)this.wKey);
        this.connector.listenTo((Control)this.wSkip);
        this.connector.listenTo((Control)this.wCompare);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.wMemberSelection.setResource(this.command.getOldResource());
            this.wMemberSelection.getConnector().doManualViewUpdate();
            this.connector.doManualViewUpdate();
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        if (!UIValidator.isValidMemberList(this.command.getOldMemberListSet(), false, this.command.getSystem().getCodePage()) && !UIValidator.isValidWildcardableMember(this.command.getOldMemberListSet(), this.command.getSystem().getCodePage())) {
            return Messages.CompareWizardPageOld_INVALID_MEM_LIST;
        }
        if (this.command.getOldCompareSet().length() > 0 && !"ALL".equals(this.command.getOldCompareSet())) {
            try {
                Integer.parseInt(this.command.getOldCompareSet());
            }
            catch (NumberFormatException e) {
                return Messages.CompareWizardPageOld_INVALID_COMPARE_RECORDS;
            }
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    private void filterMamberList(Combo getwExcludeMembers) {
        List<String> memberList = new ArrayList<String>(Arrays.asList(this.wMemberList.getText().split(COMMA)));
        ArrayList<String> excludeList = new ArrayList<String>(Arrays.asList(getwExcludeMembers.getText().split(COMMA)));
        for (String exclude : excludeList) {
            memberList = memberList.stream().filter(s -> !s.matches(exclude.replaceAll("\\*", "\\\\w*"))).collect(Collectors.toList());
        }
        this.wMemberList.setText(String.join((CharSequence)COMMA, memberList));
    }

    private class CompareWizardPageOldConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private CompareWizardPageOldConnector() {
        }

        protected void updateModelFromViewImpl() {
            CompareWizardPageOld.this.command.setOldMemberList(CompareWizardPageOld.this.wMemberList.getText());
            CompareWizardPageOld.this.command.setOldIoExit(CompareWizardPageOld.this.wIoExit.getSelection());
            CompareWizardPageOld.this.command.setOldIoExitCustom(CompareWizardPageOld.this.wIoExitCustom.getText());
            CompareWizardPageOld.this.command.setOldBinaryRecordLength(CompareWizardPageOld.this.wBinaryRecordLength.getText());
            CompareWizardPageOld.this.command.setOldKey(CompareWizardPageOld.this.wKey.getText());
            CompareWizardPageOld.this.command.setOldSkip(CompareWizardPageOld.this.wSkip.getText());
            CompareWizardPageOld.this.command.setOldCompare(CompareWizardPageOld.this.wCompare.getText());
            CompareWizardPageOld.this.command.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            CompareWizardPageOld.this.wMemberSelection.setResource(CompareWizardPageOld.this.command.getOldResource());
            this.updateComboFromModelIfNeeded(CompareWizardPageOld.this.wMemberList, CompareWizardPageOld.this.command.getOldMemberListSet());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageOld.this.wIoExit, CompareWizardPageOld.this.command.isOldIoExit());
            this.updateComboFromModelIfNeeded(CompareWizardPageOld.this.wIoExitCustom, CompareWizardPageOld.this.command.getOldIoExitCustom());
            this.updateComboFromModelIfNeeded(CompareWizardPageOld.this.wBinaryRecordLength, CompareWizardPageOld.this.command.getOldBinaryRecordLength());
            this.updateComboFromModelIfNeeded(CompareWizardPageOld.this.wKey, CompareWizardPageOld.this.command.getOldKey());
            this.updateComboFromModelIfNeeded(CompareWizardPageOld.this.wSkip, CompareWizardPageOld.this.command.getOldSkip());
            this.updateComboFromModelIfNeeded(CompareWizardPageOld.this.wCompare, CompareWizardPageOld.this.command.getOldCompare());
            boolean resourceHasMembers = CompareWizardPageOld.this.command.getOldResource() instanceof DataSet && ((DataSet)CompareWizardPageOld.this.command.getOldResource()).getHasMembers();
            CompareWizardPageOld.this.wMemberList.setEnabled(resourceHasMembers);
            CompareWizardPageOld.this.wMemberListLookup.setEnabled(resourceHasMembers);
            CompareWizardPageOld.this.wIoExit.setEnabled(CompareWizardPageOld.this.command.getSynch() != DSM.DsmSynch.LMOD);
            CompareWizardPageOld.this.wIoExitCustom.setEnabled(CompareWizardPageOld.this.command.isOldIoExit() && CompareWizardPageOld.this.command.getSynch() != DSM.DsmSynch.LMOD);
            CompareWizardPageOld.this.wBinaryRecordLength.setEnabled(CompareWizardPageOld.this.command.getOldResource() instanceof UssFile);
            if (CompareWizardPageOld.this.command.getOldResource() instanceof DataSet) {
                DataSetType type = ((DataSet)CompareWizardPageOld.this.command.getOldResource()).getType();
                CompareWizardPageOld.this.wKey.setEnabled(type == DataSetType.RRDS || type == DataSetType.KSDS || type == DataSetType.KSDSIAM);
            } else if (CompareWizardPageOld.this.command.getOldResource() instanceof CicsFile) {
                CicsFile cicsFile = (CicsFile)CompareWizardPageOld.this.command.getOldResource();
                CompareWizardPageOld.this.wKey.setEnabled(cicsFile.getKeyLength() != -1 && cicsFile.getKeyStartLocation() != -1);
            } else {
                CompareWizardPageOld.this.wKey.setEnabled(false);
            }
            CompareWizardPageOld.this.wSkip.setEnabled(CompareWizardPageOld.this.command.getSynch() != DSM.DsmSynch.LMOD);
            CompareWizardPageOld.this.wCompare.setEnabled(CompareWizardPageOld.this.command.getSynch() != DSM.DsmSynch.LMOD);
            CompareWizardPageOld.this.wMemberSelection.setCreatedEnabled(CompareWizardPageOld.this.command.getSynch() != DSM.DsmSynch.LMOD);
            CompareWizardPageOld.this.wMemberSelection.setChangedEnabled(CompareWizardPageOld.this.command.getSynch() != DSM.DsmSynch.LMOD);
            CompareWizardPageOld.this.wMemberSelection.setUseridEnabled(CompareWizardPageOld.this.command.getSynch() != DSM.DsmSynch.LMOD);
            String validationErrorMessage = CompareWizardPageOld.this.getValidationErrorMessage();
            CompareWizardPageOld.this.setPageComplete(validationErrorMessage == null);
            CompareWizardPageOld.this.setErrorMessage(validationErrorMessage);
        }
    }
}

