/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.socket.func.DSM;
import com.ibm.etools.fm.ui.dialog.MemberLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.CompareModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CompareWizardPageNew
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(CompareWizardPageNew.class);
    private final CompareModel command;
    private CompareWizardPageNewConnector connector = new CompareWizardPageNewConnector();
    private Combo wMember;
    private Button wMemberLookup;
    private Button wIoExit;
    private Combo wIoExitCustom;
    private Combo wBinaryRecordLength;
    private Combo wKey;
    private Combo wSkip;
    private Combo wCompare;

    protected CompareWizardPageNew(CompareModel command) {
        super(Messages.CompareWizardPageNew_NEW_RESOURCE_SETTINGS);
        this.setTitle(Messages.CompareWizardPageNew_NEW_RESOURCE_SETTINGS);
        this.setMessage(Messages.CompareWizardPageNew_SPECIFY_NEW_RESOURCE_SETTINGS);
        this.command = command;
    }

    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group memberGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageNew_MEMBER_SPECIFICATION, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        GUI.label.left((Composite)memberGroup, (String)Messages.CompareWizardPageNew_MEMBER, (Object)GUI.grid.d.left1());
        this.wMember = GUI.combo.editable((Composite)memberGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wMember.setToolTipText(Messages.CompareWizardPageNew_MEMBER_TOOLTIP);
        new ComboValueSaver(this.wMember, ((Object)((Object)this)).getClass().getCanonicalName() + "Members");
        this.wMemberLookup = LookupButton.createLookupButtonLeft1((Composite)memberGroup);
        this.wMemberLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ArrayList<Member> selectedMembers;
                MemberLookupDialog dlg = new MemberLookupDialog((DataSet)CompareWizardPageNew.this.command.getNewResource(), "");
                dlg.setAllowMultiSelect(false);
                if (dlg.open() == 0 && !(selectedMembers = dlg.getSelectedMembers()).isEmpty()) {
                    CompareWizardPageNew.this.wMemberLookup.setFocus();
                    Member selectedMember = (Member)selectedMembers.get(0);
                    CompareWizardPageNew.this.wMember.setText(selectedMember.getName());
                }
            }
        });
        Group miscGroup = GUI.group((Composite)parent, (String)Messages.CompareWizardPageNew_MISC_SETTINGS, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wIoExit = GUI.button.checkbox((Composite)miscGroup, (String)Messages.Label__IO_EXIT, (Object)GUI.grid.d.left1());
        this.wIoExitCustom = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wIoExitCustom, ((Object)((Object)this)).getClass().getCanonicalName() + "CustomIOExit");
        GUI.label.left((Composite)miscGroup, (String)Messages.Label__BINARY_RECORD_LENGTH, (Object)GUI.grid.d.left1());
        this.wBinaryRecordLength = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wBinaryRecordLength, ((Object)((Object)this)).getClass().getCanonicalName() + "BinRecLen");
        this.wBinaryRecordLength.setToolTipText(Messages.CompareWizardPageOld_BINARY_RECORD_LENGTH_TOOLTIP);
        GUI.label.left((Composite)miscGroup, (String)Messages.CompareWizardPageNew_KSDS_KEY_RRDS_SLOT, (Object)GUI.grid.d.left1());
        this.wKey = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wKey, ((Object)((Object)this)).getClass().getCanonicalName() + "Key");
        this.wKey.setToolTipText(Messages.CompareWizardPageOld_KSDS_KEY_RRDS_SLOT_TOOLTIP);
        GUI.label.left((Composite)miscGroup, (String)Messages.CompareWizardPageNew_SKIP, (Object)GUI.grid.d.left1());
        this.wSkip = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wSkip, ((Object)((Object)this)).getClass().getCanonicalName() + "Skip");
        this.wSkip.setToolTipText(Messages.CompareWizardPageOld_SKIP_TOOLTIP);
        GUI.label.left((Composite)miscGroup, (String)Messages.CompareWizardPageNew_COMPARE, (Object)GUI.grid.d.left1());
        this.wCompare = GUI.combo.editable((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wCompare, ((Object)((Object)this)).getClass().getCanonicalName() + "Compare");
        this.wCompare.setToolTipText(Messages.CompareWizardPageOld_COMPARE_TOOLTIP);
        this.connector.listenTo(this.command);
        this.connector.listenTo((Control)this.wMember);
        this.connector.listenTo((Control)this.wIoExit);
        this.connector.listenTo((Control)this.wIoExitCustom);
        this.connector.listenTo((Control)this.wBinaryRecordLength);
        this.connector.listenTo((Control)this.wKey);
        this.connector.listenTo((Control)this.wSkip);
        this.connector.listenTo((Control)this.wCompare);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        if (this.command.getNewMemberSet().length() > 0 && !Member.isValidName((String)this.command.getNewMemberSet(), (String)this.command.getSystem().getCodePage())) {
            return Messages.CompareWizardPageNew_INVALID_MEMBER;
        }
        if (this.command.getNewCompareSet().length() > 0 && !"ALL".equals(this.command.getNewCompareSet())) {
            try {
                Integer.parseInt(this.command.getNewCompareSet());
            }
            catch (NumberFormatException e) {
                return Messages.CompareWizardPageNew_INVALID_COMPARE_NUM;
            }
        }
        if (this.command.getNumberDifferencesSet().length() > 0 && !"ALL".equals(this.command.getNumberDifferencesSet())) {
            try {
                Integer.parseInt(this.command.getNumberDifferencesSet());
            }
            catch (NumberFormatException e) {
                return Messages.CompareWizardPageNew_INVALID_NUMBER_DIFFERENCES;
            }
        }
        boolean resourceHasMembers = this.command.getNewResource() instanceof DataSet && ((DataSet)this.command.getNewResource()).getHasMembers();
        boolean multipleOldMembers = this.command.isMultipleOldMembersSelected(true);
        if (resourceHasMembers && multipleOldMembers && this.command.getNewMemberSet().length() > 0) {
            return Messages.CompareWizardPageNew_MULTIPLE_MEMBERS_DISALLOWED;
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    public IWizardPage getNextPage() {
        if (this.command.getSynch() == DSM.DsmSynch.LMOD) {
            return super.getNextPage().getNextPage();
        }
        return super.getNextPage();
    }

    private class CompareWizardPageNewConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private CompareWizardPageNewConnector() {
        }

        protected void updateModelFromViewImpl() {
            CompareWizardPageNew.this.command.setNewMember(CompareWizardPageNew.this.wMember.getText());
            CompareWizardPageNew.this.command.setNewIoExit(CompareWizardPageNew.this.wIoExit.getSelection());
            CompareWizardPageNew.this.command.setNewIoExitCustom(CompareWizardPageNew.this.wIoExitCustom.getText());
            CompareWizardPageNew.this.command.setNewBinaryRecordLength(CompareWizardPageNew.this.wBinaryRecordLength.getText());
            CompareWizardPageNew.this.command.setNewKey(CompareWizardPageNew.this.wKey.getText());
            CompareWizardPageNew.this.command.setNewSkip(CompareWizardPageNew.this.wSkip.getText());
            CompareWizardPageNew.this.command.setNewCompare(CompareWizardPageNew.this.wCompare.getText());
            CompareWizardPageNew.this.command.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateComboFromModelIfNeeded(CompareWizardPageNew.this.wMember, CompareWizardPageNew.this.command.getNewMember().toUpperCase());
            this.updateButtonSelectionFromModelIfNeeded(CompareWizardPageNew.this.wIoExit, CompareWizardPageNew.this.command.isNewIoExit());
            this.updateComboFromModelIfNeeded(CompareWizardPageNew.this.wIoExitCustom, CompareWizardPageNew.this.command.getNewIoExitCustom());
            this.updateComboFromModelIfNeeded(CompareWizardPageNew.this.wBinaryRecordLength, CompareWizardPageNew.this.command.getNewBinaryRecordLength());
            this.updateComboFromModelIfNeeded(CompareWizardPageNew.this.wKey, CompareWizardPageNew.this.command.getNewKey());
            this.updateComboFromModelIfNeeded(CompareWizardPageNew.this.wSkip, CompareWizardPageNew.this.command.getNewSkip());
            this.updateComboFromModelIfNeeded(CompareWizardPageNew.this.wCompare, CompareWizardPageNew.this.command.getNewCompare());
            boolean resourceHasMembers = CompareWizardPageNew.this.command.getNewResource() instanceof DataSet && ((DataSet)CompareWizardPageNew.this.command.getNewResource()).getHasMembers();
            boolean multipleOldMembers = CompareWizardPageNew.this.command.isMultipleOldMembersSelected(true);
            CompareWizardPageNew.this.wMember.setEnabled(resourceHasMembers && (!multipleOldMembers || CompareWizardPageNew.this.wMember.getText().length() > 0));
            CompareWizardPageNew.this.wMemberLookup.setEnabled(resourceHasMembers && !multipleOldMembers);
            CompareWizardPageNew.this.wIoExit.setEnabled(CompareWizardPageNew.this.command.getSynch() != DSM.DsmSynch.LMOD);
            CompareWizardPageNew.this.wIoExitCustom.setEnabled(CompareWizardPageNew.this.command.isNewIoExit());
            CompareWizardPageNew.this.wBinaryRecordLength.setEnabled(CompareWizardPageNew.this.command.getNewResource() instanceof UssFile);
            if (CompareWizardPageNew.this.command.getNewResource() instanceof DataSet) {
                DataSetType type = ((DataSet)CompareWizardPageNew.this.command.getNewResource()).getType();
                CompareWizardPageNew.this.wKey.setEnabled(type == DataSetType.RRDS || type == DataSetType.KSDS || type == DataSetType.KSDSIAM);
            } else if (CompareWizardPageNew.this.command.getNewResource() instanceof CicsFile) {
                CicsFile cicsFile = (CicsFile)CompareWizardPageNew.this.command.getNewResource();
                CompareWizardPageNew.this.wKey.setEnabled(cicsFile.getKeyLength() != -1 && cicsFile.getKeyStartLocation() != -1);
            } else {
                CompareWizardPageNew.this.wKey.setEnabled(false);
            }
            CompareWizardPageNew.this.wSkip.setEnabled(CompareWizardPageNew.this.command.getSynch() != DSM.DsmSynch.LMOD);
            CompareWizardPageNew.this.wCompare.setEnabled(CompareWizardPageNew.this.command.getSynch() != DSM.DsmSynch.LMOD);
            String validationErrorMessage = CompareWizardPageNew.this.getValidationErrorMessage();
            CompareWizardPageNew.this.setPageComplete(validationErrorMessage == null);
            CompareWizardPageNew.this.setErrorMessage(validationErrorMessage);
        }
    }
}

