/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.socket.func.DSM;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.SET;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.MemberSelectionCriteriaModel;
import com.ibm.etools.fm.ui.widget.TemplateWithOffsetModel;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.core.model.IRefreshable;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class CompareModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MULTI_MEMBER_PLACEHOLDER = "...";
    private static final String[] KEY_TYPE_LIST_VALUES = new String[]{"CHAR", "BINARY", "PACKED", "FLOAT", "ZONED"};
    private static final String[] KEY_ORDER_LIST_VALUES = new String[]{"A", "D"};
    public static final String COMPARE_ALL = "ALL";
    public static final String NUMBER_DIFFS_ALL = "ALL";
    private String oldResource = "";
    private IRefreshable oldResourceLoaded = null;
    private String oldResourceVolume = "";
    private String newResource = "";
    private IRefreshable newResourceLoaded = null;
    private String newResourceVolume = "";
    private String oldMembersList = "";
    private MemberSelectionCriteriaModel oldMemberSelectionCriteria = new MemberSelectionCriteriaModel(this.getSystem());
    private boolean oldIoExit = false;
    private String oldIoExitCustom = "";
    private String oldBinaryRecordLength = "";
    private String oldKey = "";
    private String oldSkip = "0";
    private String oldCompare = "ALL";
    private boolean oldIgnoreLengthMismatches = false;
    private String newMember = "";
    private boolean newIoExit = false;
    private String newIoExitCustom = "";
    private String newBinaryRecordLength = "";
    private String newKey = "";
    private String newSkip = "0";
    private String newCompare = "ALL";
    private boolean autoMapFieldsFirst = false;
    private boolean allKeysMatch = false;
    private boolean keyDupOk = false;
    private TemplateWithOffsetModel oldTemplate = new TemplateWithOffsetModel(this.getSystem());
    private String oldTemplateFieldMapping = "";
    private TemplateWithOffsetModel newTemplate = new TemplateWithOffsetModel(this.getSystem());
    private String newTemplateFieldMapping = "";
    private boolean reportingLayout = false;
    private boolean reportingCriteria = false;
    private boolean reportingFieldMapping = false;
    private boolean reportingUnmapped = false;
    private boolean reportingStartInHex = false;
    private boolean reportingLengthInHex = false;
    private boolean reportingArrayElements = false;
    private boolean reportingStats = false;
    private DSM.DsmSynch synch = DSM.DsmSynch.ONETOONE;
    private DSM.DsmType type = DSM.DsmType.RECORD;
    private String limit = "100";
    private String length = "1";
    private DSM.DsmList list = DSM.DsmList.SUMMARY;
    private boolean excludeInserted = false;
    private boolean excludeDeleted = false;
    private boolean excludeChanged = false;
    private boolean excludeMatched = false;
    private boolean wideListing = true;
    private boolean showingHexOutput = false;
    private boolean showingChangedOnly = false;
    private String numberDifferences = "ALL";
    private boolean highlightingFields = false;
    private boolean showingAttributeInfo = false;
    private boolean showingSelected = false;
    private boolean suppressFields = false;
    private DSM.DsmPack pack = DSM.DsmPack.UNPACK;
    private boolean leftJustifyingNumbers = false;
    private boolean usingKeyFromOldTemplate = false;
    private boolean usingKeyFromNewTemplate = false;
    private String oldTemplateKeyFields = "";
    private String newTemplateKeyFields = "";
    private String oldKeyLocations = "";
    private String newKeyLocations = "";
    private String keyLengths = "";
    private String keyTypes = "";
    private String newKeyLengths = "";
    private String newKeyTypes = "";
    private String keyOrders = "";
    private String csCSects = "";
    private DSM.DsmCmpLvl compareLevel = DSM.DsmCmpLvl.LMOD;
    private DSM.DsmDateForm dateForm = DSM.DsmDateForm.YYYYDDD;
    private boolean lmSize = false;
    private boolean lmAddress = false;
    private boolean lmLinker = false;
    private boolean lmDate = false;
    private boolean lmMode = false;
    private boolean lmAuth = false;
    private boolean lmAttr = false;
    private boolean csSize = false;
    private boolean csAddress = false;
    private boolean csCompiler = false;
    private boolean csDate = false;
    private boolean csMode = false;
    private boolean csZap = false;
    private boolean csText = false;
    private boolean csCompOpts = false;
    private boolean csProgAttrs = false;
    private boolean csExclude = false;
    private boolean ignoringBlanks = false;
    private boolean ignoringCase = false;
    private boolean matchReformatted = false;
    private boolean sortBefore = false;
    private boolean resultDatasets = false;
    private boolean includeMd = false;
    private String insertsDataset = "";
    private DSM.DsmDisp insertsDisposition = DSM.DsmDisp.MOD;
    private String insertsReclen = "";
    private String deletesDataset = "";
    private DSM.DsmDisp deletesDisposition = DSM.DsmDisp.MOD;
    private String deletesReclen = "";
    private String nchangesDataset = "";
    private DSM.DsmDisp nchangesDisposition = DSM.DsmDisp.MOD;
    private String nchangesReclen = "";
    private String ochangesDataset = "";
    private DSM.DsmDisp ochangesDisposition = DSM.DsmDisp.MOD;
    private String ochangesReclen = "";
    private String nmatchesDataset = "";
    private DSM.DsmDisp nmatchesDisposition = DSM.DsmDisp.MOD;
    private String nmatchesReclen = "";
    private String omatchesDataset = "";
    private DSM.DsmDisp omatchesDisposition = DSM.DsmDisp.MOD;
    private String omatchesReclen = "";

    public CompareModel(IPDHost host) {
        super(host);
        this.oldMemberSelectionCriteria.setEventDelegate(this);
        this.oldTemplate.setEventDelegate(this);
        this.newTemplate.setEventDelegate(this);
    }

    public DSM toUtilityFunction() {
        ArrayList<String> oldMemberListAsList;
        DSM dsm = new DSM();
        if (this.getOldResource() != null) {
            Volume volume;
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.DSNOLD, (Object)this.getOldResource().getFormattedName(), this.getSystem());
            if (this.getOldResource() instanceof DataSet && (volume = ((DataSet)this.getOldResource()).getVolume()) != null) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.VOLSEROLD, (Object)volume.getVolserID(), this.getSystem());
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        MemberSelectionCriteriaModel omsc = this.getOldMemberSelectionCriteria();
        if (omsc.isUsingRange()) {
            if (omsc.getMembersRangeStart().equals(omsc.getMembersRangeEnd())) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MEMOLD, (Object)omsc.getMembersRangeStart(), this.getSystem());
            } else {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MEMSTART, (Object)omsc.getMembersRangeStart(), this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MEMEND, (Object)omsc.getMembersRangeEnd(), this.getSystem());
            }
        }
        if (omsc.isUsingCreated()) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CRESTART, (Object)dateFormat.format(omsc.getMembersCreatedStart().getTime()), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CREEND, (Object)dateFormat.format(omsc.getMembersCreatedEnd().getTime()), this.getSystem());
        }
        if (omsc.isUsingChanged()) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CHGSTART, (Object)dateFormat.format(omsc.getMembersChangedStart().getTime()), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CHGEND, (Object)dateFormat.format(omsc.getMembersChangedEnd().getTime()), this.getSystem());
        }
        if (omsc.isUsingUserID()) {
            if (omsc.getMembersUserIDStart().equals(omsc.getMembersUserIDEnd())) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.USERID, (Object)omsc.getMembersUserIDStart(), this.getSystem());
            } else {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.UIDSTART, (Object)omsc.getMembersUserIDStart(), this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.UIDEND, (Object)omsc.getMembersUserIDEnd(), this.getSystem());
            }
        }
        if ((oldMemberListAsList = this.getOldMemberListAsList()).size() == 1) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MEMOLD, (Object)this.getOldMemberList().toUpperCase(), this.getSystem());
        } else {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MEMLIST, (Object)this.getOldMemberList().toUpperCase(), this.getSystem());
        }
        if (DSM.DsmSynch.LMOD != this.getSynch()) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.USEIOXOLD, (Object)this.isOldIoExit(), this.getSystem());
        }
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IOXOLD, (Object)this.getOldIoExitCustom(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.BINRECOLD, (Object)this.getOldBinaryRecordLength(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYOLD, (Object)this.getOldKey(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.SKIPOLD, (Object)this.getOldSkip(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CMPOLD, (Object)this.getOldCompare(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.NUMDIFF, (Object)this.getNumberDifferences(), this.getSystem());
        if (this.getNewResource() != null) {
            Volume volume;
            Object dsnNew = this.getNewResource().getFormattedName();
            if (!this.getNewMember().isEmpty()) {
                dsnNew = (String)dsnNew + "(" + this.getNewMember().toUpperCase() + ")";
            }
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.DSNNEW, dsnNew, this.getSystem());
            if (this.getNewResource() instanceof DataSet && (volume = ((DataSet)this.getNewResource()).getVolume()) != null) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.VOLSERNEW, (Object)volume.getVolserID(), this.getSystem());
            }
        }
        if (DSM.DsmSynch.LMOD != this.getSynch()) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.USEIOXNEW, (Object)this.isNewIoExit(), this.getSystem());
        }
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IOXNEW, (Object)this.getNewIoExitCustom(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.BINRECNEW, (Object)this.getNewBinaryRecordLength(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYNEW, (Object)this.getNewKey(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.SKIPNEW, (Object)this.getNewSkip(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CMPNEW, (Object)this.getNewCompare(), this.getSystem());
        if (this.getOldTemplate().getTemplate() != null && DSM.DsmSynch.LMOD != this.getSynch()) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.TCOLD, (Object)this.getOldTemplate().getTemplate().getFormattedName(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.OFFSETOLD, (Object)this.getOldTemplate().getOffsetsForHost(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.FIELDOLD, (Object)this.getOldTemplateFieldMapping(), this.getSystem());
        }
        if (this.getNewTemplate().getTemplate() != null & DSM.DsmSynch.LMOD != this.getSynch()) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.TCNEW, (Object)this.getNewTemplate().getTemplate().getFormattedName(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.OFFSETNEW, (Object)this.getNewTemplate().getOffsetsForHost(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.FIELDNEW, (Object)this.getNewTemplateFieldMapping(), this.getSystem());
        }
        if (this.getOldTemplate().getTemplate() != null && this.getNewTemplate().getTemplate() != null & DSM.DsmSynch.LMOD != this.getSynch()) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CORRESP, (Object)this.isAutoMapFieldsFirst(), this.getSystem());
        }
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.SYNCH, (Object)this.getSynch(), this.getSystem());
        if (DSM.DsmSynch.READAHEAD == this.getSynch() || DSM.DsmSynch.RAKEY == this.getSynch()) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.LIMIT, (Object)this.getLimit(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.LENGTH, (Object)this.getLength(), this.getSystem());
        }
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.LIST, (Object)this.getList(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.WIDE, (Object)this.isWideListing(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.HEX, (Object)this.isShowingHexOutput(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.HILIGHT, (Object)this.isHighlightingFields(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.PACK, (Object)this.getPack(), this.getSystem());
        if (DSM.DsmSynch.KEYED == this.getSynch() || DSM.DsmSynch.RAKEY == this.getSynch()) {
            if (this.getOldTemplate().getTemplate() != null) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYTCOLD, (Object)this.isUsingKeyFromOldTemplate(), this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYFLDOLD, (Object)this.getOldTemplateKeyFields(), this.getSystem());
            }
            if (this.getNewTemplate().getTemplate() != null) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYTCNEW, (Object)this.isUsingKeyFromNewTemplate(), this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYFLDNEW, (Object)this.getNewTemplateKeyFields(), this.getSystem());
            }
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYLOCOLD, (Object)this.getOldKeyLocations(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYLOCNEW, (Object)this.getNewKeyLocations(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYLEN, (Object)this.getKeyLengths(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYTYPE, (Object)this.getKeyTypes(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYLENNEW, (Object)this.getNewKeyLengths(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYTYPNEW, (Object)this.getNewKeyTypes(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYORD, (Object)this.getKeyOrders(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYMATCH, (Object)this.isAllKeysMatch(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.KEYDUPOK, (Object)this.isKeyDupOk(), this.getSystem());
            if (this.isSortBefore()) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.SORT, (Object)true, this.getSystem());
            }
        }
        if (this.isReportingLayout() || this.isReportingCriteria()) {
            if (!this.isReportingCriteria()) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.PBK, (Object)DSM.DsmPbk.LAYOUTS, this.getSystem());
            } else if (!this.isReportingLayout()) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.PBK, (Object)DSM.DsmPbk.CRITERIA, this.getSystem());
            } else {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.PBK, (Object)DSM.DsmPbk.ALL, this.getSystem());
            }
        } else {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.PBK, (Object)DSM.DsmPbk.NONE, this.getSystem());
        }
        if (this.isReportingFieldMapping() || this.isReportingUnmapped()) {
            if (!this.isReportingUnmapped()) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MAP, (Object)DSM.DsmMap.MAPPED, this.getSystem());
            } else if (!this.isReportingFieldMapping()) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MAP, (Object)DSM.DsmMap.UNMAPPED, this.getSystem());
            } else {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MAP, (Object)DSM.DsmMap.ALL, this.getSystem());
            }
        } else {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MAP, (Object)DSM.DsmMap.NONE, this.getSystem());
        }
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.ARRAY, (Object)this.isReportingArrayElements(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.HEXLEN, (Object)this.isReportingLengthInHex(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.HEXLOC, (Object)this.isReportingStartInHex(), this.getSystem());
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.FSTATS, (Object)this.isReportingStats(), this.getSystem());
        if (this.getSynch() == DSM.DsmSynch.LMOD) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CMPLVL, (Object)this.getCompareLevel(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.DATEFORM, (Object)this.getDateForm(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.LMODC, this.getLModC(), this.getSystem());
            if (this.isDoingCSectCompare()) {
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CSECTC, this.getCSectC(), this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CSECTS, (Object)this.getCsCSects(), this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.XCSECTS, (Object)this.isCsExclude(), this.getSystem());
            }
        }
        if (this.type == DSM.DsmType.FORMATTED || this.synch == DSM.DsmSynch.LMOD) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.CHNGDFLD, (Object)this.isShowingChangedOnly(), this.getSystem());
        }
        if (this.type == DSM.DsmType.FORMATTED) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.TYPE, (Object)DSM.DsmType.FORMATTED, this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IGNLEN, (Object)this.isOldIgnoreLengthMismatches(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.JUST, (Object)this.isLeftJustifyingNumbers(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.SHOWATTR, (Object)this.isShowingAttributeInfo(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.MATCHREF, (Object)this.isMatchReformatted(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IGNORELB, (Object)this.isIgnoringBlanks(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IGNORETB, (Object)this.isIgnoringBlanks(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IGNORECASE, (Object)this.isIgnoringCase(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.SLCTDFLD, (Object)this.isShowingSelected(), this.getSystem());
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.SUPIDFLD, (Object)this.isSuppressingFields(), this.getSystem());
        } else {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.TYPE, (Object)DSM.DsmType.RECORD, this.getSystem());
        }
        if (this.list == DSM.DsmList.LONG) {
            dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.EXCLUDE, (Object)this.getExcludes(), this.getSystem());
        }
        dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.INCLUDEMD, (Object)this.isIncludeMd(), this.getSystem());
        if (this.isResultDatasets()) {
            Object path;
            IZRL aZrl;
            if (!this.insertsDataset.isEmpty()) {
                aZrl = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.insertsDataset);
                path = aZrl.getFormattedName();
                if (aZrl instanceof UssFile) {
                    path = "'" + (String)path + "'";
                }
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IOUTDSN, path, this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IDISP, (Object)this.getInsertsDisposition(), this.getSystem());
                if (!this.insertsReclen.isEmpty()) {
                    dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.IBINREC, (Object)this.getInsertsReclen(), this.getSystem());
                }
            }
            if (!this.deletesDataset.isEmpty()) {
                aZrl = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.deletesDataset);
                path = aZrl.getFormattedName();
                if (aZrl instanceof UssFile) {
                    path = "'" + (String)path + "'";
                }
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.DOUTDSN, path, this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.DDISP, (Object)this.getDeletesDisposition(), this.getSystem());
                if (!this.deletesReclen.isEmpty()) {
                    dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.DBINREC, (Object)this.getDeletesReclen(), this.getSystem());
                }
            }
            if (!this.nchangesDataset.isEmpty()) {
                aZrl = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.nchangesDataset);
                path = aZrl.getFormattedName();
                if (aZrl instanceof UssFile) {
                    path = "'" + (String)path + "'";
                }
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.NCOUTDSN, path, this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.NCDISP, (Object)this.getNChangesDisposition(), this.getSystem());
                if (!this.nchangesReclen.isEmpty()) {
                    dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.NCBINREC, (Object)this.getNChangesReclen(), this.getSystem());
                }
            }
            if (!this.ochangesDataset.isEmpty()) {
                aZrl = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.ochangesDataset);
                path = aZrl.getFormattedName();
                if (aZrl instanceof UssFile) {
                    path = "'" + (String)path + "'";
                }
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.OCOUTDSN, path, this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.OCDISP, (Object)this.getOChangesDisposition(), this.getSystem());
                if (!this.ochangesReclen.isEmpty()) {
                    dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.OCBINREC, (Object)this.getOChangesReclen(), this.getSystem());
                }
            }
            if (!this.nmatchesDataset.isEmpty()) {
                aZrl = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.nmatchesDataset);
                path = aZrl.getFormattedName();
                if (aZrl instanceof UssFile) {
                    path = "'" + (String)path + "'";
                }
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.NMOUTDSN, path, this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.NMDISP, (Object)this.getNMatchesDisposition(), this.getSystem());
                if (!this.nmatchesReclen.isEmpty()) {
                    dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.NMBINREC, (Object)this.getNMatchesReclen(), this.getSystem());
                }
            }
            if (!this.omatchesDataset.isEmpty()) {
                aZrl = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.omatchesDataset);
                path = aZrl.getFormattedName();
                if (aZrl instanceof UssFile) {
                    path = "'" + (String)path + "'";
                }
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.OMOUTDSN, path, this.getSystem());
                dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.OMDISP, (Object)this.getOMatchesDisposition(), this.getSystem());
                if (!this.omatchesReclen.isEmpty()) {
                    dsm.setValue((NewUtilityFunction.IUtilFuncParam)DSM.OMBINREC, (Object)this.getOMatchesReclen(), this.getSystem());
                }
            }
        }
        return dsm;
    }

    public void fromUtilityFunction(DSM dsm) {
        this.setOldResource((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.DSNOLD, this.getSystem()));
        this.setOldResourceVolume((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.VOLSEROLD, this.getSystem()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        MemberSelectionCriteriaModel omsc = this.getOldMemberSelectionCriteria();
        String memOld = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.MEMOLD, this.getSystem());
        String memStart = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.MEMSTART, this.getSystem());
        String memEnd = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.MEMEND, this.getSystem());
        if (memOld.isEmpty()) {
            omsc.setUsingRange(false);
            omsc.setMembersRangeStart(memOld);
            omsc.setMembersRangeEnd(memOld);
        } else {
            omsc.setUsingRange(memStart.length() > 0 && memEnd.length() > 0);
            omsc.setMembersRangeStart(memStart);
            omsc.setMembersRangeEnd(memEnd);
        }
        String creStart = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CRESTART, this.getSystem());
        String creEnd = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CREEND, this.getSystem());
        omsc.setUsingCreated(creStart.length() > 0 && creEnd.length() > 0);
        omsc.setMembersCreatedStart(creStart, dateFormat);
        omsc.setMembersCreatedEnd(creEnd, dateFormat);
        String chgStart = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CHGSTART, this.getSystem());
        String chgEnd = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CHGEND, this.getSystem());
        omsc.setUsingChanged(chgStart.length() > 0 && chgEnd.length() > 0);
        omsc.setMembersChangedStart(chgStart, dateFormat);
        omsc.setMembersChangedEnd(chgEnd, dateFormat);
        String uidStart = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.UIDSTART, this.getSystem());
        String uidEnd = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.UIDEND, this.getSystem());
        String userId = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.USERID, this.getSystem());
        if (!userId.isEmpty()) {
            omsc.setUsingUserID(true);
            omsc.setMembersUserIDStart(userId);
            omsc.setMembersUserIDEnd(userId);
        } else {
            omsc.setUsingUserID(uidStart.length() > 0 && uidEnd.length() > 0);
            omsc.setMembersUserIDStart(uidStart);
            omsc.setMembersUserIDEnd(uidEnd);
        }
        String memList = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.MEMLIST, this.getSystem());
        if (!memList.isEmpty()) {
            this.setOldMemberList(memList);
        } else {
            this.setOldMemberList(memOld);
        }
        this.setOldIoExit((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.USEIOXOLD, this.getSystem()));
        this.setOldIoExitCustom((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.IOXOLD, this.getSystem()));
        this.setOldBinaryRecordLength((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.BINRECOLD, this.getSystem()));
        this.setOldKey((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYOLD, this.getSystem()));
        this.setOldSkip((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.SKIPOLD, this.getSystem()));
        this.setOldCompare((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CMPOLD, this.getSystem()));
        this.setNumberDifferences((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.NUMDIFF, this.getSystem()));
        this.setOldIgnoreLengthMismatches((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.IGNLEN, this.getSystem()));
        this.setNewResource((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.DSNNEW, this.getSystem()));
        this.setNewResourceVolume((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.VOLSERNEW, this.getSystem()));
        this.setNewIoExit((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.USEIOXNEW, this.getSystem()));
        this.setNewIoExitCustom((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.IOXNEW, this.getSystem()));
        this.setNewBinaryRecordLength((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.BINRECNEW, this.getSystem()));
        this.setNewKey((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYNEW, this.getSystem()));
        this.setNewSkip((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.SKIPNEW, this.getSystem()));
        this.setNewCompare((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CMPNEW, this.getSystem()));
        TemplateWithOffsetModel otm = this.getOldTemplate();
        otm.setTemplate((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.TCOLD, this.getSystem()));
        otm.setOffset((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.OFFSETOLD, this.getSystem()));
        this.setOldTemplateFieldMapping((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.FIELDOLD, this.getSystem()));
        TemplateWithOffsetModel ntm = this.getNewTemplate();
        ntm.setTemplate((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.TCNEW, this.getSystem()));
        ntm.setOffset((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.OFFSETNEW, this.getSystem()));
        this.setNewTemplateFieldMapping((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.FIELDNEW, this.getSystem()));
        this.setAutoMapFieldsFirst((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CORRESP, this.getSystem()));
        this.setSynch((DSM.DsmSynch)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.SYNCH, this.getSystem()));
        this.setLimit((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.LIMIT, this.getSystem()));
        this.setLength((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.LENGTH, this.getSystem()));
        this.setList((DSM.DsmList)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.LIST, this.getSystem()));
        this.setWideListing((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.WIDE, this.getSystem()));
        this.setShowingHexOutput((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.HEX, this.getSystem()));
        this.setShowingChangedOnly((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CHNGDFLD, this.getSystem()));
        this.setHighlightingFields((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.HILIGHT, this.getSystem()));
        this.setShowingAttributeInfo((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.SHOWATTR, this.getSystem()));
        this.setShowingSelected((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.SLCTDFLD, this.getSystem()));
        this.setSuppressFields((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.SUPIDFLD, this.getSystem()));
        this.setPack((DSM.DsmPack)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.PACK, this.getSystem()));
        this.setLeftJustifyingNumbers((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.JUST, this.getSystem()));
        this.setUsingKeyFromOldTemplate((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYTCOLD, this.getSystem()));
        this.setOldTemplateKeyFields((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYFLDOLD, this.getSystem()));
        this.setUsingKeyFromNewTemplate((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYTCNEW, this.getSystem()));
        this.setNewTemplateKeyFields((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYFLDNEW, this.getSystem()));
        this.setOldKeyLocations((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYLOCOLD, this.getSystem()));
        this.setNewKeyLocations((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYLOCNEW, this.getSystem()));
        this.setKeyLengths((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYLEN, this.getSystem()));
        this.setKeyTypes((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYTYPE, this.getSystem()));
        this.setNewKeyLengths((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYLENNEW, this.getSystem()));
        this.setNewKeyTypes((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYTYPNEW, this.getSystem()));
        this.setKeyOrders((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYORD, this.getSystem()));
        this.setAllKeysMatch((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYMATCH, this.getSystem()));
        this.setKeyDupOk((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.KEYDUPOK, this.getSystem()));
        this.setExcludes((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.EXCLUDE, this.getSystem()));
        this.setReporting((DSM.DsmPbk)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.PBK, this.getSystem()));
        this.setMapping((DSM.DsmMap)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.MAP, this.getSystem()));
        this.setReportingArrayElements((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.ARRAY, this.getSystem()));
        this.setReportingStartInHex((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.HEXLOC, this.getSystem()));
        this.setReportingLengthInHex((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.HEXLEN, this.getSystem()));
        this.setReportingStats((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.FSTATS, this.getSystem()));
        this.setCompareLevel((DSM.DsmCmpLvl)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CMPLVL, this.getSystem()));
        this.setDateForm((DSM.DsmDateForm)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.DATEFORM, this.getSystem()));
        this.setLModC((Set)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.LMODC, this.getSystem()));
        this.setCSectC((Set)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CSECTC, this.getSystem()));
        this.setCsCSects((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.CSECTS, this.getSystem()));
        this.setCsExclude((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.XCSECTS, this.getSystem()));
        this.setType((DSM.DsmType)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.TYPE, this.getSystem()));
        this.setMatchReformatted((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.MATCHREF, this.getSystem()));
        this.setIgnoringBlanks((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.IGNORELB, this.getSystem()));
        this.setIgnoringCase((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.IGNORECASE, this.getSystem()));
        this.setSortBefore((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.SORT, this.getSystem()));
        this.setIncludeMd((Boolean)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.INCLUDEMD, this.getSystem()));
        String dsn = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.IOUTDSN, this.getSystem());
        if (dsn != null) {
            if (dsn.startsWith("'")) {
                dsn = dsn.substring(1, dsn.length() - 1);
            }
            this.setInsertsDataset(dsn);
        }
        this.setInsertsDisposition((DSM.DsmDisp)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.IDISP, this.getSystem()));
        this.setInsertsReclen((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.IBINREC, this.getSystem()));
        dsn = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.DOUTDSN, this.getSystem());
        if (dsn != null) {
            if (dsn.startsWith("'")) {
                dsn = dsn.substring(1, dsn.length() - 1);
            }
            this.setDeletesDataset(dsn);
        }
        this.setDeletesDisposition((DSM.DsmDisp)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.DDISP, this.getSystem()));
        this.setDeletesReclen((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.DBINREC, this.getSystem()));
        dsn = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.NCOUTDSN, this.getSystem());
        if (dsn != null) {
            if (dsn.startsWith("'")) {
                dsn = dsn.substring(1, dsn.length() - 1);
            }
            this.setNChangesDataset(dsn);
        }
        this.setNChangesDisposition((DSM.DsmDisp)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.NCDISP, this.getSystem()));
        this.setNChangesReclen((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.NCBINREC, this.getSystem()));
        dsn = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.OCOUTDSN, this.getSystem());
        if (dsn != null) {
            if (dsn.startsWith("'")) {
                dsn = dsn.substring(1, dsn.length() - 1);
            }
            this.setOChangesDataset(dsn);
        }
        this.setOChangesDisposition((DSM.DsmDisp)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.OCDISP, this.getSystem()));
        this.setOChangesReclen((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.OCBINREC, this.getSystem()));
        dsn = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.NMOUTDSN, this.getSystem());
        if (dsn != null) {
            if (dsn.startsWith("'")) {
                dsn = dsn.substring(1, dsn.length() - 1);
            }
            this.setNMatchesDataset(dsn);
        }
        this.setNMatchesDisposition((DSM.DsmDisp)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.NMDISP, this.getSystem()));
        this.setNMatchesReclen((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.NMBINREC, this.getSystem()));
        dsn = (String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.OMOUTDSN, this.getSystem());
        if (dsn != null) {
            if (dsn.startsWith("'")) {
                dsn = dsn.substring(1, dsn.length() - 1);
            }
            this.setOMatchesDataset(dsn);
        }
        this.setOMatchesDisposition((DSM.DsmDisp)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.OMDISP, this.getSystem()));
        this.setOMatchesReclen((String)dsm.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSM.OMBINREC, this.getSystem()));
        if (!(this.getInsertsDataset().isEmpty() && this.getDeletesDataset().isEmpty() && this.getNChangesDataset().isEmpty() && this.getOChangesDataset().isEmpty() && this.getNMatchesDataset().isEmpty() && this.getOMatchesDataset().isEmpty())) {
            this.setResultDatasets(true);
        }
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        this.applyPrintOptions(monitor);
        DSM dsm = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), (UtilityFunction)dsm, (IHowIsGoing)monitor);
    }

    private void applyPrintOptions(IHowIsGoing monitor) {
        try {
            IEclipsePreferences systemOptsPrefs = InstanceScope.INSTANCE.getNode("com.ibm.etools.fm.ui.prefs.prtopts");
            Preferences node = systemOptsPrefs.node(this.getHostProvider().getDescription());
            String pageSkipVal = node.get("pageskip", "YES");
            String dumpVal = node.get("dump", "UPDOWN");
            String dataHdrVal = node.get("datahdr", "YES");
            String recLimitVal = node.get("reclimit", "(1,*)");
            String printLenVal = node.get("reclength", "80");
            String printTransVal = node.get("pagetrans", "ON");
            String headerPagVal = node.get("headerpage", "YES");
            SET set = new SET();
            set.setPageSkip(pageSkipVal);
            set.setPrintLen(Integer.parseInt(printLenVal));
            set.setDumpVal(dumpVal);
            set.setDataHdr(dataHdrVal);
            set.setRecLimit(recLimitVal);
            set.setPrintTrans(printTransVal);
            set.setHeaderPage(headerPagVal);
            Result result = UtilityFunctionRunner.execute((IPDHost)this.getHostProvider(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getHostProvider()), (UtilityFunction)set, (IHowIsGoing)monitor);
            if (result.getRC() != 0) {
                System.out.println(result.getDisplayMessage());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setHostProvider(IPDHost newProvider) {
        this.oldResourceLoaded = null;
        this.newResourceLoaded = null;
        super.setHostProvider(newProvider);
    }

    public String validateResourceTypes(IHowIsGoing monitor) throws InterruptedException {
        IZRL newResource;
        IZRL oldResource = this.getOldResource();
        if (oldResource instanceof DataSetOrMember) {
            DataSet oldDataSet = ((DataSetOrMember)oldResource).asDataSet();
            if (!(this.oldResourceLoaded instanceof DataSet && oldResource.equals(this.oldResourceLoaded) && oldDataSet.getAllVolumes().equals(((DataSet)this.oldResourceLoaded).getAllVolumes()) && oldDataSet.getConfirmedExists())) {
                Result refreshExistence = oldDataSet.refreshExistence(monitor);
                refreshExistence.isSuccessfulWithoutWarnings();
                this.oldResourceLoaded = oldDataSet;
            }
            if (!oldDataSet.getConfirmedExists()) {
                return Messages.DSMCommand_NONEXISTANT_OLD_DATA_SET;
            }
            if (!oldDataSet.getHasMembers()) {
                this.oldMemberSelectionCriteria.clear();
                this.oldMembersList = "";
            }
        } else if (oldResource instanceof CicsFile) {
            CicsFile oldCicsFile = (CicsFile)oldResource;
            if (!(this.oldResourceLoaded instanceof CicsFile) || !oldResource.equals(this.oldResourceLoaded)) {
                oldCicsFile.refreshSelf(monitor);
                this.oldResourceLoaded = oldCicsFile;
            }
            if (!oldCicsFile.getConfirmedExists()) {
                return Messages.DSMCommand_OLD_RESOURCE_NO_EXIST;
            }
            if (!oldCicsFile.isOpen()) {
                return Messages.DSMCommand_OLD_CICS_FILE_CLOSED;
            }
        }
        if ((newResource = this.getNewResource()) instanceof DataSetOrMember) {
            DataSet newDataSet = ((DataSetOrMember)newResource).asDataSet();
            if (!(this.newResourceLoaded instanceof DataSet && newResource.equals(this.newResourceLoaded) && newDataSet.getAllVolumes().equals(((DataSet)this.newResourceLoaded).getAllVolumes()) && newDataSet.getConfirmedExists())) {
                Result refreshExistence = newDataSet.refreshExistence(monitor);
                refreshExistence.isSuccessfulWithoutWarnings();
                this.newResourceLoaded = newDataSet;
            }
            if (!newDataSet.getConfirmedExists()) {
                return Messages.DSMCommand_NONEXISTANT_NEW_DATA_SET;
            }
            if (!newDataSet.getHasMembers()) {
                this.newMember = "";
            }
        } else if (newResource instanceof CicsFile) {
            CicsFile newCicsFile = (CicsFile)newResource;
            if (!(this.newResourceLoaded instanceof CicsFile) || !newResource.equals(this.newResourceLoaded)) {
                newCicsFile.refreshSelf(monitor);
                this.newResourceLoaded = newCicsFile;
            }
            if (!newCicsFile.getConfirmedExists()) {
                return Messages.DSMCommand_NEW_RESOURCE_NO_EXIST;
            }
            if (!newCicsFile.isOpen()) {
                return Messages.DSMCommand_NEW_CICS_FILE_CLOSED;
            }
        }
        return null;
    }

    public boolean usingOldTemplate() {
        return this.getOldTemplate().getTemplate() != null;
    }

    public boolean usingNewTemplate() {
        return this.getNewTemplate().getTemplate() != null;
    }

    public boolean isOldDataSetWithMembers() {
        IZRL src = this.getOldResource();
        if (src instanceof DataSet) {
            return ((DataSet)src).getHasMembers();
        }
        return false;
    }

    public boolean isNewDataSetWithMembers() {
        IZRL src = this.getNewResource();
        if (src instanceof DataSet) {
            return ((DataSet)src).getHasMembers();
        }
        return false;
    }

    @Deprecated
    public boolean isMultipleOldMembersSelected() {
        return this.isMultipleOldMembersSelected(true);
    }

    public String getSingleSourceMemberSelected() {
        if (this.getOldResource() instanceof DataSet) {
            if (this.oldMemberSelectionCriteria.isNoMemberSelected() && this.oldMembersList.indexOf(",") == -1 && !this.oldMembersList.isEmpty()) {
                return this.oldMembersList;
            }
            if (this.oldMemberSelectionCriteria.isSingleMemberSelected() && this.oldMembersList.isEmpty()) {
                return this.oldMemberSelectionCriteria.getMembersRangeStart();
            }
        }
        return null;
    }

    public boolean isMultipleOldMembersSelected(boolean ignorePossibles) {
        boolean multipleSrcMembers = false;
        if (this.getOldResource() instanceof DataSet) {
            multipleSrcMembers = this.oldMembersList.indexOf(",") >= 0;
            multipleSrcMembers = multipleSrcMembers || this.oldMemberSelectionCriteria.isUsingRange() && !this.oldMemberSelectionCriteria.getMembersRangeStart().equals(this.oldMembersList);
            multipleSrcMembers = multipleSrcMembers || this.oldMemberSelectionCriteria.isMultipleMembersSelected(ignorePossibles);
        }
        return multipleSrcMembers;
    }

    public void setOldResource(IZRL oldZrl) {
        DataSet oldDataSet;
        this.oldMembersList = "";
        this.oldMemberSelectionCriteria.clear();
        this.oldResource = oldZrl.getFormattedName();
        if (oldZrl instanceof IRefreshable && ((IRefreshable)oldZrl).getConfirmedExists()) {
            this.oldResourceLoaded = (IRefreshable)oldZrl;
        }
        DataSet dataSet = oldDataSet = oldZrl instanceof DataSet ? (DataSet)oldZrl : null;
        if (oldZrl instanceof Member) {
            Member member = (Member)oldZrl;
            oldDataSet = member.asDataSet();
            this.oldResource = oldDataSet.getFormattedName();
            this.oldResourceLoaded = oldDataSet;
            this.oldMembersList = member.getName();
        }
        if (oldDataSet != null) {
            this.oldResourceVolume = oldDataSet.getVolume() != null ? oldDataSet.getVolume().getVolserID() : "";
        }
    }

    public void setOldResource(String oldResource) {
        int memStart = ((String)oldResource).indexOf("(");
        int memEnd = ((String)oldResource).indexOf(")");
        if (memStart >= 0 && memStart < memEnd) {
            String mem = ((String)oldResource).substring(memStart + 1, memEnd);
            oldResource = ((String)oldResource).substring(0, memStart);
            if (!MULTI_MEMBER_PLACEHOLDER.equals(mem)) {
                if (UIValidator.isValidWildcardableMember(mem, this.getSystem().getCodePage()) || UIValidator.isValidMemberList(mem, false, this.getSystem().getCodePage())) {
                    this.oldMembersList = mem;
                    this.oldMemberSelectionCriteria.clear();
                } else {
                    oldResource = (String)oldResource + "()";
                    this.oldMembersList = "";
                    this.oldMemberSelectionCriteria.clear();
                }
            }
        } else {
            this.oldMembersList = "";
            this.oldMemberSelectionCriteria.clear();
        }
        this.oldResource = oldResource;
    }

    private IZRL getOldResourceParsed() {
        IZRL parsedResource = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.oldResource);
        if (parsedResource instanceof DataSet && Volume.isValid((String)this.oldResourceVolume, (String)this.getSystem().getCodePage())) {
            ((DataSet)parsedResource).setVolume(Volume.create((IPDHost)this.getSystem(), (String)this.oldResourceVolume));
        }
        return parsedResource;
    }

    public boolean isOldResourceLoaded() {
        boolean useLoadedResource = false;
        if (this.oldResourceLoaded instanceof DataSet && ((DataSet)this.oldResourceLoaded).equalsWithVolumes((Object)this.getOldResourceParsed())) {
            useLoadedResource = true;
        } else if (this.oldResourceLoaded instanceof CicsFile && this.oldResourceLoaded.equals(this.getOldResourceParsed())) {
            useLoadedResource = true;
        }
        return useLoadedResource;
    }

    public String getOldResourceSet() {
        return this.oldResource;
    }

    public IZRL getOldResource() {
        if (this.getSystem() != null && ZRLs.isParseable((IPDHost)this.getSystem(), (String)this.oldResource)) {
            if (this.isOldResourceLoaded()) {
                return this.oldResourceLoaded;
            }
            return this.getOldResourceParsed();
        }
        return null;
    }

    public String getOldResourceVolumeSet() {
        return this.oldResourceVolume;
    }

    public String getOldResourceVolume() {
        if (Volume.isValid((String)this.oldResourceVolume, (String)this.getSystem().getCodePage())) {
            return this.oldResourceVolume;
        }
        return "";
    }

    public void setOldResourceVolume(String oldResourceVolume) {
        this.oldResourceVolume = oldResourceVolume;
    }

    public void setNewResource(IZRL newZrl) {
        DataSet newDataSet;
        this.newMember = "";
        this.newResource = newZrl.getFormattedName();
        if (newZrl instanceof IRefreshable && ((IRefreshable)newZrl).getConfirmedExists()) {
            this.newResourceLoaded = (IRefreshable)newZrl;
        }
        DataSet dataSet = newDataSet = newZrl instanceof DataSet ? (DataSet)newZrl : null;
        if (newZrl instanceof Member) {
            Member member = (Member)newZrl;
            newDataSet = member.asDataSet();
            this.newResource = newDataSet.getFormattedName();
            this.newResourceLoaded = newDataSet;
            this.newMember = member.getName();
        }
        if (newDataSet != null) {
            this.newResourceVolume = newDataSet.getVolume() != null ? newDataSet.getVolume().getVolserID() : "";
        }
    }

    public void setNewResource(String newResource) {
        int memStart = newResource.indexOf("(");
        int memEnd = newResource.indexOf(")");
        if (memStart >= 0 && memStart < memEnd) {
            String mem = newResource.substring(memStart + 1, memEnd);
            if (Member.isValidName((String)mem, (String)this.getSystem().getCodePage())) {
                this.newMember = mem;
                newResource = newResource.substring(0, memStart);
            }
        } else {
            this.newMember = "";
        }
        this.newResource = newResource;
    }

    private IZRL getNewResourceParsed() {
        IZRL parsedResource = ZRLs.parseZRL((IPDHost)this.getSystem(), (String)this.newResource);
        if (parsedResource instanceof DataSet && Volume.isValid((String)this.newResourceVolume, (String)this.getSystem().getCodePage())) {
            ((DataSet)parsedResource).setVolume(Volume.create((IPDHost)this.getSystem(), (String)this.newResourceVolume));
        }
        return parsedResource;
    }

    public boolean isNewResourceLoaded() {
        boolean useLoadedResource = false;
        if (this.newResourceLoaded instanceof DataSet && ((DataSet)this.newResourceLoaded).equalsWithVolumes((Object)this.getNewResourceParsed())) {
            useLoadedResource = true;
        } else if (this.newResourceLoaded instanceof CicsFile && this.newResourceLoaded.equals(this.getNewResourceParsed())) {
            useLoadedResource = true;
        }
        return useLoadedResource;
    }

    public String getNewResourceSet() {
        return this.newResource;
    }

    public IZRL getNewResource() {
        if (this.getSystem() != null && ZRLs.isParseable((IPDHost)this.getSystem(), (String)this.newResource)) {
            if (this.isNewResourceLoaded()) {
                return this.newResourceLoaded;
            }
            return this.getNewResourceParsed();
        }
        return null;
    }

    public String getNewResourceVolumeSet() {
        return this.newResourceVolume;
    }

    public String getNewResourceVolume() {
        if (Volume.isValid((String)this.newResourceVolume, (String)this.getSystem().getCodePage())) {
            return this.newResourceVolume;
        }
        return "";
    }

    public void setNewResourceVolume(String newResourceVolume) {
        this.newResourceVolume = newResourceVolume;
    }

    public void setOldMemberList(String oldMember) {
        this.oldMembersList = oldMember;
    }

    public String getOldMemberListSet() {
        return this.oldMembersList;
    }

    public String getOldMemberList() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> membersAsList = this.getOldMemberListAsList();
        for (String member : membersAsList) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(member);
        }
        return sb.toString();
    }

    public ArrayList<String> getOldMemberListAsList() {
        ArrayList<String> memberList = new ArrayList<String>();
        if (this.getOldResource() instanceof DataSet) {
            if (UIValidator.isValidMemberList(this.oldMembersList, false, this.getSystem().getCodePage())) {
                String[] splitList;
                String[] stringArray = splitList = this.oldMembersList.split(",");
                int n = splitList.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (Member.isValidName((String)string.toUpperCase(), (String)this.getSystem().getCodePage())) {
                        memberList.add(string);
                    }
                    ++n2;
                }
            } else if (UIValidator.isValidWildcardableMember(this.oldMembersList, this.getSystem().getCodePage())) {
                memberList.add(this.oldMembersList);
            }
        }
        return memberList;
    }

    public MemberSelectionCriteriaModel getOldMemberSelectionCriteria() {
        return this.oldMemberSelectionCriteria;
    }

    public boolean isOldIoExit() {
        return this.oldIoExit && this.synch != DSM.DsmSynch.LMOD;
    }

    public void setOldIoExit(boolean oldIoExit) {
        this.oldIoExit = oldIoExit;
    }

    public String getOldIoExitCustom() {
        if (this.oldIoExit && this.getSynch() != DSM.DsmSynch.LMOD) {
            return this.oldIoExitCustom;
        }
        return "";
    }

    public void setOldIoExitCustom(String oldIoExitCustom) {
        this.oldIoExitCustom = oldIoExitCustom;
    }

    public String getOldBinaryRecordLengthSet() {
        return this.oldBinaryRecordLength;
    }

    public String getOldBinaryRecordLength() {
        if (this.getOldResource() instanceof UssFile) {
            try {
                int binreclen = Integer.parseInt(this.oldBinaryRecordLength);
                if (binreclen > 1 || binreclen < 32760) {
                    return this.oldBinaryRecordLength;
                }
                return "";
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return "";
    }

    public void setOldBinaryRecordLength(String oldBinaryRecordLength) {
        this.oldBinaryRecordLength = oldBinaryRecordLength;
    }

    public String getOldKeySet() {
        return this.oldKey;
    }

    public String getOldKey() {
        boolean canHaveKey = false;
        IZRL currResource = this.getOldResource();
        if (currResource instanceof DataSet) {
            DataSetType type = ((DataSet)currResource).getType();
            canHaveKey = type == DataSetType.KSDS || type == DataSetType.KSDSIAM || type == DataSetType.RRDS;
        } else if (currResource instanceof CicsFile) {
            CicsFile cicsFile = (CicsFile)currResource;
            boolean bl = canHaveKey = cicsFile.getKeyLength() != -1 && cicsFile.getKeyStartLocation() != -1;
        }
        if (canHaveKey) {
            String key = this.oldKey;
            if (key.length() > 30) {
                key = key.substring(0, 30);
            }
            return key;
        }
        return "";
    }

    public void setOldKey(String oldKey) {
        this.oldKey = oldKey;
    }

    public String getOldSkip() {
        if (this.getSynch() != DSM.DsmSynch.LMOD) {
            return this.oldSkip;
        }
        return "";
    }

    public void setOldSkip(String oldSkip) {
        this.oldSkip = oldSkip;
    }

    public String getOldCompareSet() {
        return this.oldCompare;
    }

    public String getOldCompare() {
        if (this.getSynch() != DSM.DsmSynch.LMOD) {
            try {
                int parseInt = Integer.parseInt(this.oldCompare);
                if (parseInt >= 0 && parseInt <= 999999999) {
                    return this.oldCompare;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "ALL";
    }

    public void setOldCompare(String oldCompare) {
        this.oldCompare = oldCompare;
    }

    public boolean isOldIgnoreLengthMismatches() {
        return this.oldIgnoreLengthMismatches;
    }

    public void setOldIgnoreLengthMismatches(boolean oldIgnoreLengthMismatches) {
        this.oldIgnoreLengthMismatches = oldIgnoreLengthMismatches;
    }

    public void setNewMember(String newMember) {
        this.newMember = newMember;
    }

    public String getNewMemberSet() {
        return this.newMember;
    }

    public String getNewMember() {
        if (Member.isValidName((String)this.newMember, (String)this.getSystem().getCodePage())) {
            return this.newMember;
        }
        return "";
    }

    public boolean isNewIoExit() {
        return this.newIoExit && this.synch != DSM.DsmSynch.LMOD;
    }

    public void setNewIoExit(boolean newIoExit) {
        this.newIoExit = newIoExit;
    }

    public String getNewIoExitCustom() {
        if (this.newIoExit) {
            return this.newIoExitCustom;
        }
        return "";
    }

    public void setNewIoExitCustom(String newIoExitCustom) {
        this.newIoExitCustom = newIoExitCustom;
    }

    public String getNewBinaryRecordLengthSet() {
        return this.newBinaryRecordLength;
    }

    public String getNewBinaryRecordLength() {
        if (this.getNewResource() instanceof UssFile) {
            try {
                int binreclen = Integer.parseInt(this.newBinaryRecordLength);
                if (binreclen > 1 || binreclen < 32760) {
                    return this.newBinaryRecordLength;
                }
                return "";
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return "";
    }

    public void setNewBinaryRecordLength(String newBinaryRecordLength) {
        this.newBinaryRecordLength = newBinaryRecordLength;
    }

    public String getNewKeySet() {
        return this.newKey;
    }

    public String getNewKey() {
        boolean canHaveKey = false;
        IZRL currResource = this.getNewResource();
        if (currResource instanceof DataSet) {
            DataSetType type = ((DataSet)currResource).getType();
            canHaveKey = type == DataSetType.KSDS || type == DataSetType.KSDSIAM || type == DataSetType.RRDS;
        } else if (currResource instanceof CicsFile) {
            CicsFile cicsFile = (CicsFile)currResource;
            boolean bl = canHaveKey = cicsFile.getKeyLength() != -1 && cicsFile.getKeyStartLocation() != -1;
        }
        if (canHaveKey) {
            String key = this.newKey;
            if (key.length() > 30) {
                key = key.substring(0, 30);
            }
            return key;
        }
        return "";
    }

    public void setNewKey(String newKey) {
        this.newKey = newKey;
    }

    public String getNewSkip() {
        if (this.getSynch() != DSM.DsmSynch.LMOD) {
            return this.newSkip;
        }
        return "";
    }

    public void setNewSkip(String newSkip) {
        this.newSkip = newSkip;
    }

    public String getNewCompareSet() {
        return this.newCompare;
    }

    public String getNewCompare() {
        if (this.getSynch() != DSM.DsmSynch.LMOD) {
            try {
                int parseInt = Integer.parseInt(this.newCompare);
                if (parseInt >= 0 && parseInt <= 999999999) {
                    return this.newCompare;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "ALL";
    }

    public void setNewCompare(String newCompare) {
        this.newCompare = newCompare;
    }

    public boolean isAutoMapFieldsFirst() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.autoMapFieldsFirst;
    }

    public void setAutoMapFieldsFirst(boolean autoMapFieldsFirst) {
        this.autoMapFieldsFirst = autoMapFieldsFirst;
    }

    public boolean isAllKeysMatch() {
        return this.allKeysMatch;
    }

    public void setAllKeysMatch(boolean allKeysMatch) {
        this.allKeysMatch = allKeysMatch;
    }

    public boolean isKeyDupOk() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.keyDupOk;
    }

    public void setKeyDupOk(boolean keyDupOk) {
        this.keyDupOk = keyDupOk;
    }

    public TemplateWithOffsetModel getOldTemplate() {
        return this.oldTemplate;
    }

    public String getOldTemplateFieldMapping() {
        if (this.usingOldTemplate()) {
            return this.oldTemplateFieldMapping;
        }
        return "";
    }

    public void setOldTemplateFieldMapping(String oldTemplateFieldMapping) {
        this.oldTemplateFieldMapping = oldTemplateFieldMapping;
    }

    public TemplateWithOffsetModel getNewTemplate() {
        return this.newTemplate;
    }

    public String getNewTemplateFieldMapping() {
        if (this.usingNewTemplate()) {
            return this.newTemplateFieldMapping;
        }
        return "";
    }

    public void setNewTemplateFieldMapping(String newTemplateFieldMapping) {
        this.newTemplateFieldMapping = newTemplateFieldMapping;
    }

    public boolean isReportingLayout() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.reportingLayout;
    }

    public void setReportingLayout(boolean reportingLayout) {
        this.reportingLayout = reportingLayout;
    }

    public boolean isReportingCriteria() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.reportingCriteria;
    }

    public void setReportingCriteria(boolean reportingCriteria) {
        this.reportingCriteria = reportingCriteria;
    }

    public boolean isReportingFieldMapping() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.reportingFieldMapping;
    }

    public void setReporting(DSM.DsmPbk dsmPbk) {
        switch (dsmPbk) {
            case ALL: {
                this.reportingLayout = true;
                this.reportingCriteria = true;
                break;
            }
            case LAYOUTS: {
                this.reportingLayout = true;
                break;
            }
            case CRITERIA: {
                this.reportingCriteria = true;
                break;
            }
        }
    }

    public void setMapping(DSM.DsmMap dsmMap) {
        switch (dsmMap) {
            case ALL: {
                this.reportingFieldMapping = true;
                this.reportingUnmapped = true;
                break;
            }
            case MAPPED: {
                this.reportingFieldMapping = true;
                break;
            }
            case UNMAPPED: {
                this.reportingUnmapped = true;
                break;
            }
        }
    }

    public void setReportingFieldMapping(boolean reportingFieldMapping) {
        this.reportingFieldMapping = reportingFieldMapping;
    }

    public boolean isReportingUnmapped() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.reportingUnmapped;
    }

    public void setReportingUnmapped(boolean reportingUnmapped) {
        this.reportingUnmapped = reportingUnmapped;
    }

    public boolean isReportingStartInHex() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.reportingStartInHex;
    }

    public void setReportingStartInHex(boolean reportingStartInHex) {
        this.reportingStartInHex = reportingStartInHex;
    }

    public boolean isReportingLengthInHex() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.reportingLengthInHex;
    }

    public void setReportingLengthInHex(boolean reportingLengthInHex) {
        this.reportingLengthInHex = reportingLengthInHex;
    }

    public boolean isReportingArrayElements() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.reportingArrayElements;
    }

    public void setReportingArrayElements(boolean reportingArrayElements) {
        this.reportingArrayElements = reportingArrayElements;
    }

    public boolean isReportingStats() {
        return this.usingOldTemplate() && this.usingNewTemplate() && this.reportingStats;
    }

    public void setReportingStats(boolean reportingStats) {
        this.reportingStats = reportingStats;
    }

    public DSM.DsmType getType() {
        return this.type;
    }

    public void setType(DSM.DsmType type) {
        this.type = type;
    }

    public DSM.DsmSynch getSynch() {
        return this.synch;
    }

    public void setSynch(DSM.DsmSynch synch) {
        this.synch = synch;
    }

    public String getLimit() {
        if (this.synch == DSM.DsmSynch.READAHEAD || this.synch == DSM.DsmSynch.RAKEY) {
            return this.limit;
        }
        return "";
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getLength() {
        if (this.synch == DSM.DsmSynch.READAHEAD || this.synch == DSM.DsmSynch.RAKEY) {
            return this.length;
        }
        return "";
    }

    public void setLength(String length) {
        this.length = length;
    }

    public DSM.DsmList getList() {
        return this.list;
    }

    public void setList(DSM.DsmList list) {
        this.list = list;
    }

    public boolean isExcludeInserted() {
        return this.excludeInserted;
    }

    public void setExcludeInserted(boolean excludeInserted) {
        this.excludeInserted = excludeInserted;
    }

    public boolean isExcludeDeleted() {
        return this.excludeDeleted;
    }

    public void setExcludeDeleted(boolean excludeDeleted) {
        this.excludeDeleted = excludeDeleted;
    }

    public boolean isExcludeChanged() {
        return this.excludeChanged;
    }

    public void setExcludeChanged(boolean excludeChanged) {
        this.excludeChanged = excludeChanged;
    }

    public boolean isExcludeMatched() {
        return this.excludeMatched;
    }

    public void setExcludeMatched(boolean excludeMatched) {
        this.excludeMatched = excludeMatched;
    }

    public boolean isWideListing() {
        return this.wideListing;
    }

    public void setWideListing(boolean wideListing) {
        this.wideListing = wideListing;
    }

    public boolean isShowingHexOutput() {
        return this.showingHexOutput && this.getSynch() != DSM.DsmSynch.LMOD && this.getList() != DSM.DsmList.SUMMARY;
    }

    public void setShowingHexOutput(boolean showingHexOutput) {
        this.showingHexOutput = showingHexOutput;
    }

    public boolean isShowingChangedOnly() {
        return this.showingChangedOnly;
    }

    public void setShowingChangedOnly(boolean showingChangedOnly) {
        this.showingChangedOnly = showingChangedOnly;
    }

    public boolean isHighlightingFields() {
        return this.highlightingFields;
    }

    public void setHighlightingFields(boolean highlightingFields) {
        this.highlightingFields = highlightingFields;
    }

    public String getNumberDifferencesSet() {
        return this.numberDifferences;
    }

    public String getNumberDifferences() {
        try {
            Integer.parseInt(this.numberDifferences);
            return this.numberDifferences;
        }
        catch (NumberFormatException e) {
            return "ALL";
        }
    }

    public void setNumberDifferences(String numberDifferences) {
        this.numberDifferences = numberDifferences;
    }

    public boolean isShowingAttributeInfo() {
        if (this.usingOldTemplate() || this.usingNewTemplate()) {
            return this.showingAttributeInfo;
        }
        return false;
    }

    public void setShowingAttributeInfo(boolean showingAttributeInfo) {
        this.showingAttributeInfo = showingAttributeInfo;
    }

    public boolean isShowingSelected() {
        if (this.usingOldTemplate() || this.usingNewTemplate()) {
            return this.showingSelected;
        }
        return false;
    }

    public void setShowingSelected(boolean showingSelected) {
        this.showingSelected = showingSelected;
    }

    public boolean isSuppressingFields() {
        if (this.usingOldTemplate() || this.usingNewTemplate()) {
            return this.suppressFields;
        }
        return false;
    }

    public void setSuppressFields(boolean suppressFields) {
        this.suppressFields = suppressFields;
    }

    public DSM.DsmPack getPack() {
        if (this.getSynch() == DSM.DsmSynch.LMOD) {
            return DSM.DsmPack.UNPACK;
        }
        return this.pack;
    }

    public void setPack(DSM.DsmPack pack) {
        this.pack = pack;
    }

    public boolean isLeftJustifyingNumbers() {
        return this.type == DSM.DsmType.FORMATTED && this.leftJustifyingNumbers;
    }

    public void setLeftJustifyingNumbers(boolean leftJustifyingNumbers) {
        this.leftJustifyingNumbers = leftJustifyingNumbers;
    }

    public boolean isUsingKeyFromOldTemplate() {
        return (this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && this.usingOldTemplate() && this.usingKeyFromOldTemplate;
    }

    public void setUsingKeyFromOldTemplate(boolean usingKeyFromOldTemplate) {
        this.usingKeyFromOldTemplate = usingKeyFromOldTemplate;
    }

    public boolean isUsingKeyFromNewTemplate() {
        return (this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && this.usingNewTemplate() && this.usingKeyFromNewTemplate;
    }

    public void setUsingKeyFromNewTemplate(boolean usingKeyFromNewTemplate) {
        this.usingKeyFromNewTemplate = usingKeyFromNewTemplate;
    }

    public String getOldTemplateKeyFields() {
        if ((this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && this.usingOldTemplate()) {
            return this.oldTemplateKeyFields;
        }
        return "";
    }

    public void setOldTemplateKeyFields(String oldTemplateKeyFields) {
        this.oldTemplateKeyFields = oldTemplateKeyFields;
    }

    public String getNewTemplateKeyFields() {
        if ((this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && this.usingNewTemplate()) {
            return this.newTemplateKeyFields;
        }
        return "";
    }

    public void setNewTemplateKeyFields(String newTemplateKeyFields) {
        this.newTemplateKeyFields = newTemplateKeyFields;
    }

    public String getOldKeyLocations() {
        if (this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) {
            return this.oldKeyLocations;
        }
        return "";
    }

    public void setOldKeyLocations(String oldKeyLocations) {
        this.oldKeyLocations = oldKeyLocations;
    }

    public String getNewKeyLocations() {
        if (this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) {
            return this.newKeyLocations;
        }
        return "";
    }

    public void setNewKeyLocations(String newKeyLocations) {
        this.newKeyLocations = newKeyLocations;
    }

    public String getKeyLengthsSet() {
        return this.keyLengths;
    }

    public String getKeyLengths() {
        if ((this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && UIValidator.isValidIntegerList(this.keyLengths, true)) {
            return this.keyLengths;
        }
        return "";
    }

    public void setKeyLengths(String keyLengths) {
        this.keyLengths = keyLengths;
    }

    public String getNewKeyLengthsSet() {
        return this.newKeyLengths;
    }

    public String getNewKeyLengths() {
        if ((this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && UIValidator.isValidIntegerList(this.newKeyLengths, true)) {
            return this.newKeyLengths;
        }
        return "";
    }

    public void setNewKeyLengths(String keyLengths) {
        this.newKeyLengths = keyLengths;
    }

    public String getKeyTypesSet() {
        return this.keyTypes;
    }

    public String getKeyTypes() {
        if ((this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && UIValidator.isValidStringList(this.keyTypes, KEY_TYPE_LIST_VALUES, true)) {
            return this.keyTypes;
        }
        return "";
    }

    public void setKeyTypes(String keyTypes) {
        this.keyTypes = keyTypes;
    }

    public String getNewKeyTypesSet() {
        return this.newKeyTypes;
    }

    public String getNewKeyTypes() {
        if ((this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && UIValidator.isValidStringList(this.newKeyTypes, KEY_TYPE_LIST_VALUES, true)) {
            return this.newKeyTypes;
        }
        return "";
    }

    public void setNewKeyTypes(String keyTypes) {
        this.newKeyTypes = keyTypes;
    }

    public String getKeyOrdersSet() {
        return this.keyOrders;
    }

    public String getKeyOrders() {
        if ((this.synch == DSM.DsmSynch.KEYED || this.synch == DSM.DsmSynch.RAKEY) && UIValidator.isValidStringList(this.keyOrders, KEY_ORDER_LIST_VALUES, true)) {
            return this.keyOrders;
        }
        return "";
    }

    public void setKeyOrders(String keyOrders) {
        this.keyOrders = keyOrders;
    }

    public String getExcludes() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> excludesAsList = this.getExcludesAsList();
        for (String exclude : excludesAsList) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(exclude);
        }
        return sb.toString();
    }

    public ArrayList<String> getExcludesAsList() {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (this.excludeInserted) {
            excludeList.add("INSERTED");
        }
        if (this.excludeDeleted) {
            excludeList.add("DELETED");
        }
        if (this.excludeChanged) {
            excludeList.add("CHANGED");
        }
        if (this.excludeMatched) {
            excludeList.add("MATCHED");
        }
        return excludeList;
    }

    public void setExcludes(String excludes) {
        String[] excludesList;
        String[] stringArray = excludesList = excludes.split(",");
        int n = excludesList.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            if (exclude.equals("INSERTED")) {
                this.excludeInserted = true;
            }
            if (exclude.equals("DELETED")) {
                this.excludeDeleted = true;
            }
            if (exclude.equals("CHANGED")) {
                this.excludeChanged = true;
            }
            if (exclude.equals("MATCHED")) {
                this.excludeMatched = true;
            }
            ++n2;
        }
    }

    public DSM.DsmCmpLvl getCompareLevel() {
        return this.compareLevel;
    }

    public void setCompareLevel(DSM.DsmCmpLvl compareLevel) {
        this.compareLevel = compareLevel;
    }

    public DSM.DsmDateForm getDateForm() {
        return this.dateForm;
    }

    public void setDateForm(DSM.DsmDateForm dateForm) {
        this.dateForm = dateForm;
    }

    public Set<DSM.DsmLmodC> getLModC() {
        HashSet<DSM.DsmLmodC> lmodc = new HashSet<DSM.DsmLmodC>();
        if (this.isLmSize()) {
            lmodc.add(DSM.DsmLmodC.SIZE);
        }
        if (this.isLmAddress()) {
            lmodc.add(DSM.DsmLmodC.ADDRESS);
        }
        if (this.isLmLinker()) {
            lmodc.add(DSM.DsmLmodC.LINKER);
        }
        if (this.isLmDate()) {
            lmodc.add(DSM.DsmLmodC.TIME);
        }
        if (this.isLmMode()) {
            lmodc.add(DSM.DsmLmodC.MODE);
        }
        if (this.isLmAuth()) {
            lmodc.add(DSM.DsmLmodC.AUTH);
        }
        if (this.isLmAttr()) {
            lmodc.add(DSM.DsmLmodC.ATTR);
        }
        return lmodc;
    }

    public void setLModC(Set<DSM.DsmLmodC> lmodc) {
        this.setLmSize(lmodc.contains(DSM.DsmLmodC.SIZE));
        this.setLmAddress(lmodc.contains(DSM.DsmLmodC.ADDRESS));
        this.setLmLinker(lmodc.contains(DSM.DsmLmodC.LINKER));
        this.setLmDate(lmodc.contains(DSM.DsmLmodC.TIME));
        this.setLmMode(lmodc.contains(DSM.DsmLmodC.MODE));
        this.setLmAuth(lmodc.contains(DSM.DsmLmodC.AUTH));
        this.setLmAttr(lmodc.contains(DSM.DsmLmodC.ATTR));
    }

    public boolean isLmSize() {
        return this.lmSize;
    }

    public void setLmSize(boolean lmSize) {
        this.lmSize = lmSize;
    }

    public boolean isLmAddress() {
        return this.lmAddress;
    }

    public void setLmAddress(boolean lmAddress) {
        this.lmAddress = lmAddress;
    }

    public boolean isLmLinker() {
        return this.lmLinker;
    }

    public void setLmLinker(boolean lmLinker) {
        this.lmLinker = lmLinker;
    }

    public boolean isLmDate() {
        return this.lmDate;
    }

    public void setLmDate(boolean lmDate) {
        this.lmDate = lmDate;
    }

    public boolean isLmMode() {
        return this.lmMode;
    }

    public void setLmMode(boolean lmMode) {
        this.lmMode = lmMode;
    }

    public boolean isLmAuth() {
        return this.lmAuth;
    }

    public void setLmAuth(boolean lmAuth) {
        this.lmAuth = lmAuth;
    }

    public boolean isLmAttr() {
        return this.lmAttr;
    }

    public void setLmAttr(boolean lmAttr) {
        this.lmAttr = lmAttr;
    }

    public boolean isDoingCSectCompare() {
        return this.compareLevel == DSM.DsmCmpLvl.CSECT;
    }

    public Set<DSM.DsmCsectC> getCSectC() {
        HashSet<DSM.DsmCsectC> csectc = new HashSet<DSM.DsmCsectC>();
        if (this.isCsSize()) {
            csectc.add(DSM.DsmCsectC.SIZE);
        }
        if (this.isCsAddress()) {
            csectc.add(DSM.DsmCsectC.ADDRESS);
        }
        if (this.isCsCompiler()) {
            csectc.add(DSM.DsmCsectC.COMPILER);
        }
        if (this.isCsDate()) {
            csectc.add(DSM.DsmCsectC.DATE);
        }
        if (this.isCsMode()) {
            csectc.add(DSM.DsmCsectC.MODE);
        }
        if (this.isCsZap()) {
            csectc.add(DSM.DsmCsectC.ZAP);
        }
        if (this.isCsText()) {
            csectc.add(DSM.DsmCsectC.TEXT);
        }
        if (this.isCsCompOpts()) {
            csectc.add(DSM.DsmCsectC.COPT);
        }
        if (this.isCsProgAttrs()) {
            csectc.add(DSM.DsmCsectC.ATTR);
        }
        return csectc;
    }

    public void setCSectC(Set<DSM.DsmCsectC> csectc) {
        this.setCsSize(csectc.contains(DSM.DsmCsectC.SIZE));
        this.setCsAddress(csectc.contains(DSM.DsmCsectC.ADDRESS));
        this.setCsCompiler(csectc.contains(DSM.DsmCsectC.COMPILER));
        this.setCsDate(csectc.contains(DSM.DsmCsectC.DATE));
        this.setCsMode(csectc.contains(DSM.DsmCsectC.MODE));
        this.setCsZap(csectc.contains(DSM.DsmCsectC.ZAP));
        this.setCsText(csectc.contains(DSM.DsmCsectC.TEXT));
        this.setCsCompOpts(csectc.contains(DSM.DsmCsectC.COPT));
        this.setCsProgAttrs(csectc.contains(DSM.DsmCsectC.ATTR));
    }

    public boolean isCsSize() {
        return this.isDoingCSectCompare() && this.csSize;
    }

    public void setCsSize(boolean csSize) {
        this.csSize = csSize;
    }

    public boolean isCsAddress() {
        return this.isDoingCSectCompare() && this.csAddress;
    }

    public void setCsAddress(boolean csAddress) {
        this.csAddress = csAddress;
    }

    public boolean isCsCompiler() {
        return this.isDoingCSectCompare() && this.csCompiler;
    }

    public void setCsCompiler(boolean csCompiler) {
        this.csCompiler = csCompiler;
    }

    public boolean isCsDate() {
        return this.isDoingCSectCompare() && this.csDate;
    }

    public void setCsDate(boolean csDate) {
        this.csDate = csDate;
    }

    public boolean isCsMode() {
        return this.isDoingCSectCompare() && this.csMode;
    }

    public void setCsMode(boolean csMode) {
        this.csMode = csMode;
    }

    public boolean isCsZap() {
        return this.isDoingCSectCompare() && this.csZap;
    }

    public void setCsZap(boolean csZap) {
        this.csZap = csZap;
    }

    public boolean isCsText() {
        return this.isDoingCSectCompare() && this.csText;
    }

    public void setCsText(boolean csText) {
        this.csText = csText;
    }

    public boolean isCsCompOpts() {
        return this.isDoingCSectCompare() && this.csCompOpts;
    }

    public void setCsCompOpts(boolean csCompOpts) {
        this.csCompOpts = csCompOpts;
    }

    public boolean isCsProgAttrs() {
        return this.isDoingCSectCompare() && this.csProgAttrs;
    }

    public void setCsProgAttrs(boolean csProgAttrs) {
        this.csProgAttrs = csProgAttrs;
    }

    public String getCsCSects() {
        if (this.isDoingCSectCompare()) {
            return this.csCSects;
        }
        return "";
    }

    public void setCsCSects(String csCSects) {
        this.csCSects = csCSects;
    }

    public boolean isCsExclude() {
        return this.isDoingCSectCompare() && this.csExclude;
    }

    public void setCsExclude(boolean csExclude) {
        this.csExclude = csExclude;
    }

    public boolean isIgnoringBlanks() {
        return this.type == DSM.DsmType.FORMATTED && this.ignoringBlanks;
    }

    public void setIgnoringBlanks(boolean ignoreBlanks) {
        this.ignoringBlanks = ignoreBlanks;
    }

    public boolean isIgnoringCase() {
        return this.type == DSM.DsmType.FORMATTED && this.ignoringCase;
    }

    public void setIgnoringCase(boolean ignoreCase) {
        this.ignoringCase = ignoreCase;
    }

    public boolean isMatchReformatted() {
        return this.type == DSM.DsmType.FORMATTED && this.matchReformatted;
    }

    public void setMatchReformatted(boolean matchReformatted) {
        this.matchReformatted = matchReformatted;
    }

    public boolean isSortBefore() {
        return this.sortBefore;
    }

    public void setSortBefore(boolean sortBefore) {
        this.sortBefore = sortBefore;
    }

    public boolean isResultDatasets() {
        return this.resultDatasets;
    }

    public void setResultDatasets(boolean resultDatasets) {
        this.resultDatasets = resultDatasets;
    }

    public boolean isIncludeMd() {
        return this.includeMd;
    }

    public void setIncludeMd(boolean includeMd) {
        this.includeMd = includeMd;
    }

    public String getInsertsDataset() {
        return this.insertsDataset;
    }

    public void setInsertsDataset(String resource) {
        this.insertsDataset = resource;
    }

    public DSM.DsmDisp getInsertsDisposition() {
        return this.insertsDisposition;
    }

    public void setInsertsDisposition(DSM.DsmDisp disp) {
        this.insertsDisposition = disp;
    }

    public String getInsertsReclen() {
        return this.insertsReclen;
    }

    public void setInsertsReclen(String reclen) {
        this.insertsReclen = reclen;
    }

    public String getDeletesDataset() {
        return this.deletesDataset;
    }

    public void setDeletesDataset(String resource) {
        this.deletesDataset = resource;
    }

    public DSM.DsmDisp getDeletesDisposition() {
        return this.deletesDisposition;
    }

    public void setDeletesDisposition(DSM.DsmDisp disp) {
        this.deletesDisposition = disp;
    }

    public String getDeletesReclen() {
        return this.deletesReclen;
    }

    public void setDeletesReclen(String reclen) {
        this.deletesReclen = reclen;
    }

    public String getNChangesDataset() {
        return this.nchangesDataset;
    }

    public void setNChangesDataset(String resource) {
        this.nchangesDataset = resource;
    }

    public DSM.DsmDisp getNChangesDisposition() {
        return this.nchangesDisposition;
    }

    public void setNChangesDisposition(DSM.DsmDisp disp) {
        this.nchangesDisposition = disp;
    }

    public String getNChangesReclen() {
        return this.nchangesReclen;
    }

    public void setNChangesReclen(String reclen) {
        this.nchangesReclen = reclen;
    }

    public String getOChangesDataset() {
        return this.ochangesDataset;
    }

    public void setOChangesDataset(String resource) {
        this.ochangesDataset = resource;
    }

    public DSM.DsmDisp getOChangesDisposition() {
        return this.ochangesDisposition;
    }

    public void setOChangesDisposition(DSM.DsmDisp disp) {
        this.ochangesDisposition = disp;
    }

    public String getOChangesReclen() {
        return this.ochangesReclen;
    }

    public void setOChangesReclen(String reclen) {
        this.ochangesReclen = reclen;
    }

    public String getNMatchesDataset() {
        return this.nmatchesDataset;
    }

    public void setNMatchesDataset(String resource) {
        this.nmatchesDataset = resource;
    }

    public DSM.DsmDisp getNMatchesDisposition() {
        return this.nmatchesDisposition;
    }

    public void setNMatchesDisposition(DSM.DsmDisp disp) {
        this.nmatchesDisposition = disp;
    }

    public String getNMatchesReclen() {
        return this.nmatchesReclen;
    }

    public void setNMatchesReclen(String reclen) {
        this.nmatchesReclen = reclen;
    }

    public String getOMatchesDataset() {
        return this.omatchesDataset;
    }

    public void setOMatchesDataset(String resource) {
        this.omatchesDataset = resource;
    }

    public DSM.DsmDisp getOMatchesDisposition() {
        return this.omatchesDisposition;
    }

    public void setOMatchesDisposition(DSM.DsmDisp disp) {
        this.omatchesDisposition = disp;
    }

    public String getOMatchesReclen() {
        return this.omatchesReclen;
    }

    public void setOMatchesReclen(String reclen) {
        this.omatchesReclen = reclen;
    }

    private CompareModel clone(CompareModel command) {
        command.setAutoMapFieldsFirst(this.isAutoMapFieldsFirst());
        command.setKeyDupOk(this.isKeyDupOk());
        command.allKeysMatch = this.allKeysMatch;
        command.numberDifferences = this.numberDifferences;
        command.highlightingFields = this.highlightingFields;
        command.matchReformatted = this.matchReformatted;
        command.ignoringBlanks = this.ignoringBlanks;
        command.ignoringCase = this.ignoringCase;
        command.keyLengths = this.keyLengths;
        command.keyTypes = this.keyTypes;
        command.newKeyLengths = this.newKeyLengths;
        command.newKeyTypes = this.newKeyTypes;
        command.keyOrders = this.keyOrders;
        command.leftJustifyingNumbers = this.leftJustifyingNumbers;
        command.length = this.length;
        command.limit = this.limit;
        command.list = this.list;
        command.newBinaryRecordLength = this.newBinaryRecordLength;
        command.newCompare = this.newCompare;
        command.newIoExit = this.newIoExit;
        command.newIoExitCustom = this.newIoExitCustom;
        command.newKey = this.newKey;
        command.newKeyLocations = this.newKeyLocations;
        command.newMember = this.newMember;
        command.newResource = this.newResource;
        command.newResourceLoaded = (IRefreshable)this.getCloneOf(this.newResourceLoaded);
        command.newResourceVolume = this.newResourceVolume;
        command.newSkip = this.newSkip;
        command.newTemplate = this.newTemplate.clone();
        command.newTemplateFieldMapping = this.newTemplateFieldMapping;
        command.newTemplateKeyFields = this.newTemplateKeyFields;
        command.oldBinaryRecordLength = this.oldBinaryRecordLength;
        command.oldCompare = this.oldCompare;
        command.oldIgnoreLengthMismatches = this.oldIgnoreLengthMismatches;
        command.oldIoExit = this.oldIoExit;
        command.oldIoExitCustom = this.oldIoExitCustom;
        command.oldKey = this.oldKey;
        command.oldKeyLocations = this.oldKeyLocations;
        command.oldMemberSelectionCriteria = (MemberSelectionCriteriaModel)((Object)this.getCloneOf((Object)this.oldMemberSelectionCriteria));
        command.oldMembersList = this.oldMembersList;
        command.oldResource = this.oldResource;
        command.oldResourceLoaded = (IRefreshable)this.getCloneOf(this.oldResourceLoaded);
        command.oldResourceVolume = this.oldResourceVolume;
        command.oldSkip = this.oldSkip;
        command.oldTemplate = this.oldTemplate.clone();
        command.oldTemplateFieldMapping = this.oldTemplateFieldMapping;
        command.oldTemplateKeyFields = this.oldTemplateKeyFields;
        command.pack = this.pack;
        command.reportingArrayElements = this.reportingArrayElements;
        command.reportingFieldMapping = this.reportingFieldMapping;
        command.reportingUnmapped = this.reportingUnmapped;
        command.reportingStartInHex = this.reportingStartInHex;
        command.reportingLengthInHex = this.reportingLengthInHex;
        command.reportingLayout = this.reportingLayout;
        command.reportingCriteria = this.reportingCriteria;
        command.reportingStats = this.reportingStats;
        command.showingAttributeInfo = this.showingAttributeInfo;
        command.showingSelected = this.showingSelected;
        command.suppressFields = this.suppressFields;
        command.excludeInserted = this.excludeInserted;
        command.excludeDeleted = this.excludeDeleted;
        command.excludeChanged = this.excludeChanged;
        command.excludeMatched = this.excludeMatched;
        command.wideListing = this.wideListing;
        command.showingHexOutput = this.showingHexOutput;
        command.showingChangedOnly = this.showingChangedOnly;
        command.synch = this.synch;
        command.type = this.type;
        command.usingKeyFromNewTemplate = this.usingKeyFromNewTemplate;
        command.usingKeyFromOldTemplate = this.usingKeyFromOldTemplate;
        command.autoMapFieldsFirst = this.autoMapFieldsFirst;
        command.keyDupOk = this.keyDupOk;
        command.compareLevel = this.compareLevel;
        command.dateForm = this.dateForm;
        command.lmSize = this.lmSize;
        command.lmAddress = this.lmAddress;
        command.lmLinker = this.lmLinker;
        command.lmDate = this.lmDate;
        command.lmMode = this.lmMode;
        command.lmAuth = this.lmAuth;
        command.lmAttr = this.lmAttr;
        command.csSize = this.csSize;
        command.csAddress = this.csAddress;
        command.csCompiler = this.csCompiler;
        command.csDate = this.csDate;
        command.csMode = this.csMode;
        command.csZap = this.csZap;
        command.csText = this.csText;
        command.csCompOpts = this.csCompOpts;
        command.csProgAttrs = this.csProgAttrs;
        command.csCSects = this.csCSects;
        command.csExclude = this.csExclude;
        command.sortBefore = this.sortBefore;
        command.includeMd = this.includeMd;
        command.resultDatasets = this.resultDatasets;
        command.insertsDataset = this.insertsDataset;
        command.insertsDisposition = this.insertsDisposition;
        command.insertsReclen = this.insertsReclen;
        command.deletesDataset = this.deletesDataset;
        command.deletesDisposition = this.deletesDisposition;
        command.deletesReclen = this.deletesReclen;
        command.nchangesDataset = this.nchangesDataset;
        command.nchangesDisposition = this.nchangesDisposition;
        command.nchangesReclen = this.nchangesReclen;
        command.ochangesDataset = this.ochangesDataset;
        command.ochangesDisposition = this.ochangesDisposition;
        command.ochangesReclen = this.ochangesReclen;
        command.nmatchesDataset = this.nmatchesDataset;
        command.nmatchesDisposition = this.nmatchesDisposition;
        command.nmatchesReclen = this.nmatchesReclen;
        command.omatchesDataset = this.omatchesDataset;
        command.omatchesDisposition = this.omatchesDisposition;
        command.omatchesReclen = this.omatchesReclen;
        return command;
    }

    public CompareModel clone() {
        CompareModel dsm = new CompareModel(this.getHostProvider());
        return this.clone(dsm);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompareModel) {
            CompareModel other = (CompareModel)((Object)obj);
            return this.getSystem().equals(other.getSystem()) && this.toUtilityFunction().equals((Object)other.toUtilityFunction());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.toUtilityFunction().hashCode();
    }

    public static String[] getKeyTypeListValues() {
        return Arrays.copyOf(KEY_TYPE_LIST_VALUES, KEY_TYPE_LIST_VALUES.length);
    }

    public static String[] getKeyOrdersListValues() {
        return Arrays.copyOf(KEY_ORDER_LIST_VALUES, KEY_ORDER_LIST_VALUES.length);
    }
}

