/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.socket.func.DSM;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.CompareModel;
import com.ibm.etools.fm.ui.wizards.CompareRunnable;
import com.ibm.etools.fm.ui.wizards.CompareWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CompareActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private CompareModel model = null;
    private static DSMActionItemPropertySource propSource;

    public CompareActionItem(CompareModel model) {
        super(ActionType.DSM, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        String resourceOld = null;
        String resourceNew = null;
        resourceOld = this.getFullOldResourceName(false);
        IZRL newResource = this.model.getNewResource();
        resourceNew = newResource != null ? newResource.getFormattedName() : "unknown";
        return MessageFormat.format(Messages.DSMActionItem_LABEL, resourceOld, resourceNew);
    }

    private String getFullOldResourceName(boolean listAllMembers) {
        if (this.model.isMultipleOldMembersSelected(false)) {
            return this.model.getOldResource().getFormattedName() + "(" + (listAllMembers ? this.model.getOldMemberList() : "...") + ")";
        }
        if (this.model.getSingleSourceMemberSelected() != null) {
            return this.model.getOldResource().getFormattedName() + "(" + this.model.getSingleSourceMemberSelected() + ")";
        }
        IZRL oldResource = this.model.getOldResource();
        if (oldResource != null) {
            return oldResource.getFormattedName();
        }
        return "unknown";
    }

    @Override
    public String getToolTipText() {
        return MessageFormat.format(Messages.DSMActionItem_TOOLTIP, this.getFullOldResourceName(true), this.model.getNewResource().getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        DSM function = new DSM();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        CompareModel model = new CompareModel(system);
        model.fromUtilityFunction(function);
        return new CompareActionItem(model);
    }

    public CompareModel getModel() {
        return this.model;
    }

    @Override
    public void execute() {
        this.beginExecution();
        CompareRunnable runnable = new CompareRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final CompareModel clone = this.model.clone();
        CompareWizard wizard = new CompareWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                CompareActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public CompareActionItem clone() {
        CompareActionItem clone = new CompareActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CompareActionItem) {
            CompareActionItem other = (CompareActionItem)obj;
            return this.getSystem().equals(other.getSystem()) && this.model.toUtilityFunction().equals((Object)other.model.toUtilityFunction());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 37;
        r = 37 * r + this.getSystem().hashCode();
        r = 37 * r + this.model.toUtilityFunction().hashCode();
        return r;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new DSMActionItemPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    private static class DSMActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private CompareModel model;
        private IPropertyDescriptor[] propertyDescriptors;
        private String oldResource = "oldResource";
        private String oldResourceVolume = "oldResourceVolume";
        private String newResource = "newResource";
        private String newResourceVolume = "newResourceVolume";
        private String oldMembersList = "oldMembersList";
        private String membersRangeStart = "membersRangeStart";
        private String membersRangeEnd = "membersRangeEnd";
        private String membersCreatedStart = "membersCreatedStart";
        private String membersCreatedEnd = "membersCreatedEnd";
        private String membersChangedStart = "membersChangedStart";
        private String membersChangedEnd = "membersChangedEnd";
        private String membersUserIDStart = "membersUserIDStart";
        private String membersUserIDEnd = "membersUserIDEnd";
        private String oldIoExitCustom = "oldIoExitCustom";
        private String oldBinaryRecordLength = "oldBinaryRecordLength";
        private String oldKey = "oldKey";
        private String oldSkip = "oldSkip";
        private String oldCompare = "oldCompare";
        private String oldIgnoreLengthMismatches = "oldIgnoreLengthMismatches";
        private String newMember = "newMember";
        private String newIoExitCustom = "newIoExitCustom";
        private String newBinaryRecordLength = "newBinaryRecordLength";
        private String newKey = "newKey";
        private String newSkip = "newSkip";
        private String newCompare = "newCompare";
        private String autoMapFieldsFirst = "autoMapFieldsFirst";
        private String oldTemplate = "oldTemplate";
        private String oldOffset = "oldOffset";
        private String oldTemplateFieldMapping = "oldTemplateFieldMapping";
        private String newTemplate = "newTemplate";
        private String newOffset = "newOffset";
        private String newTemplateFieldMapping = "newTemplateFieldMapping";
        private String reportingLayouts = "reportingLayout";
        private String reportingCriteria = "reportingCriteria";
        private String reportingFieldMapping = "reportingFieldMapping";
        private String reportingUnmapped = "reportingUnmapped";
        private String reportingStartInHex = "reportingStartInHex";
        private String reportingLengthInHex = "reportingLengthInHex";
        private String reportingStats = "reportingStats";
        private String reportingArrayElements = "reportingArrayElements";
        private String synch = "synch";
        private String type = "type";
        private String limit = "limit";
        private String length = "length";
        private String list = "list";
        private String wideListing = "wideListing";
        private String showingHexOutput = "showingHexOutput";
        private String showingChanged = "showingChanged";
        private String numberDifferences = "numberDifferences";
        private String highlightingFields = "highlightingFields";
        private String showingAttributeInfo = "showingAttributeInfo";
        private String showingSelected = "showingSelected";
        private String suppressingFields = "suppressingFields";
        private String pack = "pack";
        private String leftJustifyingNumbers = "leftJustifyingNumbers";
        private String usingKeyFromOldTemplate = "usingKeyFromOldTemplate";
        private String usingKeyFromNewTemplate = "usingKeyFromNewTemplate";
        private String oldTemplateKeyFields = "oldTemplateKeyFields";
        private String newTemplateKeyFields = "newTemplateKeyFields";
        private String oldKeyLocations = "oldKeyLocations";
        private String newKeyLocations = "newKeyLocations";
        private String keyLengths = "keyLengths";
        private String keyTypes = "keyTypes";
        private String newKeyLengths = "newKeyLengths";
        private String newKeyTypes = "newKeyTypes";
        private String keyOrders = "keyOrders";
        private String allKeysMatch = "allKeysMatch";
        private String keyDupOk = "keyDupOk";
        private String compareLevel = "compareLevel";
        private String dateForm = "dateForm";
        private String lmSize = "lmSize";
        private String lmAddress = "lmAddress";
        private String lmLinker = "lmLinker";
        private String lmDate = "lmDate";
        private String lmMode = "lmMode";
        private String lmAuth = "lmAuth";
        private String lmAttr = "lmAttr";
        private String csSize = "csSize";
        private String csAddress = "csAddress";
        private String csCompiler = "csCompiler";
        private String csDate = "csDate";
        private String csMode = "csMode";
        private String csZap = "csZap";
        private String csText = "csText";
        private String csCompOpts = "csCompOpts";
        private String csProgAttrs = "csProgAttrs";
        private String csCSects = "csCSect";
        private String csExclude = "csExclude";
        private String matchReformatted = "matchReformatted";
        private String ignoringBlanks = "ignoringBlanks";
        private String ignoringCase = "ignoringCase";
        public String sortBefore = "sortBefore";
        public String resultDatasets = "resultDatasets";
        public String includeMD = "includeMD";
        public String excludeInserted = "excludeInserted";
        public String excludeDeleted = "excludeDeleted";
        public String excludeChanged = "excludeChanged";
        public String excludeMatched = "excludeMatched";
        public String insertsDataset = "insertsDataset";
        public String insertsDisposition = "insertsDisposition";
        public String insertsReclen = "insertsReclen";
        public String deletesDataset = "deletesDataset";
        public String deletesDisposition = "deletesDisposition";
        public String deletesReclen = "deletesReclen";
        public String nchangesDataset = "nchangesDataset";
        public String nchangesDisposition = "nchangesDisposition";
        public String nchangesReclen = "nchangesReclen";
        public String ochangesDataset = "ochangesDataset";
        public String ochangesDisposition = "ochangesDisposition";
        public String ochangesReclen = "ochangesReclen";
        public String nmatchesDataset = "nmatchesDataset";
        public String nmatchesDisposition = "nmatchesDisposition";
        public String nmatchesReclen = "nmatchesReclen";
        public String omatchesDataset = "omatchesDataset";
        public String omatchesDisposition = "omatchesDisposition";
        public String omatchesReclen = "omatchesReclen";

        public DSMActionItemPropertySource(CompareModel model) {
            this.model = model;
            this.init();
        }

        public void setModel(CompareModel model) {
            this.model = model;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.oldResource, Messages.DSMActionItem_OLD_RESOURCE));
            temp.add(new PropertyDescriptor((Object)this.oldResourceVolume, Messages.DSMActionItem_OLD_RESOUCE_VOLUME));
            temp.add(new PropertyDescriptor((Object)this.newResource, Messages.DSMActionItem_NEW_RESOURCE));
            temp.add(new PropertyDescriptor((Object)this.newResourceVolume, Messages.DSMActionItem_NEW_RESOURCE_VOLUME));
            temp.add(new PropertyDescriptor((Object)this.oldMembersList, Messages.DSMActionItem_OLD_MEMBER_LIST));
            temp.add(new PropertyDescriptor((Object)this.membersRangeStart, Messages.DSMActionItem_MEMBER_RANGE_START));
            temp.add(new PropertyDescriptor((Object)this.membersRangeEnd, Messages.DSMActionItem_MEMBER_RANGE_END));
            temp.add(new PropertyDescriptor((Object)this.membersCreatedStart, Messages.DSMActionItem_CREATED_START));
            temp.add(new PropertyDescriptor((Object)this.membersCreatedEnd, Messages.DSMActionItem_CREATED_END));
            temp.add(new PropertyDescriptor((Object)this.membersChangedStart, Messages.DSMActionItem_CHANGE_START));
            temp.add(new PropertyDescriptor((Object)this.membersChangedEnd, Messages.DSMActionItem_CHANGE_END));
            temp.add(new PropertyDescriptor((Object)this.membersUserIDStart, Messages.DSMActionItem_USER_ID_START));
            temp.add(new PropertyDescriptor((Object)this.membersUserIDEnd, Messages.DSMActionItem_USER_ID_END));
            temp.add(new PropertyDescriptor((Object)this.oldIoExitCustom, Messages.DSMActionItem_OLD_IO_EXIT));
            temp.add(new PropertyDescriptor((Object)this.oldBinaryRecordLength, Messages.DSMActionItem_OLD_BINARY_RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.oldKey, Messages.DSMActionItem_OLD_KEY));
            temp.add(new PropertyDescriptor((Object)this.oldSkip, Messages.DSMActionItem_OLD_SKIP));
            temp.add(new PropertyDescriptor((Object)this.oldCompare, Messages.DSMActionItem_OLD_RECORDS_TO_COMPARE));
            temp.add(new PropertyDescriptor((Object)this.oldIgnoreLengthMismatches, Messages.DSMActionItem_IGNORE_LENGTH_MISMATCHES));
            temp.add(new PropertyDescriptor((Object)this.newMember, Messages.DSMActionItem_NEW_MEMBER));
            temp.add(new PropertyDescriptor((Object)this.newIoExitCustom, Messages.DSMActionItem_NEW_IO_EXIT));
            temp.add(new PropertyDescriptor((Object)this.newBinaryRecordLength, Messages.DSMActionItem_NEW_BINARY_RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.newKey, Messages.DSMActionItem_NEW_KEY));
            temp.add(new PropertyDescriptor((Object)this.newSkip, Messages.DSMActionItem_NEW_SKIP));
            temp.add(new PropertyDescriptor((Object)this.newCompare, Messages.DSMActionItem_NEW_COMPARE));
            temp.add(new PropertyDescriptor((Object)this.autoMapFieldsFirst, Messages.CompareWizardPageTemplate_AUTO_MAP_CORRESP_FIELDS));
            temp.add(new PropertyDescriptor((Object)this.oldTemplate, Messages.DSMActionItem_OLD_TEMPLATE));
            temp.add(new PropertyDescriptor((Object)this.oldOffset, Messages.DSMActionItem_OLD_TEMPLATE_OFFSET));
            temp.add(new PropertyDescriptor((Object)this.oldTemplateFieldMapping, Messages.DSMActionItem_OLD_TEMPLATE_FIELD_MAPPING));
            temp.add(new PropertyDescriptor((Object)this.newTemplate, Messages.DSMActionItem_NEW_TEMPLATE));
            temp.add(new PropertyDescriptor((Object)this.newOffset, Messages.DSMActionItem_NEW_TEMPLATE_OFFSET));
            temp.add(new PropertyDescriptor((Object)this.newTemplateFieldMapping, Messages.DSMActionItem_NEW_TEMPLATE_FIELD_MAPPING));
            temp.add(new PropertyDescriptor((Object)this.reportingLayouts, Messages.CompareWizardPageTemplate_REPORT_LAYOUTS));
            temp.add(new PropertyDescriptor((Object)this.reportingCriteria, Messages.CompareWizardPageTemplate_REPORT_CRITERIA));
            temp.add(new PropertyDescriptor((Object)this.reportingFieldMapping, Messages.CompareWizardPageTemplate_REPORT_FIELD_MAPPINGS));
            temp.add(new PropertyDescriptor((Object)this.reportingUnmapped, Messages.CompareWizardPageTemplate_REPORT_UNMAPPED));
            temp.add(new PropertyDescriptor((Object)this.reportingStartInHex, Messages.CompareWizardPageTemplate_REPORT_FIELDS_IN_HEX));
            temp.add(new PropertyDescriptor((Object)this.reportingLengthInHex, Messages.CompareWizardPageTemplate_REPORT_LENGTH_IN_HEX));
            temp.add(new PropertyDescriptor((Object)this.reportingArrayElements, Messages.CompareWizardPageTemplate_REPORT_ARRAY_ELEMENTS));
            temp.add(new PropertyDescriptor((Object)this.reportingStats, Messages.CompareWizardPageTemplate_REPORT_STATS));
            temp.add(new PropertyDescriptor((Object)this.synch, Messages.CompareWizardPageFirst_SYNCHRONIZATION));
            temp.add(new PropertyDescriptor((Object)this.limit, Messages.DSMActionItem_LIMIT));
            temp.add(new PropertyDescriptor((Object)this.length, Messages.DSMActionItem_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.list, Messages.CompareWizardPageFirst_RESULT_LISTING));
            temp.add(new PropertyDescriptor((Object)this.wideListing, Messages.CompareWizardPageFirst_WIDE_LISTING));
            temp.add(new PropertyDescriptor((Object)this.showingHexOutput, Messages.CompareWizardPageFirst_HEX_FORMATTING));
            temp.add(new PropertyDescriptor((Object)this.showingChanged, Messages.CompareWizardPageFirst_CHANGED_ONLY));
            temp.add(new PropertyDescriptor((Object)this.numberDifferences, Messages.CompareWizardPageFirst_NUMBER_DIFFERENCES));
            temp.add(new PropertyDescriptor((Object)this.highlightingFields, Messages.CompareWizardPageFirst_HIGHLIGHT_CHANGED));
            temp.add(new PropertyDescriptor((Object)this.showingAttributeInfo, Messages.CompareWizardPageTemplate_SHOW_ATTRIBUTES_IN_HEADERS));
            temp.add(new PropertyDescriptor((Object)this.showingSelected, Messages.CompareWizardPageTemplate_SHOW_SELECTED));
            temp.add(new PropertyDescriptor((Object)this.suppressingFields, Messages.CompareWizardPageTemplate_SUPPRESS_FIELDS));
            temp.add(new PropertyDescriptor((Object)this.pack, Messages.CompareWizardPageFirst_ISPF_PACKING));
            temp.add(new PropertyDescriptor((Object)this.leftJustifyingNumbers, Messages.CompareWizardPageTemplate_LEFT_JUSTIFY_NUMERICS));
            temp.add(new PropertyDescriptor((Object)this.usingKeyFromOldTemplate, Messages.CompareWizardPageSynchronization_USE_OLD_TEMPLATE_KEYS));
            temp.add(new PropertyDescriptor((Object)this.usingKeyFromNewTemplate, Messages.CompareWizardPageSynchronization_USE_NEW_TEMPLATE_KEYS));
            temp.add(new PropertyDescriptor((Object)this.oldTemplateKeyFields, Messages.CompareWizardPageSynchronization_OLD_TEMPLATE_KEYS));
            temp.add(new PropertyDescriptor((Object)this.newTemplateKeyFields, Messages.CompareWizardPageSynchronization_NEW_TEMPLATE_KEYS));
            temp.add(new PropertyDescriptor((Object)this.oldKeyLocations, Messages.CompareWizardPageSynchronization_OLD_KEY_LOCATIONS));
            temp.add(new PropertyDescriptor((Object)this.newKeyLocations, Messages.CompareWizardPageSynchronization_NEW_KEY_LOCATIONS));
            temp.add(new PropertyDescriptor((Object)this.keyLengths, Messages.CompareWizardPageSynchronization_KEY_LENGTHS));
            temp.add(new PropertyDescriptor((Object)this.keyTypes, Messages.CompareWizardPageSynchronization_KEY_TYPES));
            temp.add(new PropertyDescriptor((Object)this.newKeyLengths, Messages.CompareWizardPageSynchronization_NEW_KEY_LENGTHS));
            temp.add(new PropertyDescriptor((Object)this.newKeyTypes, Messages.CompareWizardPageSynchronization_NEW_KEY_TYPES));
            temp.add(new PropertyDescriptor((Object)this.keyOrders, Messages.CompareWizardPageSynchronization_KEY_ORDERS));
            temp.add(new PropertyDescriptor((Object)this.allKeysMatch, Messages.CompareWizardPageSynchronization_MATCH_ALL));
            temp.add(new PropertyDescriptor((Object)this.keyDupOk, Messages.CompareWizardPageSynchronization_DUPLICATES_OK));
            temp.add(new PropertyDescriptor((Object)this.compareLevel, Messages.CompareWizardPageLoadModule_COMPARISON_LEVEL));
            temp.add(new PropertyDescriptor((Object)this.dateForm, Messages.CompareWizardPageLoadModule_DATE_FORMAT));
            temp.add(new PropertyDescriptor((Object)this.lmSize, Messages.DSMActionItem_LOAD_MODULE_SIZE));
            temp.add(new PropertyDescriptor((Object)this.lmAddress, Messages.DSMActionItem_LOAD_MODULE_ENTRY_POINT_ADDRESS));
            temp.add(new PropertyDescriptor((Object)this.lmLinker, Messages.DSMActionItem_LOAD_MODULE_VERSION_OF_LINKER_USED));
            temp.add(new PropertyDescriptor((Object)this.lmDate, Messages.DSMActionItem_LOAD_MODULE_LINK_DATE));
            temp.add(new PropertyDescriptor((Object)this.lmMode, Messages.DSMActionItem_LOAD_MODULE_AMODE));
            temp.add(new PropertyDescriptor((Object)this.lmAuth, Messages.DSMActionItem_LOAD_MODULE_AUTHORIZATION));
            temp.add(new PropertyDescriptor((Object)this.lmAttr, Messages.DSMActionItem_LOAD_MODULE_LINK_ATTRIBUTES));
            temp.add(new PropertyDescriptor((Object)this.csSize, Messages.DSMActionItem_CSECT_PRIVATE));
            temp.add(new PropertyDescriptor((Object)this.csAddress, Messages.DSMActionItem_CSECT_ADDRESSS));
            temp.add(new PropertyDescriptor((Object)this.csCompiler, Messages.DSMActionItem_CSECT_VERSION_OF_COMPILER));
            temp.add(new PropertyDescriptor((Object)this.csDate, Messages.DSMActionItem_CSECT_DATE));
            temp.add(new PropertyDescriptor((Object)this.csMode, Messages.DSMActionItem_CSECT_AMODE));
            temp.add(new PropertyDescriptor((Object)this.csZap, Messages.DSMActionItem_CSECT_AMSPZAP));
            temp.add(new PropertyDescriptor((Object)this.csText, Messages.DSMActionItem_CSECT_TEXT_CONTENT));
            temp.add(new PropertyDescriptor((Object)this.csCompOpts, Messages.DSMActionItem_CSECT_COMPILE_OPTIONS));
            temp.add(new PropertyDescriptor((Object)this.csProgAttrs, Messages.DSMActionItem_CSECT_PROGRAM_ATTRS));
            temp.add(new PropertyDescriptor((Object)this.csCSects, Messages.DSMActionItem_CSECT_CSECTS));
            temp.add(new PropertyDescriptor((Object)this.csExclude, Messages.DSMActionItem_CSECT_EXCLUDE));
            temp.add(new PropertyDescriptor((Object)this.type, Messages.CompareWizardPageTemplate_COMPARISON_TYPE));
            temp.add(new PropertyDescriptor((Object)this.matchReformatted, Messages.CompareWizardPageTemplate_MATCH_REFORMATTED));
            temp.add(new PropertyDescriptor((Object)this.ignoringBlanks, Messages.CompareWizardPageTemplate_IGNORE_BLANKS));
            temp.add(new PropertyDescriptor((Object)this.ignoringCase, Messages.CompareWizardPageTemplate_IGNORE_CASE));
            temp.add(new PropertyDescriptor((Object)this.sortBefore, Messages.CompareWizardPageFirst_SORT_BEFORE));
            temp.add(new PropertyDescriptor((Object)this.resultDatasets, Messages.CompareWizardPageFirst_RESULT_DATASETS));
            temp.add(new PropertyDescriptor((Object)this.includeMD, Messages.EditorOptionDialog_MQ_INCLUDE_DESCRIPTORS));
            temp.add(new PropertyDescriptor((Object)this.excludeInserted, Messages.CompareWizardPageFirst_EXCLUDE_INSERTED));
            temp.add(new PropertyDescriptor((Object)this.excludeDeleted, Messages.CompareWizardPageFirst_EXCLUDE_DELETED));
            temp.add(new PropertyDescriptor((Object)this.excludeChanged, Messages.CompareWizardPageFirst_EXCLUDE_CHANGED));
            temp.add(new PropertyDescriptor((Object)this.excludeMatched, Messages.CompareWizardPageFirst_EXCLUDE_MATCHED));
            temp.add(new PropertyDescriptor((Object)this.insertsDataset, Messages.CompareWizardPageResultDatasets_INSERTS_DATASET));
            temp.add(new PropertyDescriptor((Object)this.insertsDisposition, Messages.CompareWizardPageResultDatasets_INSERTS_DISPOSITION));
            temp.add(new PropertyDescriptor((Object)this.insertsReclen, Messages.CompareWizardPageResultDatasets_INSERTS_RECLEN));
            temp.add(new PropertyDescriptor((Object)this.deletesDataset, Messages.CompareWizardPageResultDatasets_DELETES_DATASET));
            temp.add(new PropertyDescriptor((Object)this.deletesDisposition, Messages.CompareWizardPageResultDatasets_DELETES_DISPOSITION));
            temp.add(new PropertyDescriptor((Object)this.deletesReclen, Messages.CompareWizardPageResultDatasets_DELETES_RECLEN));
            temp.add(new PropertyDescriptor((Object)this.nchangesDataset, Messages.CompareWizardPageResultDatasets_NCHANGES_DATASET));
            temp.add(new PropertyDescriptor((Object)this.nchangesDisposition, Messages.CompareWizardPageResultDatasets_NCHANGES_DISPOSITION));
            temp.add(new PropertyDescriptor((Object)this.nchangesReclen, Messages.CompareWizardPageResultDatasets_NCHANGES_RECLEN));
            temp.add(new PropertyDescriptor((Object)this.ochangesDataset, Messages.CompareWizardPageResultDatasets_OCHANGES_DATASET));
            temp.add(new PropertyDescriptor((Object)this.ochangesDisposition, Messages.CompareWizardPageResultDatasets_OCHANGES_DISPOSITION));
            temp.add(new PropertyDescriptor((Object)this.ochangesReclen, Messages.CompareWizardPageResultDatasets_OCHANGES_RECLEN));
            temp.add(new PropertyDescriptor((Object)this.nmatchesDataset, Messages.CompareWizardPageResultDatasets_NMATCHES_DATASET));
            temp.add(new PropertyDescriptor((Object)this.nmatchesDisposition, Messages.CompareWizardPageResultDatasets_NMATCHES_DISPOSITION));
            temp.add(new PropertyDescriptor((Object)this.nmatchesReclen, Messages.CompareWizardPageResultDatasets_NMATCHES_RECLEN));
            temp.add(new PropertyDescriptor((Object)this.omatchesDataset, Messages.CompareWizardPageResultDatasets_OMATCHES_DATASET));
            temp.add(new PropertyDescriptor((Object)this.omatchesDisposition, Messages.CompareWizardPageResultDatasets_OMATCHES_DISPOSITION));
            temp.add(new PropertyDescriptor((Object)this.omatchesReclen, Messages.CompareWizardPageResultDatasets_OMATCHES_RECLEN));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.oldResource)) {
                    return this.model.getOldResourceSet();
                }
                if (id.equals(this.oldResourceVolume)) {
                    return this.model.getOldResourceVolume();
                }
                if (id.equals(this.newResource)) {
                    return this.model.getNewResourceSet();
                }
                if (id.equals(this.newResourceVolume)) {
                    return this.model.getNewResourceVolume();
                }
                if (id.equals(this.oldMembersList)) {
                    return this.model.getOldMemberList();
                }
                if (id.equals(this.membersRangeStart)) {
                    if (!this.model.getOldMemberSelectionCriteria().isUsingRange()) {
                        return "";
                    }
                    return this.model.getOldMemberSelectionCriteria().getMembersRangeStart();
                }
                if (id.equals(this.membersRangeEnd)) {
                    if (!this.model.getOldMemberSelectionCriteria().isUsingRange()) {
                        return "";
                    }
                    return this.model.getOldMemberSelectionCriteria().getMembersRangeEnd();
                }
                if (id.equals(this.membersCreatedStart)) {
                    if (!this.model.getOldMemberSelectionCriteria().isUsingCreated()) {
                        return "";
                    }
                    return this.model.getOldMemberSelectionCriteria().getMembersCreatedStartFormatted();
                }
                if (id.equals(this.membersCreatedEnd)) {
                    if (!this.model.getOldMemberSelectionCriteria().isUsingCreated()) {
                        return "";
                    }
                    return this.model.getOldMemberSelectionCriteria().getMembersCreatedEndFormatted();
                }
                if (id.equals(this.membersChangedStart)) {
                    if (!this.model.getOldMemberSelectionCriteria().isUsingChanged()) {
                        return "";
                    }
                    return this.model.getOldMemberSelectionCriteria().getMembersChangedStartFormatted();
                }
                if (id.equals(this.membersChangedEnd)) {
                    if (!this.model.getOldMemberSelectionCriteria().isUsingChanged()) {
                        return "";
                    }
                    return this.model.getOldMemberSelectionCriteria().getMembersChangedEndFormatted();
                }
                if (id.equals(this.membersUserIDStart)) {
                    if (!this.model.getOldMemberSelectionCriteria().isUsingUserID()) {
                        return "";
                    }
                    return this.model.getOldMemberSelectionCriteria().getMembersUserIDStart();
                }
                if (id.equals(this.membersUserIDEnd)) {
                    if (!this.model.getOldMemberSelectionCriteria().isUsingUserID()) {
                        return "";
                    }
                    return this.model.getOldMemberSelectionCriteria().getMembersUserIDEnd();
                }
                if (id.equals(this.oldIoExitCustom)) {
                    if (!this.model.isOldIoExit()) {
                        return "";
                    }
                    return this.model.getOldIoExitCustom();
                }
                if (id.equals(this.oldBinaryRecordLength)) {
                    return this.model.getOldBinaryRecordLength();
                }
                if (id.equals(this.oldKey)) {
                    return this.model.getOldKey();
                }
                if (id.equals(this.oldSkip)) {
                    return this.model.getOldSkip();
                }
                if (id.equals(this.oldCompare)) {
                    return this.model.getOldCompare();
                }
                if (id.equals(this.oldIgnoreLengthMismatches)) {
                    return this.model.isOldIgnoreLengthMismatches();
                }
                if (id.equals(this.newMember)) {
                    return this.model.getNewMember();
                }
                if (id.equals(this.newIoExitCustom)) {
                    if (!this.model.isNewIoExit()) {
                        return "";
                    }
                    return this.model.getNewIoExitCustom();
                }
                if (id.equals(this.newBinaryRecordLength)) {
                    return this.model.getNewBinaryRecordLength();
                }
                if (id.equals(this.newKey)) {
                    return this.model.getNewKey();
                }
                if (id.equals(this.newSkip)) {
                    return this.model.getNewSkip();
                }
                if (id.equals(this.newCompare)) {
                    return this.model.getNewCompare();
                }
                if (id.equals(this.autoMapFieldsFirst)) {
                    return this.model.isAutoMapFieldsFirst();
                }
                if (id.equals(this.oldTemplate)) {
                    return this.model.getOldTemplate().getTemplateSet();
                }
                if (id.equals(this.oldOffset)) {
                    return this.model.getOldTemplate().getOffsets();
                }
                if (id.equals(this.oldTemplateFieldMapping)) {
                    return this.model.getOldTemplateFieldMapping();
                }
                if (id.equals(this.newTemplate)) {
                    return this.model.getNewTemplate().getTemplateSet();
                }
                if (id.equals(this.newOffset)) {
                    return this.model.getNewTemplate().getOffsets();
                }
                if (id.equals(this.newTemplateFieldMapping)) {
                    return this.model.getNewTemplateFieldMapping();
                }
                if (id.equals(this.reportingLayouts)) {
                    return this.model.isReportingLayout();
                }
                if (id.equals(this.reportingCriteria)) {
                    return this.model.isReportingCriteria();
                }
                if (id.equals(this.reportingFieldMapping)) {
                    return this.model.isReportingFieldMapping();
                }
                if (id.equals(this.reportingUnmapped)) {
                    return this.model.isReportingUnmapped();
                }
                if (id.equals(this.reportingStartInHex)) {
                    return this.model.isReportingStartInHex();
                }
                if (id.equals(this.reportingLengthInHex)) {
                    return this.model.isReportingLengthInHex();
                }
                if (id.equals(this.reportingArrayElements)) {
                    return this.model.isReportingArrayElements();
                }
                if (id.equals(this.reportingStats)) {
                    return this.model.isReportingStats();
                }
                if (id.equals(this.synch)) {
                    return this.model.getSynch();
                }
                if (id.equals(this.type)) {
                    return this.model.getType();
                }
                if (id.equals(this.limit)) {
                    return this.model.getLimit();
                }
                if (id.equals(this.length)) {
                    return this.model.getLength();
                }
                if (id.equals(this.list)) {
                    return this.model.getList();
                }
                if (id.equals(this.wideListing)) {
                    return this.model.isWideListing();
                }
                if (id.equals(this.showingHexOutput)) {
                    return this.model.isShowingHexOutput();
                }
                if (id.equals(this.showingChanged)) {
                    return this.model.isShowingChangedOnly();
                }
                if (id.equals(this.numberDifferences)) {
                    return this.model.getNumberDifferences();
                }
                if (id.equals(this.highlightingFields)) {
                    return this.model.isHighlightingFields();
                }
                if (id.equals(this.showingAttributeInfo)) {
                    return this.model.isShowingAttributeInfo();
                }
                if (id.equals(this.showingSelected)) {
                    return this.model.isShowingSelected();
                }
                if (id.equals(this.suppressingFields)) {
                    return this.model.isSuppressingFields();
                }
                if (id.equals(this.pack)) {
                    return this.model.getPack();
                }
                if (id.equals(this.leftJustifyingNumbers)) {
                    return this.model.isLeftJustifyingNumbers();
                }
                if (id.equals(this.usingKeyFromOldTemplate)) {
                    return this.model.isUsingKeyFromOldTemplate();
                }
                if (id.equals(this.usingKeyFromNewTemplate)) {
                    return this.model.isUsingKeyFromNewTemplate();
                }
                if (id.equals(this.oldTemplateKeyFields)) {
                    if (!this.model.isUsingKeyFromOldTemplate()) {
                        return "";
                    }
                    return this.model.getOldTemplateKeyFields();
                }
                if (id.equals(this.newTemplateKeyFields)) {
                    if (!this.model.isUsingKeyFromNewTemplate()) {
                        return "";
                    }
                    return this.model.getNewTemplateKeyFields();
                }
                if (id.equals(this.oldKeyLocations)) {
                    if (!this.model.isUsingKeyFromOldTemplate()) {
                        return "";
                    }
                    return this.model.getOldKeyLocations();
                }
                if (id.equals(this.newKeyLocations)) {
                    if (!this.model.isUsingKeyFromNewTemplate()) {
                        return "";
                    }
                    return this.model.getNewKeyLocations();
                }
                if (id.equals(this.keyLengths)) {
                    if (!this.model.isUsingKeyFromNewTemplate()) {
                        return "";
                    }
                    return this.model.getKeyLengths();
                }
                if (id.equals(this.keyTypes)) {
                    if (!this.model.isUsingKeyFromNewTemplate()) {
                        return "";
                    }
                    return this.model.getKeyTypes();
                }
                if (id.equals(this.newKeyLengths)) {
                    if (!this.model.isUsingKeyFromNewTemplate()) {
                        return "";
                    }
                    return this.model.getNewKeyLengths();
                }
                if (id.equals(this.newKeyTypes)) {
                    if (!this.model.isUsingKeyFromNewTemplate()) {
                        return "";
                    }
                    return this.model.getNewKeyTypes();
                }
                if (id.equals(this.keyOrders)) {
                    return this.model.getKeyOrders();
                }
                if (id.equals(this.allKeysMatch)) {
                    return this.model.isAllKeysMatch();
                }
                if (id.equals(this.keyDupOk)) {
                    return this.model.isKeyDupOk();
                }
                if (id.equals(this.compareLevel)) {
                    if (this.model.getSynch() != DSM.DsmSynch.LMOD) {
                        return "";
                    }
                    return this.model.getCompareLevel();
                }
                if (id.equals(this.dateForm)) {
                    return this.model.getDateForm();
                }
                if (id.equals(this.lmSize)) {
                    return this.model.isLmSize();
                }
                if (id.equals(this.lmAddress)) {
                    return this.model.isLmAddress();
                }
                if (id.equals(this.lmLinker)) {
                    return this.model.isLmLinker();
                }
                if (id.equals(this.lmDate)) {
                    return this.model.isLmDate();
                }
                if (id.equals(this.lmMode)) {
                    return this.model.isLmMode();
                }
                if (id.equals(this.lmAuth)) {
                    return this.model.isLmAuth();
                }
                if (id.equals(this.lmAttr)) {
                    return this.model.isLmAttr();
                }
                if (id.equals(this.csSize)) {
                    return this.model.isCsSize();
                }
                if (id.equals(this.csAddress)) {
                    return this.model.isCsAddress();
                }
                if (id.equals(this.csCompiler)) {
                    return this.model.isCsCompiler();
                }
                if (id.equals(this.csDate)) {
                    return this.model.isCsDate();
                }
                if (id.equals(this.csMode)) {
                    return this.model.isCsMode();
                }
                if (id.equals(this.csZap)) {
                    return this.model.isCsZap();
                }
                if (id.equals(this.csText)) {
                    return this.model.isCsText();
                }
                if (id.equals(this.csCompOpts)) {
                    return this.model.isCsCompOpts();
                }
                if (id.equals(this.csProgAttrs)) {
                    return this.model.isCsProgAttrs();
                }
                if (id.equals(this.csCSects)) {
                    return this.model.getCsCSects();
                }
                if (id.equals(this.csExclude)) {
                    return this.model.isCsExclude();
                }
                if (id.equals(this.matchReformatted)) {
                    return this.model.isMatchReformatted();
                }
                if (id.equals(this.ignoringBlanks)) {
                    return this.model.isIgnoringBlanks();
                }
                if (id.equals(this.ignoringCase)) {
                    return this.model.isIgnoringCase();
                }
                if (id.equals(this.sortBefore)) {
                    return this.model.isSortBefore();
                }
                if (id.equals(this.resultDatasets)) {
                    return this.model.isResultDatasets();
                }
                if (id.equals(this.includeMD)) {
                    return this.model.isIncludeMd();
                }
                if (id.equals(this.excludeInserted)) {
                    return this.model.isExcludeInserted();
                }
                if (id.equals(this.excludeDeleted)) {
                    return this.model.isExcludeDeleted();
                }
                if (id.equals(this.excludeChanged)) {
                    return this.model.isExcludeChanged();
                }
                if (id.equals(this.excludeMatched)) {
                    return this.model.isExcludeMatched();
                }
                if (id.contentEquals(this.insertsDataset)) {
                    return this.model.getInsertsDataset();
                }
                if (id.contentEquals(this.insertsDisposition)) {
                    return this.model.getInsertsDisposition();
                }
                if (id.contentEquals(this.insertsReclen)) {
                    return this.model.getInsertsReclen();
                }
                if (id.contentEquals(this.deletesDataset)) {
                    return this.model.getDeletesDataset();
                }
                if (id.contentEquals(this.deletesDisposition)) {
                    return this.model.getDeletesDisposition();
                }
                if (id.contentEquals(this.deletesReclen)) {
                    return this.model.getDeletesReclen();
                }
                if (id.contentEquals(this.nchangesDataset)) {
                    return this.model.getNChangesDataset();
                }
                if (id.contentEquals(this.nchangesDisposition)) {
                    return this.model.getNChangesDisposition();
                }
                if (id.contentEquals(this.nchangesReclen)) {
                    return this.model.getNChangesReclen();
                }
                if (id.contentEquals(this.ochangesDataset)) {
                    return this.model.getOChangesDataset();
                }
                if (id.contentEquals(this.ochangesDisposition)) {
                    return this.model.getOChangesDisposition();
                }
                if (id.contentEquals(this.ochangesReclen)) {
                    return this.model.getOChangesReclen();
                }
                if (id.contentEquals(this.nmatchesDataset)) {
                    return this.model.getNMatchesDataset();
                }
                if (id.contentEquals(this.nmatchesDisposition)) {
                    return this.model.getNMatchesDisposition();
                }
                if (id.contentEquals(this.nmatchesReclen)) {
                    return this.model.getNMatchesReclen();
                }
                if (id.contentEquals(this.omatchesDataset)) {
                    return this.model.getOMatchesDataset();
                }
                if (id.contentEquals(this.omatchesDisposition)) {
                    return this.model.getOMatchesDisposition();
                }
                if (id.contentEquals(this.omatchesReclen)) {
                    return this.model.getOMatchesReclen();
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

