/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.views.systems.handlers.AlterDataSetActionItem;
import com.ibm.etools.fm.ui.views.systems.nodes.ActionItemNode;
import com.ibm.etools.fm.ui.views.systems.nodes.DataSetNode;
import com.ibm.etools.fm.ui.widget.SystemSelectionCombo;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.HowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AlterDataSetWizardPage
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021. All rights reserved.";
    private Set<IPDHost> possibleHosts = new HashSet<IPDHost>();
    private ComboViewer wDataSetSystemViewer;
    private Combo wDataSet;
    private Combo wDataSetType;
    private DateTime wExpirationDate;
    private Button[] wExpirationChoice = new Button[3];
    private Combo wStoreClass;
    private Combo wManagementClass;
    private Combo wCrossSystem;
    private Combo wCrossRegion;
    private IPDHost host;
    private String previousDataText = "";
    private List<DataSet> association;
    private boolean isShellCreation = false;

    protected AlterDataSetWizardPage(IPDHost host) {
        super(Messages.AlterWizardPageFirst_ALTER_ATTRIBUTES);
        this.host = host;
        this.possibleHosts = new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all());
        this.setMessage(Messages.AlterWizardPageFirst_MESSAGE);
        this.setPageComplete(false);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        String dataSetText = "";
        if (selection != null && selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            Object object = treeSelection.getFirstElement();
            if (object instanceof DataSetNode) {
                dataSetText = ((DataSet)((DataSetNode)((Object)object)).getDataObject()).getName();
            } else if (object instanceof ActionItemNode) {
                AlterDataSetActionItem item = (AlterDataSetActionItem)((ActionItemNode)((Object)object)).getDataObject();
                dataSetText = item.getDataSetName();
            }
        }
        this.wDataSetSystemViewer = SystemSelectionCombo.createSystemLabelAndComboViewer(parent, this.possibleHosts, this.host);
        this.wDataSetSystemViewer.getCombo().setEnabled(false);
        GUI.label.left((Composite)parent, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)parent, (String)Messages.Label__DATA_SET, (Object)GUI.grid.d.left1());
        this.wDataSet = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        this.wDataSet.setText(dataSetText);
        this.wDataSet.setEnabled(false);
        this.previousDataText = dataSetText;
        LookupDialogFactory.defaults(LookupButton.createLookupResourceButtonLeft1(parent), this.wDataSet, (IHostProvider)this.host).noAllocate().addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "DataSet").create();
        this.wDataSet.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new FMWizardPage.ManagedWidget(this, this.wDataSet, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__DATA_SET), this.host){

            @Override
            protected boolean isValid() {
                if (!AlterDataSetWizardPage.this.wDataSet.isDisposed()) {
                    boolean isValidDataSet = DataSet.isValidDataSetName((String)AlterDataSetWizardPage.this.wDataSet.getText(), (String)AlterDataSetWizardPage.this.host.getCodePage());
                    AlterDataSetWizardPage.this.setPageComplete(false);
                    return isValidDataSet;
                }
                return false;
            }

            @Override
            public void onChange(Event event) {
                AlterDataSetWizardPage.this.loadWidgetValues();
            }
        };
        Object[] DEFAULT_POSSIBLE_TYPES = new DataSetType[]{DataSetType.PS, DataSetType.DA, DataSetType.PDS, DataSetType.LIBRARY, DataSetType.KSDS, DataSetType.RRDS, DataSetType.ESDS, DataSetType.LDS, DataSetType.GDG, DataSetType.AIX};
        GUI.label.left((Composite)parent, (String)Messages.Label__DATA_SET_TYPE, (Object)GUI.grid.d.left1());
        this.wDataSetType = GUI.combo.readOnly((Composite)parent, (Object)GUI.grid.d.fillH((int)1), (Object[])DEFAULT_POSSIBLE_TYPES);
        new FMWizardPage.ManagedWidget(this, this.wDataSetType, this.host);
        this.wDataSetType.setEnabled(false);
        Group expirationGroup = GUI.group((Composite)parent, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_STORAGE_EXPIRATION_TITLE, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wExpirationChoice[0] = GUI.button.radio((Composite)expirationGroup, (String)Messages.AlterWizardPageFirst_NULLIFY_RETENTION, (Object)GUI.grid.d.fillH((int)2));
        this.wExpirationChoice[1] = GUI.button.radio((Composite)expirationGroup, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_STORAGE_EXPIRATION_SPECIFY, (Object)GUI.grid.d.left1());
        this.wExpirationDate = GUI.datetime.date((Composite)expirationGroup, (Object)GUI.grid.d.left1());
        new FMWizardPage.ManagedWidget(this, this.wExpirationDate, this.host);
        this.wExpirationChoice[2] = GUI.button.radio((Composite)expirationGroup, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_STORAGE_EXPIRATION_NOLIMIT, (Object)GUI.grid.d.fillH((int)2));
        new FMWizardPage.ManagedWidget(this, this.wExpirationChoice, this.host){

            @Override
            public void onChange(Event event) {
                AlterDataSetWizardPage.this.wExpirationDate.setEnabled(AlterDataSetWizardPage.this.isSelected((Control)AlterDataSetWizardPage.this.wExpirationChoice[1]));
            }
        };
        this.getShell().pack();
        this.isShellCreation = true;
        this.setControl((Control)parent);
        if (!dataSetText.isEmpty()) {
            this.loadWidgetValues();
        }
    }

    private void createSMSWidget(Composite parent) {
        Group smsGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_PAGE_STORAGE_SMS, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        GUI.label.left((Composite)smsGroup, (String)Messages.AlterWizardPageFirst_STORAGE_CLASS, (Object)GUI.grid.d.left1());
        this.wStoreClass = GUI.combo.editable((Composite)smsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wStoreClass, ((Object)((Object)this)).getClass().getCanonicalName() + "StoreClass");
        new FMWizardPage.ManagedWidget(this, this.wStoreClass, this.host);
        GUI.label.left((Composite)smsGroup, (String)Messages.AlterWizardPageFirst_MANAGEMENT_CLASS, (Object)GUI.grid.d.left1());
        this.wManagementClass = GUI.combo.editable((Composite)smsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wManagementClass, ((Object)((Object)this)).getClass().getCanonicalName() + "ManagementClass");
        new FMWizardPage.ManagedWidget(this, this.wManagementClass, this.host);
        this.getShell().pack();
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            complete = true;
            if (this.wDataSetType.getText().equals(DataSetType.DA.name()) || this.wDataSetType.getText().equals(DataSetType.GDG.name())) {
                this.setErrorMessage(Messages.Msg__X_IS_INVALID);
                complete = false;
            }
            complete = this.validateShareOptions(complete);
        }
        super.setPageComplete(complete);
    }

    private boolean validateShareOptions(boolean complete) {
        if (this.wCrossRegion != null && !this.wCrossRegion.isDisposed()) {
            try {
                int crossReg = Integer.parseInt(this.wCrossRegion.getText());
                if (crossReg > 4) {
                    this.setErrorMessage(Messages.MSG_ALTER_WIZARD_PROCESS_ALTER_CROSS_REG_ERROR);
                    complete = false;
                }
            }
            catch (Exception ex) {
                complete = this.setInvalidNumberError();
            }
        }
        if (this.wCrossSystem != null && !this.wCrossSystem.isDisposed()) {
            try {
                int crossSys = Integer.parseInt(this.wCrossSystem.getText());
                if (crossSys < 3 || crossSys > 4) {
                    this.setErrorMessage(Messages.MSG_ALTER_WIZARD_PROCESS_ALTER_CROSS_SYS_ERROR);
                    complete = false;
                }
            }
            catch (Exception ex) {
                complete = this.setInvalidNumberError();
            }
        }
        return complete;
    }

    private boolean setInvalidNumberError() {
        this.setErrorMessage(Messages.MSG_ALTER_WIZARD_PROCESS_ALTER_INTEGER_ERROR);
        boolean complete = false;
        return complete;
    }

    @Override
    protected void updateControlValues() {
    }

    private void loadWidgetValues() {
        Cursor waitCursor = Display.getCurrent().getSystemCursor(1);
        this.getShell().setCursor(waitCursor);
        try {
            String typedText = this.wDataSet.getText();
            if (typedText.isEmpty()) {
                return;
            }
            if (!this.isShellCreation && this.previousDataText.equals(typedText)) {
                return;
            }
            try {
                this.isShellCreation = false;
                this.previousDataText = typedText;
                DataSetQuery query = DataSetQuery.create((IPDHost)this.host, (String)typedText);
                try {
                    query.loadDataSets((IHowIsGoing)new HowIsGoing((Object)new NullProgressMonitor()));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                List dataSets = query.getDataSets();
                if (dataSets.size() > 0) {
                    int i = 0;
                    while (i < dataSets.size()) {
                        DataSet dataSet = (DataSet)dataSets.get(i);
                        if (dataSet.getName().equalsIgnoreCase(this.wDataSet.getText())) {
                            int j = 0;
                            while (j < this.wDataSetType.getItemCount()) {
                                String dataSetType = this.wDataSetType.getItem(j);
                                if (dataSet.getType().toString().equals(dataSetType)) {
                                    DataSetProperties props = dataSet.getProperties();
                                    String expiryDate = props.getPropertyValue("Expiration date");
                                    String storageClass = props.getPropertyValue("SMS storage class");
                                    String managementClass = props.getPropertyValue("SMS management class");
                                    this.association = dataSet.getAssociatedDataSets();
                                    this.wDataSetType.select(j);
                                    this.resetExpirationDateControlValues();
                                    if (expiryDate == null || expiryDate.equals("0000.000")) {
                                        this.wExpirationChoice[0].setSelection(true);
                                        calender = Calendar.getInstance();
                                        this.wExpirationDate.setDate(calender.get(1), calender.get(2), calender.get(5));
                                        this.wExpirationDate.setEnabled(false);
                                    } else {
                                        calender = AllocateDataSetModel.parseExpiryDate(expiryDate.toString());
                                        if (calender.get(1) == 1999 && calender.get(6) == 365 || expiryDate.equals("0000.000")) {
                                            this.wExpirationChoice[2].setSelection(true);
                                            calender = Calendar.getInstance();
                                            this.wExpirationDate.setDate(calender.get(1), calender.get(2), calender.get(5));
                                            this.wExpirationDate.setEnabled(false);
                                        } else {
                                            this.wExpirationDate.setDate(calender.get(1), calender.get(2), calender.get(5));
                                            this.wExpirationChoice[1].setSelection(true);
                                            this.wExpirationDate.setEnabled(true);
                                        }
                                    }
                                    String dateSetTypeText = this.wDataSetType.getItem(j);
                                    String crossRegion = dataSet.getCrossRegion();
                                    String crossSystem = dataSet.getCrossSystem();
                                    this.manageWidgetOnDataTypeSelection(dateSetTypeText, crossRegion, crossSystem, storageClass, managementClass);
                                    break;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        finally {
            this.getShell().setCursor(null);
        }
    }

    private void resetExpirationDateControlValues() {
        int dataSetComboItems = 0;
        while (dataSetComboItems < this.wExpirationChoice.length) {
            this.wExpirationChoice[dataSetComboItems].setSelection(false);
            ++dataSetComboItems;
        }
    }

    private void manageWidgetOnDataTypeSelection(String dateSetTypeText, String crossRegion, String crossSystem, String storeClass, String mgtClass) {
        if (dateSetTypeText.equals(DataSetType.KSDS.name()) || dateSetTypeText.equals(DataSetType.RRDS.name()) || dateSetTypeText.equals(DataSetType.ESDS.name()) || dateSetTypeText.equals(DataSetType.VRRDS.name()) || dateSetTypeText.equals(DataSetType.LDS.name()) || dateSetTypeText.equals(DataSetType.AIX.name())) {
            Composite parent = (Composite)this.getControl();
            if (dateSetTypeText.equals(DataSetType.AIX.name())) {
                Group group = AlterDataSetWizardPage.getShareOptGrp(parent, Messages.Title_ALLOCATE_WIZARD_PAGE_STORAGE_SMS);
                if (group != null) {
                    group.dispose();
                    group = null;
                    this.getShell().pack();
                }
            } else {
                this.checkAndCreateSMSGrp(storeClass, mgtClass, parent);
            }
            if (AlterDataSetWizardPage.getShareOptGrp(parent, Messages.MSG_ALTER_WIZARD_PAGE_SHARE_OPT) != null) {
                this.wCrossRegion.setText(crossRegion);
                this.wCrossSystem.setText(crossSystem);
                return;
            }
            Group shareOptionsGroup = GUI.group((Composite)parent, (String)Messages.MSG_ALTER_WIZARD_PAGE_SHARE_OPT, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
            GUI.label.left((Composite)shareOptionsGroup, (String)Messages.AlterWizardPageFirst_CROSS_REGION, (Object)GUI.grid.d.left1());
            this.wCrossRegion = GUI.combo.editable((Composite)shareOptionsGroup, (Object)GUI.grid.d.fillH((int)1));
            new ComboValueSaver(this.wCrossRegion, ((Object)((Object)this)).getClass().getCanonicalName() + Messages.MSG_ALTER_WIZARD_PAGE_CROSS_REG);
            new FMWizardPage.ManagedWidget(this, this.wCrossRegion, this.host);
            this.wCrossRegion.setText(crossRegion);
            GUI.label.left((Composite)shareOptionsGroup, (String)Messages.AlterWizardPageFirst_CROSS_SYSTEMS, (Object)GUI.grid.d.left1());
            this.wCrossSystem = GUI.combo.editable((Composite)shareOptionsGroup, (Object)GUI.grid.d.fillH((int)1));
            new ComboValueSaver(this.wCrossSystem, ((Object)((Object)this)).getClass().getCanonicalName() + Messages.MSG_ALTER_WIZARD_PAGE_CROSS_SYS);
            new FMWizardPage.ManagedWidget(this, this.wCrossSystem, this.host);
            this.wCrossSystem.setText(crossSystem);
            this.getShell().pack();
        } else {
            Composite parent = (Composite)this.getControl();
            Group group = AlterDataSetWizardPage.getShareOptGrp(parent, Messages.MSG_ALTER_WIZARD_PAGE_SHARE_OPT);
            if (group != null) {
                group.dispose();
                group = null;
                this.getShell().pack();
            }
            this.checkAndCreateSMSGrp(storeClass, mgtClass, parent);
        }
    }

    private void checkAndCreateSMSGrp(String storeClass, String mgtClass, Composite parent) {
        Group smsGrp = AlterDataSetWizardPage.getShareOptGrp(parent, Messages.Title_ALLOCATE_WIZARD_PAGE_STORAGE_SMS);
        if (smsGrp != null) {
            this.wManagementClass.setText(mgtClass);
            this.wStoreClass.setText(storeClass);
        } else {
            this.createSMSWidget(parent);
            this.wManagementClass.setText(mgtClass);
            this.wStoreClass.setText(storeClass);
        }
    }

    private static Group getShareOptGrp(Composite parent, String grpName) {
        Control[] controls;
        Group shareOptGrp = null;
        Control[] controlArray = controls = parent.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Group group;
            Control control = controlArray[n2];
            if (control instanceof Group && (group = (Group)control).getText().equals(grpName)) {
                shareOptGrp = group;
                break;
            }
            ++n2;
        }
        return shareOptGrp;
    }

    public String getDataSetName() {
        return this.wDataSet.getText();
    }

    public String getMgtClass() {
        if (!this.wManagementClass.isDisposed()) {
            return this.wManagementClass.getText();
        }
        return null;
    }

    public String getStoreClass() {
        if (!this.wStoreClass.isDisposed()) {
            return this.wStoreClass.getText();
        }
        return null;
    }

    public Calendar getExpireDate() {
        return GUI.datetime.get((DateTime)this.wExpirationDate);
    }

    public String getCrossRegion() {
        if (this.wCrossRegion != null && !this.wCrossRegion.isDisposed()) {
            return this.wCrossRegion.getText();
        }
        return null;
    }

    public String getCrossSystem() {
        if (this.wCrossSystem != null && !this.wCrossSystem.isDisposed()) {
            return this.wCrossSystem.getText();
        }
        return null;
    }

    public List<DataSet> getAssociation() {
        return this.association;
    }

    public Button[] getwExpirationChoice() {
        return this.wExpirationChoice;
    }
}

